/*

	*****************************************
	*					*
	*	Brian D. Lockrey		*
	*	ITT North Technology Center	*
	*	4565 Columbus Pike		*
	*	Delaware, Ohio 43015		*
	*	614-548-4301 Ext. 343		*
	*					*
	*****************************************

	Release	1.01

		S P L U N L

	Description:

		SPELL Dictionary Unload Utility

	Entry Points:

		MAIN	- the only entry point

	External Routines:

		ERRTXT	- Return RSTS/E Error text
		HEADER	- Print Header Text
		RMSCLO	- RMS Close a file
		RMSCON	- RMS Connect a Record Access Stream
		RMSGET	- RMS Get a Record
		RMSOPE	- RMS Open a file
		RMSRAC	- RMS Specify Record Access mode

	Change Activities:

	Date		Pgm-#	Description
	----		-----	-----------
	29-Jan-82	1.01	Original Release

*/

#include	<stdio.h>
extern int rmsope(), rmscon(), rmsrac();
extern int rmsget(), rmsclo();

char file1[30], file5[30], recbuf[25], keybuf[25];
char word[50];

int lun, fac, shr, istat, keynum, keysiz, mode, recsiz, rop;
int rfa[3];
FILE *f1;

main(argc, argv)
char *argv[];
int argc;
{
	char c;
	int i, w;

	header("SPLUNL Version 2.01");

	lun = 5;	/* primary dictionary */
	fac = 0;	/* read only */
	shr = 1;	/* shared access desired */
	keynum = 0;	/* key # 0 */
	rop = 0;	/* .eq. match */
	mode = 0;	/* sequential access */
	recsiz = 24;	/* recordsize */
	keysiz = 24;	/* keysize */

l0:	puts("Output File? ");
	gets(file1);
	if ((f1 = fopen(file1,"w")) == NULL) {
		puts("?Can't open output file\n");
		goto l0;
	}
	strcpy(file5,"C:SPDICT.DAT");
	call (rmsope,5,&lun,&file5,&fac,&shr,&istat);
	if (istat != 1) {
		puts("%Open failure for dictionary file: ");
		puts(file5); puts("\n");
		rmserr();
	}
	call (rmscon,6,&lun,&keynum,&mode,&recbuf,&recsiz,&istat);
	if (istat != 1) rmserr();
	call (rmsrac,3,&lun,&mode,&istat);
	if (istat != 1) rmserr();
	unload();
	fclose(f1);
	call (rmsclo,2,&lun,&istat);
	if (istat != 1) rmserr();
}

unload()
{
	for (;;) {
		call (rmsget,3,&lun,&rfa,&istat);
		if (istat == 1) {
			trunc(recbuf,23);
			putstr(f1,recbuf);
			putstr(f1,"\n");
		}
		else if (istat == -592) {
			return;
		}
		else {
			rmserr();
			return;
		}
	}
}

trunc(str,i)
char str[];
int i;
{
	while (str[i] == ' ' && i >= 0) {
		str[i] = '\0';
		--i;
	}
}

rmserr()
{
	printf("?RMS error code: %d\n", istat);
	exit(1);
}

puts(str)
char *str;
{
	char c;
	while ((c = *str) != 0) {
		putchar(c);
		++str;
	}
}

putstr(chan,str)
int chan;
char *str;
{
	char c;
	while ((c = *str) != 0) {
		putc(c,chan);
		++str;
	}
}
