1	EXTEND
2!	&
!	&
!			T A P E    C O P Y &
!	&
!
3!	Program:	TPECPY		! &

5!	Version:	7.0 - 1.0	! &

6!	   Date:	1-May-82	! &

7!	 Author:	W. Franklin Mitchell, Jr.	! &
!			Computer Operations Supervisor	! &
!			and Instructor in Mathematics	! &
!	&
!			Erskine College, Due West, South Carolina	! &

8!	&
!				Copyright (c) 1982	! &
!	&
!	******************************************************************* &
!	* This software is furnished free of charge to  DECUS  and may be * &
!	* copied  only  with with the inclusion of the author's name  and * &
!	* copyright notice.   No title to or ownership of  this  software * &
!	* is hereby transmitted.   Neither the author nor Erskine College * &
!	* assumes  any  responsibility for the use or reliability of this * &
!	* software.  The author welcomes comments and bug reports  mailed * &
!	* to F. Mitchell, Erskine College, Box 86 T, Due West, SC  29639. * &
!	******************************************************************* &

20!	&
!	&
!		M O D I F I C A T I O N    H I S T O R Y &
!	&
!	&
!	Ver/Ed		Edit Date	Reason &

21!	7.0-1.0		 4-May-82	Final Polish &
	&

100	! &
	!		G E N E R A L    D E S C R I P T I O N &

110!	Tape Copy is designed to allow users of RSTS systems with just one &
!	tape drive to make exact  duplicates of DOS format magnetic tapes. &
!	That is, to copy a tape to temporary disk storage and then to move &
!	this  data  to a new tape preserving the original tape's  [P,PN]'s &
!	and ordering of files. &

120!	Tape Copy &
!	&
!	1) asks for user input regarding the tape's being ready and which &
!	   disk(s) (plus [P,PN] for a privileged user) to use. &
!	&
!	2) moves the data from the original tape to disk. &
!	&
!	3) writes a PIP command file that will move the data from disk to a &
!	   new tape (WRITE.CMD). &
!	&
!	4) and writes a PIP command file to remove the temporary disk files &
!	   (CLEAN.CMD). &
!	&

130!	What to do: &
!	&
!	1) Load the tape to be copied (no write ring) and &
!	&
!	   RUN TPECPY &
!	&
!	2) Load a new tape (with write ring) and type &
!	&
!	   PIP @WRITE &
!	&
!	   Repeat step 2 until you have made as many copies as desired. &
!	&
!	3) Type &
!	&
!	   PIP @CLEAN &
!	&
!	   to remove the tape files from the temporary disk storage. &

140!	&
!	N  O  T  E : &
!	&
!	TPECPY.BAS expects &
!	&
!		o  DOS labeled magnetic tapes. &
!	&
!		o  Enough free disk to store the whole tape. &
!	&
!		o  PIP V7.0-07 or eqivalent. &
!	&
!		o  8,999 files/tape or less. &

200	! &
	!	T A P E    D R I V E &

210	TAPE.DRIVE$ = "MT0:" &
!	&
!	Edit this line if your tape drive is named something else &
	&
	&
	&

300	! &
	!	I / O    C H A N N E L S &

301!	Channel #	Used for &

310!		CMD%	WRITE.CMD and CLEAN.CMD files. &
!	&
!		TPE%	Magnetic tape drive. &
!	&
!		DSK%	Temporary disk files which are copies of the tape's &
!			files. &

320	CMD% = 1% &
\	TPE% = 2% &
\	DSK% = 3% &
	&
	&
	&
	&

800	! &
	!	F U N C T I O N   D E S C R I P T I O N &

801!	Function		Use &

810!	FNPPN$(X$)		extract PPN from DOS tape header &

820!	FNINTRAD$(X$)		extract file name from DOS tape header. &
	&
	&
	&
	&

900	! &
	!	D I M E N S I O N     S T A T E M E N T &

910	Dim DISK.ACCOUNT$(32) &
	&

920	DISK.ACCOUNT.LIMIT% = 32% &
!	&
!	Match limit in DIM statement &
	&
	&

930	WATCHING% = -1% &
!	&
!	0% = no watching, -1% = watching &

1000	! &
	!	S T A R T &

1020	On error goto 19000 &
\	Print if CCPOS(0%) &

1040	Print &
\	Print "Erskine College Tape Copy  V7.0 - 1.0  "; &
\	Print TIME$(0%); "  "; DATE$(0%) &

1060	PRIVILEGED% = 0% &
\	PRIVILEGED% = PEEK(512%) &
!	&
!	If no error, we are privileged. &

1080	Print &
\	Print "Please mount the tape to be copied on "; TAPE.DRIVE$; &
\	Print " with no write ring." &
\	Print &
\	Input "Tape drive ready <Yes>"; GO$ &
\	GO$ = CVT$$(GO$, -1%) &
\	GO$ = "Y" if LEN(GO$) = 0% &
\	Goto 1080 unless ASCII(GO$) = ASCII('Y') &

1100	Print &
\	Input "Tape density (800 or 1600) <drive default>"; DENSITY$ &
\	DENSITY$ = CVT$$(DENSITY$, -1%) &
\	Goto 1100 if not (DENSITY$="800" or DENSITY$="1600" or LEN(DENSITY$)=0%) &
\	E%, D% = 0% &
\	If DENSITY$ = "800" &
	   then &
		E% = 0% &
	\	D% = 3%
1120	If DENSITY$ = "1600" &
	   then &
		E% = 256% &
	\	D% = 0% &

1140	Open TAPE.DRIVE$ as file TPE%, mode 64% + E% + (D% * 4%) &

1160	Field #TPE%,	2% as FILE.NAME.FRONT$,	2% as FILE.NAME.REAR$, &
			2% as FILE.NAME.EXT$,	1% as PROGRAMMER$, &
			1% as PROJECT$ &

1180	I% = MAGTAPE(3%, 0%, TPE%) &
!	&
!	Rewind the tape. &

1200	I% = MAGTAPE(7%, 0%, TPE%) &
\	If (I% AND 1024%) = 0% &
	   then &
		Print &
	\	Print "%Tape is write enabled." &

1220	Goto 2000 &
	&

1240	Print &
\	Print TAPE.DRIVE$; " is off-line.  Please fix." &
\	Print &
\	Input "Drive on-line <Yes>"; GO$ &
\	Goto 1140 &
!	&
!	Handle tape off-line error. &

2000	! &
	!	G E T    W H I C H    D I S K (S)    T O    U S E &

2020	Print &
\	Print "Please define the disk(s)"; &
\	Print "/accounts(s)"; if PRIVILEGED% &
\	Print " to use for temporary storage:" &
\	DISK% = 0% &

2040	Print &
\	Print using "###.  Disk", DISK% + 1%; &
\	Print "/account"; if PRIVILEGED% &
\	Print " <no more>"; &
\	Input line DISK$ &
\	DISK$ = CVT$$(DISK$, -1%) &
\	Goto 2100 if LEN(DISK$) = 0% &
\	DISK.ACCOUNT$(DISK%) = DISK$ &

2060	Open DISK$ + "TPECPY.TMP" as file DSK% &
\	Close DSK% &
\	Kill DISK$ + "TPECPY.TMP" &
!	&
!	If this causes an error, we don't have access to DISK$ &
!	or DISK$ does not exist. &

2080	DISK% = DISK% + 1% &
\	Goto 2040 if DISK% <= DISK.ACCOUNT.LIMIT% &

2100	NR.OF.DISKS% = DISK% - 1% &
\	If NR.OF.DISKS% < 0% &
	   then &
		NR.OF.DISKS% = 0% &
	\	DISK.ACCOUNT$(0%) = "SY:" &

2120	Goto 3000 &
	&

2140	Print &
\	Print "You can't create files on "; DISK$; ".  Try again:" &
\	Goto 2040 &
!	&
!	Handle illegal disk or private disk errors. &

3000	! &
	!	B U I L D   W R I T E . C M D &
	! &
	!	A N D   P R O C E S S   T A P E   D A T A &

3020	Open "WRITE.CMD" for output as file CMD% &
\	Print #CMD%, TAPE.DRIVE$; "/ZE"; &
\	If LEN(DENSITY$) = 0% &
	   then &
		Print #CMD% &
	   else &
		Print #CMD%, "/DEN:"; DENSITY$ &

3040	DISK% = 0% &
\	FILE.NUMBER% = 1% &
\	TOTAL.BLOCKS = 0. &
\	Print &
\	Goto 3060 if not WATCHING% &
\	Print "Now processing:" &
\	Print &
\	Print "File # ------ File Name ------  Blocks" &
\	Print &

3060	Get #TPE% &
!	&
!	Read DOS header block &

3080	TAPE.FILE$ = TAPE.DRIVE$ &
		+ "[" + FNPPN$(PROJECT$) + "," + FNPPN$(PROGRAMMER$) + "]" &
		+ FNINTRAD$(FILE.NAME.FRONT$)  + FNINTRAD$(FILE.NAME.REAR$) &
		+ "." + FNINTRAD$(FILE.NAME.EXT$) &

3100	DISK.FILE$ = DISK.ACCOUNT$(DISK%) &
			+ "TC" + NUM1$(1000% + FILE.NUMBER%) + ".TMP" &

3120	Print #CMD%, CVT$$(TAPE.FILE$, 2%) "="; DISK.FILE$ &
\	Goto 3200 if not WATCHING% &
\	Print using "#,###) ", FILE.NUMBER%; &
\	Print TAPE.FILE$; SPACE$(1%); &

3200	! &
	!	M O V E    T A P E ' S    F I L E    T O    D I S K &

3220	Open DISK.FILE$ for output as file DSK% &
\	DISK.BLOCK.COUNT = 0. &

3240	Get #TPE% &
\	Put #DSK% + SWAP%(TPE%) &
\	DISK.BLOCK.COUNT = DISK.BLOCK.COUNT + 1. &
\	Goto 3240 &

3260	Close DSK% &
\	TOTAL.BLOCKS = TOTAL.BLOCKS + DISK.BLOCK.COUNT &
\	Print using "###,###", DISK.BLOCK.COUNT if WATCHING% &

3280	FILE.NUMBER% = FILE.NUMBER% + 1% &
\	If DISK% < NR.OF.DISKS% &
	   then &
		DISK% = DISK% + 1% &
	   else &
		DISK% = 0% &

3300	Goto 3060 &

4000	! &
	!	C L O S E,   B U I L D   C L E A N . C M D,   A N D   Q U I T &

4020	Close CMD%, TPE%, DSK% &
\	FILE.NUMBER% = FILE.NUMBER% - 1% &
\	Print &
\	Print using "#,### file", FILE.NUMBER%; &
\	Print "s"; if FILE.NUMBER% <> 1% &
\	Print using " ###,### block", TOTAL.BLOCKS; &
\	Print "s"; if TOTAL.BLOCKS <> 1. &
\	Print &

4040	Open "CLEAN.CMD" for output as file CMD% &

4060	Print #CMD%, DISK.ACCOUNT$(I%); &
			 "TC????.TMP/DE/WO/W" for I% = 0% to NR.OF.DISKS% &
\	Print #CMD%, "WRITE.CMD/DE/WO/W" &
\	Print #CMD%, "CLEAN.CMD/DE/W" &
\	Close  CMD% &

4080	Print &
\	Print "Now mount a new tape on "; TAPE.DRIVE$; " and type" &
\	Print &
\	Print "PIP @WRITE" &
\	Print &
\	Print 'Repeat the above "mount" and "PIP" steps until all copies'; &
\	Print ' you want are made.' &
\	Print &
\	Print "Then type" &
\	Print &
\	Print "PIP @CLEAN" &

4100	Goto 32767 &

15000	! &
	!	F U N C T I O N    F N P P N $ &

15010 Def* FNPPN$(X$) &
\	X$ = NUM1$( ASCII(X$) ) &
\	FNPPN$ = SPACE$( 3% - LEN(X$) ) + X$
15020 Fnend &
	&

15030	! &
	!	F U N C T I O N    F N I N T R A D $ &

15040	Def* FNINTRAD$(X$) = RAD$( SWAP%( CVT$%(X$) ) ) &
!	&
!	Convert a string to a Rad50 integer and then to characters. &
	&
	&
	&

19000	! &
	!	E R R O R    P R O C E S S I N G &

19020	Resume 3260 if ERR = 11% and ERL = 3240% &
!	&
!	End of file on a tape file? &

19040	Resume 4020 if ERR = 11% and ERL = 3060% &
!	&
!	Are we done? &

19060	Resume 1240 if ERR = 39% and ERL = 1140% &
!	&
!	Tape drive off-line? &

19080	Resume 2140 if ERL = 2060% &
!	&
!	Can't write on that disk. &

19100	Resume 1080 if ERR = 10% and ERL = 1060% &
!	&
!	Can't do a PEEK() because we are not privileged. &

19120	If ERR = 8% and ERL = 1140% &
	   then &
		Print &
	\	Print "?Sorry "; TAPE.DRIVE$; " is not available." &
	\	Close CMD%, TPE%, DSK% &
	\	Goto 32767 &

19990	Print &
\	Print "Unexpected Tape Copy error:" &
\	Print &
\	Print CVT$$( RIGHT( SYS(CHR$(6%) + CHR$(9%) + CHR$(ERR)), 2% ), 4% ); &
\	Print " at line "; NUM1$(ERL); "." &
\	Close CMD%, TPE%, DSK% &

32767	END
