	.TITLE	FILEIO
	.VERSION	18.
/
/	FILEIO Y1.8
/
/
/	(c) 1988, 1989, 1991 BY JOHNNY BILLQUIST
/	ALL RIGHTS RESERVED
/
/	FILEIO IS A FILE I/O PACKAGE FOR OS/8
/
/	IT CONSISTS OF THE FOLLOWING ROUTINES:
/
/
/	#	FUNCTION	DESCRIPTION
/
/	1	LOOKUP	-	DIRECTORY LOOKUP
/	2	IOPEN	-	OPEN FILE FOR INPUT
/	3	OOPEN	-	OPEN FILE FOR OUTPUT
/	4	PUT	-	PUT BLOCK IN FILE
/	5	GET	-	GET BLOCK FROM FILE
/	6	OCHAR	-	OUTPUT CHAR TO FILE
/	7	ICHAR	-	INPUT CHAR FROM FILE
/	10	PRINT	-	PRINT STRING
/	11	POSIT	-	POSITIONING OF THE FILE POINTER
/	12	POSITP	-	POSITION OF THE FILE POINTER
/	13	CLOSE	-	CLOSE FILE
/	14	FLUSH	-	FLUSH OUTPUT BUFFER
/
/	NOTE: A STRING IS A SIXBIT STRING DELIMITED BY A NULL.
/		@ IS CONTROL QUOTE.
/
/	ALL FUNCTIONS IS CALLED IN THE FORMAT
/
/	TAD	VAL	(OPTIONAL)
/	CIF	FILEIO
/	JMS	FILEIO
/	<FUNCTION>
/	<FILEBLOCK>
/	<ARG>		(NOT ALWAYS)
/	ERROR RETURN
/	NORMAL RETURN
/
/	OR BY THE MACRO CALL IN COMMON.MA
/
/	FILEBLOCK:
/
/     ADDRESS	    CONTAINS
/
/	20	DEVICE DRIVER ADDRESS
/	21	DEVICE NUMBER
/	22	BUFFER BASE ADDRESS
/	23	BUFFER FIELD
/	24	*SPARE*
/	25	BUFFER COUNT
/	26	FILE POINTER
/	27	FILE FLAGS
/	30	FILE ADDRESS
/	31	FILE SIZE
/	32	FILE END
/	33	FILE NAME
/	34	FILE NAME
/	35	FILE NAME
/	36	FILE EXTENSION
/	37	FILE DATE
/
/	FILE FLAGS
/
/	+-+-+-+-+-+-+-+-+-+-+-+-+
/	! ! ! ! ! ! ! ! ! ! ! ! !
/	+-+-+-+-+-+-+-+-+-+-+-+-+
/	 ! !                   +- TENTATIVE
/	 ! +--------------------- FILE OPEN
/	 +----------------------- MODIFIED
/
	.XSECT	.FIOX
	FIELD	2
X0,	0
X1,	0

	.ZSECT	.FIOZ
	FIELD	2
BLOCK,	ZBLOCK	20,0
ARG,	0
LC,	0
TMP,	0
AC,	0
FUNC,	0
FILEBL,	0

	.RSECT	.FILIO
	.ENTRY	$FILEIO
	FIELD	2

	USR=7700
	DEVADR=00
	DEVNUM=01
	BUFADR=02
	BUFFLD=03
	FILLIN=04
	BUFCNT=05
	FILBLK=06
	FILFLG=07
	FILBEG=10
	FILSIZ=11
	FILEND=12
	FILNAM=13
	FILEXT=16
	FILDAT=17
/
	.SBTTL	MAIN
/
/
/	M A I N   B O D Y
/
$FILEIO,
	0		/ENTRY TO FILEIO.
	DCA	AC	/SAVE AC
	RDF		/GET RETURN CODE
	TAD	(CDF CIF
	DCA	RETFLD
	RDF		/GET CDF CODE
	TAD	(CDF
	DCA	DCDF1
	TAD I	$FILEIO	/GET FUNCTION
	DCA	FUNC
	ISZ	$FILEIO
	TAD I	$FILEIO	/GET FILE BLOCK
	DCA	FILEBL
	ISZ	$FILEIO
	TAD I	$FILEIO	/GET ARG
	DCA	ARG

	CMA		/COPY FILEBLOCK INTO OUR FIELD
	TAD	FILEBL	/FROM ADDRESS - 1
	DCA	X0
	TAD	(BLOCK-1/TO ADDRESS - 1
	DCA	X1
	TAD	(-20	/20 WORDS.
	DCA	LC
	TAD	DCDF1	/CDF CODE
	DCA	1$
1$:	HLT		/SHALL BE PLACED HERE.
	TAD I	X0	/GET WORD.
	CDF	.
	DCA I	X1	/PUT WORD.
	ISZ	LC	/BUMP COUNT
	JMP	1$	/AND REPEAT.

	TAD	BLOCK	/CHECK IF A DEVICE DRIVER IS PRESENT...
	SZA CLA
	JMP	DOIT	/PRESENT. START DISPATCH
	CMA		/NO PRESENT. FATAL ERROR.
	JMP	ERR1

DOIT,	TAD	FUNC	/GET FUNCTION CODE.
	SPA SNA		/IS IT >0?
	JMP	FERR	/NO. FUNCTION ERROR.
	TAD	(-MAXFUN	/IS IT >MAXFUN?
	SMA
	JMP	FERR	/YES. FUNCTION ERROR.
	TAD	(MAXFUN-NOPFUN	/IS IT A FUNCTION WHICH MUST HAVE A OPEN FILE?
	SPA CLA
	JMP	NOTFUN	/NO.
	TAD	BLOCK+FILFLG	/GET FLAGS.
	RTL
	SNL CLA		/IS FILE OPEN?
	JMP	ERR1	/NO. OPEN ERROR.
NOTFUN,	TAD	FUNC	/GET FUNCTION
	CLL RAL		/MULTIPLY FUNCTION BY 2.
	TAD	DODISP	/ADD ADDRESS OF TABLE.
	DCA	TMP	/SAVE POINTER INTO TABLE.
	TAD I	TMP	/GET 1:ST WORD (ARGUSE)
	SZA CLA		/DOES THIS FUNCTION USE ARG?
	ISZ	$FILEIO	/YES. BUMP RETURN ADDRESS.
	ISZ	TMP	/POINT TO NEXT WORD (FUNC ADDRESS)
	TAD I	TMP	/GET ADDRESS.
	DCA	TMP	/SAVE IT.
	JMS I	TMP	/JUMP TO IT.

XIT1,	ISZ	$FILEIO	/NORMAL EXIT. BUMP RETURN ADDRESS
	SKP CLA		/SKIP ERROR ENTRY.

ERR1,	DCA	AC	/ERROR ENTRY. SAVE ERROR CODE.
	TAD	(BLOCK-1/COPY BACK FILE BLOCK
	DCA	X0
	CMA
	TAD	FILEBL
	DCA	X1
	TAD	(-20
	DCA	LC

CL1,	CDF	.
	TAD I	X0
DCDF1,	HLT
	DCA I	X1
	ISZ	LC
	JMP	CL1

	TAD	AC	/RESTORE AC.
RETFLD,	HLT		/RETURN.
	JMP I	$FILEIO
/
FERR,	CIF	10
	JMS	USR	/FUNCTION ERROR. USER ERROR 11.
	7
	11
/
DODISP,	DODISP;0	/DISPATCH TABLE
	-1;LOOK1
	-1;IOPEN1
	-1;OOPEN1
	NOPFUN=.-DODISP%2
	0;PUT1
	0;GET1
	0;OCHAR1
	0;ICHAR1
	-1;PRINT1
	-1;POSIT1
	-1;POSIP1
	0;CLOSE1
	0;FLUSH1
/
	MAXFUN=.-DODISP%2
/
	PAGE
	.SBTTL	LOOKUP
/
/	1	LOOKUP
/
/	AC		FILE SEQUENCE #
/	FILEBLOCK	TO BE FILLED WITH CORRECT DATA
/	ARG		POINTER TO FILE NAME
/
/	ERROR:
/	AC	>0	HOW MANY NOT FOUND. FILE NOT FOUND
/		=0	NONFATAL DEVICE ERROR.
/		<0	FATAL DEVICE ERROR.
/
LOOK1,	0
	TAD	BLOCK+DEVNUM	/GET DEV #.
	TAD	(7757	/ADD POINTER TO DEVICE CONTROL WORD TABLE.
	DCA	TMP	/SAVE POINTER.
	CDF	10
	TAD I	TMP	/GET CONTROL WORD.
	CDF	.
	SMA CLA		/DEVICE FILE STRUCTURED?
	JMP	NODEVS	/NO.
	TAD	AC	/COUNT TO RIGHT
	SNA		/IF IT IS ZERO, WE PUT IT AT 1
	IAC
	CIA		/THEN WE NEG.
	DCA	AC	/AND SAVE.

	JMS	WFIX;FILE	/FIX WILDCARS...
	TAD	(FILE)
	JMS	UNPACK;FNAM	/UNPACK FILENAME INTO FNAM

	CLA IAC		/RESET DIRECTORY BLOCK
LRDL1,	DCA	DIRBLK

	CIF		/CALL DEVICE DRIVER.
	JMS I	BLOCK+DEVADR
	200+.FLD
	CACHE
DIRBLK,	0
	JMP	ERR1
	TAD	(CACHE+5	/FILE POINTER POINT AT BEGINNING OF FILES
	DCA	TMP

LRFL1,	TAD I	TMP	/GET 1:ST TWO CHARS OF FILENAME
	SNA CLA		/ZERO? EMPTY FILE!
	JMP	EMFIL	/YES.
	TAD	CACHE+4	/NO, GET AIW
	CIA
	TAD	TMP	/ADD PTR TO FILENAME
	TAD	(4	/POINT BEYOND
	DCA	ARG	/NOW WE POINT AT SIZE
	TAD I	ARG	/GET SIZE
	SNA CLA		/ZERO? TENTATIVE FILE!
	JMP	TFIL	/YES.
	TAD	TMP	/NO, UNPACK FILENAME.
	JMS	UNPACK;FILE
	JMS	CMFIL;FNAM;FILE	/COMPARE FILES.
	JMP	NFIL	/NOT EQUAL FILENAMES, CONTINUE.
	ISZ	AC	/EQUAL! BUMP INDEX COUNT
	JMP	NFIL	/NOT THIS ONE?

	TAD	(BLOCK+FILLIN	/THIS ONE! SETUP PTR TO FILEBLOCK TO
				/FILL IN INFO.
	DCA	X1

	TAD	(1000)
	DCA I	X1	/SET BUFFER COUNT.
	DCA I	X1	/SET FILE POINTER.
	CLL CML RTR
	DCA I	X1	/SET FILE FLAGS.
	TAD	CACHE+1	/GET START ADDRESS
	DCA I	X1	/SAVE.
	TAD	CACHE+4	/GET AIW
	CIA		/NEG.
	TAD	ARG	/ADD PTR TO FILE AIW.
	DCA	ARG	/WE NOW HAVE PTR TO FILE SIZE.
	TAD I	ARG	/GET FILE SIZE.
	CIA
	DCA I	X1	/SAVE IT.
	TAD	BLOCK+FILSIZ	/GET FILE SIZE.
	TAD	CACHE+1	/ADD PTR TO START.
	DCA I	X1	/SAVE END ADDRESS.
	CMA
	TAD	TMP	/MOVE FILENAME AND DATE.
	DCA	X0
	TAD	(-5
	DCA	LC
1$:	TAD I	X0
	DCA I	X1
	ISZ	LC
	JMP	1$

	JMP I	LOOK1	/RETURN. WE ARE FINISHED.

NFIL,	TAD	CACHE+4	/WRONG FILENAME. SET PTR TO SIZE.
	CIA

TFIL,	TAD	ARG	/TENTATIVE FILE. SET POINTER TO SIZE.
	DCA	TMP
	JMP	NXTFIL

EMFIL,	ISZ	TMP	/EMPTY FILE. SET POINTER TO SIZE.
NXTFIL,	TAD I	TMP	/GET SIZE.
	CIA
	TAD	CACHE+1	/ADD TO START BLOCK.
	DCA	CACHE+1	/NOW START BLOCK OF NEXT FILE.
	ISZ	TMP	/BUMP PTR TO NEXT FILE.
	ISZ	CACHE	/BUMP FILE COUNT
	JMP	LRFL1	/NOT ALL FILES DONE IN THIS BLOCK.

	TAD	CACHE+2	/GET LINK.
	SZA		/WAS IT ZERO?
	JMP	LRDL1	/AND REPEAT.
	TAD	AC	/NORMALIZE ERROR CODE.
	CIA
	JMP	ERR1
/
NODEVS,	CMA
	TAD	AC	/GET REQUESTED COUNT MINUS ONE.
	SZA		/WAS IT FILE #1?
	JMP	ERR1	/NO. ERROR ON REST.
	JMS	IOPEN1	/YES. OPEN FILE NORMALLY.
	JMP I	LOOK1
/
	PAGE
	.SBTTL	IOPEN
/
/	2	IOPEN
/
/	FILEBLOCK	TO BE FILLED WITH CORRECT DATA
/	ARG		FILENAME
/
/	ERROR:
/	AC	>=0	FILE NOT FOUND. NEW FILE CREATED.
/		<0	FATAL DEVICE ERROR
/
IOPEN1,	0
	JMS	WFIX;FILE	/COPY FILENAME
	JMS	IOP2
	JMP I	IOPEN1
/
IOP2,	0
	TAD	(FILE		/SETUP FILENAME POINTER FOR LOOKUP.
	DCA	1$

	TAD	BLOCK+DEVNUM	/GET DEVICE #
	CIF	10
	JMS	USR	/CALL USR
	2		/LOOKUP
1$:	0
2$:	0
	JMP	ERRP

	TAD	(BLOCK+FILLIN	/SET UP POINTER TO FILEBLOCK
	DCA	X0

	TAD	(1000)
	DCA I	X0	/SET BUFFER COUNT
	DCA I	X0	/SET FILE POINTER
	TAD	(2000
	DCA I	X0	/SET FILE FLAGS
	TAD	1$
	DCA I	X0	/SET FILE ADDRESS
	TAD	2$
	CIA
	DCA I	X0	/SET FILE SIZE
	TAD	BLOCK+FILSIZ
	TAD	BLOCK+FILBEG
	DCA I	X0	/SET FILE END
	TAD	(FILE-1)
	DCA	X1
	TAD	(-4)
	DCA	LC
4$:	TAD I	X1
	DCA I	X0
	ISZ	LC
	JMP	4$
	JMP I	IOP2	/RETURN
/
ERRP,/	CLA
/	JMS	OOP2	/NO FILE FOUND. TEST TO OPEN OUTPUT.
/	CLA IAC		/AC=1
	JMP	ERR1	/ERROR RETURN. 1 MEANS FILE CREATED.
	.SBTTL	OOPEN
/
/	3	OOPEN
/
/	AC		MAX SIZE IN BLOCKS OF FILE
/	FILEBLOCK	TO BE FILLED WITH CORRECT DATA
/	ARG		FILENAME
/
/	ERROR:
/	AC	>=0	NONFATAL ERROR
/		<0	FATAL ERROR
/
OOPEN1,	0
	JMS	WFIX;FILE	/COPY FILENAME
	JMS	OOP2
	JMP I	OOPEN1
/
OOP2,	0		/REAL OUTPUT OPEN ROUTINE.
	TAD	(FILE)	/SETUP FILENAME POINTER FOR LOOKUP.
	DCA	1$

	TAD	AC	/GET MAX SIZE REQUESTED
	RTL;RTL
	AND	(7760
	TAD	BLOCK+DEVNUM	/COMBINED WITH DEVICE #
	CIF	10
	JMS	USR	/CALL USR
	3		/ENTER
1$:	0
2$:	0
	JMP	ERR1

	TAD	(BLOCK+FILLIN	/SET UP POINTER TO FILEBLOCK
	DCA	X0

	TAD	(1000)
	DCA I	X0	/SET BUFFER COUNT
	DCA I	X0	/SET FILE POINTER
	TAD	(2001
	DCA I	X0	/SET FILE FLAGS
	TAD	1$
	DCA I	X0	/SET FILE ADDRESS
	DCA I	X0	/SET FILE SIZE
	TAD	2$
	CIA
	TAD	1$
	DCA I	X0	/SET FILE END
	TAD	(FILE-1)
	DCA	X1
	TAD	(-4)
	DCA	LC
4$:	TAD I	X1
	DCA I	X0
	ISZ	LC
	JMP	4$
	TAD	7666
	DCA I	X0	/SET FILE DATE
	JMP I	OOP2	/RETURN
/
FNAM,	ZBLOCK	10
FILE,	ZBLOCK	10
/
	PAGE
	.SBTTL	PUT
/
/	4	PUT
/
/	AC		RELATIVE BLOCK #
/	FILEBLOCK	FILE INFO
/
/	ERROR:
/	AC	>=0	NO MORE SPACE
/	AC	<0	FATAL DEVICE ERROR
/
PUT1,	0
	ISZ	BLOCK+FILBLK	/BUMP LAST.
	TAD	AC	/GET REQUESTED BLOCK.
	SZA		/ZERO?
	DCA	BLOCK+FILBLK	/NO. SAVE AS DEFAULT.
	CMA
	TAD	BLOCK+FILBLK	/GET BLOCK TO WRITE.
	TAD	BLOCK+FILBEG
	DCA	OBLK	/SAVE AS BLOCK TO OUTPUT TO.
	TAD	BLOCK+FILEND	/GET FILE END POINTER...
	CIA
	CLL CML
	TAD	OBLK	/COMPARE WITH FILE PTR...
	SNL CLA		/L=0 PTR OUT OF FILE SPACE.
	JMP	ERR1	/YES. ERROR!
	TAD	BLOCK+BUFADR	/NO. GET BLOCK ADDRESS
	DCA	OADR	/SAVE AS ADDRESS TO OUTPUT FROM.
	TAD	BLOCK+BUFFLD	/GET FIELD
	TAD	(4200	/COMBINE WITH WRITE 1 BLOCK CODE.
	DCA	OFUN	/SAVE AS FUNCTION.
	CIF		/CALL DEVICE DRIVER WITH THIS INFO.
	JMS I	BLOCK+DEVADR
OFUN,	0
OADR,	0
OBLK,	0
	JMP	ERR1	/DEVICE ERROR.

	TAD	BLOCK+FILFLG	/CLEAR MODIFIED FLAG.
	AND	(3777
	DCA	BLOCK+FILFLG
	TAD	BLOCK+FILBLK	/GET WRITTEN BLOCK.
	CIA CLL CML
	TAD	BLOCK+FILSIZ	/COMPARE WITH SIZE.
	SNL		/SIZE GROW?
	JMP	1$	/NO.
	CIA		/YES. ADD CHANGE.
	TAD	BLOCK+FILSIZ
	DCA	BLOCK+FILSIZ	/SAVE AS NEW SIZE.

1$:	CLA
	TAD	BLOCK+FILBLK	/GET AC.
	DCA	AC	/SAVE BLOCK OPERATED FROM.

	JMP I	PUT1	/RETURN
	.SBTTL	GET
/
/	5	GET
/
/	AC		RELATIVE BLOCK #
/	FILEBLOCK	FILE INFO
/
/	ERROR:
/	AC	>=0	END OF FILE
/	AC	<0	FATAL DEVICE ERROR
/
GET1,	0
	TAD	BLOCK+FILFLG	/GET FLAGS
	SMA CLA		/MODIFIED BIT SET?
	JMP	1$	/NO.
	TAD	AC	/YES. SAVE AC.
	DCA	ACS
	TAD	BLOCK+FILBLK	/SET UP FOR PUT TO OLD BLOCK.
	DCA	AC
	JMS	PUT1	/PUT BLOCK
	TAD	ACS	/RESTORE AC
	DCA	AC

1$:	TAD	AC	/CHECK IF BLOCK ALREADY IN MEMORY...
	SNA
	JMP	2$	/BLOCK ZERO DOESN'T COUNT...
	CIA
	TAD	BLOCK+FILBLK
	SNA CLA
	JMP I	GET1	/ALREADY IN MEMORY. DON'T READ IT!

2$:	ISZ	BLOCK+FILBLK	/BUMP DEFAULT.
	TAD	AC	/GET AC.
	SZA		/ZERO?
	DCA	BLOCK+FILBLK	/NO. SAVE AS DEAFULT.

	CMA		/NO. CALCULATE ABSOLUTE ADDRESS.
	TAD	BLOCK+FILBLK
	TAD	BLOCK+FILBEG
	DCA	IBLK	/SAVE IT.
	TAD	BLOCK+FILEND	/GET FILE END PTR.
	CIA
	CLL CML
	TAD	IBLK	/COMPARE WITH FILE PTR.
	SNL CLA		/L=0 MEANS OUT OF FILE BOUNDS. ERROR!
	JMP	ERR1	/YES. ERROR.
	TAD	BLOCK+BUFADR
	DCA	IADR	/TRANSFER ADDRESS...
	TAD	BLOCK+BUFFLD	/GET FIELD...
	TAD	(200	/... AND COMBINE WITH READ 1 BLOCK...
	DCA	IFUN	/... AND SAVE AS FUNCTION.

	CIF		/CALL DEVICE DRIVER.
	JMS I	BLOCK+DEVADR
IFUN,	0
IADR,	0
IBLK,	0
	JMP	ERR1

	JMP I	GET1	/RETURN
/
ACS,	0
/
NXTBLK,	0		/GET NEXT BLOCK ROUTINE.
	CLA
	TAD	BLOCK+FILBLK	/GET LAST BLOCK.
	DCA	AC	/SAVE AS AC FOR PUT ROUTINE.
	TAD	BLOCK+FILFLG	/BUFFER MODIFIED?
	SPA CLA
	JMS	PUT1	/PUT BLOCK.
	ISZ	AC	/SET AC TO READ BLOCK
	TAD	BLOCK+FILEND	/GET END PTR.
	CIA
	CLL CML
	TAD	AC	/GET BLOCK TO READ.
	TAD	BLOCK+FILBEG	/ADD ADDRESS.
	SNL SZA CLA	/ADDRESS > END?
	JMP	ERR1	/YES. ERROR. NO MORE SPACE!

	CMA
	TAD	AC	/GET PTR.
	CIA CLL CML
	TAD	BLOCK+FILSIZ	/COMPARE WITH SIZE.
	SNL SZA
	ISZ	NXTBLK	/PTR <= SIZE. BUMP RETURN. READ DONE.
	SNL SZA CLA		/PTR > SIZE?
	JMS	GET1	/NO. READ BLOCK.
	DCA	BLOCK+BUFCNT	/CLEAR OFFSET.
	TAD	AC		/GET CURRENT BLOCK.
	DCA	BLOCK+FILBLK	/SAVE CURRENT BLOCK.

	JMP I	NXTBLK	/RETURN
/
	PAGE
	.SBTTL	OCHAR
/
/	6	OCHAR
/
/	AC		CHARACTER
/	FILEBLOCK	FILE INFO
/
/	ERROR:
/	AC	>=0	NO MORE SPACE
/	AC	<0	FATAL DEVICE ERROR
/
ICHAR,
OCHAR1,	0
	TAD	AC	/GET CHARACTER
	DCA	OCHAR	/SAVE IT.

	TAD	BLOCK+BUFCNT	/GET OFFSET.
	TAD	(-1000)		/CHECK IF END OF BLOCK REACHED.
	SZA CLA
	JMP	1$		/NO.
	JMS	NXTBLK	/YES. NEXT BLOCK.
	NOP

1$:	TAD	BLOCK+BUFCNT	/GET COUNT
	AND	(1774)
	CLL RAR
	TAD	BLOCK+BUFADR
	DCA	ARG		/THIS IS POINTER TO DOUBLEWORD CONTANING CHAR
	TAD	BLOCK+BUFFLD	/MAKE FIELD CHANGE CODE.
	TAD	(CDF)
	DCA	.+1
	HLT			/CHANGE FIELD.
	TAD	BLOCK+BUFCNT
	AND	(3)
	TAD	(-1)
	SNA		/0 = 2:ND CHAR...
	ISZ	ARG	/2:ND CHAR IS IN 2:ND WORD.
	SMA SZA CLA	/3:RD CHAR?
	JMP	OSPLIT	/3:RD...

	TAD I	ARG	/GET WORD.
	AND	(7400	/MASK CHAR.
	TAD	OCHAR	/PUT IN NEW CHAR.
	DCA I	ARG	/RESTORE.
OCRET,	CDF	.	/RESTORE FIELD.
	ISZ	BLOCK+BUFCNT	/BUMP POINTER.
	TAD	BLOCK+FILFLG	/SET BUFFER MODIFIED BIT.
	RAL
	CLL CML RAR
	DCA	BLOCK+FILFLG
	TAD	BLOCK+BUFCNT	/CHECK IF BUFFER IS FULL.
	TAD	(-1000)
	SZA CLA
	JMP	1$		/IS NOT.
	TAD	BLOCK+FILBLK	/IT IS. GET CURRENT BLOCK.
	DCA	AC
	JMS	PUT1		/OUTPUT CURRENT BLOCK

1$:	TAD	OCHAR		/GIVE OUTPUT CHARACTER BACK.
	DCA	AC
	JMP I	OCHAR1

OSPLIT,	CLA CLL CMA RAL	/REPEAT LOOP TWICE.
	DCA	LC
	TAD	OCHAR	/GET CHAR.
	RTL;RTL		/GET HIGH PART.
1$:	AND	(7400	/MASK.
	DCA	TMP	/SAVE IT.
	TAD I	ARG	/GET 1:ST WORD.
	AND	(377	/MASK AWAY PREVIOUS CHAR.
	TAD	TMP	/SAVE NEW CHAR.
	DCA I	ARG	/SAVE WORD.
	ISZ	ARG	/POINT AT NEXT WORD.
	TAD	OCHAR	/GET CHAR.
	RTR;RTR;RAR	/GET LOW PART
	ISZ	LC	/LOOP.
	JMP	1$
	CLA
	ISZ	BLOCK+BUFCNT
	JMP	OCRET	/CONTINUE.
	.SBTTL	ICHAR
/
/	7	ICHAR
/
/	AC		READ CHARACTER
/	FILEBLOCK	FILE INFO
/
/	ERROR:
/	AC	>=0	END OF FILE
/	AC	<0	FATAL DEVICE ERROR
/
OCHAR,
ICHAR1,	0
	TAD	BLOCK+BUFCNT	/CHECK BUFFER COUNT.
	TAD	(-1000)		/END?
	SZA CLA
	JMP	1$		/NO.
	JMS	NXTBLK		/YES.
	JMP	ERR1	/NO READ DONE. EOF.

1$:	TAD	BLOCK+BUFCNT	/GET BUFFER COUNT.
	AND	(1774)
	CLL RAR
	TAD	BLOCK+BUFADR
	DCA	ARG	/SAVE. THIS IS POINTER TO DOUBLEWORD CONTAINING CHARS
	TAD	BLOCK+BUFFLD	/GET FIELD
	TAD	(CDF	/MAKE CDF CODE
	DCA	.+1	/SAVE
	HLT		/AND EXECUTE.
	TAD	BLOCK+BUFCNT
	AND	(3)
	TAD	(-1)
	SNA
	ISZ	ARG
	SMA SZA CLA
	JMP	ISPLIT	/3:RD...
	TAD I	ARG	/GET WORD.
	AND	(377	/MASK CHAR.
PRET,	CDF	.	/RESTORE FIELD.
	ISZ	BLOCK+BUFCNT
	DCA	AC	/SAVE CHAR.
	JMP I	ICHAR1	/RETURN.

ISPLIT,	TAD I	ARG	/GET HIGH PART OF CHAR
	AND	(7400	/MASK
	CLL RTR;RTR	/MOVE TO PLACE.
	DCA	TMP	/SAVE.
	ISZ	ARG
	TAD I	ARG	/GET LOW PART.
	AND	(7400	/MASK
	CLL RTL;RTL;RAL	/MOVE TO PLACE.
	TAD	TMP	/GET HIGH PART.
	ISZ	BLOCK+BUFCNT
	JMP	PRET	/CONTINUE.
/
	PAGE
	.SBTTL	PRINT
/
/	10	PRINT
/
/	FILEBLOCK	FILE INFO
/	ARG		POINTER TO STRING
/
/	ERRORL:
/	AC	>=0	NO MORE SPACE
/	AC	<0	FATAL DEVICE ERROR
/
PRINT1,	0
	DCA	FLG	/CLEAR WRD
	TAD	DCDF1	/GET CDF CODE.
	DCA	GNXT	/PUT AT SPOT.
	TAD	ARG	/MOVE STRING POINTER TO SAFE PLACE...
	DCA	STRPTR
1$:	JMS	GCSIX	/GET SIXBIT CHAR.
	SNA		/WAS IT PREF                                                                                                                                                                                                                                                                                                                                                                                IX?
	JMS	PREFIX	/YES. GET PREFIX EXTENSION.
	DCA	AC	/SAVE CHARACTER.
	JMS	OCHAR1	/OUTPUT CHARACTER.
	JMP	1$	/REPEAT.

PREFIX,	0		/PREFIX EXTENSION FUNCTION
	DCA	AC	/CLEAR AC IF WE SHALL RETURN...
	JMS	GCSIX	/GET NEXT CHARACTER
	SNA		/IS THE CHAR ZERO?
	JMP I	PRINT1	/YES. END OF STRING.
	TAD	(100	/WRAP. CAPITALS BECOME CONTROL, SPECIALS BECOME
	AND	(177	/LOWERCASE.
	JMP I	PREFIX	/RETURN.

GCSIX,	0		/GET CHAR. SIXBIT.
	ISZ	FLG	/FIRST OR SECOND CHAR?
	JMP	GNXT	/FIRST.
	CLA		/SECOND...
	TAD	WRD	/GET STORED VALUE.
DO,	JMS	UNSIX	/UNSIXIFY.
	JMP I	GCSIX	/RETURN

GNXT,	HLT		/FETCH NEXT WORD. HERE WILL CDF BE PLACED.
	TAD I	STRPTR	/GET WORD.
	CDF	.
	DCA	WRD	/SAVE IT.
	ISZ	STRPTR	/BUMP WORD PTR.
	CLA CMA		/SET FLAG FOR SECOND CHAR...
	DCA	FLG
	TAD	WRD	/GET WORD.
	RTR;RTR;RTR	/SWAP
	JMP	DO	/JUMP TO UNSIXIFY PART.

WRD,	0
STRPTR,	0
FLG,	0
	.SBTTL	POSIT
/
/	11	POSIT
/
/	FILEBLOCK	FILE INFO
/	ARG		POINTER TO POSITION (24BIT)
/
/	ERROR:
/	AC	>=0	END OF FILE
/		<0	FATAL DEVICE ERROR
/
POSIT1,	0
	TAD I	ARG	/GET ADDRESS OF ARGUMENT.
	DCA	TMP
	TAD	DCDF1	/GET FIELD.
	DCA	.+1
	HLT
	TAD I	TMP	/GET BLOCK #.
	ISZ	TMP
	DCA	AC
	TAD I	TMP	/GET OFFSET.
	DCA	BLOCK+BUFCNT
	CDF	.
	JMS	GET1	/READ IN BLOCK.
	JMP I	POSIT1	/RETURN
	.SBTTL	POSITP
/
/	12	POSITP
/
/	AC		RETURNED LOW PART OF POS.
/	FILEBLOCK	FILE INFO
/	ARG		POINTER TO ADDRESS FOR HIGH PART.
/
/	ERROR:
/	NONE
/
POSIP1,	0
	TAD I	ARG	/GET POINTER TO RESULT ADDRESS.
	DCA	TMP
	TAD	DCDF1	/GET CDF CODE
	DCA	.+1	/SAVE IT
	HLT		/AND EXECUTE IT.
	TAD	BLOCK+FILBLK	/GET BLOCK.
	DCA I	TMP
	ISZ	TMP
	TAD	BLOCK+BUFCNT	/GET OFFSET.
	DCA I	TMP
	CDF	.
	JMP I	POSIP1	/RETURN
	.SBTTL	CLOSE
/
/	13	CLOSE
/
/	FILEBLOCK	FILE INFO
/
/	ERROR:
/	AC	>=0	NO MORE SPACE
/		<0	FATAL DEVICE ERROR
/
CLOSE1,	0
	TAD	BLOCK+FILFLG	/GET FLAGS.
	SMA CLA		/MODIFIED BLOCK?
	JMP	1$	/NO.
	TAD	BLOCK+FILBLK	/YES. OUTPUT IT.
	DCA	AC
	JMS	PUT1

1$:	TAD	BLOCK+FILFLG	/GET FLAGS.
	RAR
	SNL CLA		/TENTATIVE FILE?
	JMP	ECLOSE	/NO.

	TAD	(BLOCK+FILNAM-1)
	DCA	X0
	TAD	(FILE-1)
	DCA	X1
	TAD	(-4)
	DCA	LC
2$:	TAD I	X0
	DCA I	X1
	ISZ	LC
	JMP	2$

	TAD	BLOCK+FILSIZ	/YES. SET UP FINAL SIZE.
	DCA	FSIZ

	TAD	BLOCK+DEVNUM	/GET DEV. #
	CIF	10
	JMS	USR	/CALL USR FOR CLOSE.
	4
	FILE
FSIZ,	0
	JMP	ERR1

ECLOSE,	DCA	BLOCK+FILFLG	/CLEAR FILE FLAGS.
	JMP I	CLOSE1	/RETURN
/
	PAGE
	.SBTTL	FLUSH
/
/	14	FLUSH
/
/	FILEBLOCK	FILE INFO
/
/	OUTPUT:
/	AC		BLOCK #
/
/	ERROR:
/	AC	>=0	NO MORE SPACE
/		<0	FATAL DEVICE ERROR
/
FLUSH1,	0		/ENTRY TO FLUSH.
	DCA	AC	/CLEAR AC.
	TAD	BLOCK+FILFLG	/CHECK IF BLOCK HAS BEEN MODIFIED.
	SMA CLA
	JMP I	FLUSH1		/WAS NOT...

1$:	TAD	BLOCK+BUFCNT	/FILL REST OF CURRENT WORD...
	AND	(3)		/GET BYTE OFFSET.
	SNA CLA			/OFFSET=0?
	JMP	2$		/YES.
	JMS	OCHAR1		/NO. OUTPUT A NUL.
	JMP	1$		/REPEAT.

2$:	TAD	BLOCK+BUFCNT	/GET OFFSET.
	AND	(1774)		/GET WORD OFFSET.
	CLL RAR
	DCA	TMP		/SAVE OFFSET.
	TAD	TMP
	TAD	(-400)		/GET COUNT.
	SNA
	JMP	4$		/ALREADY AT END OF BLOCK.
	DCA	LC
	TAD	TMP		/GET OFFSET.
	TAD	BLOCK+BUFADR
	DCA	TMP		/SAVE ADDRESS.
	TAD	BLOCK+BUFFLD	/GET BUFFER FIELD.
	TAD	(CDF)
	DCA	.+1
	HLT			/CHANGE FIELD.

3$:	DCA I	TMP		/CLEAR WORD.
	ISZ	TMP		/BUMP POINTER.
	ISZ	LC		/BUMP COUNTER.
	JMP	3$		/LOOP.

4$:	CDF	.		/CHANGE FIELD BACK.
	TAD	(1000)		/SET POINTER TO END OF BLOCK.
	DCA	BLOCK+BUFCNT
	TAD	BLOCK+FILBLK	/GET CURRENT BLOCK #.
	DCA	AC
	JMS	PUT1		/OUTPUT CURRENT BLOCK #.

	JMP I	FLUSH1

	PAGE
	.SBTTL	OTHER
/
/	ASSORTED ROUTINES...
/
UNSIX,	0		/UNSIXIFY ROUTINE.
	AND	(77	/MASK SIXBIT CHAR.
	SNA		/ZERO?
	JMP I	UNSIX	/YES. RETURN.
	TAD	(-40	/SEPARATE CHARS FROM SPECIAL.
	SPA		/CHAR?
	TAD	(100	/YES. CHARACTIFY.
	TAD	(40	/NORMALIZE.
	JMP I	UNSIX	/RETURN
/
UNPACK,	0
	DCA	ARG
	CMA
	TAD I	UNPACK
	DCA	10
	ISZ	UNPACK
	TAD	(-4	/10 CHARS
	DCA	LC
1$:	TAD I	ARG	/GET WORD.
	RTR;RTR;RTR	/1:ST CHAR
	JMS	UNSIX	/AS BYTE
	DCA I	10	/AND SAVE.
	TAD I	ARG	/2:ND CHAR
	JMS	UNSIX	/AS BYTE
	DCA I	10	/AND SAVE.
	ISZ	ARG	/BUMP TO NEXT WORD
	ISZ	LC	/DUMP COUNTER
	JMP	1$	/AND LOOP.
	JMP I	UNPACK
/
WFIX,	0		/WILDCARD FIX.
	CLA CMA		/GET ARG.
	TAD I	WFIX
	DCA	X0	/DESTINATION.
	ISZ	WFIX
	TAD	DCDF1
	DCA	GIARG1
1$:	JMS	GIARG	/GET 1:ST WORD
	TAD	(-5200	/WAS IT "* "
	SZA CLA
	TAD	1$	/NO. AS LOOP TO GET ARG.
	SNA
	TAD	(CMA	/YES. SET TOOP TO WRITE "??????"
	DCA	2$
	TAD	(-3
	DCA	LC
2$:	HLT		/COPY FILENAME.
	DCA I	X0
	ISZ	ARG	/BUMP SOURCE POINTER.
	ISZ	LC
	JMP	2$

WEX,	JMS	GIARG		/CHECK IF EXTENSION IS "* "
	TAD	(-5200
	SNA
	TAD	(7777-5200	/IT IS. CHANGE TO "??"
	TAD	(5200
	DCA I	X0		/SAVE.
	JMP I	WFIX		/RETURN
/
GIARG,	0
GIARG1,	HLT
	TAD I	ARG
	CDF	.FLD
	JMP I	GIARG
/
CMFIL,	0			/COMPARE FILES.
	CLA CMA			/GET 1:ST FILEPTR
	TAD I	CMFIL
	DCA	X0
	ISZ	CMFIL
	CMA			/GET 2:ND FILEPTR
	TAD I	CMFIL
	DCA	X1
	ISZ	CMFIL
	TAD	(-10		/COMPARE 10 CHARS.
	DCA	LC

1$:	TAD I	X0		/GET CHAR.
	TAD	(-77		/COMPARE WITH "?".
	SNA			/EQUALS?
	JMP	3$		/YES. WILDCARD.
	TAD	(77		/NO. RESTORE
	CIA			/AND NEGATE,
	TAD I	X1		/AND COMPARE.
	SZA CLA			/EQUALS?
	JMP I	CMFIL		/NO. RETURN NOT EQUAL.
2$:	ISZ	LC		/YES, EQUALS. BUMP COUNT
	JMP	1$		/AND REPEAT.
	ISZ	CMFIL		/ALL WAS EQUAL. BUMP RETURN
	JMP I	CMFIL		/AND RETURN.

3$:	DCA I	X1		/WILDCARD MATCH. CLEAR AC, AND BUMP 2:ND FPTR
	JMP	2$		/AND CONTINUE.
/
	PAGE
/
CACHE,	ZBLOCK	400,0
/
$
