	.TITLE	GETSTR - Get a substring.
	.VERSION 21
	.ENABLE	7BIT
/ ++
/	GETSTR Y2.1
/
/	(c) 1989 by Johnny Billquist
/
/	History:
/
/	89/01/04 16:00	BQT	X1.0. Split from STRLIB.
/	89/12/27 05:00	BQT	Y2.0. Made frm PRSLIB.
/	90/01/04 15:30	BQT	Y2.1. Added variable separator.
/
/ --
	.FSECT	.GETSTR
	.ENTRY	$GETSTR
/
/ FUNCTION: GETS A STRING TERMINATED BY SPACE OR NULL.
/
/ USAGE:
/	JMS	$GETSTR
/	SRCSTR			SOURCE STRING POINTER.
/	DSTSTR			DESTINATION STRING POINTER.
/	MAXLEN			MAX LENGTH OF DESTINATION STRING.
/	SEP			SEPARATOR
/				AC POINTS AT REST OF STRING.
/
$GETSTR,
	0			/For return address.
	CLA
	TAD I	$GETSTR		/Get arg1.
	ISZ	$GETSTR
	DCA	SP$		/Save as source pointer.
	TAD I	$GETSTR		/Get arg2.
	ISZ	$GETSTR
	DCA	DP$		/Save as destination pointer.
	TAD I	$GETSTR		/Get arg3.
	ISZ	$GETSTR
	CIA
	DCA	ML$		/Save as max length.
	TAD I	$GETSTR		/Get arg4.
	ISZ	$GETSTR
	DCA	SEP1$		/Save as separator.
	TAD	SEP1$
	CIA
	DCA	SEP2$		/Both ways...
	RDF			/Get return field.
	TAD	(CDF CIF)
	DCA	R$
	RDF			/Get data field.
	TAD	(CDF)
	DCA	C1$
	TAD	C1$
	DCA	C2$
	CDF	.FLD		/Change to current field.

				/Skip leading spaces...
1$:	JMS	GC$		/Get char.
	SNA			/End of string?
	JMP	E$		/Yes.
	TAD	(-40		/No. Space?
	SZA CLA
	JMP	2$		/No. Start copying.
	ISZ	SP$		/Yes. Bump pointer.
	JMP	1$		/Repeat.

				/Copy string.
2$:	JMS	GC$		/Get char.
	SNA			/End of string?
	JMP	E$		/Yes.
	ISZ	SP$		/Bump pointer.
	TAD	SEP2$		/No. Separator?
	SNA
	JMP	E$		/Yes.
	TAD	SEP1$		/No.
	JMS	PC$		/Save char.
	ISZ	DP$		/Bump dest. pointer.
	ISZ	ML$		/Bump length count.
	JMP	2$		/Repeat.

				/Buffer full. Skip trailing chars...
3$:	JMS	GC$		/Get char.
	SNA			/End of string?
	JMP	E$		/Yes.
	ISZ	SP$		/No. Bump pointer.
	TAD	SEP2$		/Separator?
	SZA CLA
	JMP	3$		/No. Repeat.

				/End of copy.
E$:	JMS	PC$		/Put NUL at end of dest.
	TAD	SP$		/Get new source pointer.
R$:	HLT			/Return field.
	JMP I	$GETSTR		/Return.

GC$:	0			/Get char...
C1$:	HLT			/Change to data field.
	TAD I	SP$		/Get char.
	CDF	.FLD		/Change to current field.
	JMP I	GC$		/Return.

PC$:	0			/Put char...
C2$:	HLT			/Change to data field.
	DCA I	DP$		/Put char.
	CDF	.FLD		/Change to current field.
	JMP I	PC$		/Return.

SP$:	0			/Source pointer.
DP$:	0			/Destination pointer.
ML$:	0			/Max length.
SEP1$:	0			/Positive separator.
SEP2$:	0			/Negative separator.
/
$
