/*-------------------------------------------------------------------------
 *  Rocket Center of Pressure (cp) calculator - version 1.2
 *-------------------------------------------------------------------------
 * This file contains the help strings for the cp.c program. To eliminate
 * the help strings, uncomment the NO_HELP_STRINGS literal in cp.c. 
 *
 * Author: Mark C. Spiegl
 *
 * Copyright:
 * This program may be freely distributed, copied or modified provided
 * it is not used for profit. No warranty provided.
 *
 * Revisions:
 * 10/94   v1.2   Mark Spiegl - Add help screens
 *
 *------------------------------------------------------------------------
 */

#ifndef OUTPUT_HELP_STRINGS 

static char **no_help = (char **) 0; 
static char **nose_help = (char **) 0; 
static char **ocp_help = (char **) 0; 
static char **tran_help2 = (char **) 0; 
static char **tran_help = (char **) 0; 
static char **fin_help = (char **) 0; 
static char **r_help = (char **) 0; 
static char **xb_help = (char **) 0; 
static char **xp_help = (char **) 0; 

#else 

/****************************************************************************/
static char *no_help[] = {"\n      No additional help available\n\n", (char *)0};

/****************************************************************************/
static char *nose_help[] = {"\n",
"                                                              \n",
"                        ...............+                      \n",
"                       /\\              .                     \n",
"                      /  \\             .                     \n",
"                     /    \\            .                     \n",
"                    /      \\           .                     \n",
"                   /        \\      Length of nose            \n",
"                  /          \\         .  (Ln)               \n",
"                 /            \\        .                     \n",
"                /              \\       .                     \n",
"               /                \\      .                     \n",
"              /------------------\\ ....+                     \n",
"              |                  |                            \n",
"              .                  .                            \n",
"              +...... (d) .......+                            \n",
"                diameter at base                              \n",
"                    of nose                                   \n",
"                                                              \n", 
(char *) 0}; 

/****************************************************************************/
static char *ocp_help[] = {"\n",
"                                                               \n",
"      Ogive     ( O ) - Curved sides,   pointed top            \n",
"                                                               \n",
"      Cone      ( C ) - Straight sides, pointed top            \n",
"                                                               \n",
"      Parabolic ( P ) - Curved sides,   rounded top            \n",
"                                                               \n", 
(char *) 0};

/****************************************************************************/
static char *tran_help2[] = {"\n",
"\n",
"                  |      |                                     \n",
"                  | body |                                     \n",
"                  |      |                                     \n",
"                  /------\\                                    \n",
"                 /        \\                                   \n",
"                /transition\\                                  \n",
"               /            \\                                 \n",
"              /--------------\\                                \n",
"              |              |                                 \n",
"              |              |                                 \n",
"              |     body     |                                 \n",
"              |              |                                 \n",
"                                                               \n",
"                                                               \n", 
(char *) 0}; 

/****************************************************************************/
static char *tran_help[] = {"\n",
"                                                               \n",
"                  towards nose                                 \n",
"                                                               \n",
"                  +...(df)...+                                 \n",
"                  .          .                                 \n",
"                  |          |                                 \n",
"                  |          |                                 \n",
"                  /-----------\\ .......+                      \n",
"                 /             \\       .                      \n",
"                /               \\    length of transition     \n",
"               /                 \\     .    (Lt)              \n",
"              /-------------------\\ ...+                      \n",
"              |                   |                            \n",
"              |                   |                            \n",
"              |                   |                            \n",
"              .                   .                            \n",
"              +.......(dr)........+                            \n",
"                                                               \n",
"                 towards rear                                  \n",
"                                                               \n", 
(char *) 0}; 

/****************************************************************************/
static char *fin_help[] = {"\n",
"                                                                    \n",
"                                                                    \n",
"                         +.......Tip chord (Ct)........+            \n",
"                Sweep    .                             .            \n",
"             +...(Xr)....+                             .            \n",
"             .           /--------------+--------------/....+       \n",
"             .         /              .              /      .       \n",
"             .       /              .              /        .       \n",
"             .     /       Mid chord (Lf)        /     Semispan (S) \n",
"             .   /              .              /            .       \n",
"             . /              .              /              .       \n",
"   ==========/==============+==============/................+       \n",
"   =================== ROCKET BODY ========|                        \n",
"   ========================================|                        \n",
"   ========================================|                        \n",
"             .                             .                        \n",
"             +.......Root chord (Cr).......+                        \n",
"                                                                    \n\n", 
(char *) 0}; 

/****************************************************************************/
static char *r_help[] = {"\n",
"                                                                    \n",
"                       /-----------------------------/              \n",
"                     /                             /                \n",
"                   /                             /                  \n",
"                 /                             /                    \n",
"               /                             /                      \n",
"   ----------/-----------------------------/........+               \n",
"                                           |        .               \n",
"                         ROCKET BODY       |   Diameter (R)         \n",
"                                           |        .               \n",
"   ----------\\-----------------------------\\........+             \n",
"               \\                             \\                    \n",
"                 \\                             \\                  \n",
"                   \\                             \\                \n",
"                     \\                             \\              \n",
"                       \\-----------------------------\\            \n",
"                                                                    \n", 
(char *) 0}; 

/****************************************************************************/
static char *xb_help[] = {"\n",
"\n",
"                      ...................+                     \n",
"                     /\\                  .                    \n",
"                    /  \\                 .                    \n",
"                   /nose\\                .                    \n",
"                  /------\\               .                    \n",
"                  |      |        tip of nose to fin           \n",
"                  |      |         leading edge (Xb)           \n",
"                  | body |               .                     \n",
"                  |      |               .                     \n",
"                  |      |               .                     \n",
"                  +      +...............+                     \n",
"                 /|      |\\                                   \n",
"                / |      | \\                                  \n",
"               /  |      |  \\                                 \n",
"               |  |      |  |                                  \n",
"               |  |      |  |                                  \n",
"                                                               \n", 
(char *) 0}; 

/****************************************************************************/
static char *xp_help[] = {"\n",
"\n",
"                      ...................+                     \n",
"                     /\\                  .                    \n",
"                    /  \\                 .                    \n",
"                   /nose\\                .                    \n",
"                  /------\\               .                    \n",
"                  |      |        tip of nose to start         \n",
"                  |      |         of transition (Xp)          \n",
"                  | body |               .                     \n",
"                  |      |               .                     \n",
"                  |      |               .                     \n",
"                  /------\\...............+                    \n",
"                 /        \\                                   \n",
"                /transition\\                                  \n",
"               /            \\                                 \n",
"              /--------------\\                                \n",
"              |              |                                 \n",
"              |              |                                 \n",
"                                                               \n",
"                                                               \n", 
(char *) 0}; 

/****************************************************************************/


#endif 
