DEFINT I-N
DECLARE FUNCTION dragarea! (icode, fps, cd)

REM Calculation in American units (perverse) but I/O in metric
REM because used for high school students and need to set good example!

CONST rho = .078  'lb/cu ft: I live in an ideal atmosphere!
CONST rho2 = rho / 288 ' includes conversion from sq in to sq ft, and 0.5
                       ' for dynamic press. term
CONST g = 32.2, fs2mph = 60 / 88
DIM thr(20), tim(20), v(100), height(100)

COLOR 15, 1: CLS : PRINT
  PRINT "     *********************************************************"
  PRINT "     *  Program to predict model rocket performance based    *"
  PRINT "     *  on pressure, base, friction and interference drag    *"
  PRINT "     *  calculated from equations in FLUID DYNAMIC DRAG      *"
  PRINT "     *  by HOERNER. Program accounts for change in Reynolds  *"
  PRINT "     *  number as the model's speed changes.                 *"
  PRINT "     *  NO ALLOWANCE FOR TRANSONIC DRAG IS MADE.             *"
  PRINT "     *  Program is in Microsoft QuickBASIC language          *"
  PRINT "     *                                                       *"
  PRINT "     * (C) 1992,94 John S. Kallend. Please distribute freely *"
  PRINT "     *********************************************************"
  PRINT : PRINT " Press a key to continue": DO WHILE INKEY$ = "": LOOP
drgc:   imax = 0
        DO UNTIL INKEY$ = "": LOOP
        icode = 0
        a = dragarea(icode, 164, cd)
        icode = 1
        PRINT USING "Speed ###  Cd #.##"; av; cd
        IF oflg% THEN GOTO newdat

lp:     PRINT :
        imax = 0
        CLS : PRINT
        PRINT " Now enter engine data: you may do it": PRINT
        PRINT " 1. From RASP data file"
        PRINT " 2. Impulse & average thrust"
        PRINT
        PRINT " Enter 1 or 2 ==> 1"; : LOCATE , POS(0) - 1
        INPUT "", a$
        i = VAL(a$)
        SELECT CASE i
        CASE 0, 1
        OPEN "rasp.dat" FOR INPUT AS #1
        icol = 1: irow = 1
        CLS
        DO: DO
        IF EOF(1) THEN GOTO e1
        LINE INPUT #1, a$
        LOOP UNTIL LEFT$(a$, 1) <> ";"
        LOCATE , icol:
        PRINT LEFT$(a$, 9)
        IF CSRLIN = 24 THEN icol = icol + 10: LOCATE 1, icol
        DO: IF EOF(1) THEN EXIT DO:
        LINE INPUT #1, a$:
        LOOP UNTIL LEFT$(a$, 1) = ";"
        LOOP

e1:     CLOSE #1


        LOCATE 25, 1: INPUT "Type engine designation (e.g., B6) ==> ", eng$
        eng$ = UCASE$(eng$)
        L = LEN(eng$)

        OPEN "rasp.dat" FOR INPUT AS #1
        DO
        IF EOF(1) THEN PRINT "Not found": CLOSE #1: SLEEP 2: GOTO lp
        LINE INPUT #1, e$
        LOOP UNTIL LEFT$(e$, L) = eng$
        CLS : PRINT : PRINT e$
        nwtflg% = 0
        L = INSTR(e$, " ")
        FOR j = 1 TO 3
        FOR i = L TO 80: IF MID$(e$, i, 1) <> " " THEN EXIT FOR
        NEXT
        IF i >= LEN(e$) THEN nwtflg% = -1: EXIT FOR
        L = INSTR(i, e$, " ")
        NEXT
        pwt = VAL(MID$(e$, L, 60))
        PRINT "Propellant weight = "; 1000 * pwt; "g,";
        
        FOR i = L TO 80: IF MID$(e$, i, 1) <> " " THEN EXIT FOR
        NEXT
        L = INSTR(i, e$, " ")
        motrwt! = VAL(MID$(e$, L, 60))
        PRINT " motor weight = "; 1000 * motrwt!; "g"
        PRINT : PRINT "Press a key to continue":
        DO WHILE INKEY$ = "": LOOP
        thr(0) = 0: tim(0) = 0
        i = 1
        DO
         INPUT #1, tim(i), thr(i)
         'PRINT a, b
         i = i + 1
        LOOP UNTIL thr(i - 1) = 0
        CLOSE #1
        burn = tim(i - 1)
        engflag% = -1
        npoints = i - 1
        FOR i = 1 TO npoints
        thr(i) = thr(i) * 2.2 * g / 9.81'convert to pounds
        NEXT
        PRINT

        CASE 2
        INPUT " Enter motor impulse (N.sec) : ", impls
        INPUT " Enter average thrust (N) : ", thrust
        IF thrust = 0 GOTO lp
        burn = impls / thrust:
        thrust = thrust * 2.2 / 9.81: PRINT 'convert to pounds
'        PRINT USING "Thrust = ###.#lb. Burn time = ##.#sec."; thrust; burn
        PRINT : SLEEP 1
        thrust = thrust * g  ' convert to poundals for Newton's Law
        engflag% = 0
        nwtflg% = -1
        CASE ELSE
        GOTO lp
        END SELECT
        IF oflg% THEN GOTO newdat

wt:     imax = 0
        IF oflg% THEN
         CLS
         PRINT " Current weight = "; wgt * 16 * 28; "g"
        END IF
        PRINT : INPUT " Enter total liftoff weight in grams :", wgt
        IF wgt <= 0 GOTO wt
        wgt = wgt / 16 / 28
        IF nwtflg% OR NOT engflag% THEN 'don't have it from RASP
          PRINT : INPUT " and propellant weight in grams :", pwt
        END IF
        pwt = pwt / 16 / 28
        IF pwt >= wgt THEN GOTO wt
        IF oflg% THEN GOTO newdat


'       Now comes the time slice solution of the equation of motion.
'       Calculations made every 1/100 of second.
'       Uses extrapolated velocity for next time slice to
'       improve accuracy, though little difference noted with time
'       slice this small. Runge-Kutta *may* be a little better
'       but I suspect not worth the effort since the physical assumptions
'       are so gross anyway, and f(v,t) does not behave in a peculiar
'       way.

calc:   PRINT : PRINT "WAIT"
        IF NOT engflag% THEN actthr = thrust 'average thrust
        vmax = 0: v = 0: height = 0: PRINT
        icount = 0
        dt = .025: dvlast = 0!: aimp = 0!
        FOR it = 0 TO 20 / dt
        t = it * dt
         IF t >= burn THEN
          actthr = 0
         ELSE
          actwt = wgt - (pwt * t / burn)
          IF engflag% THEN 'we have RASP data, so linear interpolate
           FOR j = 0 TO npoints
             IF tim(j) > t THEN EXIT FOR
           NEXT
             actthr = thr(j - 1) + (t - tim(j - 1)) * (thr(j) - thr(j - 1)) / (tim(j) - tim(j - 1))
           END IF
        END IF
        IF height <= 0 THEN IF v < 0 THEN v = 0' doesn't go backwards on ramp
        IF it > 20 THEN IF v <= 0 THEN EXIT FOR   'apogee
        dv = (actthr - drag) * dt / (actwt)
        dv = dv - g * dt: v = v + dv   'vertical flight assumed
        d2v = dv - dvlast
        dvlast = dv
        dvnext = dv + d2v
        vnextime = v + dvnext * .5       'anticipate velocity in
                                         'center of next time slice
                                         'It's not Runge-Kutta but it
                                         'has same effect in this problem
        aimp = aimp + actthr
        height = height + v * dt
        IF v > vmax THEN vmax = v: hburn = height
        af = dragarea(1, vnextime, cd)
        drag = rho2 * af * vnextime * vnextime   ' drag in poundals
       IF it / 10 = it \ 10 THEN
         v(icount) = v: height(icount) = height
         icount = icount + 1
       END IF
       NEXT
       imax = icount - 1
       CLS
       PRINT : LOCATE , 5
       PRINT USING " Max. speed = ####m/s = ###mph"; vmax / 3.28; vmax * fs2mph
       LOCATE , 5
       PRINT USING " Burnout height = #### m"; hburn / 3.28
       LOCATE , 5
       PRINT USING " Maximum height = #### m"; height / 3.28
       LOCATE , 5
       PRINT USING " Time to apogee = ##.# sec."; t
       LOCATE , 5
       pimp = aimp * dt / g * 4.43
       IF pimp > 10 THEN
        u$ = " Calc. motor impulse = #### N.s"
       ELSE
        u$ = " Calc. motor impulse = ##.# N.s"
       END IF
       PRINT USING u$; pimp
       LOCATE 25, 5: PRINT "Press ENTER to continue"; :
       DO: a$ = INKEY$: LOOP UNTIL a$ <> ""

2 newdat:
        oflg% = -1
        VIEW PRINT
        CLS : LOCATE 2, 2: PRINT "Now you can:"
        LOCATE 5, 1: PRINT " 0. QUIT": PRINT
        PRINT " 1. Enter new rocket dimensions ": PRINT
        PRINT " 2. Change weight": PRINT :
        PRINT " 3. Try new motor": PRINT
        PRINT " 4. Calculate performance": PRINT
        PRINT " 5. Print out flight profile": PRINT
        PRINT " 6. Drag coefficient vs velocity": PRINT
        PRINT " Enter choice (0 thru 6) ==> ";
        INPUT "", a$
        i = VAL(a$):  IF i > 6 THEN GOTO newdat
        ON i GOTO drgc, wt, lp, calc, detail, cdpr
        END

detail:  mcol = 1
        IF imax <> 0 THEN
         SCREEN 9
         COLOR 15, 1: CLS
         LOCATE 1: PRINT "  Time  vel(m/s) alt(m)"
         VIEW PRINT 2 TO 25: mcol = 1
        
         FOR icount = 0 TO imax
         LOCATE , mcol: ' dgp = drag / 32 * 16 * 28
         hgp = height(icount) / 3.28
         PRINT USING "  ##.##   ###    ####"; icount * .25; v(icount) / 3.28; hgp
         IF CSRLIN = 25 THEN
            mcol = mcol + 25: LOCATE 2
         END IF
         IF mcol > 55 THEN mcol = 1
         NEXT
        WINDOW (0, 0)-(imax, height / 3.1)
        FOR icount = 1 TO imax
        LINE (icount - 1, height(icount - 1) / 3.28)-(icount, height(icount) / 3.28), 15
        NEXT
        WINDOW (0, 0)-(imax, vmax / 3.1)
        FOR icount = 1 TO imax
        LINE (icount - 1, v(icount - 1) / 3.28)-(icount, v(icount) / 3.28), 14
        NEXT

        SLEEP 160
        SCREEN 0: COLOR 15, 1
        ELSE
         PRINT "You must calculate performance first"
        GOTO calc
        END IF
       LOCATE 25, mcol: PRINT "Press ENTER to continue"; :
       DO: a$ = INKEY$: LOOP UNTIL a$ <> ""

       GOTO newdat

cdpr: CLS
    PRINT " Vel(m/s)  Cd": PRINT
    FOR av = 25 TO 300 STEP 25
    fps = av * 3.28
    a = dragarea(1, fps, cd)
    PRINT USING " ###      #.##"; av; cd
    NEXT
       LOCATE 25, 2: PRINT "Press ENTER to continue"; :
       DO: a$ = INKEY$: LOOP UNTIL a$ <> ""

       GOTO newdat

DEFSNG L-N
FUNCTION dragarea (icode, v, cd) STATIC
REM icode=0 for data entry, 1 for calculations
STATIC xc
CONST pi = 3.1416, pio4 = pi / 4, in2cm = 2.54

10    fps = v: IF fps <= 0 THEN fps = 1
      IF icode = 0 THEN
        VIEW PRINT
        CLS : LOCATE 3, 1
        COLOR 15, 1: CLS : LOCATE 1, 22:
        PRINT "ROCKET DRAG CALCULATION DATA ENTRY"
        VIEW PRINT 2 TO 25
        IF xc <> 0 THEN
getdat:  cgflag% = -1: CLS
         LOCATE 3, 1: PRINT " CURRENT DATA"
         PRINT " Fuselage length = "; lgthin * in2cm; "cm"
         PRINT " Nose length = "; nosel * in2cm; "cm"
         PRINT " Diameter = "; dia * in2cm; "cm"
         PRINT " Fin area = "; finarea * in2cm * in2cm; "cm^2"'back to cm squared!
         PRINT " Surface:"; fin$
         PRINT USING " 50 m/s  Drag Coeff. on fuselage frontal area = #.## "; cdsav
         PRINT " Relative drag contributions at last computed speed shown below:"
         PRINT
         PRINT " You may now make changes to:": PRINT
         PRINT " 0. Nothing - go back to menu"
         PRINT USING " 1. Fuselage: ###.# % (base drag = ##.# %)"; fa; ba
    '     PRINT USING " 2. Wing:     ###.# %"; wa
         PRINT USING " 2. Fins:     ###.# % (interference = ###.# %)"; fina; fintar * 100 / xc
         PRINT USING " 3. Misc:     ###.# %"; amisc * 100 / xc
         PRINT " 4. Surface finish:"
         PRINT
         PRINT " Enter 1 thru 4 to change one of these, 0 to continue ==> ";
         INPUT "", a$
         i = VAL(a$): CLS : IF i = 0 THEN VIEW PRINT: GOTO exi
         ON i GOSUB getfus, getfins, getmisc, getsurf

        ELSE
          cgflag% = 0
          wflag% = 0: fflag% = 0: sflag% = 0
          wdrgarea = 0!: findrga = 0!
          GOSUB getsurf
          PRINT : PRINT " Dimensions of fuselage/body including nose "
          GOSUB getfus
   '       PRINT : INPUT "2: WINGS (Y/N)? ", a$
    '      a$ = UCASE$(a$)
     '     IF a$ = "N" THEN wflag% = 0: GOTO nowing
      '    GOSUB getwing
          wflag% = 0
nowing:
     '     PRINT : INPUT "3. FINS (Y/N) :", a$
      '    IF UCASE$(a$) = "N" THEN fflag% = 0: GOTO nofins ELSE fflag% = -1
          GOSUB getfins

nofins:   PRINT : PRINT "4. Miscellaneous drag items (lugs, skids etc)"
          PRINT :
          GOSUB getmisc
          VIEW PRINT
        END IF
        
'        fps = 150
      END IF 'this completes icode=0 code

      'Body tube drag follows. I use turbulent flow formula
      '(it will surely be turbulent after the nose/bt junction).
      critk = .0154 / fps   '.185/12 constant for max roughness in FEET
      reyn = 6100 * fps * lgth
      IF sfk > critk THEN
       cf = .032 * (sfk / lgth) ^ .2
      ELSE
       cf = 1! / (1.5024 * LOG(reyn) - 5.6) ^ 2 'Schoenherr equation for
                                               'smooth turbulent flow.
                                               'Assume forebody pressure
                                               'drag negligible (according
                                               'to Hoerner).
      END IF
      dcf = .0016 * ldrat / reyn ^ .4     'Correction for curvature
      cf = cf + dcf

      cdnbt = 1.02 * cf * (1! + 1.5 * dol + 7 * dol * dol) * sw / xsec
      cdb = .029 / SQR(cdnbt)
      fusarea = (cdnbt + cdb) * xsec
      basarea = cdb * xsec    'Hoerner is very pessimistic about the
                              'effect of boat-tailing, and so I shall
                              'ignore it.

      '***WINGS*****
      'wing calculation will be ignored in this program
      IF wflag% THEN   'wing calculation at zero lift
        reyn = 6100 * fps * chord
        cf = 1.33 / SQR(reyn)   'Blasius equation for laminar flow
        cf2 = 1! / (1.5024 * LOG(reyn) - 5.6) ^ 2 - 310 / reyn
        ' the 310/R term gives transition region. Pessimistic!
        'laminar/turbulent transition at R=5.4E5
        IF cf2 > cf THEN
         cf = cf2 ' turbulent flow or transition
         cdwing = 2! * cf * (1! + 2 * thick + 60 * thick ^ 4)
        ELSE
         cdwing = 2! * cf * (1! + thick) + thick ^ 2
        END IF
        wdrgarea = cdwing * wngarea
      END IF

      '***FINS***

      IF fflag% THEN ' use same equations as wing above.
        reynf = 6100 * fps * c
      IF sfk > critk THEN
       cf = .032 * (sfk / c) ^ .2  'Cf from surface roughness
       cdfin = 2! * cf * (1! + 2! * toc + 60 * (toc) ^ 4)
      ELSE


        IF reynf < 100000! THEN    'More likely turbulent because
         cf = 1.33 / SQR(reynf)    'of interference with body
         cdfin = 2! * cf * (1! + toc) + (toc) ^ 2
        ELSE
         cf2 = 1! / (1.5024 * LOG(reynf) - 5.6) ^ 2 - 310 / reynf
         cdfin = 2! * cf2 * (1! + 2! * toc + 60 * (toc) ^ 4)
        END IF
       END IF
        IF NOT sflag% THEN cdfin = cdfin + 1.1 * (toc) ^ 2 'correction
                                                           'for rounded fins
        findrga = cdfin * finarea
      END IF


      xc = fusarea + wdrgarea + findrga + amisc + fintar
      dragarea = xc
      cd = xc / xsec
      IF icode = 0 THEN
         cdsav = cd
         fa = fusarea * 100! / xc: ba = basarea * 100! / xc
         wa = wdrgarea * 100! / xc: fina = findrga * 100! / xc
         IF cgflag% THEN GOTO getdat
         CLS : LOCATE 3, 1
         PRINT USING " Drag coeff. on fuselage frontal area = #.## "; cd
         PRINT " Relative drag contributions at 50m/s": PRINT
         PRINT USING " Fuselage:    ###.# % (base drag = ##.# %)"; fa; ba
   '      PRINT USING " Wing:     ###.# %"; wa
         PRINT USING " Fins:        ###.# %"; fina
         PRINT USING " Interference:###.# %"; fintar * 100 / xc
         PRINT USING " Misc:        ###.# %"; amisc * 100 / xc
         PRINT : INPUT " Press a key to continue ", a$
      END IF
      GOTO exi

getsurf:
        CLS : PRINT : PRINT " Closest description of surface finish:": PRINT
        PRINT " 1. Highly polished paint or similar polished surface"
        PRINT " 2. Sprayed, smooth gloss paint or similar"
        PRINT " 3. Rough or matt paint"
        PRINT " 4. Unfinished wood, poor quality paint, or worse"
        PRINT : INPUT " Enter 1 thru 4 ==> ", isurf
        SELECT CASE isurf
        CASE 1
         sfk = .0001        'equiv grain size in inches from Chap.V
         fin$ = " polished"
        CASE 2
         sfk = .0005
         fin$ = " smooth"
        CASE 3
         sfk = .001
         fin$ = " matt"
        CASE 4
         sfk = .008
         fin$ = " poor, unfinished"
        CASE ELSE
         GOTO getsurf
        END SELECT
        vcrit = .185 / sfk / 3.3    'chap 5 equ 3
        IF isurf > 1 THEN
         PRINT
         PRINT USING " Surface will cause extra drag above ### m/s"; vcrit
         IF x <> 0 THEN SLEEP 1
        END IF
        sfk = sfk / 12!'to feet
        RETURN

        
getfus:

      PRINT :
      INPUT " Enter overall length (cm): ", lgthin: lgthin = lgthin / in2cm
      lgth = lgthin / 12  'conv to feet
      INPUT " Enter NOSE length (cm): ", nosel: nosel = nosel / in2cm
fus:
 '     PRINT : INPUT " Enter 0 for CIRCULAR, 1 for RECTANGULAR body : ", a$
  '    i = VAL(a$)
   '   IF i = 0 THEN
         INPUT " Enter diameter of tube (cm) : ", dia: dia = dia / in2cm
         xsec = pio4 * dia * dia
         uni = lgthin - nosel
         sw = pi * dia * (uni + nosel * .67)
       
'      ELSEIF i = 1 THEN
 '        INPUT " Fuselage width (in) : ", wid
  '       INPUT " and depth (in) : ", dep
   '      xsec = wid * dep
    '     uni = lgthin - nosel
     '    sw = 2 * (dep + wid) * (uni + nosel * .67)
      'ELSE
       '  GOTO fus
  '    END IF
'       PRINT "xsec="; xsec; "sw="; sw
      d = 2 * SQR(xsec / pi):
      dol = (d / lgthin) ^ 1.5
      ldrat = lgthin / d
      RETURN

getwing:
      PRINT
      INPUT " Enter total wing area in sq.in. : ", wngarea
      IF wngarea = 0 THEN wflag% = 0: RETURN ELSE wflag% = -1
      INPUT " Enter % thickness : ", thick: thick = thick / 100!
      INPUT " Enter wingspan in inches: ", span
      chord = wngarea / span / 12
      RETURN

getfins: CLS
      PRINT : PRINT " Please enter fin dimensions": PRINT
      PRINT " 1. Trapezoidal or triangular fins"
      PRINT " 2. Any other shape": PRINT
      INPUT " Enter 1 or 2 ==> ", ixfi
      PRINT
      SELECT CASE ixfi
      CASE 1
      INPUT " How many fins? ", nfin
      IF nfin = 0 THEN fflag% = 0: RETURN ELSE fflag% = -1
      INPUT " Enter fin root chord in cm. ", frtchd
      INPUT " and tip chord in cm. ", ftpchd
      c = (frtchd + ftpchd) * .5
      INPUT " Now enter fin length perpendicular to body (cm) ", flnght
      finarea = c * flnght * nfin

      
      CASE 2
      INPUT " How many fins? ", nfin
      IF nfin = 0 THEN fflag% = 0: RETURN ELSE fflag% = -1
      INPUT " Enter total fin area in sq.cm. ", finarea
      INPUT " and fin root chord in cm. ", frtchd
      INPUT " Now enter fin length perpendicular to body (cm) ", flnght
      c = finarea / nfin / flnght
      CASE ELSE
      GOTO getfins
      END SELECT

      finarea = finarea / in2cm / in2cm
      INPUT " Enter fin thickness in cm : ", t
      t = t / 12 / in2cm
       c = c / 12 / in2cm: PRINT
       toc = t / c: roottoc = t / frtchd: Cdcint = .8 * roottoc ^ 3
       IF Cdcint < .001 THEN Cdcint = .001
       fintar = (frtchd / in2cm) ^ 2 * Cdcint * nfin
       'interference Cdc from Hoerner, per fin
       'assume near worst case
      IF c = 0 THEN PRINT "ERROR IN DATA VALUE - REENTER": GOTO getfins
      INPUT " Enter 0 for streamlined or 1 for rounded fins : ", a$
      
      IF UCASE$(a$) = "0" THEN sflag% = -1 ELSE sflag% = 0
      RETURN

getmisc:  PRINT
INPUT " Enter total frontal area of lugs etc. in sq.cm. : ", amisc
       amisc = amisc / in2cm / in2cm
     RETURN

exi:
     END FUNCTION

