/*
 *  linux/ibcs/stream.c
 *
 *  Copyright (C) 1994  Mike Jagdis (jaggy@purplet.demon.co.uk)
 *
 * $Id: stream.c,v 1.3 1995/02/13 10:13:17 mike Exp $
 * $Source: /usr/CVS/ibcs/iBCSemul/stream.c,v $
 */

#include <linux/config.h>

#include <linux/module.h>
#include <linux/version.h>

#include <asm/segment.h>
#ifndef KERNEL_DS
#include <linux/segment.h>
#endif

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/kernel.h>

#include <ibcs/ibcs.h>
#include <ibcs/stream.h>

#ifdef IBCS_TRACE
#include <ibcs/trace.h>
#endif


/* We LIE and pretend that getmsg and putmsg succeeded. This is necessary
 * for the emulation of the /dev/spx interface to the local X server.
 * If you plan on implmenting these tread very carefully...
 */


int
ibcs_getmsg(int fd, struct strbuf *ctlptr, struct strbuf *dataptr, int *flags)
{
#ifdef IBCS_TRACE
	if ((ibcs_trace & TRACE_API) || ibcs_func_p->trace) {
		printk(KERN_DEBUG "iBCS: getmsg from %d, ctl=%lx[%ld], data=%lx[%ld], flags=%lx\n",
			fd,
			(unsigned long)(ctlptr ? get_fs_long(&ctlptr->buf) : 0L),
			(unsigned long)(ctlptr ? get_fs_long(&ctlptr->maxlen) : 0L),
			(unsigned long)(dataptr ? get_fs_long(&dataptr->buf) : 0L),
			(unsigned long)(dataptr ? get_fs_long(&dataptr->maxlen) : 0L),
			(unsigned long)get_fs_long(flags));
	}
#endif
	return 0;
}


int
ibcs_putmsg(int fd, struct strbuf *ctlptr, struct strbuf *dataptr, int *flags)
{
#ifdef IBCS_TRACE
	if ((ibcs_trace & TRACE_API) || ibcs_func_p->trace) {
		printk(KERN_DEBUG "iBCS: putmsg from %d, ctl=%lx[%ld], data=%lx[%ld], flags=%lx\n",
			fd,
			(unsigned long)(ctlptr ? get_fs_long(&ctlptr->buf) : 0L),
			(unsigned long)(ctlptr ? get_fs_long(&ctlptr->maxlen) : 0L),
			(unsigned long)(dataptr ? get_fs_long(&dataptr->buf) : 0L),
			(unsigned long)(dataptr ? get_fs_long(&dataptr->maxlen) : 0L),
			(unsigned long)get_fs_long(flags));
	}
#endif
	return 0;
}
