/*
 *  linux/ibcs/timod.c
 *
 *  Copyright (C) 1995  Mike Jagdis
 *
 * $Id: timod.c,v 1.1 1995/03/07 17:19:37 mike Exp $
 * $Source: /usr/CVS/ibcs/iBCSemul/timod.c,v $
 */
#include <linux/config.h>

#include <linux/module.h>
#include <linux/version.h>

#include <asm/segment.h>
#ifndef KERNEL_DS
#include <linux/segment.h>
#endif

#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/mm.h>

#include <ibcs/ibcs.h>
#include <ibcs/tli.h>

#ifdef IBCS_TRACE
#include <ibcs/trace.h>
#endif


int
timod_ioctl(int fd, unsigned int func, void *arg)
{
	switch (func) {
		case 100: { /* TI_GETINFO */
			int error;
			struct T_info_ack *t = (struct T_info_ack *)arg;
			struct inode *ino = current->FD[fd]->f_inode;

			if (!ino || !ino->i_sock)
				return TBADF;

			error = verify_area(VERIFY_WRITE,
					arg, sizeof(struct t_info));
			if (error)
				return error;

			if (get_fs_long(&t->PRIM_type) != T_INFO_REQ)
				return -EINVAL;

			put_fs_long(T_INFO_ACK, &t->PRIM_type);
			put_fs_long(0, &t->CURRENT_state);
			put_fs_long(-2, &t->CDATA_size);
			put_fs_long(-2, &t->DDATA_size);
			put_fs_long(sizeof(struct sockaddr), &t->ADDR_size);
			put_fs_long(-1, &t->OPT_size);
			put_fs_long(16384, &t->TIDU_size);
			switch (ino->u.socket_i.type) {
				case SOCK_STREAM:
					put_fs_long(1, &t->ETSDU_size);
					put_fs_long(0, &t->TSDU_size);
					put_fs_long(2, &t->SERV_type);
					break;
				default:
					put_fs_long(-2, &t->ETSDU_size);
					put_fs_long(16384, &t->TSDU_size);
					put_fs_long(3, &t->SERV_type);
					break;
			}
			return 0;
		}

		case 101: /* TI_OPTMGMT */
		case 102: /* TI_BIND */
#ifdef IBCS_TRACE
			if (ibcs_trace & TRACE_STREAMS)
				printk(KERN_ERR "iBCS: STREAMS timod op %d\n",
					func);
#endif
			return TNOTSUPPORT;

		case 103: /* TI_UNBIND */
#ifdef IBCS_TRACE
			if (ibcs_trace & TRACE_STREAMS)
				printk(KERN_ERR "iBCS: STREAMS timod op %d\n",
					func);
#endif
			return TNOTSUPPORT;
	}

	return TNOTSUPPORT;
}
