#ifndef __TLI_H
#define __TLI_H

struct t_info {
	long addr;
	long options;
	long tsdu;
	long etsdu;
	long connect;
	long discon;
	long servtype;
};


/* Error codes used by TLI transport providers. */
#define	TBADADDR		1
#define	TBADOPT			2
#define	TACCES			3
#define TBADF			4
#define TNOADDR			5
#define TOUTSTATE	        6
#define TBADSEQ		        7
#define TSYSERR			8
#define TLOOK		        9
#define TBADDATA	       10
#define TBUFOVFLW	       11
#define TFLOW		       12
#define	TNODATA		       13
#define TNODIS		       14
#define TNOUDERR	       15
#define TBADFLAG	       16
#define TNOREL		       17
#define TNOTSUPPORT	       18
#define TSTATECHNG	       19


/* Messages used by "timod". */

#define	T_CONN_REQ	0
#define T_CONN_RES	1
#define T_DISCON_REQ	2
#define T_DATA_REQ	3
#define T_EXDATA_REQ	4
#define T_INFO_REQ	5
#define T_BIND_REQ	6
#define T_UNBIND_REQ	7
#define T_UNITDATA_REQ	8
#define T_OPTMGMT_REQ   9
#define T_ORDREL_REQ	10

#define T_CONN_IND	11
#define T_CONN_CON	12
#define T_DISCON_IND	13
#define T_DATA_IND	14
#define T_EXDATA_IND	15
#define T_INFO_ACK	16
#define T_BIND_ACK	17
#define T_ERROR_ACK	18
#define T_OK_ACK	19
#define T_UNITDATA_IND	20
#define T_UDERROR_IND	21
#define T_OPTMGMT_ACK   22
#define T_ORDREL_IND    23

struct T_info_req {
	long	PRIM_type;	/* Always T_INFO_REQ */
};

struct T_info_ack {
	long	PRIM_type;	/* Always T_INFO_ACK */
	long	TSDU_size;
	long	ETSDU_size;
	long	CDATA_size;
	long	DDATA_size;
	long	ADDR_size;
	long	OPT_size;
	long	TIDU_size;
	long	SERV_type;
	long	CURRENT_state;
};

extern int timod_ioctl(int, unsigned int, void *);

#endif /* __TLI_H */
