#!/bin/sh

set -e

echo converting 1 ...
./bfnnconv.pl linux-faq.bfnn
echo converting 2 ...
./bfnnconv.pl linux-faq.bfnn
echo formatting 1 ...
lout -idoc linux-faq.lout >/dev/null
echo formatting 2 ...
lout -idoc linux-faq.lout >linux-faq.ps
echo changes ...
./changes.text
echo tarring ...
./mktar.sh

if [ x != "x$1" ]
then
	echo archiving to $1 ...
	mkdir $1
	cp linux-faq.ascii linux-faq.source.tar.gz $1/.
	echo exporting ...
	cp linux-faq.tar.gz linux-faq.html.tar.gz $HOME/out/.
	echo posting ...
	sh ./linux-faq.post
	sleep 20
	echo posting changes ...
	sh ./changes.post
fi

echo done.
exit 0
