#ifndef _TRAPSIGN_H
#define _TRAPSIGN_H

#include	<stdio.h>
#include	<ctype.h>

#include	<X11/Xlib.h>
#include	<X11/Xutil.h>

#include	<X11/xpm.h>


void HandleASignal(int nonsense)
{
    fprintf(stderr,"signal %d Kill xgroups\n",nonsense);
    exit(0);
}

void InstallSignalHandler()
{
    signal(SIGHUP,HandleASignal);
    signal(SIGINT,HandleASignal);
    signal(SIGQUIT,HandleASignal);
    signal(SIGABRT,HandleASignal);
    signal(SIGFPE,HandleASignal);
    signal(SIGKILL,HandleASignal);
    signal(SIGSEGV,HandleASignal);
    signal(SIGPIPE,HandleASignal);
    signal(SIGALRM,HandleASignal);
    signal(SIGTERM,HandleASignal);
}

int myhandler(Display *display, XErrorEvent *myerr)
{
	char errore[256];

	XGetErrorText(display,myerr->error_code,errore,256);
	fprintf(stderr,"XErrorEvent: %s (request=%d\n",errore,myerr->request_code);
}

#endif

