#include	<stdio.h>
#include	<string.h>
#include	<unistd.h>
#include	<malloc.h>
#include	<X11/xpm.h>
#include	"xqdtk.h"
#include	"xgroups.h"
#include    "trapsign.h"

Window toplevel;
EditBox *edit_window;
EditBox *cmdline_window;
char filename[PATH_MAX];
char itemname[PATH_MAX];
char new_filename[PATH_MAX];
Programma scelta_icona;
char *IconsList[MAXICONS];
int NoOfIconsInList;
int CurrentIconOfList;
int ExecInAWindow=0;
TextBox *in_window_window;
TextBox *icon_name_window;

int Read_Icons_File(char *ifname, int warning)
{
	FILE *fd;
	char s[PATH_MAX];

	fd=fopen(ifname,"rt");
	if (fd==NULL)
	{
		if (warning)
		{
			fprintf(stderr,"Cannot open icon file %s\n",ICONLIST);
			fprintf(stderr,"^^^this is a big configuration error\n");
		}
		return(1);
	}

	while(1)
	{
		fgets(s,sizeof(s),fd); if (strcmp(s,"")==0) break;
		if (strchr(s,'\n')!=NULL) *(strchr(s,'\n'))='\0';

		NoOfIconsInList++;
		if(NoOfIconsInList > MAXICONS-1)
		{
			fprintf(stderr,"MAXICONS exceeded, please recompile me with a lergest limit\n");
			NoOfIconsInList--;
			break;
		}

		IconsList[NoOfIconsInList]=(char *) malloc(strlen(s)+1);
		strcpy(IconsList[NoOfIconsInList],s);

		if (feof(fd)) break;
	}

	fclose(fd);

	return(0);
}

void Read_Icons_Names()
{
	char ifn[PATH_MAX];

	IconsList[0]=(char *) malloc(strlen(DEFAULTICON)+1);
	strcpy(IconsList[0],DEFAULTICON);
	NoOfIconsInList=0;
	CurrentIconOfList=0;

	Read_Icons_File(ICONLIST,1);

	sprintf(ifn,"%s/.xgroups/%s",getenv("HOME"),PICONLIST);
	Read_Icons_File(ifn,0);
}

void next_icon(int arg)
{
	char iname[PATH_MAX];

	Destroy_icona(&scelta_icona);

	CurrentIconOfList += arg;

	if (CurrentIconOfList >= NoOfIconsInList) CurrentIconOfList=NoOfIconsInList-1;
	if (CurrentIconOfList < 0) CurrentIconOfList=0;

	Read_icona(toplevel,IconsList[CurrentIconOfList],&scelta_icona);
	Paint_icona(toplevel,&scelta_icona,NULL,0);

	sprintf(iname,"%d/%d: %s",CurrentIconOfList+1,NoOfIconsInList,IconsList[CurrentIconOfList]);
	x_display_text(icon_name_window, iname);
}

void exit_fn(int arg)
{
	Destroy_icona(&scelta_icona);

	exit(arg);
}

void next_edit(int arg)
{
	switch(arg)
	{
		case 0: x_activate_edit_box(edit_window, "name: ", itemname);
				break;

		case 1: x_activate_edit_box(cmdline_window, "command: ", "");
				break;
	}
}

/*
	action==ADD_GRP		create a new group or modify
	action==DEL_ITM		delete a group (comment it)
*/

void make_new_group(int action)
{
	char tmp[PATH_MAX];
	char name[PATH_MAX];
	char cmdline[PATH_MAX];
	char entry[PATH_MAX];
	char s[PATH_MAX];
	char cmd[PATH_MAX];
	FILE *fd;
	FILE *fdo;
	FILE *fdg;

/* it is VERY important that the directory $HOME/.xgroups exist */

	sprintf(cmd,"mkdir -p %s/.xgroups",getenv("HOME"));
	system(cmd);

/* get the name in edit_window */

	sprintf(name,x_get_edit_text(edit_window));

	if (strcmp(name,"") != 0)
	{
		sprintf(entry,"N=\"%s\"",name);

		fd=fopen(filename,"rt");
		if (fd==NULL)
		{
			fprintf(stderr,"Cannot open group %s\n",filename);
			exit(1);
		}

		sprintf(tmp,"/tmp/grp.%d",getpid());
		fdo=fopen(tmp,"wt");
		if (fdo==NULL)
		{
			fprintf(stderr,"Cannot open tmp file %s\n",tmp);
			fclose(fd);
			exit(1);
		}

/* make the right action */

		while(1)
		{
			fgets(s,sizeof(s),fd);

			if(strstr(s,entry) == NULL)
			{
				fprintf(fdo,"%s",s);
			}

			if (feof(fd)) break;
		}

		switch(action)
		{
			case ADD_GRP:	fprintf(fdo,"I=\"/usr/local/lib/xgroups/group.xpm\"  N=\"%s\" G=\"xgroups %s\"\n",name,name);
							break;

			case ADD_PRG:	strcpy(cmdline,x_get_edit_text(cmdline_window));
							if(strcmp(cmdline,"")!=0)
							{
								if (ExecInAWindow)
								{
									fprintf(fdo,"I=\"%s\"  N=\"%s\" C=\"xterm -e xgroups_exec %s\"\n",IconsList[CurrentIconOfList],name,cmdline);
								}
								else
								{
									fprintf(fdo,"I=\"%s\"  N=\"%s\" C=\"%s\"\n",IconsList[CurrentIconOfList],name,cmdline);
								}
							}
							break;
		}

		fclose(fd);
		fclose(fdo);

/* move tmp file in the new abc.grp */

		unlink(new_filename);

		sprintf(cmd,"mv %s %s",tmp,new_filename);

		if (system(cmd))
		{
			fprintf(stderr,"Cannot move %s to %s\n",tmp,new_filename);
			exit(1);
		}

/* if not exist, make a empty group in $HOME/.xgroups */

		if (action==ADD_GRP)
		{
			sprintf(tmp,"%s/.xgroups/%s.grp",getenv("HOME"),name);

			fdg=fopen(tmp,"rt");
			if (fdg==NULL)
			{
				fdg=fopen(tmp,"wt");
				if (fdg==NULL)
				{
					fprintf(stderr,"Cannot create new group %s\n",tmp);
					exit(1);
				}
				fprintf(fdg,"# Group: %s\n",name);
				fclose(fdg);
			}
			else
			{
				fclose(fdg);
			}
		}
	}

	exit(2);
}

void in_window(int arg)
{
	ExecInAWindow++; if (ExecInAWindow>1) ExecInAWindow=0;

	switch (ExecInAWindow)
	{
		case 0: x_display_text(in_window_window, "no"); break;
		case 1: x_display_text(in_window_window, "yes"); break;
	}
}

main(int argc, char *argv[])
{
	XEvent event;
	char title[PATH_MAX];
	char iname[PATH_MAX];
	int operation;

	InstallSignalHandler();
	XSetErrorHandler(myhandler);

	if (argc <= 3)
	{
		fprintf(stderr,"Usage: %s [-d|-g|-p] input_file.grp group_name [item_name]\n",argv[0]);
		exit(1);
	}

	if (argc <=4)
	{
		strcpy(itemname,"");
	}
	else
	{
		strcpy(itemname,argv[4]);
	}

	strcpy(filename,argv[2]);
	sprintf(new_filename,"%s/.xgroups/%s.grp",getenv("HOME"),argv[3]);

	operation=ADD_GRP;
/*	sprintf(title,"New Group (%s)",argv[2]); */
	sprintf(title,"New Group");

	if(strcmp(argv[1],"-d")==0)
	{
		operation=DEL_ITM;
/*		sprintf(title,"Delete Entry (%s)",argv[2]); */
		sprintf(title,"Delete Entry");
	}

	if(strcmp(argv[1],"-p")==0)
	{
		operation=ADD_PRG;
/*		sprintf(title,"New Program (%s)",argv[2]); */
		sprintf(title,"New Program");
	}

	toplevel = x_init(title, 200, 200, 300+200*(operation==ADD_PRG), 100+100*(operation==ADD_PRG), argc, argv);
	x_labeled_button(toplevel, "ok", 175+200*(operation==ADD_PRG), 18, 50, 20, make_new_group, operation);
	x_labeled_button(toplevel, "Cancel", 240+200*(operation==ADD_PRG), 18, 50, 20, exit_fn, 0);

	edit_window = x_edit_box(toplevel, 15, 10, 15, 150, 30, next_edit, (operation==ADD_PRG)?1:0);
	x_activate_edit_box(edit_window, "name: ", itemname);

	if (operation==ADD_PRG)
	{
		cmdline_window = x_edit_box(toplevel, 60, 10, 55, 280+200, 30, next_edit, 0);
		x_labeled_button(toplevel, "exec in window", 130+200, 100, 20, 20, in_window, 0);
		in_window_window = x_text_box(toplevel, 5, Centered, 240+200, 100, 50, 20);
		icon_name_window = x_text_box(toplevel, 60, Left, 140, 140, 150+200, 20);
		x_display_text(in_window_window, "no");

		Read_Icons_Names();
		scelta_icona.x=30;
		scelta_icona.y=90;
		strcpy(scelta_icona.nome,"");
		Read_icona(toplevel,IconsList[0],&scelta_icona);
		sprintf(iname,"%d/%d: %s",CurrentIconOfList+1,NoOfIconsInList,IconsList[CurrentIconOfList]);
		x_display_text(icon_name_window, iname);

		x_labeled_button(toplevel, "<", 13, 165, 20, 20, next_icon, -1);
		x_labeled_button(toplevel, "<<", 15+24, 165, 20, 20, next_icon, -10);
		x_labeled_button(toplevel, ">>", 25+WICONA-24, 165, 20, 20, next_icon, +10);
		x_labeled_button(toplevel, ">", 27+WICONA, 165, 20, 20, next_icon, +1);

		Paint_icona(toplevel,&scelta_icona,next_icon,0);
	}

	x_event_loop();
}

