/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main.h"

#include "gamedialog.h"

#include "kpuzzle.h"
#include "kpuzzleapp.h"

#include <qpushbutton.h>
#include <qlabel.h>

#include <kconfig.h>

CGameDialog::CGameDialog(QWidget* parent) : QDialog(parent,0,true)
{
        setCaption(i18n("Game Parameters"));

        QLabel* lb;
	QPushButton* bt;

        _vbox = new QVBoxLayout(this,30,20);

        _gameType = new QComboBox(false,this);

	lb = new QLabel(_gameType,i18n("&Game Type"),this);

        _vbox->addWidget(lb);
        _vbox->addSpacing(5);
        _vbox->addWidget(_gameType);

        _vbox->addStretch(5);

	_pieceSize = new QComboBox(false,this);

	lb = new QLabel(_pieceSize,i18n("&Piece Size"),this);

        _vbox->addWidget(lb);
        _vbox->addSpacing(5);
        _vbox->addWidget(_pieceSize);

        _vbox->addStretch(5);

	_difficulty = new QComboBox(false,this);

	lb = new QLabel(_difficulty,i18n("&Difficulty"),this);

        _vbox->addWidget(lb);
        _vbox->addSpacing(5);
        _vbox->addWidget(_difficulty);

        _vbox->addStretch(5);

        _useMask = new QCheckBox(i18n("&Use piece mask"),this);
	_useMask->setChecked(kapp->sessionConfig()->readBoolEntry("UsePieceMask",SV_USE_PIECE_MASK));

        _vbox->addWidget(_useMask);

        _vbox->addStretch(5);

        _hbox = new QHBoxLayout(15);
        _vbox->addLayout(_hbox);

        bt = new QPushButton(i18n("OK"),this);
	bt->setDefault(true);
	connect(bt,SIGNAL(clicked()),this,SLOT(accept()));
        _hbox->addWidget(bt);
        _hbox->addSpacing(5);

	bt = new QPushButton(i18n("Cancel"),this);
	connect(bt,SIGNAL(clicked()),this,SLOT(reject()));
        _hbox->addWidget(bt);
        _hbox->addSpacing(5);


        bt = new QPushButton(i18n("&Help"),this);
        connect(bt,SIGNAL(clicked()),this,SLOT(slotHelp()));
        _hbox->addWidget(bt);

	_gameType->insertItem(i18n("Standard"));
	_gameType->insertItem(i18n("Piece-Time")); // You have got a certain time for every piece
	_gameType->insertItem(i18n("Faults-Count")); // You may try every piece n times
	_gameType->insertItem(i18n("All-Faults")); // The faults for all pieces are counted together
	_gameType->insertItem(i18n("Unbearable")); // The current piece switches automatically
	_gameType->setCurrentItem(0);

	_pieceSize->insertItem(i18n("Invisible"));
	_pieceSize->insertItem(i18n("Small"));
	_pieceSize->insertItem(i18n("Normal"));
	_pieceSize->insertItem(i18n("Large"));
	_pieceSize->insertItem(i18n("Huge"));
	_pieceSize->setCurrentItem(2);

	_difficulty->insertItem(i18n("Easy"));
	_difficulty->insertItem(i18n("Medium"));
	_difficulty->insertItem(i18n("Hard"));

        _vbox->activate();
}

CGameDialog::~CGameDialog()
{

}

char CGameDialog::gameType()
{
	return _gameType->currentItem() + 1;
}

char CGameDialog::pieceSize()
{
	return _pieceSize->currentItem();
}

char CGameDialog::difficulty()
{
	return _difficulty->currentItem();
}

void CGameDialog::slotHelp()
{
        kapp->invokeHTMLHelp(HF_DIALOG_NEWGAME,HA_DIALOG_NEWGAME);
}

