/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [shell.cpp]                   Shell Control                                */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU General Public Licence.       */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

// Although it would be nicer to use KProcess here, bash and other programs
// recognize that they are not connected to a terminal because of the socks
// used within this modul. Maybe one can dig out something about it ...
// knows better. 

//FIXME: for some reason no SIGHUP is send to the child process.
//       did this manually in Shell::~Shell, but that's not the solution.

//FIXME: something is broken here. The shell does not come up reliably.
//       also, we have strange results when doing a reset.
//       these problems are most propably connected.
//       Would be nice to use kprocess instead...

//NOTE:  This module is hacked to death. Don't waste any time in reading it.

/* some posix terminal handling taken from minicom. */
/* shell material from rxvt/kvt                     */

#include <stdio.h>
#include <stdlib.h>

#include <termios.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include <assert.h>
#include <time.h>
#include <signal.h>
#include <wait.h>

#include "Shell.h"
#include "Shell.moc"

#define HERE fprintf(stdout,"%s(%d): here\n",__FILE__,__LINE__)

FILE* log = NULL; //stdout;

/* ---| Shell Parameters |--------------------------------------------------- */

void Shell::setparms()
/* Set baudrate, parity and number of bits. */
{
  struct termios tty;

  tcgetattr(fd, &tty);

  cfsetospeed(&tty, (speed_t)B115200);
  cfsetispeed(&tty, (speed_t)B115200);

  tty.c_cflag = (tty.c_cflag & ~CSIZE) | CS8;
  tty.c_iflag = IGNBRK;
  tty.c_lflag = 0;
  tty.c_oflag = 0;
  tty.c_cflag |= CLOCAL | CREAD;
  tty.c_cc[VMIN] = 1;
  tty.c_cc[VTIME] = 5;

  tty.c_iflag |= IXON | IXOFF;
  tty.c_cflag &= ~(PARENB | PARODD);
  tty.c_cflag &= ~CRTSCTS;

  tcsetattr(fd, TCSANOW, &tty);
}

void Shell::setSize(int lines, int columns)
// Tell the teletype handler what size the window is.
// Called after a window size change.
{ struct winsize wsize;
  if(fd < 0) return;
  wsize.ws_row = (unsigned short)lines;
  wsize.ws_col = (unsigned short)columns;
  ioctl(fd,TIOCSWINSZ,(char *)&wsize);
}

static char ptynam[] = "/dev/ptyxx";
static char ttynam[] = "/dev/ttyxx";
static int  comm_pid;
#define error(S) fprintf(stderr,"%s\n",S)


static Shell* me; //FIXME: that's bad! Better setup a list of shells.

static void catch_child(int)
//  Catch a SIGCHLD signal and exit if the direct child has died.
{
  if (wait((int *)NULL) == comm_pid) 
    {
//printf("Child %d died.\n",comm_pid);
//    clean_exit(0);
      me->doneShell(me);
    }
  /* reinstall the SIGCHLD-handler since we have more childs now,
     for example other kvts (Matthias) */ 
  signal(SIGCHLD,catch_child);
}

//  Catch a fatal signal and tidy up before quitting
static void catch_sig(int sig)
{
  signal(sig,SIG_DFL);
//cleanutent();
//setuid(getuid());
  kill(getpid(),sig);
}

void Shell::doneShell(Shell*)
{
  emit done();
}

void makeShell(char* dev)
//FIXME: something is still broken here
//FIXME: and questionable, also.
{
  struct termios ttmode;
  int tt = open(dev, O_RDWR);
assert(tt > 0);
  dup2(tt,fileno(stdin));
  dup2(tt,fileno(stdout));
  dup2(tt,fileno(stderr));
      
      if (setsid() < 0)
	perror("failed to set process group");
#if defined(TIOCSCTTY)
      ioctl(0, TIOCSCTTY, 0) ;
#endif
      {
	int pgrp = getpid();
	ioctl(0, TIOCSPGRP, (char *)&pgrp);
	setpgid(0,0);
	close(open(ttynam, O_WRONLY, 0));
	setpgid(0,0);
      }

  ioctl(0,TCGETS,(char *)&ttmode);

  ttmode.c_iflag = BRKINT | IGNPAR | ICRNL| IXON | IMAXBEL;
  ttmode.c_lflag = ISIG|IEXTEN|ICANON|ECHO|ECHOE|ECHOK|ECHOCTL|ECHOKE;
  ttmode.c_oflag = OPOST | ONLCR ;
  ttmode.c_cflag = B9600 | CS8 | CREAD;

/*
  ttmode.c_cc[VEOF] = CEOF;
  ttmode.c_cc[VEOL] = CEOL; 
  ttmode.c_cc[VINTR] = CINTR;
  ttmode.c_cc[VQUIT] = CQUIT;
  ttmode.c_cc[VERASE] = CERASE;
  ttmode.c_cc[VKILL] = CKILL;
  ttmode.c_cc[VSUSP] = CSUSP;
  ttmode.c_cc[VSTART] = CSTART;
  ttmode.c_cc[VSTOP] = CSTOP;
*/
  ioctl(0,TCSETS,(char *)&ttmode);

  setgid(getgid()); 
  { char* loc = "/bin/sh";
    int x = execlp(loc,loc,NULL);
    printf("failed %d\n",x);
  }
}

int openShell()
{ int ptyfd, i; char *s3, *s4;
  static char ptyc3[] = "pqrstuvwxyz";
  static char ptyc4[] = "0123456789abcdef";

  // Find a master pty that we can open ////////////////////////////////

  ptyfd = -1;
  for (s3 = ptyc3; *s3 != 0; s3++) 
  {
    for (s4 = ptyc4; *s4 != 0; s4++) 
    {
      ptynam[8] = ttynam[8] = *s3;
      ptynam[9] = ttynam[9] = *s4;
      if ((ptyfd = open(ptynam,O_RDWR)) >= 0) 
      {
        if (geteuid() == 0 || access(ttynam,R_OK|W_OK) == 0) break;
        close(ptyfd); ptyfd = -1;
      }
    }
    if (ptyfd >= 0) break;
  }
  if (ptyfd < 0) 
  { error("Can't open a pseudo teletype"); return -1; }
//printf("Devices: %s %s\n",ptynam,ttynam);
  fcntl(ptyfd,F_SETFL,O_NDELAY);

//lstat(ttynam,&ttyfd_stat);

//makeutent(&ttynam[5]);  /* stamp /etc/utmp */  

//FIXME: not the right place
  for (i = 1; i <= 15; i++) if (i!=SIGCHLD) signal(i,catch_sig);
  signal(SIGCHLD,catch_child);

  return ptyfd;
}

int Shell::run()
{
  comm_pid = fork();
  if (comm_pid < 0) { error("Can't fork"); return(-1); }
  if (comm_pid == 0) 
  { 
    makeShell(ttynam);
  }
//printf("child process: %d\n",comm_pid);
  return 0;
}

Shell::Shell()
/* setup modem */
{
  me = this;
  fd = openShell();
  assert( fd > 0 ); //FIXME: catch user's bug
  assert( 0 == tcgetattr( fd, &tp ) );
  setparms();

  mn = new QSocketNotifier(fd, QSocketNotifier::Read);
  mw = new QSocketNotifier(fd, QSocketNotifier::Write);
  connect( mn, SIGNAL(activated(int)), this, SLOT(DataReceived(int)) );
  connect( mw, SIGNAL(activated(int)), this, SLOT(DataWritten(int)) );
}

Shell::~Shell()
/* restore modem */
{
  delete mn;
  assert( 0 == tcsetattr( fd, TCSANOW, &tp ) );
  kill(comm_pid,SIGHUP); //FIXME: Why does this not happen automatically
  close(fd);
}

void Shell::send_byte(char c)
{ 
  write(fd,&c,1); mw->setEnabled(TRUE);
}

void Shell::send_string(const char* s)
{
  write(fd,s,strlen(s)); mw->setEnabled(TRUE);
}

void Shell::send_bytes(char* s, int len)
{
  write(fd,s,len); mw->setEnabled(TRUE);
}

void Shell::DataReceived(int)
{ char buf[1024];
  int n = read(fd, buf, 1024);
  emit block_in(buf,n);
  if (log) for (int i = 0; i < n; i++) fputc(buf[i],log);
}

void Shell::DataWritten(int)
{
  mw->setEnabled(FALSE); written();
}
