/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [te_widget.h]           Terminal Emulation Widget                          */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#ifndef TE_WIDGET_H
#define TE_WIDGET_H

#include <qwidget.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qkeycode.h>

#include "TECommon.h"

class TEWidget : public QFrame
// a widget representing attributed text
{ Q_OBJECT

public:

    TEWidget(QWidget *parent=0, const char *name=0);

public:
    void setDefaultForeColor(QColor);
    void setDefaultBackColor(QColor);
    QColor getDefaultForeColor();
    QColor getDefaultBackColor();
    void changeFont(char* name);

public:
    
    void setImage(const ca* const newimg, int lines, int columns);

    int  Lines()   { return lines;   }
    int  Columns() { return columns; }

public:

    void Bell();

signals:

    void keyPressedSignal(QKeyEvent *e);
    void mouseSignal(int cb, int cx, int cy);
    void changedImageSizeSignal(int lines, int columns);
    void configureRequest( TEWidget*, int x, int y );

protected:

    bool eventFilter( QObject *, QEvent * );

    void paintEvent( QPaintEvent * );
    void resizeEvent(QResizeEvent*);
    void frameChanged();

    void mousePressEvent( QMouseEvent* );
    void mouseReleaseEvent( QMouseEvent* );
    void mouseMoveEvent( QMouseEvent* );


    void emitSelection();
    QRect orderSelection(QPoint a, QPoint b);
    void swapSelection(QPoint a, QPoint b);
    QString getText(QPoint a, QPoint b);

public:

    void clearImage(); //FIXME: public for special purpose only (see vt102emu)

private:

    QFont f;
    int font_h; // height
    int font_w; // width
    int font_a; // ascend

    int lines;
    int columns;
    ca *image; // [lines][columns]

    QColor color_table[ALL_COLORS];

    BOOL resizing;

    void makeImage();

    QPoint bgnSel;
    QPoint endSel;
    int    actSel; // in selection

};

#endif // TE_WIDGET_H
