/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [xtermemu.h]             X Terminal Emulation                              */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1998 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#ifndef VT102EMU_H
#define VT102EMU_H

#include "TEWidget.h"
#include "TEScreen.h"
#include "TEmulation.h"
#include <qtimer.h>
#include <stdio.h>

#define MODE_AppScreen 0
#define MODE_AppCuKeys 1
#define MODE_AppKeyPad 2
#define MODE_Mouse1000 3
#define MODE_total     4

struct DECpar
{
  BOOL mode[MODE_total];
};

class VT102Emulation : public Emulation // QObject
{ Q_OBJECT

public:

  VT102Emulation(TEWidget* gui);
  ~VT102Emulation();

public slots: // signals incoming from TEWidget
 
  void onImageSizeChange(int lines, int columns);
  void onKeyPress(QKeyEvent*);
  void onMouse(int cb, int cx, int cy);

public:

  void tableInit();
  void onRcvByte(int);
  void reset();

public:
    
  bool isActive()           { return active; }
  void setActive(bool flag) { active = flag; }

public:

  BOOL getMode    (int m);

  void setMode    (int m);
  void resetMode  (int m);
  void saveMode   (int m);
  void restoreMode(int m);

  void setFixSize(int lines, int columns, bool fixed); //FIXME: experimental

  void NewLine    ();        //FIXME: evtl. move to TEmulation

private:

  bool  active;

  unsigned char pbuf[100]; //FIXME: overflow!
  int ppos;
#define MAXARGS 15
  int argv[MAXARGS];
  int argc;
  int tbl[256];

  void scan_buffer_report(); //FIXME: rename
  void ReportErrorToken();   //FIXME: rename
  void NotImplemented();

  void tau(int code, int p, int q);
  int tauMode(int code);

  // 

  void sendString(char*);

  void reportTerminalType();
  void reportStatus();
  void reportAnswerBack();
  void reportCursorPosition();

protected:

  TEScreen* screen[2];   // 0 = primary, 1 = alternate
  void setScreen(int n); // set `scr' to `screen[n]'

  DECpar currParm;
  DECpar saveParm;
};

#endif // ifndef ANSIEMU_H
