
#
#  Changes from 1.1 to 1.2:
#    - makedepend usage removed, so INCLUDEDIRS is empty now
#    - Linux part added by Louis P. Kruger (lpkruger@phoenix.princeton.edu)
#    - option -Wall removed
#

#
#  Remarks:
#    - Please execute "make clean" after changing settings, then "make".
#    - If you are using a SPARC that does NOT have a dbri device,
#      but a 8 kHz u-law device (amd), e.g. SPARC 1/1+/2/IPC/IPX/...,
#      add "-DULAW" to COMPILERFLAGS.
#      Don't use "-DULAW" for SPARC 10 machines, because these machines
#      can produce very fine CD-quality sound with their dbri device
#    - INCLUDEDIRS is only needed, if your C++ compiler does not know
#      where to find his own include files or if you want to use
#      makedepend. In this case, set INCLUDEDIRS to '-Iincludedir' 
#    - If you are using Linux, you may look for compiler and processor
#      specific optimization options which can be included in COMPILERFLAGS
#

###*** Please modify the entries for your machine: ***###
case `uname -sr` in


  Linux*)
     COMPILER=g++
     #COMPILERFLAGS='-O0 -m486 -m80387 -ffast-math -ggdb -DLINUX -DDAMN_INTEL_BYTE_ORDER -Wall'
     #COMPILERFLAGS='-O3 -m486 -m80387 -ffast-math -ggdb -DLINUX -DDAMN_INTEL_BYTE_ORDER -Wall -p -pg'
     COMPILERFLAGS='-O3 -m486 -m80387 -ffast-math -fomit-frame-pointer -DLINUX -DDAMN_INTEL_BYTE_ORDER'
     COMPILERFLAGS='-O3 -ffast-math -fomit-frame-pointer -Wall -Wstrict-prototypes -W  -D__GNU_SOURCE -DLINUX -DDAMN_INTEL_BYTE_ORDER -Wall'

#-O3 -m486 -m80387 -ffast-math -fomit-frame-pointer'

     INCLUDEDIRS=
     LIBRARIES= 
     AUDIO_INCLUDES='#include <sys/soundcard.h>' ;;

  *) echo "This programm has not been tested on your type of machine yet!"
     echo "Please modify the file configuration.sh according to your needs!"
     exit
esac

export COMPILER COMPILERFLAGS INCLUDEDIRS LIBRARIES

if [ ! -f audio_includes.h ]; then
  echo $AUDIO_INCLUDES >audio_includes.h
fi

make all
