
#ifndef SUBBAND_H
#define SUBBAND_H

#include "all.h"
#include "ibitstream.h"
#include "header.h"
#include "synthesis_filter.h"
#include "crc.h"

// abstract base class for subband classes of layer I and II:
class Subband
{
public:
  virtual void read_allocation (Ibitstream *, Header *, Crc16 *) = 0;
  virtual void read_scalefactor (Ibitstream *, Header *) = 0;
  virtual bool read_sampledata (Ibitstream *) = 0;
  virtual bool put_next_sample (e_channels, SynthesisFilter *, SynthesisFilter *) = 0;
};

#endif
