

#ifndef SUBBAND_LAYER_1_H
#define SUBBAND_LAYER_1_H

#include "all.h"
#include "subband.h"
#include "crc.h"


// class for layer I subbands in single channel mode:
class SubbandLayer1 : public Subband
{
protected:
  uint32 subbandnumber;
  uint32 samplenumber;
  uint32 allocation;
  real	 scalefactor;
  uint32 samplelength;
  real	 sample;
  real	 factor, offset;

public:
       SubbandLayer1 (uint32 subbandnumber);
  void read_allocation (Ibitstream *, Header *, Crc16 *);
  void read_scalefactor (Ibitstream *, Header *);
  bool read_sampledata (Ibitstream *);
  bool put_next_sample (e_channels, SynthesisFilter *, SynthesisFilter *);
};


// class for layer I subbands in joint stereo mode:
class SubbandLayer1IntensityStereo : public SubbandLayer1
{
protected:
  real channel2_scalefactor;

public:
       SubbandLayer1IntensityStereo (uint32 subbandnumber);
  void read_allocation (Ibitstream *stream, Header *header, Crc16 *crc)
  {
    SubbandLayer1::read_allocation (stream, header, crc);
  }
  void read_scalefactor (Ibitstream *, Header *);
  bool read_sampledata (Ibitstream *stream)
  {
    return SubbandLayer1::read_sampledata (stream);
  }
  bool put_next_sample (e_channels, SynthesisFilter *, SynthesisFilter *);
};


// class for layer I subbands in stereo mode:
class SubbandLayer1Stereo : public SubbandLayer1
{
protected:
  uint32 channel2_allocation;
  real	 channel2_scalefactor;
  uint32 channel2_samplelength;
  real	 channel2_sample;
  real	 channel2_factor, channel2_offset;

public:
       SubbandLayer1Stereo (uint32 subbandnumber);
  void read_allocation (Ibitstream *, Header *, Crc16 *);
  void read_scalefactor (Ibitstream *, Header *);
  bool read_sampledata (Ibitstream *);
  bool put_next_sample (e_channels, SynthesisFilter *, SynthesisFilter *);
};

#endif
