/************************************************************************/
/*                                                                      */
/* PortSentry - Utility Library		                               */
/*                                                                      */
/* Author: Craig H. Rowland <crowland@psionic.com>                      */
/*                          <crowland@bipolar.net>                      */
/* Created: 10-12-97                                                    */
/* Modified: 03-04-99                                                   */
/*                                                                      */
/* Send all changes/modifications/bugfixes to the above addresses.      */
/*                                                                      */
/*                                                                      */
/* This software is Copyright(c) 1997-99 Craig H. Rowland               */
/*                                                                      */
/* Disclaimer:                                                          */
/*                                                                      */
/* All software distributed by Craig H. Rowland ("the author") and      */
/* Psionic Systems is distributed AS IS and carries NO WARRANTY or      */
/* GUARANTEE OF ANY KIND. End users of the software acknowledge that    */
/* they will not hold the author, Psionic Systems, and any employer of  */
/* the author liable for failure or non-function of a software          */
/* product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK                 */
/*                                                                      */
/* Licensing restrictions apply. See the license that came with this    */
/* file for more information or visit http://www.psionic.com for more   */
/* information.                                                         */
/*                                                                      */
/* $Id: portsentry_util.c,v 1.5 1999/05/13 05:24:51 crowland Exp crowland $ */
/************************************************************************/

#include "portsentry.h"
#include "portsentry_io.h"
#include "portsentry_util.h"

/* A replacement for strncpy that covers mistakes a little better */
char *
SafeStrncpy (char *dest, const char *src, size_t size)
{
  if (!dest)
    {
      dest = NULL;
      return (NULL);
    }
  else if (size < 1)
    {
      dest = NULL;
      return (NULL);
    }

  /* Null terminate string. Why the hell strncpy doesn't do this */
  /* for you is mystery to me. God I hate C. */
  memset (dest, '\0', size);
  strncpy (dest, src, size - 1);

  return (dest);
}


/************************************************************************/
/* Generic safety function to process an IP address and remove anything */
/* that is:                                                             */
/* 1) Not a number.                                                     */
/* 2) Not a period.                                                     */
/* 3) Greater than IPMAXBUF (15)                                        */
/************************************************************************/
char *
CleanIpAddr (char *cleanAddr, const char *dirtyAddr)
{
  int count = 0, maxdot = 0, maxoctet = 0;

#ifdef DEBUG
  Log("debug: cleanAddr: Cleaning Ip address: %s", dirtyAddr);
#endif

  memset (cleanAddr, '\0', IPMAXBUF);
  /* dirtyAddr must be valid */
  if(dirtyAddr == NULL)
	return(cleanAddr);

  for (count = 0; count < IPMAXBUF - 1; count++)
    {
      if (isdigit (dirtyAddr[count]))
	{
	  if (++maxoctet > 3)
	    {
	      cleanAddr[count] = '\0';
	      break;
	    }
	  cleanAddr[count] = dirtyAddr[count];
	}
      else if (dirtyAddr[count] == '.')
	{
	  if (++maxdot > 3)
	    {
	      cleanAddr[count] = '\0';
	      break;
	    }
	  maxoctet = 0;
	  cleanAddr[count] = dirtyAddr[count];
	}
      else
	{
	  cleanAddr[count] = '\0';
	  break;
	}
    }

#ifdef DEBUG
  Log("debug: cleanAddr: Cleaned IpAddress: %s Dirty IpAddress: %s", cleanAddr, dirtyAddr);
#endif

  return (cleanAddr);
}
