#include <unistd.h>
#include <sys/stat.h>
#include <time.h>
#include <fcntl.h>
#include <ktopwidget.h>
#include <kapp.h>
#include <qwidget.h>
//#include <kkeyconf.h>
#include <qkeycode.h>
#include <qmlined.h>
#include <kmsgbox.h>
#include "kidentify.h"
#include "kidentify.moc"

kidentify :: kidentify(QWidget *, const char *name, const char *path)
	: KTopLevelWidget(name)
{
char buffer[1024],*p;
int i,nr;
QString com,tmp;
struct stat st;

	if (name) setCaption(name);

	filepath=path;
	corebt=0;

	for (i=0;i<10;i++) {
		label[i]=0;
		value[i]=0;
		}

	needed_width=200;
	needed_height=300;

	frame=new QGroupBox(i18n("File Information"),this);
	stat(path,&st);

	nr=0;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Name :"));
	value[nr]=new QLabel(frame);
	value[nr]->setText(path);

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Type :"));
	value[nr]=new QLabel(frame);
	value[nr]->setText(filetype(st.st_mode));

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Permission :"));
	value[nr]=new QLabel(frame);
	value[nr]->setText(fileperm(st.st_mode));

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Size :"));
	value[nr]=new QLabel(frame);
	sprintf(buffer,"%ld Bytes",st.st_size);
	value[nr]->setText(buffer);

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Mutation Date :"));
	value[nr]=new QLabel(frame);
	strcpy(buffer,asctime(localtime(&st.st_mtime)));
	p=buffer+strlen(buffer)-1;
	while(*p=='\n' || *p=='\r') *p--=0;
	value[nr]->setText(buffer);

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("KDE File Magic:"));
	value[nr]=new QLabel(frame);
	tmp=magic(path,MAGIC_KDE);
	value[nr]->setText(tmp);

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("System File Magic:"));
	value[nr]=new QLabel(frame);
	value[nr]->setText(magic(path,MAGIC_SYSTEM));

	nr++;
	label[nr]=new QLabel(frame);
	label[nr]->setText(i18n("Dynamic Libraries:"));
	value[nr]=new QLabel(frame);
	value[nr]->setText(libs(path));

	if (tmp=="application/x-coredump") {
		corebt=new QPushButton(i18n("Core information"),this);
		connect(corebt,SIGNAL(pressed()),
			this,SLOT(coreinfo()));
		corebt->resize(corebt->sizeHint());
		corebt->show();
		}

	for (i=0;i<10;i++) if (label[i]) {
		label[i]->resize(label[i]->sizeHint());
		value[i]->resize(value[i]->sizeHint());
		}

	frame->show();
	showit();
	resize(needed_width,needed_height);

//	setView(frame);
}

QString kidentify :: magic(const char *path, int flag)
{
QString cmd;
char line[1024],*p;
FILE *fp;

	if (flag==MAGIC_KDE)
	cmd=QString("file -m ")+kapp->kde_mimedir()+"/magic "+QString(path);
	else
	cmd=QString("file ")+QString(path);

	fp=popen(cmd.data(),"rt");
	if (!fp) return(QString("N/A"));
	fgets(line,sizeof(line),fp);
	if (feof(fp)) *line=0;
	pclose(fp);
	p=line+strlen(line)-1;
	while(*p=='\n') *p--=0;
	if (!strncmp(line,path,strlen(path))) p=line+strlen(path);
	while(*p==' ' || *p==':') p++;
	if (!*p) return(QString("N/A"));
	return(QString(p));
}

QString kidentify :: libs(const char *path)
{
QString cmd,libraries;
char line[1024],*p;
FILE *fp;

	cmd=QString("ldd ")+QString(path);

	fp=popen(cmd.data(),"rt");
	if (!fp) return(QString(i18n("N/A")));
	while(1) {
		fgets(line,sizeof(line),fp);
		if (feof(fp)) break;
		p=line; while(*p==' ' || *p=='\t') p++;
		libraries=libraries+QString(p);
		}
	pclose(fp);
	if (libraries.right(1)=="\n") {
		libraries=libraries.left(libraries.length()-1);
		}
	if (libraries.length()==0) libraries=i18n("N/A");
	return(libraries);
}

QString kidentify :: filetype(umode_t mode)
{
	if (S_ISDIR(mode)) return(i18n("directory"));
	else if (S_ISLNK(mode)) return(i18n("symbolic link"));
	else if (S_ISREG(mode)) return(i18n("file"));
	else if (S_ISCHR(mode)) return(i18n("char device"));
	else if (S_ISBLK(mode)) return(i18n("block device"));
	else if (S_ISFIFO(mode)) return(i18n("fifo"));
	else if (S_ISSOCK(mode)) return(i18n("socket"));
	return(i18n("unknown"));
}

QString kidentify :: fileperm(umode_t mode)
{
QString c;

	c.sprintf("%3o",mode&03777);
	return(c);
}

void kidentify::coreinfo()
{
char line[1024],*p;
FILE *fp;

	QMultiLineEdit *ml=new QMultiLineEdit(0);
	ml->setReadOnly(true);
	ml->setFont(kapp->fixedFont);
	QString cmd=QString("dcore ")+QString(filepath);

	fp=popen(cmd.data(),"rt");
	if (!fp) {
		ml->insertLine(i18n("dcore execution error"));
		return;
		}
	sprintf(line,i18n("Output of \"%s\" :"),cmd.data());
	ml->insertLine(line);
	while(1) {
		fgets(line,sizeof(line),fp);
		if (feof(fp)) break;
		p=line+strlen(line)-1;
		while(*p=='\r' || *p=='\n') *p--=0;
		ml->insertLine(line);
		}
	pclose(fp);
	ml->show();
}

kidentify :: ~kidentify()
{
//	KMsgBox :: message(this,"end","This is the end");

}

void kidentify::showit()
{
int i,maxw,maxtw,voffs,my;

	maxw=0; maxtw=0; voffs=1;
	frame->resize(width(),height());
	for (i=0;i<10;i++) if (label[i]) {
		if (maxw<label[i]->width()) maxw=label[i]->width();
		}
	my=20;
	for (i=0;i<10;i++) if (label[i]) {
		label[i]->move(20,my);
		value[i]->move(40+maxw,my);
		if (maxtw<(value[i]->width()+40+maxw))
			maxtw=value[i]->width()+40+maxw;
		my+=value[i]->height()+voffs;
		}
	if (corebt) {
		corebt->move(maxtw-corebt->width()-20,my);
		my+=corebt->height()+voffs;
		}
	needed_width=maxtw+20;
	needed_height=my+20;
}

void kidentify::resizeEvent(QResizeEvent *)
{
	showit();
}


int main(int argc, char* argv[])
{
char filename[1024];

	strcpy(filename,argv[0]);
	KApplication *app=new KApplication(argc,argv);
	if (argc>1) strcpy(filename,argv[1]);
	kidentify *w=new kidentify(0,filename,filename);

	app->setMainWidget(w);
	w->show();

	return(app->exec());
}

