/*
 *  dockapp.c - dockapp code
 * 
 *  Copyright (C) 2003 Draghicioiu Mihai <misuceldestept@go.ro>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "dockapp.h"
#include "wmmemfree.h"
#include "draw.h"

#include "bg.xpm"
#include "on.xpm"
#include "off.xpm"

Display  *display;
int       screen;
Window    rootwindow, window, iconwindow;
Pixmap    background, backgroundmask, on, off;
GC        gc;
Colormap  colormap;

void make_window()
{
 XpmAttributes        xpmattributes;
 XSetWindowAttributes windowattributes;
 XWMHints            *wmhints;
 XClassHint           classhint;
 XSizeHints           sizehints;
 XGCValues            gcvalues;
 int                  shape_event, shape_error;

 display = XOpenDisplay(NULL); /* FIXME: display name */
 if(!display)
 {
  fprintf(stderr, "Could not open display. Quitting.\n");
  exit(1);
 }
 screen = DefaultScreen(display);
 rootwindow = RootWindow(display, screen);
 colormap = DefaultColormap(display, screen);
 xpmattributes.valuemask = XpmColormap | XpmCloseness;
 xpmattributes.colormap = colormap;
 xpmattributes.closeness = 40000;
 XpmCreatePixmapFromData(display, rootwindow, bg_xpm,
                         &background, &backgroundmask, &xpmattributes);
 XpmCreatePixmapFromData(display, rootwindow, on_xpm,
                         &on, None, &xpmattributes);
 XpmCreatePixmapFromData(display, rootwindow, off_xpm,
                         &off, None, &xpmattributes);
 windowattributes.background_pixmap = background;
 windowattributes.event_mask = ExposureMask;
 windowattributes.colormap = colormap;
 window = XCreateWindow(display, rootwindow,
                        0, 0, WINDOW_WIDTH, WINDOW_HEIGHT, 0,
			CopyFromParent, /* FIXME: depth */
			InputOutput,
			CopyFromParent, /* FIXME: visual */
			CWBackPixmap | CWEventMask | CWColormap,
			&windowattributes);
 iconwindow = XCreateWindow(display, rootwindow,
                            0, 0, WINDOW_WIDTH, WINDOW_HEIGHT, 0,
			    CopyFromParent,  /* FIXME: depth */
			    InputOutput,
			    CopyFromParent,  /* FIXME: visual */
			    CWBackPixmap | CWEventMask,
			    &windowattributes);
 if(XShapeQueryExtension(display, &shape_event, &shape_error))
 {
  XShapeCombineMask(display, window, ShapeBounding,
                    0, 0, backgroundmask, ShapeSet);
  XShapeCombineMask(display, iconwindow, ShapeBounding,
                    0, 0, backgroundmask, ShapeSet);
 }

 wmhints = XAllocWMHints();
 wmhints -> flags = InputHint | WindowGroupHint | IconWindowHint | StateHint;
 wmhints -> input = True;
 wmhints -> window_group = window;
 wmhints -> icon_window = iconwindow;
 wmhints -> initial_state = WithdrawnState;
 XSetWMHints(display, window, wmhints);
 XFree(wmhints);

 classhint.res_name = "wmmemfree";
 classhint.res_class = "WMMemFree";
 XSetClassHint(display, window, &classhint);

 sizehints.flags = USSize | PSize | PMinSize | PMaxSize | PBaseSize;
 sizehints.width = WINDOW_WIDTH;
 sizehints.height = WINDOW_HEIGHT;
 sizehints.min_width = WINDOW_WIDTH;
 sizehints.min_height = WINDOW_HEIGHT;
 sizehints.max_width = WINDOW_WIDTH;
 sizehints.max_height = WINDOW_HEIGHT;
 sizehints.base_width = WINDOW_WIDTH;
 sizehints.base_height = WINDOW_HEIGHT;
 XSetWMNormalHints(display, window, &sizehints);

 XStoreName(display, window, "WMMemFree");

 gcvalues.graphics_exposures = False;
 gcvalues.function = GXcopy;
 gc = XCreateGC(display, rootwindow,
                GCGraphicsExposures | GCFunction,
		&gcvalues);
 XSetCommand(display, window, argv, argc);
 XMapWindow(display, window);
}

void process_events()
{
 XEvent event;

 XNextEvent(display, &event);
 switch(event.type)
 {
  case Expose:
   draw_window();
   break;
 }
}

void free_stuff()
{
 XUnmapWindow(display, window);
 XFreeGC(display, gc);
 XDestroyWindow(display, iconwindow);
 XDestroyWindow(display, window);
 XFreePixmap(display, off);
 XFreePixmap(display, on);
 XFreePixmap(display, background);
 XFreePixmap(display, backgroundmask);
 XCloseDisplay(display);
}
