/*
 *  draw.c - drawing code
 *
 *  Copyright (C) 2003 Draghicioiu Mihai <misuceldestept@go.ro>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "dockapp.h"
#include "draw.h"
#include "mem_linux.h"
#include "options.h"

void draw_window()
{
 int n;
 int mem, swp;
 int mem_max, swp_max;

 mem_getfree();
 mem_max = mem_total;
 swp_max = swp_total;
 mem = mem_used;
 if(opt_ignore_buffers) mem -= mem_buffers;
 if(opt_ignore_cache)   mem -= mem_cached;
 swp = swp_used;
 for(n=0;n<20;n++)
 {
  if(n < (mem * 20 / mem_max))
   XCopyArea(display, on, iconwindow, gc, 0, 0, 23, 2, 8, 55 - n * 2);
  else
   XCopyArea(display, off, iconwindow, gc, 0, 0, 23, 2, 8, 55 - n * 2);
  if(n < (swp * 20 / swp_max))
   XCopyArea(display, on, iconwindow, gc, 0, 0, 23, 2, 33, 55 - n * 2);
  else
   XCopyArea(display, off, iconwindow, gc, 0, 0, 23, 2, 33, 55 - n * 2);
 }
#ifdef DEBUGGY
 printf("Total memory:  %Ld\n", mem_total);
 printf("Used memory:   %Ld\n", mem_used);
 printf("Free memory:   %Ld\n", mem_free);
 printf("Shared memory: %Ld\n", mem_shared);
 printf("Buffers:       %Ld\n", mem_buffers);
 printf("Cached:        %Ld\n", mem_cached);
 printf("Total swap:    %Ld\n", swp_total);
 printf("Used swap:     %Ld\n", swp_used);
 printf("Free swap:     %Ld\n", swp_free);
#endif
}
