/*
 *  options.c - option parser
 *
 *  Copyright (C) 2003 Draghicioiu Mihai <misuceldestept@go.ro>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "wmmemfree.h"
#include "options.h"

int opt_ignore_buffers = OPT_IGNORE_BUFFERS;
int opt_ignore_cache   = OPT_IGNORE_CACHE;

void print_usage()
{
 printf("Usage: %s [OPTIONS]\n"
        "-b, --ignore-buffers   ignore buffer memory in display\n"
	"-a, --consider-buffers don't ignore buffer memory\n"
	"-c, --ignore-cache     ignore cache memory in display\n"
	"-d, --consider-cache   don't ignore cache memory\n"
	"-h, --help             print this help and exit\n"
	"-v, --version          print version number and exit\n",
	argv[0]);
}

void print_version()
{
 printf("WMMemFree version %s\n", OPT_VERSION);
}

void parse_args()
{
 int n;

 for(n=1;n<argc;n++)
 {
  if(!strcmp(argv[n], "-b") ||
     !strcmp(argv[n], "--ignore-buffers"))
   opt_ignore_buffers = 1;
  else if(!strcmp(argv[n], "-c") ||
          !strcmp(argv[n], "--ignore-cache"))
   opt_ignore_cache = 1;
  else if(!strcmp(argv[n], "-a") ||
     !strcmp(argv[n], "--consider-buffers"))
   opt_ignore_buffers = 0;
  else if(!strcmp(argv[n], "-d") ||
          !strcmp(argv[n], "--consider-cache"))
   opt_ignore_cache = 0;
  else if(!strcmp(argv[n], "-h") ||
          !strcmp(argv[n], "--help"))
  {
   print_usage();
   exit(0);
  }
  else if(!strcmp(argv[n], "-v") ||
          !strcmp(argv[n], "--version"))
  {
   print_version();
   exit(0);
  }
  else
  {
   print_usage();
   exit(1);
  }
 }
}
