/*    c_cmdtab.h
 *
 *    Copyright (c) 1994-1996, Marko Macek
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 */

#define TAB(x) \
    { Ex##x, #x }

struct {
    unsigned short CmdId;
    char *Name;
} Command_Table[] = {
TAB(Nop),
TAB(Fail),
TAB(MoveLeft),
TAB(MoveRight),
TAB(MoveUp),
TAB(MoveDown),
TAB(MovePrev),
TAB(MoveNext),
TAB(MoveWordLeft),
TAB(MoveWordRight),
TAB(MoveWordPrev),
TAB(MoveWordNext),
TAB(MoveWordEndLeft),
TAB(MoveWordEndRight),
TAB(MoveWordEndPrev),
TAB(MoveWordEndNext),
TAB(MoveLineStart),
TAB(MoveLineEnd),
TAB(MovePageUp),
TAB(MovePageDown),
TAB(MovePageLeft),
TAB(MovePageRight),
TAB(MovePageStart),
TAB(MovePageEnd),
TAB(MoveFileStart),
TAB(MoveFileEnd),
TAB(MoveBlockStart),
TAB(MoveBlockEnd),
TAB(MoveFirstNonWhite),
TAB(MoveLastNonWhite),
TAB(MovePrevEqualIndent),
TAB(MoveNextEqualIndent),
TAB(MovePrevTab),
TAB(MoveNextTab),
TAB(MoveLineTop),
TAB(MoveLineCenter),
TAB(MoveLineBottom),
TAB(ScrollLeft),
TAB(ScrollRight),
TAB(ScrollDown),
TAB(ScrollUp),    
TAB(MoveTabStart),
TAB(MoveTabEnd),

TAB(KillLine),
TAB(KillChar),
TAB(KillCharPrev),
TAB(KillWord),
TAB(KillWordPrev),
TAB(KillToLineStart),
TAB(KillToLineEnd),
TAB(KillBlock),
TAB(KillBlockOrChar),
TAB(KillBlockOrCharPrev),
TAB(BackSpace),
TAB(Delete),
TAB(CharCaseUp),
TAB(CharCaseDown),
TAB(CharCaseToggle),
TAB(LineCaseUp),
TAB(LineCaseDown),
TAB(LineCaseToggle),    
TAB(LineInsert),
TAB(LineAdd),
TAB(LineSplit),
TAB(LineJoin),
TAB(LineNew),
TAB(LineIndent),
TAB(LineTrim),

TAB(InsertSpacesToTab),
TAB(InsertTab),
TAB(InsertSpace),
TAB(WrapPara),
TAB(InsPrevLineChar),
TAB(InsPrevLineToEol),
TAB(LineDuplicate),    
TAB(BlockBegin),
TAB(BlockEnd),
TAB(BlockUnmark),
TAB(BlockCut),
TAB(BlockCopy),
TAB(BlockCutAppend),
TAB(BlockCopyAppend),
TAB(ClipClear),
TAB(BlockPaste),
TAB(BlockKill),
TAB(BlockSort),
TAB(BlockSortReverse),
TAB(BlockIndent),
TAB(BlockUnindent),
TAB(BlockClear),
TAB(BlockMarkStream),
TAB(BlockMarkLine),
TAB(BlockMarkColumn),
TAB(BlockCaseUp),
TAB(BlockCaseDown),
TAB(BlockCaseToggle),
TAB(BlockExtendBegin),
TAB(BlockExtendEnd),
TAB(BlockReIndent),
TAB(BlockSelectWord),
TAB(BlockSelectLine),
TAB(BlockSelectPara),
TAB(Undo),
TAB(Redo),
TAB(MatchBracket),
TAB(MovePrevPos),
TAB(MoveSavedPosCol),
TAB(MoveSavedPosRow),
TAB(MoveSavedPos),
TAB(SavePos),
TAB(CompleteWord),
TAB(MoveToLine),
TAB(MoveToColumn),
TAB(BlockPasteStream),
TAB(BlockPasteLine),
TAB(BlockPasteColumn),
TAB(ShowPosition),

TAB(FoldCreate),
TAB(FoldCreateByRegexp),
TAB(FoldDestroy),
TAB(FoldDestroyAll),
TAB(FoldPromote),
TAB(FoldDemote),
TAB(FoldOpen),
TAB(FoldOpenNested),
TAB(FoldClose),
TAB(FoldOpenAll),
TAB(FoldCloseAll),
TAB(FoldToggleOpenClose),
TAB(MoveFoldTop),
TAB(MoveFoldPrev),
TAB(MoveFoldNext),

TAB(PlaceBookmark),
TAB(RemoveBookmark),
TAB(GotoBookmark),

TAB(InsertString),
TAB(SelfInsert),
TAB(FilePrev),
TAB(FileNext),
TAB(FileLast),
TAB(SwitchTo),

TAB(FileReload),
TAB(FileSave),
TAB(FileSaveAll),
TAB(FileSaveAs),
TAB(FileWriteTo),
TAB(FileOpen),
TAB(FileOpenInMode),
TAB(FilePrint),

TAB(BlockPrint),
TAB(BlockRead),
TAB(BlockReadStream),
TAB(BlockReadLine),
TAB(BlockReadColumn),
TAB(BlockWrite),

TAB(IncrementalSearch),
TAB(Find),
TAB(FindReplace),
TAB(FindRepeat),
TAB(FindRepeatOnce),
TAB(FindRepeatReverse),

TAB(InsertChar),

TAB(FileClose),
TAB(FileCloseAll),

TAB(WinRefresh),

TAB(WinHSplit),
TAB(WinNext),
TAB(WinPrev),
TAB(WinClose),
TAB(WinZoom),
TAB(WinResize),

TAB(ExitEditor),

TAB(ViewBuffers),
TAB(ListRoutines),
TAB(DirOpen),

TAB(Compile),
TAB(CompilePrevError),
TAB(CompileNextError),
TAB(ViewMessages),

TAB(ShowKey),
TAB(ShowEntryScreen),
TAB(RunProgram),
TAB(HilitWord),
TAB(SearchWordPrev),
TAB(SearchWordNext),
TAB(HilitMatchBracket),
TAB(MainMenu),
TAB(LocalMenu),
TAB(ShowMenu),
TAB(ChangeMode),
TAB(ChangeKeys),
TAB(ChangeFlags),

TAB(ToggleAutoIndent),
TAB(ToggleInsert),
TAB(ToggleExpandTabs),
TAB(ToggleShowTabs),
TAB(ToggleUndo),
TAB(ToggleReadOnly),
TAB(ToggleKeepBackups),
TAB(ToggleMatchCase),
TAB(ToggleBackSpKillTab),
TAB(ToggleDeleteKillTab),
TAB(ToggleSpaceTabs),
TAB(ToggleIndentWithTabs),
TAB(ToggleBackSpUnindents),
TAB(ToggleWordWrap),
TAB(ToggleTrim),
TAB(ToggleShowMarkers),
TAB(SetLeftMargin),
TAB(SetRightMargin),
TAB(SetPrintDevice),
TAB(ChangeTabSize),
TAB(ChangeLeftMargin),
TAB(ChangeRightMargin),
TAB(ToggleSysClipboard),
TAB(Cancel),
TAB(Activate),
TAB(Rescan),
TAB(CloseActivate),
TAB(ActivateInOtherWindow),
TAB(DirGoUp),
TAB(DirGoDown), 
TAB(DirGoRoot),
TAB(DirGoto),
TAB(ShowVersion),
TAB(ASCIITable),
TAB(TypeChar),
TAB(CharTrans),
TAB(LineTrans),
TAB(BlockTrans),
TAB(DesktopSave),
TAB(DesktopSaveAs),
TAB(ChildClose),
TAB(BufListFileSave),
TAB(BufListFileClose),
TAB(ViewModeMap),
TAB(ClearMessages),
TAB(BlockUnTab),
TAB(BlockEnTab),
TAB(TagFind),
TAB(TagFindWord),
TAB(TagNext),
TAB(TagPrev),
TAB(TagPop),
TAB(TagLoad),
TAB(TagClear),
TAB(TagGoto),
TAB(BlockMarkFunction),
TAB(IndentFunction),
TAB(MoveFunctionPrev),
TAB(MoveFunctionNext),
TAB(Search),
TAB(SearchB),
TAB(SearchRx),
TAB(SearchAgain),
TAB(SearchAgainB),
TAB(SearchReplace),
TAB(SearchReplaceB),
TAB(SearchReplaceRx),
TAB(InsertDate),
TAB(InsertUid),
TAB(FrameNew),
TAB(FrameClose),
TAB(FrameNext),
TAB(FramePrev),
TAB(ShowHelpWord),
TAB(ShowHelp),
TAB(ConfigRecompile),
TAB(PlaceGlobalBookmark),
TAB(RemoveGlobalBookmark),
TAB(GotoGlobalBookmark),
TAB(MoveBeginOrNonWhite),
TAB(MoveBeginLinePageFile),
TAB(MoveEndLinePageFile),
TAB(PushGlobalBookmark),
TAB(PopGlobalBookmark),
};
#if 0
//TAB(ShowMsg),
TAB(BlockReadPipe),
TAB(BlockWritePipe),
TAB(BlockPipe),
};
#endif
