/*    c_commands.h
 *
 *    Copyright (c) 1994-1996, Marko Macek
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 */

#ifndef __COMMANDS_H__
#define __COMMANDS_H__

typedef enum {
    ErFAIL = 0,
    ErOK = 1
} ExResult;

typedef enum {
    ExNop,
    ExFail,

    //<cmd_cursor> Cursor Movement

    //& <A HREF="modes.html#ms.CursorTroughTabs">CursorTroughTabs</A>
    
    ExMoveDown,
    /// Move cursor to next line.
    ExMoveUp,
    /// Move cursor to previous line
    ExMoveLeft,
    /// Move cursor to previous column.
    ExMoveRight,
    /// Move cursor to next column.
    ExMovePrev,
    /// Move cursor to previous character. Moves to end of the previous
    /// line if cursor is at the beginning of line.
    ExMoveNext,
    /// Move cursor to next character. Moves to the beginning of next
    /// line if cursor is at the end of line.
    ExMoveWordLeft,
    /// Move cursor to the beginning of the word on the left.
    ExMoveWordRight,
    /// Move cursor to the beginning of the word on the right.
    ExMoveWordPrev,
    /// Move cursor to the beginning of the previous word.
    ExMoveWordNext,
    /// Move cursor to the beginning of the next word.
    ExMoveWordEndLeft,
    /// Move cursor to the end of the previous word.
    ExMoveWordEndRight,
    /// Move cursor to the end of the word on the right.
    ExMoveWordEndPrev,
    /// Move cursor to the end of the previous word.
    ExMoveWordEndNext,
    /// Move cursor to the end of the next word.
    ExMoveLineStart,
    /// Move cursor to the beginning of line.
    ExMoveLineEnd,
    /// Move cursor to the end of line.
    ExMovePageStart,
    /// Move cursor to the first line on current page.
    ExMovePageEnd,
    /// Move cursor to the last line on currently page.
    ExMovePageUp,
    /// Display previous page.
    ExMovePageDown,
    /// Display next page.
    ExMoveFileStart,
    /// Move cursor to the beginning of file.
    ExMoveFileEnd,
    /// Move cursor to the end of file.
    ExMovePageLeft,
    /// Scroll horizontally to display page on the left.
    ExMovePageRight,
    /// Scroll horizontally to display page on the right.
    ExMoveBlockStart,
    /// Move cursor to the beginning of block.
    ExMoveBlockEnd,
    /// Move cursor to end beginning of block.
    ExMoveFirstNonWhite,
    /// Move cursor to the first non-blank character on line.
    ExMoveLastNonWhite,
    /// Move cursor to the last non-blank character on line.
    ExMovePrevEqualIndent,
    /// Move cursor to the previous line with equal indentation.
    ExMoveNextEqualIndent,
    /// Move cursor to the next line with equal indentation.
    ExMovePrevTab,
    /// Move cursor to the previous tab position.
    ExMoveNextTab,
    /// Move cursor to the next tab position.
    ExMoveTabStart,
    /// When cursor is on the tab characters, moves it to the beginning
    /// of the tab.
    ExMoveTabEnd,
    /// When cursor is on the tab characters, moves it to the end
    /// of the tab.
    ExMoveLineTop,
    /// Scroll the file to make the current line appear on the top of the window.
    ExMoveLineCenter,
    /// Scroll the file to make the current line appear on the center of the window.
    ExMoveLineBottom,
    /// Scroll the file to make the current line appear on the bottom of the window.
    ExScrollLeft,
    /// Scroll screen left.
    ExScrollRight,
    /// Scroll screen right.
    ExScrollDown,
    /// Scroll screen down.
    ExScrollUp,
    /// Scroll screen up.
    ExMoveFoldTop,
    /// Move to the beginning of current fold.
    ExMoveFoldPrev,
    /// Move to the beginning of previous fold.
    ExMoveFoldNext,
    /// Move to the beginning of next fold.
    ExMoveBeginOrNonWhite,
    /// Move to beginning of line, or to first non blank character
    ExMoveBeginLinePageFile,
    /// Move to the beginning of line. If there already, move to the beginning
    /// page. If there already, move to the beginning of file.
    ExMoveEndLinePageFile,
    /// Move to the end of line. If there already, move to the end
    /// page. If there already, move to the end of file.
    
    //<cmd_delete> Deleting Text
    ExKillLine,
    /// Delete current line. If the line is the last line in the file,
    /// only the text is deleted.
    ExKillChar,
    /// Delete character under (after) cursor.
    ExKillCharPrev,
    /// Delete character before cursor.
    ExKillWord,
    /// Delete the word after cursor.
    ExKillWordPrev,
    /// Delete the word before cursor.
    ExKillToLineStart,
    /// Delete characters to the beginning of line.
    ExKillToLineEnd,
    /// Delete characters to the end of line.
    ExKillBlock,
    /// Delete block.
    ExKillBlockOrChar,
    /// If block is marked, delete it, otherwise delete character under cursor.
    ExKillBlockOrCharPrev,
    /// If block is marked, delete it, otherwise delete character before cursor.
    ExDelete,
    /// Delete character under (after) cursor.
    //& <A HREF="modes.html#ms.DeleteKillTab">DeleteKillTab</A>
    //& <A HREF="modes.html#ms.DeleteKillBlock">DeleteKillBlock</A>
    ExBackSpace,
    /// Delete character before cursor.
    //& <A HREF="modes.html#ms.BackSpKillTab">BackSpKillTab</A>
    //& <A HREF="modes.html#ms.BackSpKillBlock">BackSpKillBlock</A>

    //<cmd_line> Line Commands
    ExLineInsert,
    /// Insert a new line before the current one.
    ExLineAdd,
    /// Add a new line after the current one.
    ExLineSplit,
    /// Split current line after cursor position
    ExLineJoin,
    /// Join current line with next one. If cursor is positioned beyond
    /// the end of line, the current line is first padded with whitespace.
    ExLineNew,
    /// Append a new line and move to the beginning of new line.
    ExLineIndent,
    /// Reindent current line.
    ExLineTrim,
    /// Trim whitespace at the end of current line.
    ExLineDuplicate,
    /// Duplicate the current line.

    //<cmd_block> Block Commands
    ExBlockBegin,
    /// Set block beginning to current position.
    ExBlockEnd,
    /// Set block end to current position.
    ExBlockUnmark,
    /// Unmark block.
    ExBlockCut,
    /// Cut selected block to clipboard.
    ExBlockCopy,
    /// Copy selected block to clipboard.
    ExBlockCutAppend,
    /// Cut selected block and append it to clipboard.
    ExBlockCopyAppend,
    /// Append selected block to clipboard.
    ExBlockClear,
    ///
    ExBlockPaste,
    /// Paste clipboard to current position.
    ExBlockKill,
    /// Delete selected text.
    ExBlockIndent,
    /// Indent block by 1 character.
    ExBlockUnindent,
    /// Unindent block by 1 character.
    ExBlockMarkStream,
    /// Start/stop marking stream block.
    ExBlockMarkLine,
    /// Start/stop marking line block.
    ExBlockMarkColumn,
    /// Start/stop marking column block.
    ExBlockExtendBegin,
    /// Start extending selected block.
    ExBlockExtendEnd,
    /// Stop extending selected block.
    ExBlockReIndent,
    /// Reindent entire block (C/REXX mode)
    ExBlockSelectWord,
    /// Select word under cursor as block.
    ExBlockSelectLine,
    /// Select current line as block.
    ExBlockSelectPara,
    /// Select current paragraph (delimited by blank lines) as block.
    ExBlockPasteStream,
    /// Paste clipboard to current position as stream block.
    ExBlockPasteLine,
    /// Paste clipboard to current position as line block.
    ExBlockPasteColumn,
    /// Paste clipboard to current position as column block.
    ExBlockPrint,
    /// Print a block to configured device.
    ExBlockRead,
    /// Read block from file.
    ExBlockReadStream,
    ExBlockReadLine,
    ExBlockReadColumn,
    ExBlockWrite,
    /// Write marked block to file.
    ExBlockSort,
    /// Sorts the marked block in ascending order.
    ///
    //\ If mode setting MatchCase is set, characters will be compared case
    //\ sensitively.
    ///
    //\ When block is marked in <A HREF="modes.html#ec.BlockMarkStream">
    //\ Stream</A> or <A HREF="#ec.BlockMarkLine">Line</A> mode,
    //\ the entire lines in marked block will be compared.
    ///
    //\ When block is marked in <A HREF="#ec.BlockMarkColumn">Column</A>
    //\ mode, only characters within marked columns will be compared.
    ExBlockSortReverse,
    /// Sorts the marked block in descending order.
    //^ <A HREF="#ec.BlockSort">BlockSort</A>
    ExBlockUnTab,
    /// Remove tabs from marked lines.
    ExBlockEnTab,
    /// Generate and optimize tabs in marked lines.
    ExBlockMarkFunction,
    /// Mark current function as block.

    //<cmd_edit> Text Editing and Insertion
    ExUndo,
    /// Undo last operation
    ExRedo,
    /// Redo last undone operation.

    //<cmd_fold> Folding Text
    ExFoldCreate,
    ExFoldCreateByRegexp,
    ExFoldDestroy,
    ExFoldDestroyAll,
    ExFoldPromote,
    ExFoldDemote,
    ExFoldOpen,
    ExFoldOpenNested,
    ExFoldClose,
    ExFoldOpenAll,
    ExFoldCloseAll,
    ExFoldToggleOpenClose, 

    ExMoveToLine,
    ExMoveToColumn,
    ExMoveSavedPosCol,
    ExMoveSavedPosRow,
    ExMoveSavedPos,
    ExSavePos,
    ExMovePrevPos,
    // ExCursorPush,
    // ExCursorPop,

    //<cmd_bookmark>Bookmarks
    ExPlaceBookmark,
    /// Place a file-local bookmark.
    ExRemoveBookmark,
    /// Place a file-local bookmark.
    ExGotoBookmark,
    /// Go to file-local bookmark location.
    ExPlaceGlobalBookmark,
    /// Place global (persistent) bookmark.
    ExRemoveGlobalBookmark,
    /// Remove global bookmark.
    ExGotoGlobalBookmark,
    /// Go to global bookmark location.
    ExPushGlobalBookmark,
    /// Push global bookmark (named as #<num>) to stack.
    ExPopGlobalBookmark,
    /// Pop global bookmark from stack.

    //<cmd_trans> Character Translation
    ExCharCaseUp,
    ExCharCaseDown,
    ExCharCaseToggle,
    ExCharTrans,
    ExLineCaseUp,
    ExLineCaseDown,
    ExLineCaseToggle,
    ExLineTrans,
    ExBlockCaseUp,
    ExBlockCaseDown,
    ExBlockCaseToggle,
    ExBlockTrans,
    
    ExInsertString,
    ExInsertSpace,
    ExInsertChar,
    ExTypeChar,
    ExInsertTab,
    ExInsertSpacesToTab,
    ExSelfInsert,
    ExWrapPara,
    ExInsPrevLineChar,
    ExInsPrevLineToEol,
    ExCompleteWord,
    
    ExFilePrev,
    ExFileNext,
    ExFileLast,
    ExSwitchTo,

    ExFileOpen,
    ExFileOpenInMode,
    ExFileReload,
    ExFileSave,
    ExFileSaveAll,
    ExFileSaveAs,
    ExFileWriteTo,
    ExFilePrint,
    ExFileClose,
    ExFileCloseAll,
    
    ExDirOpen,
    ExDirGoUp,
    ExDirGoDown,
    ExDirGoRoot,
    ExDirGoto,

    ExIncrementalSearch,
    ExFind,
    ExFindReplace,
    ExFindRepeat,
    ExFindRepeatOnce,
    ExFindRepeatReverse,
    ExMatchBracket,
    ExHilitWord,
    ExSearchWordPrev,
    ExSearchWordNext,
    ExHilitMatchBracket,
    ExSearch,
    ExSearchB,
    ExSearchRx,
    ExSearchAgain,
    ExSearchAgainB,
    ExSearchReplace,
    ExSearchReplaceB,
    ExSearchReplaceRx,
    
    ExWinHSplit,
    ExWinNext,
    ExWinPrev,
    ExWinClose,
    ExWinZoom,
    ExWinResize,

    ExViewBuffers,
    ExListRoutines,
    ExCompile,
    ExViewMessages,
    ExCompilePrevError,
    ExCompileNextError,

    ExExitEditor,
    ExShowEntryScreen,
    ExRunProgram,

    ExShowPosition,
    ExShowVersion,
    ExShowKey,
    ExWinRefresh,

    ExMainMenu,
    ExShowMenu,
    ExLocalMenu,

    ExChangeMode,
    ExChangeKeys,
    ExChangeFlags,

    ExToggleAutoIndent,
    ExToggleInsert,
    ExToggleExpandTabs,
    ExToggleShowTabs,
    ExToggleUndo,
    ExToggleReadOnly,
    ExToggleKeepBackups,
    ExToggleMatchCase,
    ExToggleBackSpKillTab,
    ExToggleDeleteKillTab,
    ExToggleSpaceTabs,
    ExToggleIndentWithTabs,
    ExToggleBackSpUnindents,
    ExToggleWordWrap,
    ExToggleTrim,
    ExToggleShowMarkers,
    ExSetLeftMargin,
    ExSetRightMargin,
    ExToggleSysClipboard,
    ExSetPrintDevice,
    ExChangeTabSize,
    ExChangeLeftMargin,
    ExChangeRightMargin,

    ExCancel,
    ExActivate,
    ExRescan,
    ExCloseActivate,
    ExActivateInOtherWindow,

    ExASCIITable,
    ExDesktopSave,
    ExClipClear,
    ExDesktopSaveAs,
    ExChildClose,

    ExBufListFileSave,
    ExBufListFileClose,

    ExViewModeMap,
    ExClearMessages,

    ExTagFind,
    ExTagFindWord,
    ExTagNext,
    ExTagPrev,
    ExTagPop,
    ExTagLoad,
    ExTagClear,
    ExTagGoto,

    // JAL
    ExIndentFunction,
    ExMoveFunctionPrev,
    ExMoveFunctionNext,
    ExInsertDate,
    ExInsertUid,

    ExFrameNew,
    ExFrameClose,
    ExFrameNext,
    ExFramePrev,

    ExBufferViewNext,
    ExBufferViewPrev,

    ExShowHelpWord,
    ExShowHelp,
    ExConfigRecompile,
} ExCommands;

#endif
