# ifdef __REQUIRED__

%chdr
version.h
clb.hef

# endif

# if 0
VERS____( Common Library Function Declaration, Sei/Gl, 95/03/27)
# endif


/******************************************************************************
:++
:HEADER_FILE		"clb_func.h"	"CLB Function Declaration"

:PURPOSE

Deklaration von CLB Functions zur Benutzung von C++, bzw. von C Compilern, die
ANSI Standard erlauben.

:para
Definiert werden solche Funktionen, die in Assembler implementiert sind, und
solche, die in inline Definitionen in Header Files ben"otigt werden, d. h. vor
dem Includieren der '.hef' und '.hif' Files.

:para
'clb_func.h' wird durch 'promstd.h' angezogen und bewirkt seinerseits das
In"\klu"\die"\ren von 'clb.hef'.

:ENDPURPOSE
:--
******************************************************************************/

#if ANSI_STANDARD
EXTERN C_PUBLIC DLLEXPORT ADDR clb_movc3( ULONG len, ADDR src, ADDR dest);
EXTERN C_PUBLIC DLLEXPORT ADDR clb_movc5( ULONG srclen, ADDR src, TEXT fill, ULONG destlen, ADDR dest);
EXTERN C_PUBLIC DLLEXPORT ADDR clb_fill( ULONG len, ADDR from, TEXT fillchar);
EXTERN C_PUBLIC DLLEXPORT INT clb_cmpc3( ULONG len, ADDR src, ADDR dest);
EXTERN C_PUBLIC DLLEXPORT INT clb_cmpc5( ULONG srclen, ADDR src, TEXT fill, ULONG destlen, ADDR dest);
EXTERN C_PUBLIC DLLEXPORT VOID clb_xdump( ADDR buf, ULONG len);
EXTERN C_PUBLIC DLLEXPORT ADDR clb_malloc( ULONG size);
EXTERN C_PUBLIC DLLEXPORT ADDR clb_free( ADDR faddress);
EXTERN C_PUBLIC DLLEXPORT TEXT *clb_savstr( TEXT *s);
EXTERN C_PUBLIC DLLEXPORT TEXT *clb_savbuf( TEXT *s, INT n);
EXTERN C_PUBLIC DLLEXPORT VOID panic( TEXT *s1, TEXT *s2);
EXTERN C_PUBLIC DLLEXPORT VOID mon_chkctrlc();
EXTERN C_PUBLIC DLLEXPORT VOID mon_start();
EXTERN C_PUBLIC DLLEXPORT VOID mon_plin( TEXT *buf);
EXTERN C_PUBLIC DLLEXPORT VOID mon_plinlf( TEXT *buf);
#if OS2 || MSDOS
EXTERN C_PUBLIC INT clb_cast_long2int( LONG expr, TEXT *file, ULONG line, TEXT *expr_text);
EXTERN C_PUBLIC INT clb_cast_ulong2int( ULONG expr, TEXT *file, ULONG line, TEXT *expr_text);
EXTERN C_PUBLIC UINT clb_cast_long2uint( LONG expr, TEXT *file, ULONG line, TEXT *expr_text);
EXTERN C_PUBLIC UINT clb_cast_ulong2uint( ULONG expr, TEXT *file, ULONG line, TEXT *expr_text);
#if MSDOS
EXTERN C_PUBLIC VOID clb_global_free( VOID *p);
EXTERN C_PUBLIC VOID *clb_global_alloc( ULONG size);
#endif
#endif
#endif
