# ifdef __REQUIRED__

promstd.h
cracka.hef

# endif

# if 0
VERS____( cracka.h - definitions for crackargv, Hoe/Sei, 94/03/22)
# endif

/******************************************************************************
:++
:HEADER_FILE		"cracka.h"		"Argument Cracker"

:PURPOSE

Definition der Template Struktur zur Benutzung des Command Line Argument
Crackers 'clb_crackargv' und der dazugeh"origen Konstanten.

:ENDPURPOSE
:--
******************************************************************************/
/*P*/
/*
**	Argument description structure
*/

struct argtemplate
    {
    char flag_cname;	        /* character to reference this flag	*/
                                /* used in UNIX style with '-'          */
    char flag_type;	        /* the value type, see below		*/
    char flag_mlength;	        /* number of chars needed to "match"	*/
    char *flag_lname;	        /* long name to reference this flag	*/
                                /* used in DCL style with '/'           */
    char *flag_aname;	        /* alternate string name (e.g. Multics)	*/
    char *flag_value;	        /* a place to put the value		*/
    char *flag_prompt;	        /* prompt for a missing parameter	*/
    char *flag_usage;	        /* text for usage message		*/
    };

typedef struct argtemplate	ARGLIST;

/*
**	values for flag_type
*/

#define FLAGCHAR	0x1	/* a single character			*/
#define FLAGSTRING	0x2	/* a text string			*/
#define FLAGSHORT	0x3	/* a short integer			*/
#define FLAGLONG	0x4	/* a long integer			*/
#define FLAGINT		0x5	/* a natural integer			*/
#define FLAGHEX		0x6	/* a natural integer - hexadecimal	*/
#define FLAGLIST        0x7     /* a list of strings like 'argv'        */
                                /* i.e. a NULL terminated array of      */
                                /* string addresses                     */
#define FLAGBOOL	0x10	/* a boolean				*/
#define FLAGNULL	0x11	/* crackargv returns with NULL          */
#define FLAGCLDGEN      0x12    /* VMS special - generate a '.cld' file */
#define FLAGCONTINUE    0x13    /* terminate argument cracking for use	*/
				/* of the rest by another crackargv call */
#define FLAGBOOLP       0x14    /* a pointer to a boolean               */
#define FLAGIGNORE	0x20	/* flag is defined, but must be ignored	*/
#define FLAGBOOLIGNORE	(FLAGBOOL | FLAGIGNORE)
#define FLAGGIVEN	0x40	/* flag has been specified (internal)   */


/*
**	special values for flag_cname
*/

#define FLAGPOS		'\001'	/* this is a positional parameter      	*/
#define FLAGUSE		'\002'	/* forces prompting for parameter       */
				/* not for installed DCL commands	*/
/*P*/
/*
**	example for a user interface and description of 'crackargv()'
*/

# if 0

ARGLIST arglist [] = {
/*
cname,	 type,	     mlentgh,	lname,	aname,	variable, prompt,	usage
*/
FLAGPOS, FLAGLIST,	0,	NULL,	NULL,	&listlist[0], "source file", NULL,
'T',	 FLAGSTRING,	3,	"TIT",	NULL,	&title,	  NULL,	      "title",
'?',	 FLAGNULL,	4,	"HELP",	NULL,	NULL,     NULL,		" ",
'h',	 FLAGBOOL,	3,	"NOH",	NULL,	&nohflag, NULL,		" ",
'Y',     FLAGCLDGEN,    6,      "CLDGEN", NULL, NULL,     NULL,         "",
 0 };


:++
:FUNCTION         crackargv        "take apart an argument vector"

:SYNOPSIS

TEXT **crackargv( pargc, argv, template)
    INT *pargc;
    TEXT **argv;
    ARGLIST *template;

:PURPOSE

`crackargv` takes an argument vector and a template of the ""interesting""
parameters and pulls them all out.  It can be used as a general
argument cracker to insure a reasonable user interface.

:para
`*pargc`, `argv` are parameters like those of 'main( argc, argv)'.

:para
`pargc` is a pointer to the argument count ('argc') passed to your program. On
return the remaining argument count is equal to the number of arguments not
matched.

:para
`argv` is an argument vector ('argv') as passed to your basic program.  The first
element is ignored to simplify passing from 'main()'.

:para
`template` is a template of arguments.  See 'ARGLIST' example in 'cracka.h'.

:RETURNS
'NULL', if a special flag is set or a pointer to the rest of the `argv`.

:para
As Side Effects `*pargc` will be updated to the count of the arguments not used.

:para
For more details look at the file 'cracka.h'.

:--

:USAGE

        You can use the crackargv in the following modes:

        1. crack argument list
            - UNIX style
            - DCL style
        2. DCL installed command

        CRACKARGV recognizes automatically the used mode.
        The style (1 .mode) will be terminated by the first used flag
        character ('-' = UNIX style, '/' = DCL style).

:SPECIALITIES

        The field 'usage' should get a string only in case of non - boolean
        arguments. In case of boolean flag arguments use " " for 'usage'.
        The value "" defines the argument as hidden, i.e. it is not shown in
        the usage message.

        FLAGLIST should be the last positional parameter (FLAGPOS), because
        it uses the rest of the argv vector. Normally only one list is
        allowed in the command line.

        DCL style

        - /CLDGEN generates a '.CLD' file used to install as DCL command


        DCL installed command

        - Boolean flags can be YES and the negation NOFLAG can explicitely
          be used.
        - Prompting for flag arguments (qualifiers) is impossible.
        - Several list arguments are allowed, also qualifiers as list
          arguments are allowed.
        - No error occurs if more than once the same qualifier is used.

:BUGS

        In DCL and UNIX style boolean flags can only be set YES by use, a
        negation is not possible.

        The fields 'cname' and 'lname' are required in each description of a
        non - positional argument.

	A UNIX file name may be interpreted as DCL-style flag. Use '-' without
	a flag character to force UNIX-style with interpretion of '/...' as
	positional parameter.

# endif


/* local data structures */

# define CRACK_WORK struct crack_work

CRACK_WORK
    {
    ARGLIST *tmpl;	  	        /* template of arguments	      */
    TEXT *pname;                        /* first argument                     */
    TEXT **av;      		        /* argument vector  		      */
    INT ac;        		        /* argument counter 	    	      */
    INT widcnt;                         /* counter for width of usage message */
    INT status;                         /* exit status                        */
    TEXT dclchar;                       /* used for usage message	      */
    TEXT usgchar;
    TEXT dummy;
    TEXT flagchar;  		        /* '/' = DCL; '-' = UNIX       	      */
    BOOL promptflg;			/* prompt for required flags	      */
    BOOL initflg;			/* initialize table		      */
    BOOL usageflg;			/* print usage message and exit	      */
    };

