#include <stdio.h>
#include <oi_api.h>

/*
**	ProMOD PLUS data types:
**
**	The data types used below are consistent with ProMOD usage and
**	philosophy.  See header files for details.
*/


LOCAL TEXT *log_file     = "api_test.log";
LOCAL TEXT *servername   = "node::port";
LOCAL TEXT *pro_env      = NULL;
LOCAL TEXT *database     = NULL;      	    /* name of ProMod Database */
LOCAL TEXT *project      = "test-project";  /* name of ProMod Project  */


/*
**	command line parameters
**	(for utility routine crackargv(), included with API. see cracka.h)
*/

/* a little trick to keep the lines manageable */
#define __ (TEXT *)

LOCAL ARGLIST api_arglist[] =
{
/*
cname, type, mlength,lname,      aname,    variable,  prompt,    usage,
*/
'A', FLAGSTRING, 3, "LOG","pro_logfile", __ &log_file,  NULL,"log file name",
'C', FLAGSTRING, 3, "SRV", "pro_server", __ &servername,NULL,"server name",
'D', FLAGSTRING, 3, "CMD",         NULL, __ &pro_env,   NULL,"command file",
'J', FLAGSTRING, 3, "PDB","pro_database", __ &database, NULL,"ProMod Database",
'K', FLAGSTRING, 3, "PRJ","pro_project", __ &project,   NULL,"ProMod Project",
'\0'
};

/*
**	realmain() - called by the ProMOD API instead of main()
**
**	The API includes its own main() routine which performs the
**	required initialization of the object-oriented runtime environment
**	before calling the user routine realmain().
*/

INT realmain( argc, argv)
    INT argc;
    TEXT **argv;
    {
    OI_API_CON_ADDR con;
    OI_LIB_HDL_ADDR lib;
    CLIENT_ADDR client;
    OI_FD_HDL_ADDR fd;
    LONG result;
    INT fd_no_obj;
    TEXT *fd_name;

    /*
    ** 	get parameters from command line or command file
    */
    
    crackargv( &argc, argv, api_arglist);	/* parse command line */
    if( pro_env)
	clb_readargs( pro_env, api_arglist);	/* read command file  */
    clb_printargs( log_file, api_arglist);	/* log command line   */
	

    /* 
    ** 	frame part 1
    */

    con = OI_API_connect( servername, project);     /* connect to server    */
    client = OI_API_get_client( con); 		    /* get RPC handle       */
    lib = OI_LIB_HDL_create( client, "API-libhdl");
    if( OI_LIB_HDL_open( lib, project, database) == OI_LIB_MISSING_FILENAME)
	{	    				    /* open the project lib */
	printf( "can't open project = %s, database = %s\n", project,
	       			database ? database : "< NULL >");
	goto error_exit;
	}
    fd = OI_FD_HDL_create(client,"API-scan FD");

    /* 
    ** 	application body
    */

    if(OI_FD_HDL_get_name_list(fd,"*") == OI_PRD_SUCCESS)
	{
	OI_TXT_HDL_open( fd, OI_GET_MODE);
	fd_no_obj = OI_TXT_HDL_no_of_txts( (OI_TXT_HDL_ADDR) fd);
	printf( "number of objects matching pattern:\t%d\n", fd_no_obj);
	while( (fd_name = OI_TXT_HDL_getnext( (OI_TXT_HDL_ADDR) fd)) != NULL)
	    {
	    printf( "flow diagram name\t%s\n", fd_name);
	    }
	OI_TXT_HDL_close((OI_TXT_HDL_ADDR)fd);
	}
    OI_FD_HDL_delete(fd);


    /*
    ** 	frame part 2
    */
error_exit:

    OI_LIB_HDL_delete(lib);
    OI_API_disconnect(con);   /* close database and disconnect from server */
    return(SUCCESS);
    }
