#ifdef __REQUIRED__

prd_00types.h
oi_060general.h

#endif

# if 0
VERS____( oi_009types.h - basic OI types, Mrt/Mt/MB/Sei, 91/01/24)
# endif

/* FD and DATA specific return values */

#define OI_PARENT_NOT_FOUND              0x060
#define OI_IS_COMPONENT_OF_OLD_NAME      0x061
#define OI_COMPONENT_IS_BROTHER          0x062



/* definition of component types used in the OI interface */

/* MSP specific literals to specifiy type of msp text tokens
** see also oi_060general.h
*/

#define OI_MSP_IN_REF  		OI_TXT_INREF
#define OI_MSP_OUT_REF		OI_TXT_OUTREF
#define OI_MSP_INOUT_REF 	OI_TXT_INOUT
#define OI_MSP_TEXT             OI_TXT_TEXT
#define OI_MSP_ALL_REF  	51

/* SHEET specific constants
** see also oi_060general.h
*/

#define OI_SHEET_TEXT                       OI_TXT_TEXT
#define OI_SHEET_EVENT                      OI_TXT_INREF
#define OI_SHEET_EVENT_ACTION               OI_TXT_INOUT
#define OI_SHEET_ACTION_CF                  OI_TXT_OUTREF
#define OI_SHEET_ACTION_ACT_PROC            OI_TXT_ACTIVATE
#define OI_SHEET_ACTION_DEACT_PROC          OI_TXT_DEACTIVATE
#define OI_SHEET_STATE                      0x51
#define OI_SHEET_TRANS                      0x52
#define OI_SHEET_SIMPLE_FLOW                0x53
#define OI_SHEET_SIMPLE_PROC                0x54
#define OI_SHEET_ACTION_START_PROC          0x55

/* note!!!!! OI_TEXT (see below) is also a possible SHEET constant */

#define OI_STD_MAX_COORD                    30
/*P*/


/* CROSS REFERENCE MASK BITS */

#define OI_CROSS_MSP_REF                0x00000001L
#define OI_CROSS_STORE			0x00000002L
#define OI_CROSS_DA_REF                 0x00000004L
#define OI_CROSS_DATA_FLOW              0x00000008L
#define OI_CROSS_CTRL_FLOW              0x00000010L
#define OI_CROSS_ENTITY                 0x00000020L
#define OI_CROSS_RELSHIP                0x00000040L
#define OI_CROSS_NOTUSED                0x00000080L
#define OI_CROSS_ACTION                 0x00000100L
#define OI_CROSS_EVENT                  0x00000200L

/*P*/
/*********************************************/
/* general constants for TCB objects         */
/*********************************************/

	/* objects types which participate on edge types  */

#define OI_TCB_FD        1
#define OI_TCB_ERD       2
#define OI_TCB_MSP       3
#define OI_TCB_CSP       4
#define OI_TCB_SHEET     5
#define OI_TCB_NODE      6
#define OI_TCB_DDE       7
#define OI_TCB_SUB       8
#define OI_TCB_MOD       9
#define OI_TCB_FU        10
#define OI_TCB_ERM       11
#define OI_TCB_TASK      12
#define OI_TCB_DIALOG    13
#define OI_TCB_THING     14

	/* supported edge types  between requirements and design */

#define OI_TCB_TRANS_ERD_MOD		1
#define OI_TCB_TRANS_DDE_MOD		2
#define OI_TCB_TRANS_FD_MOD		3
#define OI_TCB_TRANS_NODE_FU		4
#define OI_TCB_TRANS_MSP_FU		5
#define OI_TCB_TRANS_MSP_SUB		6
#define OI_TCB_TRANS_SHEET_FU		7
#define OI_TCB_TRANS_CSP_MOD		8
#define OI_TCB_TRANS_ENT_MOD		9
#define OI_TCB_TRANS_RSH_MOD		10
#define OI_TCB_TRANS_STORE_MOD		11
#define OI_TCB_TRANS_DDE_SUB		12
#define OI_TCB_TRANS_DDE_FU		13
#define OI_TCB_TRANS_FD_SUB		14
#define OI_TCB_TRANS_ERM_MOD		15
#define OI_TCB_TRANS_FD_FU              16

#define OI_TCB_TRANS_STORE_FU		30

	/* supported edge types  between requirements and dynamic design*/

#define OI_TCB_TRANS_ERD_TASK		17
#define OI_TCB_TRANS_DDE_TASK		18
#define OI_TCB_TRANS_FD_TASK		19
#define OI_TCB_TRANS_NODE_TASK		20
#define OI_TCB_TRANS_CSP_TASK		21
#define OI_TCB_TRANS_ENT_TASK		22
#define OI_TCB_TRANS_RSH_TASK		23
#define OI_TCB_TRANS_STORE_TASK		24
#define OI_TCB_TRANS_ERM_TASK		25

#define OI_TCB_TRANS_MSP_TASK		29

	/* supported edge types  between design  and dynamic design*/

#define OI_TCB_TRANS_MOD_TASK		26


#define OI_TCB_TRANS_SUB_TASK		31

	/* supported edge types  between requirements and UI design*/

#define OI_TCB_TRANS_FD_DLG		40
#define OI_TCB_TRANS_DDE_THING		41
#define OI_TCB_TRANS_NODE_THING		42

	/* supported edge types  between design and UI design*/

#define OI_TCB_TRANS_FU_THING		50
#define OI_TCB_TRANS_SUB_DLG		51
#define OI_TCB_TRANS_MOD_DLG		52
#define OI_TCB_TRANS_MOD_THING		53


/* values for edge properties */

#define OI_TCB_TOTAL       1
#define OI_TCB_PARTIAL     2
#define OI_TCB_UNSPEC      3

#define OI_TCB_USER_DEF    1
#define OI_TCB_TOOL_DEF    2
#define OI_TCB_TRANS_GEN   3


/*P*/
/*********************************************/
/* general constants for TSKD objects         */
/*********************************************/
/* list of possible TSKD objects */
#define OI_TSKD_DIAGRAM                     0x01
#define OI_TSKD_TASK                        0x02
#define OI_TSKD_EVENT                       0x04
#define OI_TSKD_MESSAGE                     0x08
#define OI_TSKD_ACTPOINT		    0x10

/* special TSKD text object, only in diagram used */
#define OI_TSKD_TEXT		    	    OI_TEXT

/* list of possible TSKD text element types */
#define OI_TSKD_PURPOSE			    0x01
#define OI_TSKD_ACTIVATOR		    0x02
#define OI_TSKD_RESOURCE		    0x04
#define OI_TSKD_PRIORITY		    0x08

/* number of aloud points in connection */
#define OI_TSKD_MAX_COORD                     30

/* format string for namelist used by set_ana_date */
/* the format holds for tskd objects     : <obj_type, obj_name, "\0""\0", 0>  */
/* the format holds for activation points: <OI_TSKD_ACTPOINT, obj_name, tskd_obj_name, tskd_obj_type> */
#define OI_TSKD_NAMELIST		    "%d ! %s ! %s ! %d"
/* the number of parameters is constant set to four */
#define OI_TSKD_NAMELIST_COUNT		       4
/* only for internal use (oi_tskd_decode()) */
#define OI_TSKD_SEARCH_PATTERN '!'

/*P*/
/* FD specific constants */

#define OI_FD_NODE                          0x01
#define OI_FD_STORE                         0x02
#define OI_FD_TERM                          0x04
#define OI_FD_BAR                           0x08
#define OI_FD_SPLITT                        0x10
#define OI_FD_MERGE                         0x12
#define OI_FD_CONTROL_FLOW                  0x16
#define OI_FD_DATA_FLOW                     0x32
/* note!!!!! OI_TEXT (see above) is also a possible FD constant */

#define OI_FD_BIDIRECT                      0x01

#define OI_FD_MAX_COORD                     30

#define OI_FD_DF_INFLOWS                    0x01
#define OI_FD_DF_OUTFLOWS                   0x02
#define OI_FD_CF_INFLOWS                    0x04
#define OI_FD_CF_OUTFLOWS                   0x08

/* ERD constants */

#define OI_ERD_VIEW                        0x00
#define OI_ERD_GLOBAL                      0x01

#define OI_ERD_ENTITY_TYPE                 0x00
#define OI_ERD_RELSHIP_TYPE                0x01
#define OI_ERD_AGGREGAT_TYPE               0x02

#define OI_ERD_PARTIAL                     0x00
#define OI_ERD_TOTAL                       0x01
#define OI_ERD_WEAK                        0x02

#define OI_ERD_ISA_RELSHIP                 0
#define OI_ERD_NORMAL_RELSHIP              1
#define OI_ERD_WEAK_ENTITY                 2
#define OI_ERD_NORMAL_ENTITY               3

/* Source Destination Types for Edges */
#define OI_ERD_E_R                         2   /* Entity-Relship */
#define OI_ERD_E_A                         3   /* Entity-Aggregation */
#define OI_ERD_A_A                         4   /* Aggregation-Aggregation */

#define OI_ERD_NO                          0x00
#define OI_ERD_YES                         0x01

#define OI_ERD_CARD_1                      0x00
#define OI_ERD_CARD_N                      0x01
#define OI_ERD_CARD_M                      0x02
#define OI_ERD_CARD_1N                     0x03
#define OI_ERD_CARD_NM                     0x04

#define OI_ERD_MAX_COORD                   30

/*P*/
/* DA constants */

#define OI_DA_PRIMITIVE                    1
#define OI_DA_HIDDEN                       2
#define OI_DA_ITERATION                    3
#define OI_DA_OPTION                       4
#define OI_DA_NOEMBEDDING                  5
#define OI_DA_COMPLEX                      7
#define OI_DA_UNDEFINED                    8
#define OI_DA_BEGIN_SELECTION              9
#define OI_DA_WITHIN_SELECTION             10
#define OI_DA_END_SELECTION                11
#define OI_DA_SEQUENCE                     12
#define OI_DA_SYNONYM                      13
#define OI_DA_KEY                          14
#define OI_DA_NONKEY                       15
#define OI_DA_NO_ATTRIBUTE                 16
#define OI_DA_DEFINED                      17
#define OI_DA_LEAFE                        18

/* IM Constants */

#define OI_IM_ENTITY                       1
#define OI_IM_RELSHIP                      2

/*P*/
/********************************************************
         RT- (Analyzer) part
********************************************************/


/*
** definition of possible sheet types in a cspec
*/

#define OI_CSP_STD  	0x00000001L
#define OI_CSP_TXT	0x00000002L
#define OI_CSP_STM	0x00000004L

#define OI_OO_CSP_STD  	0x00000008L


/****************************************
** special constants for the analyzer  **
*****************************************/

/*
** mask bits for objects in FD's
*/

#define  OI_ANA_FD_NODE     		0x00000001L
#define  OI_ANA_FD_STORE     		0x00000002L
#define  OI_ANA_FD_TERM    		0x00000004L
#define  OI_ANA_FD_DATA_FLOW     	0x00000008L
#define  OI_ANA_FD_CONTROL_FLOW     	0x00000010L
#define  OI_ANA_FD_BAR     	        0x00000020L

#define OI_ALL_SHEETS  			-1
#define OI_ALL_THINGS  			-1
/*P*/
/***********************************
   MASKS FOR SA ANALYZER CHECK RULES
***********************************/

#define OI_SA_GLOBAL_MASK 0x0000FFFFL
#define OI_SA_LOCAL_MASK  0xFFFF0000L

/*
** GLOBAL RULES (use lower 16 bits)
*/

	/* activate rule 1.12.5 and 1.12.6 */
#define OI_SA_G_FLOW_BALANCE        		0x00000001L
       	/* activate rule 1.12.10           */
#define OI_SA_G_ST_NOT_USED_IN_CHILD            0x00000002L
	/* check whether an object name is specified */
#define OI_SA_G_NAME_NOT_NULL 			0x00000004L
	/* check whether all components of an store are accessed */
#define OI_SA_G_ST_ACCESS   			0x00000008L
	/* check whether the data definition is recursive */
#define OI_SA_G_REK_DEF   			0x00000010L
	/* check whether a control flow or one of its components is used */
        /* as data flow                                                  */
#define OI_SA_G_CF_HAS_DF                       0x00000020L

/*
** rules for NODE checks (use upper 16 bits)
*/

/* the following global flag can also be set
**		OI_SA_G_FLOW_BALANCE
**		OI_SA_G_NAME_NOT_NULL
*/
	/* activate rule 1.4.1 and 1.4.2 */
#define OI_SA_N_NO_OF_INOUT_FLOWS		0x00010000L
	/* activate rule 1.4.4 */
#define OI_SA_N_PSPEC_REQ                       0x00020000L
	/* activate rule 1.4.5 */
#define OI_SA_N_PSPEC_OPT			0x00040000L
        /* simple nodes must have no incoming control flow */
#define OI_SA_N_NO_INCTRL			0x00080000L

/*
** rules for FLOW checks (use upper 16 bits)
*/

/* the following global flag can also be set
**              OI_SA_G_REK_DEF
**              OI_SA_G_CF_HAS_DF
*/
	/* activate rule 1.1.2 */
#define OI_SA_F_MERGE_SPLIT			0x00010000L
	/* activate rule 1.1.4 */
#define OI_SA_F_IN_PSPEC                        0x00020000L
	/* activate rule 1.1.6 */
#define OI_SA_F_CHK_DEFINITION                  0x00040000L
	/* activate rule 1.1.7 */
#define OI_SA_F_NO_NAME                         0x00080000L
	/* activate rule 1.1.8 */
#define OI_SA_F_CHK_STORE			0x00100000L
/*P*/

/*
** rules for TERMINATOR checks (use upper 16 bits)
*/

/* the following global flag can also be set
**		OI_SA_G_NAME_NOT_NULL
*/

	/* activate rule 1.5.1 */
#define OI_SA_T_CHK_NO_OF_FLOWS	 		0x00010000L
	/* activate rule 1.12.7 */
#define OI_SA_T_CHK_BALANCE                     0x00020000L


/*
** rules for STORES checks (use upper 16 bits)
*/

/* the following global flags can also be set
**		OI_SA_G_NAME_NOT_NULL
**              OI_SA_G_REK_DEF
*/

	/* activate rule 1.6.1 */
#define OI_SA_S_CHK_DEFINITION 			0x00010000L
	/* activate rule 1.6.2 */
#define OI_SA_S_CHK_NO_OF_FLOWS	                0x00020000L
	/* activate rule 1.6.3 */
#define OI_SA_S_BTW_PROC_IN_TOPL                0x00040000L


/*
** rules for MSP checks (use upper 16 bits)
*/

	/* activate rule 1.13.1 */
#define OI_SA_MSP_REQ_NODE          		0x00010000L
	/* activate rule 1.13.4 and 1.13.5 */
#define OI_SA_MSP_CMP_WITH_NODE_FLOWS		0x00020000L

/*
** rules for FD checks (use upper 16 bits)
*/

/* the following global flags can also be set
**		OI_SA_G_FLOW_BALANCE
**		OI_SA_G_ST_ACCESS
*/
	/* activate rule 1.8.1 */
#define OI_SA_FD_ONE_NODE_AT_LEAST           	0x00010000L
	/* check whether the object names are unique within the FD */
#define OI_SA_FD_UNIQUE_OBJ                     0x00020000L
	/* activate rule 1.10.1 */
#define OI_SA_FD_CD_ONE_NODE			0x00040000L
	/* activate rule 1.10.2 */
#define OI_SA_FD_CD_1TERM_AT_LEAST           	0x00080000L
/*P*/
/*
** rules for HIERARCHY checks (use upper 16 bits)
*/

/* the following global flags can also be set
**		OI_SA_G_FLOW_BALANCE
**		OI_SA_G_ST_NOT_USED_IN_CHILD
**              OI_SA_G_CF_HAS_DF
*/
	/* activate rule 1.12.8 */
#define OI_SA_H_STORE_BALANCE 			0x00010000L
	/* is node unique in the complete model */
#define OI_SA_H_NODE_UNIQUE			0x00020000L
	/* terminators only in ctx-diagram allowed */
#define OI_SA_H_TERM_ONLY_IN_CTX                0x00040000L
	/* activate rule 1.12.1 */
#define OI_SA_H_ONLY_ONE_CTX                    0x00080000L
	/* activate rule 1.12.2 */
#define OI_SA_H_ONLY_ONE_TL                     0x00100000L

/*
** rules for BAR checks (use upper 16 bits)
*/

	/* does cspec exist */
#define OI_SA_B_CSP_EXISTS 			0x00010000L
        /* at least one bar must have at an incomming control flow */
#define OI_SA_B_NO_INFLOW   			0x00020000L
        /* each bar must have at least one incomming or outgoing flow */
#define OI_SA_B_NOT_ISOLATED                    0x00040000L
        /* perform balancing from bar to cspec */
#define OI_SA_B_CSP_BALANCE                     0x00080000L


/*
** rules for CSPEC resp. SHEET checks (use upper 16 bits)
*/

	/* does fd exist */
#define OI_SA_C_FD_EXISTS 			0x00010000L
	/* do balance from sheet to bars */
#define OI_SA_C_BAR_BALANCE 			0x00020000L
	/* check process activations */
#define OI_SA_C_PROCESS_ACT 			0x00040000L
	/* check the definition of action flows or events */
#define OI_SA_C_ACT_EV_DEF			0x00080000L
	/* check the values of action flows or events */
#define OI_SA_C_ACT_EV_VAL 			0x00100000L
	/* check the values of action flows or events */
#define OI_SA_C_ACT_EV_PRIM 		0x00200000L

/*
** rules for DATA checks (use upper 16 bits)
*/

/* the following global flags can also be set
**              OI_SA_G_REK_DEF
*/

/*-----------------------------------------------------------------*
   MASKS FOR IM ANALYZER CHECK RULES
 *-----------------------------------------------------------------*/

/* SAIM-Group */
#define OI_SAIM_SAME_OBJECTS_IN_DIFFERENT_STORES		0x00000001L
#define OI_SAIM_STORE_WITH_DUPLICATED_COMPONENT                 0x00000002L
#define OI_SAIM_ENTITY_NOT_USED_IN_STORE                        0x00000004L
#define OI_SAIM_RELATIONSHIP_NOT_USED_IN_STORE                  0x00000008L
#define OI_SAIM_STORE_COMPONENT_NOT_IN_IM                       0x00000010L

/* ERD-Group */
#define OI_IM_CYCLIC_GENERALIZATION                             0x00000001L
#define OI_IM_DUPLICATED_SUBTYPE                                0x00000002L
#define OI_IM_RELATIONSHIP_CONNECTION                           0x00000004L
#define OI_IM_TOTAL_GENERALIZATION_WITH_ONE_SUBTYPE             0x00000008L
#define OI_IM_ISA_CONNECTION                                    0x00000010L
#define OI_IM_ENTITY_NOT_NAMED                                  0x00000020L
#define OI_IM_RELATIONSHIP_NOT_NAMED                            0x00000040L
#define OI_IM_EMPTY_ERD                                         0x00000080L
#define OI_IM_INVALID_WEAK_ENTITY                               0x00000100L
#define OI_IM_RELATIONSHIP_WITHOUT_STRONG_CONNECTION		0x00000200L
#define OI_IM_ENTITY_WITH_WEAK_CONNECTION                       0x00000400L
#define OI_IM_WEAK_SUBTYPE                                      0x00000800L

/* DD-Group */
#define OI_IM_CYCLIC_DEFINITION                                 0x00000001L
#define OI_IM_REUSED_ATTRIBUTE_IN_GENERALIZATION                0x00000002L
#define OI_IM_INVALID_KEY                                       0x00000004L
#define OI_IM_REUSE_OF_INHERITED_ATTRIBUTE			0x00000008L
#define OI_IM_EMBEDDING_OF_ATTRIBUTE                            0x00000010L
#define OI_IM_ENTITY_WITHOUT_KEY                                0x00000020L
#define OI_IM_ENTITY_WITHOUT_NONKEY                             0x00000040L
#define OI_IM_NESTED_DEFINITION                                 0x00000080L
#define OI_IM_ENTITY_DEFINED                                    0x00000100L
#define OI_IM_DUPLICATED_ATTRIBUTE                              0x00000200L
#define OI_IM_RELATIONSHIP_WITH_KEY                             0x00000400L
#define OI_IM_SUBTYPE_WITH_KEY                                  0x00000800L
#define OI_IM_VIOLATES_1NF                                      0x00001000L
#define OI_IM_ATTRIBUTE_MODE                                    0x00002000L

/*-----------------------------------------------------------------*/
/*	 STRUCTURE NAME DEFINITIONS    				   */
/*-----------------------------------------------------------------*/

#define OI_PRD_MEM_OBJECT_LIST  struct oi_prd_mem_object_list

#define OI_FD_FLOW_DESC         struct oi_fd_flow_desc
#define OI_FD_DESCRIPTION       struct oi_fd_description
#define OI_FD_OBJ_DESC          struct oi_fd_obj_desc
#define OI_FD_CON_DESC          struct oi_fd_con_desc

#define OI_ERD_DESCRIPTION       struct oi_erd_description
#define OI_ERD_OBJ_DESC          struct oi_erd_obj_desc
#define OI_ERD_CON_DESC          struct oi_erd_con_desc
/*P*/
#define OI_GRA_OBJ_DESC          struct oi_gra_obj_desc
#define OI_GRA_CON_DESC          struct oi_gra_con_desc
#define OI_SHEET_DESCRIPTION     struct oi_sheet_description
#define OI_MTX_BLOCK_DESC        struct oi_mtx_block_desc
#define OI_MTX_ROW_DESC          struct oi_mtx_row_desc
#define OI_MTX_COLUMN_DESC       struct oi_mtx_column_desc
#define OI_MTX_CELL_DESC         struct oi_mtx_cell_desc
#define OI_MTX_TOKEN_DESC        struct oi_mtx_token_desc


#define OI_DA_DESCRIPTION       struct oi_da_description
#define OI_DA_COMP_DESC         struct oi_da_comp_desc

#define OI_MSP_DESCRIPTION      struct oi_msp_description
#define OI_SA_ACTIVATION        struct oi_sa_activation
#define OI_IM_ACTIVATION	struct oi_im_activation

#define OI_TCB_EDGE  		struct oi_tcb_edge
#define OI_TCB_OBJ   		struct oi_tcb_obj
#define OI_TCB_PROP  		struct oi_tcb_prop

/* TSKD description blocks */
#define OI_TSKD_DESCRIPTION       struct oi_tskd_description
#define OI_TSKD_OBJ_DESC          struct oi_tskd_obj_desc
#define OI_TSKD_CON_DESC          struct oi_tskd_con_desc


# ifndef OI_HEADER	/* disabled by oi.h 	*/


/*-----------------------------------------------------------------*/
/*	 STRUCTURE DEFINITIONS    				   */
/*-----------------------------------------------------------------*/

OI_PRD_MEM_OBJECT_LIST
    {
    PRD_OBJ_SPEC     name;
    };

/*-------------------*/
/* MSP specific types */
/*-------------------*/


OI_MSP_DESCRIPTION
    {
    PRD_OBJ_SPEC         name;
    PRD_OBJ_LAYOUT_SPEC  name_rep;
    PRD_USER_SPEC        author;
    PRD_USER_SPEC        group;
    PRD_DATE_SPEC        creation_date;
    PRD_TIME_SPEC        creation_time;
    PRD_DATE_SPEC        update_date;
    PRD_TIME_SPEC        update_time;
    PRD_DATE_SPEC        analyse_date;
    PRD_TIME_SPEC        analyse_time;
    BYTE                 protection;
    BYTE                 state;
    };
/*P*/
/*-------------------*/
/* FD specific types */
/*-------------------*/

OI_FD_FLOW_DESC
    {
    PRD_OBJ_SPEC    name;
    };

OI_FD_OBJ_DESC
    {
          /* von der Anwendung vergebener Identifier; eindeutig pro Diagramm */
    ULONG                   obj_id;
    PRD_OBJ_SPEC            name;
    PRD_OBJ_SPEC            sec_name;
    BYTE                    obj_type;
                      /* OI_FD_NODE, OI_FD_STORE etc. */
    PRD_OBJ_LAYOUT_SPEC     name_rep;
    PRD_POS                 name_pos;
    PRD_OBJ_LAYOUT_SPEC     sec_name_rep;
    PRD_POS                 sec_name_pos;

    PRD_POS                 obj_pos;
    PRD_ICON_SIZE           size;
    BYTE                    icon_type;
    BYTE                    font;
    SHORT                   turn_pos;
    BYTE		    hist_flag;
    };
/*P*/

OI_FD_CON_DESC
    {
    ULONG                   con_id;
          /* von der Anwendung vergebener Identifier; eindeutig pro Diagramm */
    PRD_OBJ_SPEC            name;
    PRD_OBJ_SPEC            main_flow;
    BYTE                    con_type;
                    /*  df, cf */
    PRD_OBJ_SPEC            source_name;
    PRD_OBJ_SPEC            dest_name;
    ULONG                   src_id;
    ULONG                   dst_id;
    BYTE                    src_type;  /* z.B. OI_FD_NODE etc. */
    BYTE                    dst_type;

    PRD_OBJ_LAYOUT_SPEC     name_rep;
    PRD_POS                 name_pos;
    BYTE                    icon_type;
    BYTE                    font;
    SHORT                   coord_count;
    PRD_POS                 coord_list[ OI_FD_MAX_COORD];
    BYTE		    hist_flag;
    };


OI_FD_DESCRIPTION
    {
    PRD_OBJ_SPEC         name;
    PRD_OBJ_LAYOUT_SPEC  name_rep;
    PRD_USER_SPEC        author;
    PRD_USER_SPEC        group;
    PRD_DATE_SPEC        creation_date;
    PRD_TIME_SPEC        creation_time;
    PRD_DATE_SPEC        update_date;
    PRD_TIME_SPEC        update_time;
    PRD_DATE_SPEC        analyse_date;
    PRD_TIME_SPEC        analyse_time;
    BYTE                 protection;
    BYTE                 state;

    PRD_OBJ_LAYOUT_SPEC  complete_no;
    };



/*P*/
/*--------------------*/
/* ERD specific types */
/*--------------------*/

OI_ERD_OBJ_DESC
    {
    /* von der Anwendung vergebener Identifier;
     * eindeutig pro Diagramm */
    ULONG                  obj_id;
    BYTE                   obj_type;
                  /* OI_ERD_ENTITY_TYPE, OI_ERD_RELSHIP_TYPE etc. */
    PRD_OBJ_SPEC           name;
    PRD_OBJ_LAYOUT_SPEC    name_rep;
    PRD_POS                name_pos;
    PRD_OBJ_SPEC           sec_name;
    PRD_OBJ_LAYOUT_SPEC    sec_name_rep;
    PRD_POS                sec_name_pos;

    BYTE                   kind;
                  /*  z.B. normal-relship, isa-relship */
    PRD_POS                obj_pos;
    PRD_ICON_SIZE          size;
    BYTE                   icon_type;
    BYTE                   font;
    SHORT                  turn_pos; /* Winkelangabe in Grad */
    BYTE           	   hist_flag;
    };


OI_ERD_CON_DESC
    {
    /* von der Anwendung vergebener Identifier;
     * eindeutig pro Diagramm */
    ULONG                   con_id;
    PRD_OBJ_SPEC            source_name;
    PRD_OBJ_SPEC            dest_name;
    ULONG                   src_id;
    ULONG                   dst_id;
    BYTE                    src_type;  /* z.B. OI_ERD_ENTITY_TYPE etc. */
    BYTE                    dst_type;
    PRD_OBJ_LAYOUT_SPEC     role_name;
    PRD_POS                 role_pos;

    PRD_OBJ_LAYOUT_SPEC     card_name;
    PRD_POS                 card_pos;
    BYTE                    card_type;

    BYTE                    con_type; /* ERD_PARTIAL, ERD_TOTAL */
    BYTE                    generalisation; /* ERD_YES, ERD_NO */
    BYTE                    font;
    SHORT                   coord_count;
    PRD_POS                 coord_list[ OI_ERD_MAX_COORD];
    BYTE		    hist_flag;
    };
/*P*/

OI_ERD_DESCRIPTION
    {
    PRD_OBJ_SPEC            name;
    PRD_OBJ_LAYOUT_SPEC     name_rep;
    PRD_USER_SPEC           author;
    PRD_USER_SPEC           group;
    PRD_DATE_SPEC           creation_date;
    PRD_TIME_SPEC           creation_time;
    PRD_DATE_SPEC           update_date;
    PRD_TIME_SPEC           update_time;
    PRD_DATE_SPEC           analyse_date;
    PRD_TIME_SPEC           analyse_time;
    BYTE                    protection;
    BYTE                    state;
    BYTE                    erd_kind;
    };


/*--------------------------*/
/* SHEET specific definitions */
/*--------------------------*/
OI_GRA_OBJ_DESC
    {
    ULONG                   obj_id;
          /* von der Anwendung vergebener Identifier; eindeutig pro Diagramm */
    PRD_OBJ_SPEC            name;
    PRD_OBJ_SPEC            sec_name;
    BYTE                    obj_type;   /* state , free text ,..*/

    PRD_OBJ_LAYOUT_SPEC     name_rep;
    PRD_POS                 name_pos;

    PRD_OBJ_LAYOUT_SPEC     sec_name_rep;
    PRD_POS                 sec_name_pos;

    PRD_OBJ_LAYOUT_SPEC     value;
    PRD_POS                 obj_pos;
    PRD_ICON_SIZE           size;
    BYTE                    icon_type;
    BYTE                    font;
    SHORT                   turn_pos;
             /* Winkelangabe in Grad */
    ULONG                   con_id; /* wenn obj_type == event oder action */
    BYTE		    hist_flag;
    };
/*P*/

OI_GRA_CON_DESC
    {
    ULONG            con_id;
          /* von der Anwendung vergebener Identifier; eindeutig pro Diagramm */

    ULONG            src_id;
    ULONG            dst_id;
    BYTE             src_type;
    BYTE             dst_type;

    BYTE             font;
    SHORT            coord_count;
    PRD_POS          coord_list[ OI_STD_MAX_COORD];
    BYTE	     hist_flag;
    };


OI_SHEET_DESCRIPTION
    {
    PRD_USER_SPEC        author;
    PRD_USER_SPEC        group;
    PRD_DATE_SPEC        creation_date;
    PRD_TIME_SPEC        creation_time;
    PRD_DATE_SPEC        update_date;
    PRD_TIME_SPEC        update_time;
    PRD_DATE_SPEC        analyse_date;
    PRD_TIME_SPEC        analyse_time;
    LONG                 sheet_type; /* STD , TEXT_SHEET, ... */
    PRD_POS              mtx_pos;
    BYTE                 protection;
    BYTE                 state;
    };

OI_MTX_BLOCK_DESC
    {
    ULONG               block_no;
    PRD_OBJ_SPEC        name;	/* label */
    BYTE            	label_font;
    };

OI_MTX_ROW_DESC
    {
    ULONG            	row_no;
    SHORT               heigth;		/* height of the row */
    };

OI_MTX_COLUMN_DESC
    {
    ULONG            	block_no;
    ULONG            	column_no;	/* in the block */
    SHORT               width;		/* width of the column */
    };

OI_MTX_CELL_DESC
    {
    ULONG            	block_no;
    ULONG            	column_no;	/* in the block */
    ULONG            	row_no;
    BYTE            	font;		/* font of the cell */
    };

OI_MTX_TOKEN_DESC
    {
    ULONG            	block_no;
    ULONG            	column_no;	/* in the block */
    ULONG            	row_no;
    ULONG		token_no;
    ULONG            	type;	/* process, controlflow, text,activate_process.. */
    PRD_OBJ_LAYOUT_SPEC	item;
    PRD_OBJ_LAYOUT_SPEC related_value; /* contains a value when token is of
                                          type OI_SHEET_EVENT, OI_SHEET_ACTION_CF, ....*/

    };



/*P*/
/*-------------------------*/
/* DA specific definitions */
/*-------------------------*/

OI_DA_COMP_DESC
    {
    SHORT            comp_no;
    PRD_OBJ_SPEC     comp_name;
    BYTE             connection;   /* selection, sequence, synonym */
    BYTE             embedding;    /* option, iteration, no embedding */
    BYTE             attribute_flag; /* nonkey, key, no attribute */
    INT              upper_bound; /* only used in iterations */
    INT              lower_bound;
    BYTE	     comp_info;   /* primitive, hidden etc. */
    PRD_OBJ_LAYOUT_SPEC     short_comment;
    };

OI_DA_DESCRIPTION
    {
    PRD_OBJ_SPEC         name;
    PRD_OBJ_LAYOUT_SPEC  name_rep;
    BYTE                 kind;        /* defined, hidden, primitive, undefined
                                         hidden data names werden vom Tool
                                         kreiert und wieder aufgeloest
                                      */
    PRD_USER_SPEC        author;
    PRD_USER_SPEC        group;
    PRD_DATE_SPEC        creation_date;
    PRD_TIME_SPEC        creation_time;
    PRD_DATE_SPEC        update_date;
    PRD_TIME_SPEC        update_time;
    PRD_DATE_SPEC        analyse_date;
    PRD_TIME_SPEC        analyse_time;
    BYTE                 protection;
    BYTE                 state;
    SHORT                no_comp;
    SHORT                no_tline;   /* OUT: number of comment lines */
    };

OI_SA_ACTIVATION
    {
    ULONG status_info;
    ULONG node_checks;
    ULONG store_checks;
    ULONG terminator_checks;
    ULONG msp_checks;
    ULONG csp_checks;
    ULONG data_checks;
    ULONG fd_checks;
    ULONG ctrl_flow_checks;
    ULONG data_flow_checks;
    ULONG bar_checks;
    ULONG hierarchy_checks;
    };
/*P*/
OI_IM_ACTIVATION
    {
    ULONG status_info;
    ULONG saim_checks;
    ULONG erd_checks;
    ULONG dd_checks;
    };

OI_TCB_OBJ
    {
    PRD_OBJ_SPEC name1;		/* part of the object identification                */
    PRD_OBJ_SPEC name2;         /* part of the object identification (opt.)         */
    PRD_OBJ_SPEC name3;         /* part of the object identification (opt.)         */
    LONG         no;            /* part of the object identification (opt.)         */
    LONG         obj_type;      /* type of the object such as. "OI_TCB_FD",...      */
    LONG         id;            /* only for internal use at the moment              */
    };

OI_TCB_PROP
    {
    PRD_DATE_SPEC        creation_date;
    PRD_TIME_SPEC        creation_time;
    PRD_DATE_SPEC        update_date;
    PRD_TIME_SPEC        update_time;
    PRD_DATE_SPEC        analyse_date;
    PRD_TIME_SPEC        analyse_time;
    PRD_USER_SPEC        author;
    PRD_OBJ_LAYOUT_SPEC  short_comment;
    SHORT                kind;
    BYTE                 src_prop;         /* partial, total, don't care              */
    BYTE                 dst_prop;         /* partial, total, don't care              */
    };

OI_TCB_EDGE
    {
    OI_TCB_OBJ	src; 		/* identification of the source object                */
    OI_TCB_OBJ  dst;    	/* identification of the destination object           */
    OI_TCB_PROP prop;  	 	/* attribute values of the edge                       */
    LONG        edge_type;      /* identification of the edge type                    */
    };

OI_TSKD_DESCRIPTION
    {
    PRD_OBJ_SPEC	 obj_name;
    BYTE 		 obj_type;
    PRD_OBJ_SPEC         name;
    PRD_OBJ_LAYOUT_SPEC  name_rep;
    PRD_USER_SPEC        author;
    PRD_USER_SPEC        group;
    PRD_DATE_SPEC        creation_date;
    PRD_TIME_SPEC        creation_time;
    PRD_DATE_SPEC        update_date;
    PRD_TIME_SPEC        update_time;
    PRD_DATE_SPEC        analyse_date;
    PRD_TIME_SPEC        analyse_time;
    BYTE                 protection;
    BYTE                 state;
    };


OI_TSKD_OBJ_DESC
    {
    		/* von der Anwendung vergebener Identifier; eindeutig pro Diagramm */
    ULONG                    obj_id;
    	  	/* OI_TSKD_TASK or OI_TSKD_EVENT etc. */
    BYTE                    obj_type;
		/* for Activation Points; references the message that
		   aims the act point, an act point can be referenced by more than one message */
    ULONG		    con_id;

    PRD_OBJ_SPEC            name;
    PRD_OBJ_LAYOUT_SPEC     name_rep;
    PRD_POS                 name_pos;

		/* graphic representation */
    PRD_POS                 obj_pos;
    PRD_ICON_SIZE           size;
    BYTE                    icon_type;
    BYTE                    font;
    SHORT                   turn_pos;

    BYTE		    hist_flag;
    };

OI_TSKD_CON_DESC
    {
    ULONG                    con_id;
          /* von der Anwendung vergebener Identifier; eindeutig pro Diagramm */
    PRD_OBJ_SPEC            name;
    PRD_OBJ_LAYOUT_SPEC     name_rep;
    PRD_POS                 name_pos;

    ULONG                    source_id;
    BYTE                    source_type;  /* z.B. OI_TSKD_TASK etc. */
    PRD_OBJ_SPEC            source_name;

    ULONG                    dest_id;
    BYTE                    dest_type;
    PRD_OBJ_SPEC            dest_name;

    PRD_OBJ_SPEC            main_flow;
    BYTE                    icon_type;
    BYTE                    font;
    SHORT                   coord_count;
    PRD_POS                 coord_list[ OI_TSKD_MAX_COORD];

    BYTE		    hist_flag;
    };

# endif		/* OI_HEADER	*/
