#ifdef __REQUIRED__

promdef.h
prd_00types.h

#endif

# if 0
VERS____( oi_060general.h - basic OI types, Bre/Mrt/Mt/MB/Sei/Wey, 93/12/08)
# endif

/******************************************************************************
:++
:HEADER_FILE 		oi_060general.h

:PURPOSE

Definition of OI specific Constants and Structures

:AUTHOR

Bre/Mrt/Mt/MB/Sei, 91/07/03
Wey,               93/04/19

:END
:--
******************************************************************************/
/*P*/
/*-----------------------------------------------------------------*/
/*	 CONSTANT DEFINITIONS		  			   */
/*-----------------------------------------------------------------*/

/* general constants for OI functions */

#define OI_E_ERRINERR                       0x00000001L
#define OI_E_BADCMD                         0x00000002L
#define OI_E_DEMO_EXC                       0x00000004L
#define OI_E_LOCKED                         0x00000008L

#define OI_MEMORY_MODE                      0x001
#define OI_FILE_MODE                        0x002
#define OI_TEXT_LENGTH                      240
#define OI_MAX_CHANNELS                     10

/* states of a handle */

#define OI_HDL_OPENED                       0x01
#define OI_HDL_CLOSED                       0x02

/* library specific return values */

#define OI_LIB_NOT_COMPATIBLE               0x100
#define OI_LIB_NOT_FOUND                    0x101
#define OI_LIB_MISSING_FILENAME             0x102
#define OI_LIB_WRONG_PASSWORD               0x103
#define OI_LIB_WRONG_USERNAME               0x104
#define OI_LIB_WRONG_PROJECT_NAME           0x105

/* general return codes for OI functions */

#define OI_PRD_FAILURE                      0x000
#define OI_PRD_SUCCESS                      0x001
#define OI_PRD_SERVER_NOT_AVAILABLE         0x002
#define OI_PRD_INVALID_PROJ_NAME_SPEC       0x003
#define OI_PRD_NOT_ENOUGH_MEMORY            0x004
#define OI_PRD_NO_ROOT			    0x005
#define OI_PRD_MULTIPLE_ROOT                0x006

#define OI_PRD_OBJECT_ALREADY_EXISTS        0x020
#define OI_PRD_OBJECT_NOT_EXISTS            0x021
#define OI_PRD_OBJECT_NOT_DEFINED           0x022
#define OI_PRD_INVALID_OBJECT               0x023

#define OI_PRD_CAN_NOT_OPEN_FILE            0x030

#define OI_PRD_NAME_ALREADY_IN_USE          0x040
#define OI_PRD_OBJ_LOCKED                   0x041
#define OI_PRD_AUTO_REN			    0x042

#define OI_PRD_NOT_YET_IMPLEMENTED          0x050

/* general constants for Analyzer */
#define OI_STATUS_MESSAGES              0x00000001L

/* general constants */

#define OI_EMPTY_OBJECT                     0x00
#define OI_OBJECT_DEFINED                   0x01
#define OI_UNDEF_MODE                       0x00
#define OI_GET_MODE                         0x02
#define OI_STORE_MODE                       0x03

#define OI_SEPARATOR_CHAR                   '!'
#define OI_MAX_COORD			    50
/*P*/
/* PROMOD OBJECT TYPES */

#define OI_PRD_FD			0x00000001L
#define OI_PRD_MSP			0x00000002L
#define OI_PRD_DATA			0x00000004L
#define OI_PRD_ERD			0x00000008L
#define OI_PRD_STD			0x00000010L
#define OI_PRD_SUB			0x00000020L
#define OI_PRD_MOD			0x00000040L
#define OI_PRD_OPER			0x00000080L
#define OI_PRD_MD_OBJ			0x00000100L
#define OI_PRD_ANNO			0x00000200L


#define OI_TXT_ELEM  struct oi_txt_elem
#define OI_TXT_COMP  struct oi_txt_comp

# ifndef OI_HEADER	/* disabled by oi.h 	*/

# ifndef RPC_XDR	/* don't generate conversion routines		*/

OI_TXT_COMP
    {
    LONG	comp_type;
    TEXT	*comp_name;
    };


OI_TXT_ELEM
    {
    LONG	elem_type;
    INT		no_comp;
    OI_TXT_COMP *comp;
    };

# endif /* RPC_XDR */

# endif		/* OI_HEADER	*/

/* general constants for text elements
** note !!!! this constants must range from 0..50 because special constants
** like msp- or csp-constants start with 51..
*/

/* Constants for elem_type */
#define OI_TXT_TEXT			0x00
#define OI_TXT_FORM_ON			0x01
#define OI_TXT_FORM_OF			0x02
#define OI_TXT_PAR			0x03
#define OI_TXT_INREF			0x04
#define OI_TXT_OUTREF			0x05
#define OI_TXT_INOUT			0x06
#define OI_TXT_ACTIVATE			0x07
#define OI_TXT_DEACTIVATE		0x08
#define OI_TXT_CALL			0x09
/*P*/
/* Constants for comp_type */
#define OI_TXT_DA			0x01
#define OI_TXT_SUB			0x02
#define OI_TXT_MO			0x03
#define OI_TXT_COMPON			0x04
#define OI_TXT_FORM			0x05
#define OI_TXT_FU			0x06

/* FREE TEXT  specific constants */

#define OI_TEXT                           0x64


/* HISTORY flags  */

#define  OI_HIST_INS			1
#define  OI_HIST_DEL			2
#define  OI_HIST_UPD			3

/* GRAFIC MODEs */

#define OI_SMOOTHED_MODE                0
#define OI_UNSMOOTHED_MODE              1

/*************************************/
/*  literals for ProMod-DEMO version */
/*************************************/

# define OI_DEMO_MAX_MASK   0x000000FFL

# define OI_DEMO_SUB	    0x00000105L
# define OI_DEMO_MO	    0x0000020AL
# define OI_DEMO_FU	    0x00000414L
# define OI_DEMO_BT	    0x00000805L

# define OI_DEMO_FD	    0x00001005L
# define OI_DEMO_CSP        0x00002005L
# define OI_DEMO_SHEET      0x00004005L
# define OI_DEMO_MSP	    0x00008014L
# define OI_DEMO_ERD	    0x00010002L
# define OI_DEMO_DATA	    0x00020028L

# define OI_DEMO_TSK        0x00040001L
# define OI_DEMO_TSK_T      0x00100005L
# define OI_DEMO_TSK_E      0x00200005L
# define OI_DEMO_TSK_M      0x00400014L
# define OI_DEMO_TSK_A      0x00800005L
