#ifdef __REQUIRED__

promdef.h
prd_00types.h
oi_060general.h

#endif

# if 0
VERS____( oi_509md_types.h - basic MD-OI types and constants, Bre, 91/02/21)
# endif

/******************************************************************************
:++
:
HEADER_FILE 		oi_509md_types.h

:PURPOSE

Definition of MD specific Constants and Structures

:AUTHOR

Bre 91/02/21

:END
:--
******************************************************************************/

/*
//    Trace Switches - for oi_md_trace
*/
# define OI_T_SUB_CSQL		0x00000010L
# define OI_T_MOD_CSQL		0x00000020L
# define OI_T_OPER_CSQL		0x00000040L
# define OI_T_BT_CSQL		0x00000080L
# define OI_T_MD_CSQL		0x00000100L
# define OI_T_SUB_CHART		0x00000200L
# define OI_T_MOD_CHART		0x00000400L
# define OI_T_MD_ANA_CSQL	0x00000800L
# define OI_T_HISTORY		0x00001000L
# define OI_T_MD_DATA		0x00002000L
# define OI_T_MD_CONST		0x00004000L
# define OI_T_MD_TYPE		0x00008000L
# define OI_T_MD_REF		0x00010000L
# define OI_T_IMP_FU		0x00020000L
# define OI_T_MD_CHAIN		0x00040000L
# define OI_T_TXT_GRA_PAR	0x00080000L

# define OI_TRUNC_NAME(name) if( strlen( name) >40) name[ 40] = '\0'

#define ADAPT_OBJ 1
#define ADAPT_CON 2

/*P*/
/******************************************************************************
			MD_OBJ specific Part
******************************************************************************/

/*
//	MD_OBJ specific Constants
*/

/*
//	Constants for type_component_embedding
//	and type_component_connection
*/

# define OI_MD_SEQUENCE			0x01
# define OI_MD_BEGIN_SELECTION		0x02
# define OI_MD_IN_SELECTION		0x03
# define OI_MD_END_SELECTION		0x04
# define OI_MD_ITERATION		0x05
# define OI_MD_SELECTION		0x06
# define OI_MD_TYPE_POINTER		0x07
# define OI_MD_OPERATION_POINTER	0x08
# define OI_MD_OPTION			0x09
# define OI_MD_BEGIN_ENUM		0x0A
# define OI_MD_IN_ENUM			0x0B
# define OI_MD_END_ENUM			0x0C
# define OI_MD_BEGIN_UNION		0x0D
# define OI_MD_IN_UNION			0x0E
# define OI_MD_END_UNION		0x0F

/*P*/
/*
//	Constants for references
*/
# define OI_MD_WITH_REF			0
# define OI_MD_WITHOUT_REF		1
# define OI_MD_CHART_ONLY		2

/*
//	Constants for is_defined
*/
# define OI_MD_NOT_DEFINED		0
# define OI_MD_HEADER_DEFINED		1
# define OI_MD_CHART_DEFINED		2
# define OI_MD_TEXT_DEFINED		4

/*
//	Constants for change type
*/
# define OI_MD_RENAME			1
# define OI_MD_DELETE			2

/*
//	Constants for local_use_hierarchy representation
*/
# define OI_MD_PRINTER_REP			1
# define OI_MD_EDITOR_REP			2

/*
//	Constants for marking system objects
*/
# define OI_MD_OBJECT			0
# define OI_MD_SYSTEM_OBJECT		1

/*
//	Constants for para_kind
*/
# define OI_MD_IN_PARA			0x01
# define OI_MD_OUT_PARA			0x02
# define OI_MD_IN_OUT_PARA		0x03

/*
//	Constants for md_scope
*/
# define OI_MD_EXPORT			0x01
# define OI_MD_INTERNAL			0x02
# define OI_MD_IMPORT			0x03
# define OI_MD_INHERIT			0x04

/*
//	Constants for subobj_type and obj_type
*/
# define OI_MD_OPERATION_OBJ		0x01
# define OI_MD_TYPE_OBJ			0x02
# define OI_MD_CONST_OBJ		0x03
# define OI_MD_DATA_OBJ			0x04
# define OI_MD_SUB_OBJ			0x05
# define OI_MD_MO_OBJ			0x06

/*
//	Constants for ref_type
*/
# define OI_MD_SUB_REF			0x01
# define OI_MD_MOD_REF			0x02
# define OI_MD_OPER_REF			0x03
# define OI_MD_CONST_REF		0x04
# define OI_MD_TYPE_REF			0x05
# define OI_MD_DATA_REF			0x06
# define OI_MD_PARA_REF			0x07

/*
//	Constants for loc_type
*/
# define OI_MD_LOC_PUR			0x01
# define OI_MD_LOC_PARA			0x02
# define OI_MD_LOC_PC			0x03
# define OI_MD_LOC_DA			0x04
# define OI_MD_LOC_CO			0x05
# define OI_MD_LOC_TY			0x06
# define OI_MD_LOC_IMP_FU		0x07
# define OI_MD_LOC_IMP_LIST		0x08

/*
//	Constants for ren_type
*/
# define OI_MD_SUB_REN			0x01
# define OI_MD_MOD_REN			0x02
# define OI_MD_OPER_REN			0x03

/*
//	Literals for MD_OBJ specific Structures
*/
# define OI_MD_OBJ_COUNTER		struct oi_md_obj_counter
# define OI_MD_REFERENCE		struct oi_md_reference
# define OI_MD_TYPE_DEFINITION		struct oi_md_type_definition
# define OI_MD_TYPE_COMPONENT		struct oi_md_type_component
# define OI_MD_CONST_DEFINITION		struct oi_md_const_definition
# define OI_MD_DATA_DEFINITION		struct oi_md_data_definition
# define OI_MD_OPER_EXT_REFERENCE	struct oi_md_oper_ext_reference
# define OI_MD_OPER_PARAMETER		struct oi_md_oper_parameter
# define OI_MD_SUBOBJ_PURPOSE		struct oi_md_subobj_purpose
# define OI_MD_HISTORY			struct oi_md_history


/*P*/
/*
//	MD_OBJ specific Structures
*/

# ifndef OI_HEADER	/* disabled by oi.h 	*/

OI_MD_OBJ_COUNTER
    {
    INT			ref;
    INT			oper_ref;
    INT			oper_para;
    INT			type_def;
    INT			type_comp;
    INT			cons;
    INT			data;
    INT			purpose;
    INT			subobj_purpose;
    INT			md_history;
    };


OI_MD_REFERENCE
    {
    PRD_OBJ_SPEC	sub_name;
    PRD_OBJ_SPEC	mod_name;
    PRD_OBJ_SPEC	obj_name;
    BYTE		md_scope;
    BYTE		ref_type;
    SHORT		no;
    };

OI_MD_OPER_EXT_REFERENCE
    {
    PRD_OBJ_SPEC	sub_name;
    PRD_OBJ_SPEC	mod_name;
    PRD_OBJ_SPEC	oper_name;
    SHORT		no;
    BYTE		md_scope;
    PRD_OBJ_SPEC	return_type;
    };

OI_MD_OPER_PARAMETER
    {
    PRD_OBJ_SPEC	sub_name;
    PRD_OBJ_SPEC	mod_name;
    PRD_OBJ_SPEC	oper_name;
    SHORT		no;
    PRD_OBJ_SPEC	para_name;
    PRD_OBJ_SPEC	para_type;
    BYTE		para_kind;
    };

/*P*/
OI_MD_TYPE_DEFINITION
    {
    PRD_OBJ_SPEC	type_name;
    SHORT		no;
    BYTE		md_scope;
    };

OI_MD_TYPE_COMPONENT
    {
    PRD_OBJ_SPEC	type_name;
    SHORT		component_no;
    PRD_OBJ_SPEC	component_name;
    BYTE		component_embedding;
    BYTE		component_connection;
    LONG		component_upper_bound;
    LONG		component_lower_bound;
    PRD_OBJ_SPEC	component_selector;
    PRD_OBJ_LAYOUT_SPEC	component_short_comment;
    };

OI_MD_CONST_DEFINITION
    {
    PRD_OBJ_SPEC	const_name;
    SHORT		no;
    BYTE		md_scope;
    PRD_OBJ_SPEC	const_type;
    PRD_OBJ_LAYOUT_SPEC	const_value;
    };

OI_MD_DATA_DEFINITION
    {
    PRD_OBJ_SPEC	data_name;
    SHORT		no;
    BYTE		md_scope;
    PRD_OBJ_SPEC	data_type;
    };


OI_MD_SUBOBJ_PURPOSE
    {
    BYTE		subobj_type;
    PRD_OBJ_SPEC	subobj_name;
    SHORT		line_no;
    PRD_OBJ_LAYOUT_SPEC	line_text;
    };


OI_MD_HISTORY
    {
    BYTE		obj_type;
    BYTE		change;
    BYTE		reference;
    PRD_OBJ_SPEC	old_sub;
    PRD_OBJ_SPEC	new_sub;
    PRD_OBJ_SPEC	old_mo;
    PRD_OBJ_SPEC	new_mo;
    PRD_OBJ_SPEC	old_fu;
    PRD_OBJ_SPEC	new_fu;
    };

# endif		/* OI_HEADER	*/

/*P*/
/******************************************************************************
			SUB specific Part
******************************************************************************/

/*
//	SUB specific Constants
*/

/*
//	Constants for sub_part
*/
# define OI_SUB_PART_CHART	0x01
# define OI_SUB_PART_PUR	0x02
# define OI_SUB_PART_EXP	0x04
# define OI_SUB_PART_IMP	0x08
# define OI_SUB_PART_INT	0x10
# define OI_SUB_PART_ANNO	0x20
# define OI_SUB_PART_TEXT	( OI_SUB_PART_PUR   | OI_SUB_PART_EXP \
                                | OI_SUB_PART_IMP   | OI_SUB_PART_INT )
# define OI_SUB_PART_ALL	( OI_SUB_PART_CHART | OI_SUB_PART_TEXT )

/*
//	Constants for obj_type
*/
# define OI_SUB_INT_SUB		0x01
# define OI_SUB_IMP_SUB		0x02
# define OI_SUB_INT_MOD		0x03
# define OI_SUB_IMP_MOD		0x04
# define OI_SUB_EXP_MOD		0x05

/*
//	Constants for global_op
*/
# define OI_SUB_OBJ_RENAME	0x01
# define OI_SUB_OBJ_DELETE	0x02
# define OI_SUB_OBJ_HIDE	0x04
# define OI_SUB_OBJ_CHANGE_TYPE	0x10
# define OI_SUB_OBJ_ALTER	0x20

/*
//	Literals for SUB specific Structures
*/
# define OI_SUB_COUNTER			struct oi_sub_counter
# define OI_SUB_DESCRIPTION		struct oi_sub_description
# define OI_SUB_CHART_OBJECT		struct oi_sub_chart_object
# define OI_SUB_CHART_CONNECTION	struct oi_sub_chart_connection


/*P*/
/*
//
//	SUB specific Structures
//
*/
# ifndef OI_HEADER	/* disabled by oi.h 	*/

OI_SUB_COUNTER
    {
    INT			no_obj;
    INT			no_con;
    INT			ref;
    INT			oper_ref;
    INT			oper_para;
    INT			type_def;
    INT			type_comp;
    INT			cons;
    INT			data;
    INT			purpose;
    INT			subobj_purpose;
    };

OI_SUB_DESCRIPTION
    {
    PRD_OBJ_SPEC		sub_name;
    PRD_OBJ_LAYOUT_SPEC		sub_name_rep;
    PRD_USER_SPEC		author;
    PRD_DATE_SPEC		creation_date;
    PRD_TIME_SPEC		creation_time;
    PRD_DATE_SPEC		update_date;
    PRD_TIME_SPEC		update_time;
    PRD_DATE_SPEC		analyse_date;
    PRD_TIME_SPEC		analyse_time;
    BYTE			protection;
    BYTE			state;
    BYTE			system_flag;
    PRD_OBJ_LAYOUT_SPEC		complete_no;
    };

/*P*/
OI_SUB_CHART_OBJECT
    {
    ULONG			obj_id;
    PRD_OBJ_SPEC		obj_name;
    BYTE			obj_type;
    PRD_OBJ_LAYOUT_SPEC		obj_name_rep;
    PRD_POS			obj_name_pos;
    PRD_OBJ_SPEC		sub_name;
    PRD_OBJ_LAYOUT_SPEC		sub_name_rep;
    PRD_POS			sub_name_pos;
    BYTE			global_op;
    PRD_OBJ_SPEC		old_sub;
    PRD_OBJ_SPEC		old_mo;
    PRD_POS			obj_pos;
    PRD_ICON_SIZE		obj_size;
    BYTE			obj_icon_type;
    BYTE			obj_font;
    SHORT			obj_turn_pos;
    };

OI_SUB_CHART_CONNECTION
    {
    ULONG			con_id;
    ULONG			src_obj_id;
    PRD_OBJ_SPEC		src_obj_name;
    BYTE			src_obj_type;
    ULONG			des_obj_id;
    PRD_OBJ_SPEC		des_obj_name;
    PRD_OBJ_SPEC		des_sub_name;
    BYTE			des_obj_type;
    BYTE			global_op;
    PRD_OBJ_SPEC		main_flow;
    BYTE			con_icon_type;
    BYTE			con_font;
    SHORT			coord_count;
    PRD_POS			coord_list[ OI_MAX_COORD];
    };
# endif		/* OI_HEADER	*/

/*P*/
/******************************************************************************
			MOD specific Part
******************************************************************************/
/*
//
//	MOD specific Constants
//
*/

/*
//	Constants for mod_part
*/
# define OI_MOD_PART_CHART	0x01
# define OI_MOD_PART_PUR	0x02
# define OI_MOD_PART_EXP	0x04
# define OI_MOD_PART_IMP	0x08
# define OI_MOD_PART_INT	0x10
# define OI_MOD_PART_ANNO	0x20
# define OI_MOD_PART_TEXT	( OI_MOD_PART_PUR   | OI_MOD_PART_EXP \
                                | OI_MOD_PART_IMP   | OI_MOD_PART_INT )
# define OI_MOD_PART_ALL	( OI_MOD_PART_CHART | OI_MOD_PART_TEXT )

/*
// 	Constants for obj_type
*/
# define OI_MOD_EXP_OPER	0x01
# define OI_MOD_IMP_OPER	0x02
# define OI_MOD_INT_OPER	0x03

/*
//	Constants for global_op
*/
# define OI_MOD_OBJ_RENAME	0x01
# define OI_MOD_OBJ_DELETE	0x02
# define OI_MOD_OBJ_HIDE	0x04
# define OI_MOD_OBJ_CHANGE_TYPE	0x10
# define OI_MOD_OBJ_ALTER	0x20

/*
//	Literals for MOD specific Structures
*/
# define OI_MOD_COUNTER			struct oi_mod_counter
# define OI_MOD_DESCRIPTION		struct oi_mod_description
# define OI_MOD_CHART_OBJECT		struct oi_mod_chart_object
# define OI_MOD_CHART_CONNECTION	struct oi_mod_chart_connection
# define OI_MOD_CHART_PARAMETER		struct oi_mod_chart_parameter

/*
//
//	MOD specific Structures
//
*/
# ifndef OI_HEADER	/* disabled by oi.h 	*/
OI_MOD_COUNTER
    {
    INT			no_obj;
    INT			no_con;
    INT			no_para;
    INT			ref;
    INT			oper_ref;
    INT			oper_para;
    INT			type_def;
    INT			type_comp;
    INT			cons;
    INT			data;
    INT			purpose;
    INT			subobj_purpose;
    };

OI_MOD_DESCRIPTION
    {
    PRD_OBJ_SPEC		mod_name;
    PRD_OBJ_LAYOUT_SPEC		mod_name_rep;
    BYTE			mod_scope;
    PRD_USER_SPEC		author;
    PRD_DATE_SPEC		creation_date;
    PRD_TIME_SPEC		creation_time;
    PRD_DATE_SPEC		update_date;
    PRD_TIME_SPEC		update_time;
    PRD_DATE_SPEC		analyse_date;
    PRD_TIME_SPEC		analyse_time;
    BYTE			protection;
    BYTE			state;
    BYTE			system_flag;
    PRD_OBJ_LAYOUT_SPEC		complete_no;
    };

/*P*/
OI_MOD_CHART_OBJECT
    {
    ULONG			obj_id;
    PRD_OBJ_SPEC		obj_name;
    BYTE			obj_type;
    PRD_OBJ_LAYOUT_SPEC		obj_name_rep;
    PRD_POS			obj_name_pos;
    PRD_OBJ_SPEC		sub_name;
    PRD_OBJ_LAYOUT_SPEC		sub_name_rep;
    PRD_OBJ_SPEC		mo_name;
    PRD_OBJ_LAYOUT_SPEC		mo_name_rep;
    PRD_POS			sec_pos;
    BYTE			global_op;
    PRD_OBJ_SPEC		old_sub;
    PRD_OBJ_SPEC		old_mo;
    PRD_OBJ_SPEC		old_fu;
    PRD_POS			obj_pos;
    PRD_ICON_SIZE		obj_size;
    BYTE			obj_icon_type;
    BYTE			obj_font;
    SHORT			obj_turn_pos;
    };

OI_MOD_CHART_CONNECTION
    {
    ULONG			con_id;
    ULONG			src_obj_id;
    PRD_OBJ_SPEC		src_obj_name;
    BYTE			src_obj_type;
    ULONG			des_obj_id;
    PRD_OBJ_SPEC		des_obj_name;
    PRD_OBJ_SPEC		des_sub_name;
    PRD_OBJ_SPEC		des_mo_name;
    BYTE			des_obj_type;
    BYTE			global_op;
    PRD_OBJ_SPEC		main_flow;
    BYTE			con_icon_type;
    BYTE			con_font;
    SHORT			coord_count;
    PRD_POS			coord_list[ OI_MAX_COORD];
    };

OI_MOD_CHART_PARAMETER
    {
    ULONG			para_id;
    PRD_OBJ_SPEC		para_name;
    BYTE			para_type;
    ULONG			con_id;
    PRD_OBJ_LAYOUT_SPEC		para_name_rep;
    BYTE			global_op;
    PRD_OBJ_SPEC		old_name;
    PRD_POS			para_pos;
    BYTE			para_font;
    };

# endif		/* OI_HEADER	*/

/*P*/
/******************************************************************************
			OPER specific Part
******************************************************************************/

/*
//
//	OPER specific Constants
//
*/

/*
//	Constants for oper_part
*/
# define OI_OPER_PART_PUR	0x01
# define OI_OPER_PART_PAR	0x02
# define OI_OPER_PART_INT	0x04
# define OI_OPER_PART_ANNO	0x08
# define OI_OPER_PART_TEXT	( OI_OPER_PART_PUR   | OI_OPER_PART_PAR \
                                | OI_OPER_PART_INT )
# define OI_OPER_PART_ALL	( OI_OPER_PART_TEXT )

/*
//	Literals for OPER specific Structures
*/
# define OI_OPER_COUNTER		struct oi_oper_counter
# define OI_OPER_DESCRIPTION		struct oi_oper_description

/*
//
//	OPER specific Structures
//
*/

# ifndef OI_HEADER	/* disabled by oi.h 	*/
OI_OPER_COUNTER
    {
    INT			pc_state;
    INT			ref;
    INT			oper_ref;
    INT			oper_para;
    INT			type_def;
    INT			type_comp;
    INT			cons;
    INT			data;
    INT			purpose;
    INT			subobj_purpose;
    };

OI_OPER_DESCRIPTION
    {
    PRD_OBJ_SPEC		oper_name;
    PRD_OBJ_LAYOUT_SPEC		oper_name_rep;
    BYTE			oper_scope;
    PRD_USER_SPEC		author;
    PRD_DATE_SPEC		creation_date;
    PRD_TIME_SPEC		creation_time;
    PRD_DATE_SPEC		update_date;
    PRD_TIME_SPEC		update_time;
    PRD_DATE_SPEC		analyse_date;
    PRD_TIME_SPEC		analyse_time;
    PRD_OBJ_SPEC		return_type;
    SHORT			no;
    BYTE			protection;
    BYTE			state;
    BYTE			system_flag;
    PRD_OBJ_LAYOUT_SPEC		complete_no;
    };

# endif		/* OI_HEADER	*/


/*P*/
/******************************************************************************
			Basic Types specific Part
******************************************************************************/

/*
//	Constants for Table Id
*/
# define OI_BT_MD_TABLE		1

/*
//	Constants for Translation Language
*/
# define OI_C_TRANS		0x01
# define OI_F_TRANS		0x02

/*
//	Literals for BT specific Structures
*/
# define OI_BT_DESC		struct oi_bt_desc


/*
//	BT specific Structures
*/

# ifndef OI_HEADER	/* disabled by oi.h 	*/

OI_BT_DESC
    {
    PRD_OBJ_SPEC	bt_name;
    PRD_OBJ_SPEC	c_name;
    PRD_OBJ_SPEC	f_name;
    };

# endif		/* OI_HEADER	*/


/*P*/
/******************************************************************************
			MD Analyser specific Part
******************************************************************************/

/*
//
//	Masks for the MD Analyser Rules
//
*/

/*
//	Masks for Data Rules
*/
# define OI_MD_DATA_TYPE_SPECIFIED	0x00000001L	/* Rule 1.1 */
# define OI_MD_DATA_TYPE_EXISTS		0x00000002L	/* Rule 1.2 */

/*
//	Masks for Constant Rules
*/
# define OI_MD_CONST_TYPE_SPECIFIED	0x00000001L	/* Rule 2.1 */
# define OI_MD_CONST_TYPE_EXISTS	0x00000002L	/* Rule 2.2 */
# define OI_MD_CONST_VALUE_SPECIFIED	0x00000004L	/* Rule 2.3 */

/*
//	Masks for Type Rules
*/
# define OI_MD_TYPE_SPECIFIED		0x00000001L	/* Rule 3.1 */
# define OI_MD_TYPE_USED_TYPES_EXISTS	0x00000002L	/* Rule 3.2 */
# define OI_MD_TYPE_RECURSION		0x00000004L	/* Rule 3.3 */
# define OI_MD_TYPE_BT_CONFLICT		0x00000008L     /* Rule 3.4 */

/*
//	Masks for Function Prototype Rules
*/
# define OI_MD_FU_PRO_TYPE_SPECIFIED	0x00000001L	/* Rule 4.1 */
# define OI_MD_FU_PRO_TYPE_EXISTS	0x00000002L	/* Rule 4.2 */
# define OI_MD_FU_PRO_RETURN_EXISTS	0x00000004L	/* Rule 4.3 */

/*
//	Masks for Function Rules
*/
# define OI_MD_FU_PUR_REF_EXISTS	0x00000001L	/* Rule 5.1 */
# define OI_MD_FU_PC_REF_EXISTS		0x00000002L	/* Rule 5.2 */
# define OI_MD_FU_CALL_PAR_OK		0x00000004L	/* Rule 5.3 */
# define OI_MD_FU_PAR_USED		0x00000008L	/* Rule 5.4 */
# define OI_MD_FU_INT_USED		0x00000010L	/* Rule 5.5 */
# define OI_MD_FU_PC_CALL_EXISTS        0x00000020L     /* Rule 5.6 */

/*P*/
/*
//	Masks for Import Interface Rules
*/
# define OI_MD_IMP_EXISTS		0x00000001L	/* Rule 6.1 */
# define OI_MD_IMP_USED			0x00000002L	/* Rule 6.2 */
# define OI_MD_IMP_PAR_OK		0x00000004L	/* Rule 6.3 */

/*
//	Masks for Module Interna Rules
*/
# define OI_MD_MO_INT_USED		0x00000001L	/* Rule 7.1 */

/*
//	Masks for Module Export Interface Rules
*/
# define OI_MD_MO_EXP_USED		0x00000001L	/* Rule 8.1 */

/*
//	Masks for Module Rules
*/
# define OI_MD_MO_PUR_REF_EXISTS	0x00000001L	/* Rule 9.1 */
# define OI_MD_MO_CHART_OK		0x00000002L	/* Rule 9.2 */

/*
//	Masks for Subsystem Interna Rules
*/
# define OI_MD_SUB_INT_USED		0x00000001L	/* Rule 10.1 */
# define OI_MD_SUB_INT_MO_EXISTS	0x00000002L	/* Rule 10.2 */

/*
//	Masks for Subsystem Export Interface Rules
*/
# define OI_MD_SUB_EXP_MO_EXISTS	0x00000001L	/* Rule 11.1 */
# define OI_MD_SUB_EXP_USED		0x00000002L	/* Rule 11.2 */
# define OI_MD_SUB_EXP_SUB_EXISTS	0x00000004L	/* Rule 11.3 */

/*
//	Masks for Subsystem Rules
*/
# define OI_MD_SUB_PUR_REF_EXISTS	0x00000001L	/* Rule 12.1 */
# define OI_MD_SUB_CHART_OK		0x00000002L	/* Rule 12.2 */
# define OI_MD_SUB_MUL_PARENT		0x00000004L     /* Rule 12.3 */

/*
//	Masks for Global Structures Rules
*/
# define OI_MD_GLO_INCL_HIER		0x00000001L	/* Rule 13.1 */
# define OI_MD_GLO_TYPE_TREE		0x00000002L	/* Rule 13.2 */
# define OI_MD_GLO_CALL_TREE		0x00000004L	/* Rule 13.3 */
# define OI_MD_GLO_USE_HIER		0x00000008L	/* Rule 13.4 */

/*
//	Masks for Task Enhancements Rules
*/
# define OI_MD_ANA_RULE_14_1		0x00000010L	/* Rule 14.1 */
# define OI_MD_ANA_RULE_14_2		0x00000020L	/* Rule 14.2 */
# define OI_MD_ANA_RULE_14_3		0x00000010L	/* Rule 14.3 */
# define OI_MD_ANA_RULE_14_4		0x00000020L	/* Rule 14.4 */
# define OI_MD_ANA_RULE_14_5		0x00000040L	/* Rule 14.5 */

/*P*/
/*
//	Literals for Analyser specific Structures
*/
# define OI_MD_ACTIVATION	struct oi_md_activation

/*
//	Analyser specific Structures
*/

# ifndef OI_HEADER	/* disabled by oi.h 	*/

OI_MD_ACTIVATION
    {
    ULONG	status_info;
    ULONG	data_rules;
    ULONG	const_rules;
    ULONG	type_rules;
    ULONG	fu_pro_rules;
    ULONG	fu_rules;
    ULONG	imp_rules;
    ULONG	mo_int_rules;
    ULONG	mo_exp_rules;
    ULONG	mo_rules;
    ULONG	sub_int_rules;
    ULONG	sub_exp_rules;
    ULONG	sub_rules;
    ULONG	glob_struct_rules;
    };

# ifndef RPC_XDR	/* don't generate conversion routine		*/
/*
//	Internal used structure
*/
# define OI_CHART_EDGE struct oi_chart_edge
OI_CHART_EDGE
    {
    OI_MD_REFERENCE	src;
    OI_MD_REFERENCE	des;
    };
# endif /* RPC_XDR */


# endif		/* OI_HEADER	*/


