/****************************************************************************
*               PFHADD: A Pacsat File Header Generator Program              *
*               Copyright John A. Magliacane, KD2BD 1996, 2000              *
*                        Program written: June 1996                         *
*                         Last update: 20-Jan-2000                          *
*****************************************************************************
*                                                                           *
* This program is free software; you can redistribute it and/or modify it   *
* under the terms of the GNU General Public License as published by the     *
* Free Software Foundation; either version 2 of the License or any later    *
* version.                                                                  *
*                                                                           *
* This program is distributed in the hope that it will useful, but WITHOUT  *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or     *
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License     *
* for more details.                                                         *
*                                                                           *
*****************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>

unsigned char pfh[512];
unsigned int x;

void putpfh(arg)
unsigned char arg;
{
	/* This function adds a byte into the header */
	pfh[x]=arg;
	x++;
}

void endpfh()
{
	/* This function concludes the header */
	putpfh(0);
	putpfh(0);
	putpfh(0);
}

void char2pfh(id,arg)
unsigned int id;
unsigned char arg;
{
	/* This function adds a single 8-bit character to the header */
	putpfh(id&255);
	putpfh(id>>8);
	putpfh(1);
	putpfh(arg);
}

void int2pfh(id,arg)
unsigned int id, arg;
{
	/* This function adds a single 16-bit integer to the header */
	putpfh(id&255);
	putpfh(id>>8);
	putpfh(2);
	putpfh(arg&255);
	putpfh(arg>>8);
}

void long2pfh(id,arg)
unsigned int id;
unsigned long arg;
{
	/* This function adds a long integer to the header */
	putpfh(id&255);
	putpfh(id>>8);
	putpfh(4);
	putpfh(255&arg);
	putpfh(255&(arg>>8));
	putpfh(255&(arg>>16));
	putpfh(255&(arg>>24));
}

void str2pfh(id,len,arg)
unsigned int id;
unsigned char len;
unsigned char *arg;
{
	/* This function adds a character string to the header.
	   The length is given as the second argument.  If the
	   length is variable, then a 0 is passed. */

	unsigned char real_len, str[256];
	unsigned int a;

	putpfh(id&255);
	putpfh(id>>8);

	strcpy(str,arg);

	if (len==0)
		len=strlen(str);

	else
	{
		str[len]=0;
		real_len=strlen(str);

		for (a=real_len; a<len; a++)
			str[a]=0x20;

		str[len-1]=0;
	}

	putpfh(len);

	for (a=0; a<len; a++)
		putpfh(str[a]);
}

int main(argc,argv)
int argc;
char *argv[];
{
	unsigned long body_size, file_size, days, expire_time;
	unsigned int body_checksum, header_checksum, body_offset, a, b;
	unsigned char outname[50], user_file_name[50], source[20],
		 title[80], destination[20], keywords[80], temp[10],
		 file_description[256], compression_description[256];
	int ch, file_type, compression_technique;
	time_t t;

	FILE *fopen(), *infile=NULL, *outfile;

	infile=fopen(argv[1], "rb");

	if (infile!=NULL)
	{
		strcpy(user_file_name,argv[1]);

		printf("\nSource: ");
		fgets(source,20,stdin);
		source[strlen(source)-1]=0;
		for (a=0; source[a]!=0; source[a]=toupper(source[a]), a++);
	
		printf("Destination: ");
		fgets(destination,20,stdin);
		destination[strlen(destination)-1]=0;
		for (a=0; destination[a]!=0; destination[a]=toupper(destination[a]), a++);

		printf("Subject: ");
		fgets(title,80,stdin);
		title[strlen(title)-1]=0;

		printf("Keywords: ");
		fgets(keywords,80,stdin);
		keywords[strlen(keywords)-1]=0;

		printf("Expire Time (Days): ");
		fgets(temp,10,stdin);
		sscanf(temp,"%ld",&days);

		printf("\n  0: ASCII  Text\t\t  8: Keplerian Data (NASA Format)");
		printf("\n  6: MS-DOS .EXE File\t\t  9: Keplerian Data (AMSAT Format)");
		printf("\n  7: MS-DOS .COM File\t\t 12: Multiple Files (one or more ASCII)");
		printf("\n 14: GIF Image\t\t\t 13: Multiple Files (all ASCII)");
		printf("\n 15: PCX Image\t\t\t 16: JPG Image");
		printf("\n255: User Defined File Type\n\n");
		
		printf("File Type: ");
		fgets(temp,10,stdin);
		sscanf(temp,"%d",&file_type);

		if (file_type==255)
		{
			printf("Please provide a brief description of the file: ");
			fgets(file_description,255,stdin);
			file_description[strlen(file_description)-1]=0;
		}

		if (file_type!=16)
		{
			printf("\n  0: None\t\t\t  1: ARC");
			printf("\n  2: ZIP\t\t\t  3: LHARC");
			printf("\n 16: JPG\t\t\t255: User Defined\n\n"); 

			printf("Compression Technique: ");
			fgets(temp,10,stdin);
			sscanf(temp,"%d",&compression_technique);
		}

		if (compression_technique==0 && file_type==0)
			file_type=10;

		if (compression_technique==255)
		{
			printf("Please provide a brief description of the compression method: ");
			fgets(compression_description,255,stdin);
			compression_description[strlen(compression_description)-1]=0;
		}

		body_checksum=0;
		body_size=0;

		/* Measure body_size and calculate body_checksum */

		ch=fgetc(infile);

		while (ch!=EOF)
		{
			body_checksum+=(unsigned int)ch;
			body_size++;
			ch=fgetc(infile);
		}

		fclose(infile);

		/* Build Pacsat File Header */

		x=0;
		putpfh(0xaa);
		putpfh(0x55);

		/* file_number */
		long2pfh(0x01,0L);

		/* file_name */
		str2pfh(0x02,8,"");

		/* file_ext */
		str2pfh(0x03,3,"");

		/* file_size */
		long2pfh(0x04,0L);

		/* create_time */
		t=time(NULL);
		long2pfh(0x05,(unsigned long)t);

		/* last_modified_time */
		long2pfh(0x06,(unsigned long)t);

		/* seu_flag */
		char2pfh(0x07,0);

		/* file_type */
		char2pfh(0x08,(char)file_type);

		/* body_checksum */
		int2pfh(0x09,body_checksum);

		/* header_checksum */
		int2pfh(0x0a,0);

		/* body_offset */
		int2pfh(0x0b,0);

		/* source */
		str2pfh(0x10,0,source);

		/* ax25_uploader */
		str2pfh(0x11,6,"");

		/* upload_time */
		long2pfh(0x12,0L);

		/* download_count */
		char2pfh(0x13,0);

		/* destination */
		str2pfh(0x14,0,destination);

		/* ax25_downloader */
		str2pfh(0x15,6,"");

		/* download_time */
		long2pfh(0x16,0L);

		/* expire_time */
		t=time(NULL);
		expire_time=(days*86400)+t;
		long2pfh(0x17,expire_time);

		/* priority */
		char2pfh(0x18,0);

		/* compression_technique */
		char2pfh(0x19,(char)compression_technique);

		/* title */
		str2pfh(0x22,0,title);

		/* keywords */
		if (keywords[0])
			str2pfh(0x23,0,keywords);

		/* file_description */
		if (file_description[0])
			str2pfh(0x24,0,file_description);

		/* Compression Description */
		if (compression_description[0])
			str2pfh(0x25,0,compression_description);

		/* user_file_name */
		str2pfh(0x26,0,user_file_name);

		/* end of pfh */
		endpfh();

		file_size=body_size+x;
		body_offset=x;

		x=26;
		long2pfh(0x04,file_size);

		x=65;
		int2pfh(0x0b,body_offset);

		/* Calculate header_checksum */
		header_checksum=0;

		for (a=0; a<body_offset; header_checksum+=pfh[a], a++);

		x=60;
		int2pfh(0x0a, header_checksum);

		/* Generate .OUT filename */

		b=0;		
		
		do
		{
			outname[b]=user_file_name[b];
			b++;	

		} while (user_file_name[b]!=0 && user_file_name[b]!='.');

		outname[b]='.';
		outname[b+1]='o';
		outname[b+2]='u';
		outname[b+3]='t';
		outname[b+4]=0;

		outfile=fopen(outname,"wb");
		printf("\n%s ready for upload!\n", outname);


		/* Write PFH to .OUT File */

		for (a=0; a<body_offset; fputc(pfh[a],outfile), a++);


		/* Add body of file */

		infile=fopen(user_file_name,"rb");

		ch=fgetc(infile);

		while (ch!=EOF)
		{
			fputc((unsigned int)ch,outfile);
			ch=fgetc(infile);
		}

		fclose(infile);
		fclose(outfile);
	}

	if (argc==1)
		fprintf(stderr,"Usage: pfhadd filename\n");

	else if (infile==NULL)
		fprintf(stderr,"*** %s not found!\n", user_file_name);

	exit(0);
} 
