/****************************************************************************
*                 PHS: A Pacsat File Header Stripper Program                *
*               Copyright John A. Magliacane, KD2BD 1996, 2000              *
*                        Program written: June 1996                         *
*                         Last update: 04-Aug-2001                          *
*****************************************************************************
*                                                                           *
* This program is free software; you can redistribute it and/or modify it   *
* under the terms of the GNU General Public License as published by the     *
* Free Software Foundation; either version 2 of the License or any later    *
* version.                                                                  *
*                                                                           *
* This program is distributed in the hope that it will useful, but WITHOUT  *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or     *
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License     *
* for more details.                                                         *
*                                                                           *
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

FILE *infile, *outfile;

/* Global Variables */

unsigned char id_lsb, id_msb, length, data[256], seu_flag, file_type,
	      download_count, priority, compression_technique, verbose,
	      mail, extract;

char file_name[256], file_ext[256], source[256], ax25_uploader[256],
     destination[256], ax25_downloader[256], bbs_message_type, bid[256],
     title[256], keywords[256], file_description[256], result[256],
     compression_description[256], user_file_name[256], filename[256];

unsigned int body_checksum, header_checksum, body_offset, id;

unsigned long file_number, file_size, create_time, last_modified_time,
	      upload_time, download_time, expire_time;


unsigned int getitem()
{
	int x;

	id_lsb=fgetc(infile);
	id_msb=fgetc(infile);
	length=fgetc(infile);

	for (x=1; x<=(int)length; x++)
		data[x-1]=fgetc(infile);

	return (((int)id_lsb)|((int)id_msb<<8));
}

unsigned int data2int()
{
	unsigned int byte0, byte1;
	
	if (length==2)
	{
		byte0=(unsigned int)data[0];
		byte1=(unsigned int)data[1];

		return ((byte0)|(byte1<<8));
	}
	else
		return 0;
}


unsigned long data2long()
{
	unsigned long byte0, byte1, byte2, byte3;

	if (length==4)
	{
		byte0=(unsigned long)data[0];
		byte1=(unsigned long)data[1];
		byte2=(unsigned long)data[2];
		byte3=(unsigned long)data[3];

		return (byte0|(byte1<<8)|(byte2<<16)|(byte3<<24));
	}
	else
		return 0;
}


char *data2str()
{
	int x;

	for (x=1; x<=(int)length; x++)
		result[x-1]=(char)data[x-1];

	result[length]=0;

	return result;
}


char *data2time(x)
unsigned long x;
{
	time_t t;

	if (x!=0)
	{
		t=x;
		strcpy(result,asctime(gmtime(&t)));
		result[strlen(result)-1]=0;
	
		if (result[8]==32)
			result[8]='0';
	}
	else
		strcpy(result,"not initialized");

	return result;
}

void display_file_type(x)
unsigned char x;
{
	printf(" ---> ");
	switch (x)
	{
		case 0x00:
		printf("ASCII Text");	
		break;
					
		case 0x01:
		printf("RLI/MBL Message Body");
		break;

		case 0x02:
		printf("RLI/MBL Import File (multiple messages)");
		break;

		case 0x03:
		printf("UoSAT Whole Orbit Data");
		break;

		case 0x04:
		printf("Microsat Whole Orbit Data");
		break;

		case 0x06:
		printf("MS-DOS .EXE File");
		break;

		case 0x07:
		printf("MS-DOS .COM File");
		break;

		case 0x08:
		printf("Keplerian Data (NASA Format)");
		break;

		case 0x09:
		printf("Keplerian Data (AMSAT Format)");
		break;

		case 0x0a:
		printf("Non-Compressed ASCII");
		break;

		case 0x0c:
		printf("Multiple Files (one or more ASCII)");
		break;

		case 0x0d:
		printf("Multiple Files (all ASCII)");
		break;

		case 0x0e:
		printf("Image - GIF Format");
		break;

		case 0x0f:
		printf("Image - PCX Format");
		break;

		case 0x10:
		printf("Image - JPG Format");
		break;

		case 0x11:
		printf("Confirmation Message");
		break;

		case 0xc8:
		printf("Config. Files - U/L From Command Stations");
		break;
	
		case 0xc9:
		printf("Microsat Activity Log");
		break;

		case 0xca:
		printf("Microsat Broadcast Log");
		break;

		case 0xcb:
		printf("Whole Orbit Data Log");
		break;

		case 0xcc:
		printf("ADCS Log");
		break;

		case 0xcd:
		printf("TDE Log");
		break;

		case 0xce:
		printf("SCTE Log");
		break;

		case 0xcf:
		printf("Transputer Log (including EISLOG)");
		break;

		case 0xd0:
		printf("SEU Error Log");
		break;

		case 0xd1:
		printf("CPE Log");
		break;

		case 0xd2:
		printf("Battery Charge Log");
		break;

		case 0xd3:
		printf("Image File");
		break;

		case 0xd4:
		printf("SPL Log");
		break;

		case 0xd5:
		printf("PCT Log");
		break;

		case 0xd6:
		printf("PCT Command Log");
		break;

		case 0xd7:
		printf("Quick Look Image File");
		break;

		case 0xd8:
		printf("Time Tagged Telecommand Log");
		break;

		case 0xd9:
		printf("Callsign List Log");
		break;

		case 0xda:
		printf("GPS Data File");
		break;

		case 0xff:
		printf("See Description Below");
		break;

		default:
		printf("Unknown");
		break;
	}
	printf("\n");
}

void display_compression_technique(x)
unsigned char x;
{
	printf(" ---> ");
	switch (x)
	{
		case 0x00:
		printf("Not Compressed");
		break;

		case 0x01:
		printf("ARC Compression");
		break;

		case 0x02:
		printf("ZIP Compression");
		break;

		case 0x03:
		printf("LHARC Compression");
		break;

		case 0x10:
		printf("JPG Compression");
		break;

		case 0xff:
		printf("See Description Below");
		break;
					
		default:
		printf("Unknown");
	}
	printf("\n");
}

void strip_headers(file_dl)
char *file_dl;
{
	/* Initialize variables */

	file_number=0L;
	file_name[0]=0;
	file_ext[0]=0;
	file_size=0L;
	create_time=0L;
	last_modified_time=0L;
	seu_flag=0;
	file_type=0;
	body_checksum=0;
	header_checksum=0;
	body_offset=0;
	source[0]=0;
	ax25_uploader[0]=0;
	upload_time=0L;
	download_count=0;
	destination[0]=0;
	ax25_downloader[0]=0;
	download_time=0L;
	expire_time=0L;
	priority=0;
	compression_technique=0;
	bbs_message_type=0;
	bid[0]=0;
	title[0]=0;
	keywords[0]=0;
	file_description[0]=0;
	compression_description[0]=0;
	user_file_name[0]=0;
	
	if (verbose)
		printf("---------------------------- %s ----------------------------\n",file_dl);
	
	id=getitem();
	
	/* Continue this loop until the end
	   of the PFH is reached (id==0) */

	while (id!=0)
	{
		switch(id)
		{
			case 0x01:
			file_number=data2long();

			if (verbose)
				printf("File Number         :\t0x%02lx\n",file_number);
			break;

			case 0x02:
			strcpy(file_name,data2str());

			if (verbose && file_name[0]!=32)
				printf("File Name           :\t%s\n",file_name);
			break;

			case 0x03:
			strcpy(file_ext,data2str());

			if (verbose && file_ext[0]!=32)
				printf("File Extension      :\t%s\n",file_ext);
			break;

			case 0x04:
			file_size=data2long();

			if (verbose)
				printf("File Size           :\t%lu\n",file_size);
			break;

			case 0x05:
			create_time=data2long();

			if (verbose)
				printf("Create Time         :\t%s\n",data2time(create_time));
			break;

			case 0x06:
			last_modified_time=data2long();

			if (verbose)
				printf("Last Modified       :\t%s\n",data2time(last_modified_time));
			break;

			case 0x07:
			seu_flag=data[0];

			if (verbose)
				printf("SEU Flag            :\t0x%02x\n",seu_flag);
			break;
	
			case 0x08:
			file_type=data[0];

			if (verbose)
			{
				printf("File Type           :\t0x%02x",file_type);
				display_file_type(file_type);
			}
			break;

			case 0x09:
			body_checksum=data2int();

			if (verbose)
				printf("Body Checksum       :\t0x%02x\n",body_checksum);
			break;

			case 0x0a:
			header_checksum=data2int();

			if (verbose)
				printf("Header Checksum     :\t0x%02x\n",header_checksum);
			break;

			case 0x0b:
			body_offset=data2int();

			if (verbose)
				printf("Body Offset         :\t0x%04x\n",body_offset);
			break;


			/* Extended Header Information */

			case 0x10:
			strcpy(source,data2str());

			if (verbose)
				printf("Source              :\t%s\n",source);
			break;

			case 0x11:
			strcpy(ax25_uploader,data2str());

			if (verbose && ax25_uploader[0]!=32)
				printf("AX.25 Uploader      :\t%s\n",ax25_uploader);
			break;

			case 0x12:
			upload_time=data2long();

			if (verbose)
				printf("Upload Time         :\t%s\n",data2time(upload_time));
			break;

			case 0x13:
			download_count=data[0];

			if (verbose)
				printf("Download Count      :\t0x%02x\n",download_count);
			break;

			case 0x14:
			strcpy(destination,data2str());

			if (verbose)				
				printf("Destination         :\t%s\n",destination);
			break;

			case 0x15:
			strcpy(ax25_downloader,data2str());

			if (verbose && ax25_downloader[0]!=32)
				printf("AX.25 Downloader    :\t%s\n",ax25_downloader);
			break;

			case 0x16:
			download_time=data2long();

			if (verbose)
				printf("Download Time       :\t%s\n",data2time(download_time));
			break;

			case 0x17:
			expire_time=data2long();

			if (verbose)
				printf("Expire Time         :\t%s\n",data2time(expire_time));
			break;

			case 0x18:
			priority=data[0];

			if (verbose)
				printf("Priority            :\t0x%02x\n",priority);
			break;

			/* Optional Header Fields */

			case 0x19:
			compression_technique=data[0];

			if (verbose)
			{
				printf("Compression Type    :\t0x%02x",compression_technique);
				display_compression_technique(compression_technique);
			}
			break;				

			case 0x20:
			bbs_message_type=data[0];
			break;

			case 0x21:
			strcpy(bid,data2str());

			if (verbose)
				printf("Bulletin ID         :\t%s\n",bid);
			break;

			case 0x22:
			strcpy(title,data2str());

			if (verbose)
				printf("Title               :\t%s\n",title);
			break;

			case 0x23:
			strcpy(keywords,data2str());

			if (verbose)
				printf("Keywords            :\t%s\n",keywords);
			break;
	
			case 0x24:
			strcpy(file_description,data2str());

			if (verbose)
				printf("File Description    :\t%s\n",file_description);
			break;

			case 0x25:
			strcpy(compression_description,data2str());

			if (verbose)
				printf("Compression Desc.   :\t%s\n",compression_description);
			break;

			case 0x26:
			strcpy(user_file_name,data2str());

			if (verbose)
				printf("User Filename       :\t%s\n",user_file_name);
			break;
		}

	id=getitem();
	}
}

void mail2user()
{
	unsigned char str[256], mailfile[80];
	int a;
	
	sprintf(mailfile,"%s",getenv("MAIL"));

	outfile=fopen(mailfile,"a");

	fprintf(outfile,"\n\nFrom space %s\n",data2time(upload_time));
	fprintf(outfile,"Received: from PACSAT by %s id %0lx; %s\n",getenv("MYCALL"),file_number,data2time(upload_time));
	fprintf(outfile,"Date: %s\n",data2time(upload_time));
	fprintf(outfile,"From: space (%s)\n",source);
	fprintf(outfile,"Message-Id: <%ld.%s>\n",upload_time,file_name);
	fprintf(outfile,"To: %s\n",destination);
	fprintf(outfile,"Subject: %s\n",title);
	
	if (keywords[0])
		fprintf(outfile,"Keywords: %s\n",keywords);

	fprintf(outfile,"\n"); 

	if (compression_technique==0)
	{
		infile=fopen(filename,"rb");

		fgets(str,255,infile);

		do
		{
			a=strlen(str);

			if (a>1 && str[a-2]==13 && str[a-1]==10)
			{
				str[a-2]=10;
				str[a-1]=0;
			}

			fprintf(outfile,"%s",str);
			fgets(str,255,infile);
	
		} while (feof(infile)==0);

		fclose(infile);
		fclose(outfile);
	}		
	
	else
	{
		if (compression_technique==2)
		{
			fclose(outfile);
			sprintf(str,"unzip -paa %s >> %s",filename, mailfile);
			system(str);
		}

		if (compression_technique==3)
		{
			fclose(outfile);
			sprintf(str,"lha -ptqif %s >> %s",filename, mailfile);
			system(str);
		}
	}
	
	unlink(filename);
}

int main (argc,argv)
int argc;
char *argv[];
{
	int a, x;
	unsigned measured_body_checksum;
	char dl_file[80], dlx_file[80];
		
	/* Defaults */

	verbose=1;
	mail=0;
	extract=1;

	for (x=1; x<argc; x++)
	{
		while (argv[x][0]=='-')
		{
			for (a=1; a!=strlen(argv[x]); a++)
			{
				switch (argv[x][a])
				{
					case 'q':
					verbose=0;
					break;

					case 'm':
					mail=1;
					break;

					case 'x':
					extract=0;
					break;
				}
			}	
			x++;
		}
		strcpy(dl_file,argv[x]);
		infile=fopen(dl_file,"rb");

		if (infile!=NULL && fgetc(infile)==0xaa && fgetc(infile)==0x55)
		{
			strip_headers(argv[x]);
				
			if (extract)
			{
				if (user_file_name[0]==0)
					strcpy (filename, file_name);
				else
					strcpy (filename, user_file_name);

				outfile=fopen(filename,"wb");

				measured_body_checksum=0;

				a=fgetc(infile);

				do
				{
					fprintf(outfile,"%c",a);
					measured_body_checksum+=a;
					a=fgetc(infile);

				} while (feof(infile)==0);

				fclose(infile);
				fclose(outfile);

				if ((measured_body_checksum&65535)!=body_checksum)
					fprintf(stderr,"*** Body checksum error!\n");

				if (mail && file_type==0 && getenv("MAIL")!=NULL && (compression_technique==0 || compression_technique==2 || compression_technique==3))
					mail2user();

				else
				{
					if (compression_technique==2)
					{
						sprintf(result,"unzip -aojqq %s",filename);
						if (system(result)==0)
							unlink(filename);
					}

					if (compression_technique==3)
					{
						sprintf(result,"lha -xtqi %s",filename);
						if (system(result)==0)
							unlink(filename);
					}
				}
				
				/* Rename input file with .dlx extension */
	
				for (a=0; dl_file[a]!='.' && dl_file[a]!=0; dlx_file[a]=dl_file[a], a++);
				
				dlx_file[a]='.';
				dlx_file[a+1]='d';
				dlx_file[a+2]='l';
				dlx_file[a+3]='x';
				dlx_file[a+4]=0;		
			
				if (strcmp(dl_file,dlx_file)!=0)	
					rename (dl_file, dlx_file);
			}
		}
	}
	
	if (argc==1)
		fprintf(stderr,"Usage: phs -qxm file.dl\n");

	else if (infile==NULL)
		fprintf(stderr,"*** %s not found!\n",argv[x]);

	exit(0);
}
