/****************************************************************************
*  SB2OUT: A Pacsat File Header Generator For Preformatted Packet Messages  *
*               Copyright John A. Magliacane, KD2BD 1995, 2001              *
*                       Program Written: August 1995                        *
*                         Last update: 09-Jul-2001                          *
*****************************************************************************
*                                                                           *
* This program is free software; you can redistribute it and/or modify it   *
* under the terms of the GNU General Public License as published by the     *
* Free Software Foundation; either version 2 of the License or any later    *
* version.                                                                  *
*                                                                           *
* This program is distributed in the hope that it will useful, but WITHOUT  *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or     *
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License     *
* for more details.                                                         *
*                                                                           *
*****************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>

unsigned char pfh[512];
unsigned int x;
unsigned char string[256];

void putpfh (arg)
unsigned char arg;
{
	pfh[x]=arg;
	x++;
}

void endpfh()
{
	putpfh(0);
	putpfh(0);
	putpfh(0);
}

void char2pfh(id,arg)
unsigned int id;
unsigned char arg;
{
	putpfh(id&255);
	putpfh(id>>8);
	putpfh(1);
	putpfh(arg);
}

void int2pfh(id,arg)
unsigned int id, arg;
{
	putpfh(id&255);
	putpfh(id>>8);
	putpfh(2);
	putpfh(arg&255);
	putpfh(arg>>8);
}

void long2pfh(id,arg)
unsigned int id;
unsigned long arg;
{
	putpfh(id&255);
	putpfh(id>>8);
	putpfh(4);

	putpfh(255&arg);
	putpfh(255&(arg>>8));
	putpfh(255&(arg>>16));
	putpfh(255&(arg>>24));
}

void str2pfh(id,len,arg)
unsigned int id;
unsigned char len;
unsigned char *arg;
{
	unsigned char real_len, str[256];
	unsigned int a;

	putpfh(id&255);
	putpfh(id>>8);

        strcpy(str,arg);

	if (len==0)
		len=strlen(str);
	else
	{
		str[len]=0;
		real_len=strlen(str);	

		for(a=real_len; a<len; a++)
			str[a]=0x20;

		str[len-1]=0;
	}
	
	putpfh(len);

	for(a=0; a<len; a++)
		putpfh(str[a]);
}

char *cradd(str)
char str[255];
{
	unsigned int len;
	
	strcpy(string,str);
	len=strlen(string);
	if ((string[len-2]!=13)&&(string[len-1]==10))
	{
		string[len-1]=13;
		string[len]=10;
		string[len+1]=0;
	}
	return(string);
}

char *crlfdel(str)
char str[255];
{
	unsigned int a;

	strcpy(string,str);

	for (a=0; string[a]!=10 && string[a]!=13 && string[a]!=0; a++);

	string[a]=0;
	return(string);
}
		
int main(argc,argv)
int argc;
char *argv[];
{
	int ch;
	time_t t;
	unsigned long body_size, file_size, days, expire_time;
	unsigned int body_checksum, header_checksum, body_offset,
		 a, b, length;
	unsigned char outname[50], user_file_name[50], line[256],
		 source[15], title[80], string[256], bid[20], zipname[50],
		 destination[10], keywords[80], compression_technique,
		 file_type=0, command[5], bbs_callsign[20];
	char flag;

	FILE *fopen(), *argfile, *outfile=NULL, *infile=NULL;

	argfile=fopen(argv[1],"rb");

	while (argfile!=NULL && feof(argfile)==0)
	{
		/* Scan packet bulletin file for source,
		   destination, BID$ information */
 
		/* Find "SB", "SP", or EOF */

		do
		{
			fgets(line,255,argfile);
			
			flag=strncmp(line,"SB ",3);
		
			if (flag)
				flag=strncmp(line,"SP ",3);
		
		} while (flag!=0 && feof(argfile)==0);

		/* At this point we have either an SB, SP, or EOF */

		if (feof(argfile)==0)
		{
			/* At this point we've ruled out an EOF */

			a=0;
			length=strlen(line);

			/* Move past spaces until we
			   get to a "real" character */

			while (line[a]==32 && a<=length)
				a++;

			/* Parse for command (SB or SP) */

			for (b=0; a<=length && line[a]!=32; a++)
			{
				if (line[a]!=32)
				{
					command[b]=toupper(line[a]);
					b++;
				}
			}

			command[b]=0;

			/* Parse for destination callsign */

			while (line[a]==32 && a<=length)
				a++;

			for (b=0; a<=length && line[a]!=32 && line[a]!='@'; a++)
			{
				if (line[a]!=32 && line[a]!='@')
				{
					destination[b]=toupper(line[a]);
					b++;
				}
			}

			destination[b]=0;

			/* Parse for bbs callsign */

			while ((line[a]=='@' || line[a]==32) && a<=length)
				a++;

			for (b=0; a<=length && line[a]!=32; a++)
			{
				if (line[a]!=32)
				{
					bbs_callsign[b]=toupper(line[a]);
					b++;
				}
			}

			bbs_callsign[b]=0;

			/* Parse for optional $BID and source callsign */

			bid[0]=0;
			source[0]=0;

			for (a++; a<=length; a++)
			{
				if (line[a]=='$')
				{
					while (line[a]==32 && a<=length)
					a++;

					for (b=0; a<=length && line[a]!=32 && line[a]!='\n' && a<=length; a++)
					{
						bid[b]=line[a];
						b++;
					}

					bid[b]=0;
				}

				if (line[a]=='<')
				{
					a++;
					while (line[a]==32)
						a++;

					for (b=0; line[a]!=32 && line[a]!='\n' && a<=length; a++)
					{
						source[b]=toupper(line[a]);
						b++;
					}

					source[b]=0;
				}
			}

			/* Read the next line to grab the subject */

			fgets(line,255,argfile);

			if (line[0]!=10 || line[0]!=13)
				strcpy(title,crlfdel(line));
			else
				strcpy(title,"no subject");
		}

		/* Create a KEYWORDS field based
		   on the address of the message */

		sprintf(keywords,"%s %s @ %s",command,destination,bbs_callsign);

		if (bid[0])
		{
			strcat(keywords," ");
			strcat(keywords,bid);
		}

		if (source[0])
		{
			strcat(keywords," < ");
			strcat(keywords,source);
		}
		else
			strcpy(source,getenv("MYCALL"));

		if (source[0]==0)
			strcpy(source,"NOCALL");

		/* If this is addressed to KEPS,
		   assign the appropriate file_type */

		if (strcmp(destination,"KEPS")==0)
			file_type=0x08;
		else
			file_type=0x00;

		/* If this is a bulletin (SB), then
		   assign the destination to ALL */

		if (strcmp(command,"SB")==0)
			strcpy(destination,"ALL");
 
	        /* Input file can be closed now that source
		   and BID$ information has been obtained */

		fclose(argfile);
	
		/* All files are ZIPed for DOS/Winblows
		   compatibility by adding CRs (zip -qkl) */

		strcpy(zipname,argv[1]);

		for (a=0; zipname[a]!='.' && zipname[a]!=0; a++);		
			
		zipname[a]='.';
		zipname[a+1]='z';
		zipname[a+2]='i';
		zipname[a+3]='p';
		zipname[a+4]=0;
			
		sprintf(string,"zip -qkl %s %s",zipname,argv[1]);
		system(string);

		compression_technique=2;

		strcpy(user_file_name,zipname);

		infile=fopen(zipname,"rb");

		body_checksum=0;
		body_size=0;
			
		/* Measure body_size and calculate body_checksum */

		ch=fgetc(infile);

		while (ch!=EOF)
		{
			body_checksum+=(unsigned int)ch;
			body_size++;
			ch=fgetc(infile);
		}

		/* Build Pacsat File Header */
		
		x=0;
		putpfh(0xaa);
		putpfh(0x55);

		/* file_number */
		long2pfh(0x01,0L);

		/* file_name */
		str2pfh(0x02,8,"");

		/* file_ext */
		str2pfh(0x03,3,"");
	
		/* file_size */
		long2pfh(0x04,0L);

		/* create_time */
		t=time(NULL);
		long2pfh(0x05,(unsigned long)t);

		/* last_modified_time */
		long2pfh(0x06,(unsigned long)t);

		/* seu_flag */
		char2pfh(0x07,0);

		/* file_type */
		char2pfh(0x08,file_type);

		/* body_checksum */
		int2pfh(0x09,body_checksum);

		/* header_checksum */
		int2pfh(0x0a,0);

		/* body_offset */
		int2pfh(0x0b,0);

		/* source */
		str2pfh(0x10,0,source);

		/* ax25_uploader */
		str2pfh(0x11,6,"");

		/* upload_time */
		long2pfh(0x12,0L);

		/* download_count */
		char2pfh(0x13,0);

		/* destination */
		str2pfh(0x14,0,destination);

		/* ax25_downloader */
		str2pfh(0x15,6,"");

		/* download_time */
		long2pfh(0x16,0L);

		/* expire_time */
		t=time(NULL);
		days=7;
		expire_time=(days*86400)+t;
		long2pfh(0x17,expire_time);

		/* priority */
		char2pfh(0x18,0);

		/* compression_technique */
		char2pfh(0x19,compression_technique);

		/* bulletin_id_number */
		if (bid[0])
			str2pfh(0x21,0,bid);

		/* title */
		str2pfh(0x22,0,title);

		/* keywords */
		str2pfh(0x23,0,keywords);

		/* user_file_name */
		str2pfh(0x26,0,user_file_name);

		/* end of pfh */
		endpfh();
		
		file_size=body_size+x;
		body_offset=x;
		
		x=26;
		long2pfh(0x04,file_size);

		x=65;
		int2pfh(0x0b,body_offset);

		/* Calculate header_checksum */
		header_checksum=0;

		for (a=0; a<body_offset; header_checksum+=pfh[a], a++);

		x=60;
		int2pfh(0x0a,header_checksum);

		/* Generate .OUT filename */
		
		strcpy(outname,zipname);
	
		for (a=0; outname[a]!='.' && outname[a]!=0; a++);		
		
		outname[a]='.';
		outname[a+1]='o';
		outname[a+2]='u';
		outname[a+3]='t';
		outname[a+4]=0;

		outfile=fopen(outname,"wb");
		printf("Creating %s\n",outname);

	        /* Write PFH to .OUT file */
		for (a=0; a<body_offset; fputc(pfh[a],outfile), a++);

		/* Add body of file */

		rewind(infile);

		ch=fgetc(infile);

		while (ch!=EOF)
		{
			fputc((unsigned int)ch,outfile);
			ch=fgetc(infile);
		}
	
		if (compression_technique)
			unlink(user_file_name);

		fclose(infile);
		fclose(outfile);
	}

	if (argc==1)
		fprintf(stderr,"Usage: sb2out packetfile\n");

	else if (infile==NULL)
		fprintf(stderr,"*** %s not found!\n",argv[1]);
	
	exit(0);
}
