
//=============================//

template <typename ElType> struct Element{
		ElType date;
		Element* next;
		Element* prev;
		Element():next(0),prev(0){};
};

template <typename TElList> class List{
	Element<TElList> *pCurr;
	Element<TElList> *pFirst;
	int nCurr, size;
public:
	List();
	List(const List<TElList> &);
	List<TElList> &operator=(List<TElList>);
	int Size() const {return size;};
	void add(TElList x);
	void add_in_begin(TElList x);
	void add_in_end(TElList x);
	TElList& GetDate();
	TElList& operator[](int n);
	TElList& erase();
	void clear();
	~List();
};

template <typename TElList> List<TElList>::List(){
	pCurr = pFirst = 0;
	size = 0;
	nCurr = 0;
}
template <typename TElList> List<TElList>::List(const List<TElList> &obj){
	pCurr = pFirst = 0;
	size = nCurr = 0;
	Element<TElList> *pNew;
	Element<TElList> *p_obj_first = obj.pFirst;
	Element<TElList> *p_obj_curr = obj.pFirst;
	if (obj.size){
		if (p_obj_first){
			pNew = new Element<TElList>;
			pFirst = pCurr = pNew;
			pFirst->next = pFirst->prev = pFirst;
			pCurr->date = p_obj_curr->date;
			nCurr = ++size;
			p_obj_curr = p_obj_curr->next;
		}
		while(p_obj_curr != p_obj_first){
			pNew = new Element<TElList>;
			pNew->prev=pCurr;
			pNew->next=pCurr->next;
			pNew->next->prev = pNew;
			pCurr->next=pNew;
			pCurr = pNew;
			pCurr->date = p_obj_curr->date;
			nCurr = ++size;
			p_obj_curr = p_obj_curr->next;
		}
	}
}

template <typename TElList> List<TElList> &List<TElList>::operator=(List<TElList> obj){
	while(size--){
		pCurr = pFirst->next;
		delete pFirst;
		pFirst = pCurr;
	}
	pCurr = pFirst = 0;
	size = nCurr = 0;
	Element<TElList> *p_obj_first = obj.pFirst;
	Element<TElList> *p_obj_curr = obj.pFirst;
	Element<TElList> *pNew;
	if (obj.size){
		if (p_obj_first){
			pNew = new Element<TElList>;
			pFirst = pCurr = pNew;
			pFirst->next = pFirst->prev = pFirst;
			pCurr->date = p_obj_curr->date;
			nCurr = ++size;
			p_obj_curr = p_obj_curr->next;
		}
		while(p_obj_curr != p_obj_first){
			pNew = new Element<TElList>;
			pNew->prev=pCurr;	
			pNew->next=pCurr->next;
			pNew->next->prev = pNew;
			pCurr->next=pNew;
			pCurr = pNew;	
			pCurr->date = p_obj_curr->date;
			nCurr = ++size;
			p_obj_curr = p_obj_curr->next;
		}
	}
	return (*this);
}

template <typename TElList> void List<TElList>::add(TElList x){
	Element<TElList> *pNew = new Element<TElList>;
	if (!pFirst) {
		 pFirst = pCurr = pNew;
		 pFirst->next = pFirst->prev = pFirst;
	} else {
		pNew->prev=pCurr;	
		pNew->next=pCurr->next;
		pNew->next->prev = pNew;
		pCurr->next=pNew;
		pCurr=pNew;
	}
	pCurr->date = x;
	++size;
	++nCurr;
}

template <typename TElList> void List<TElList>::add_in_begin(TElList x){
	Element<TElList> *pNew = new Element<TElList>;
	if (!pFirst) {
		 pFirst = pCurr = pNew;
		 pFirst->next = pFirst->prev = pFirst;
	} else {
		pNew->prev=pFirst->prev;	
		pNew->next=pFirst;
		pNew->next->prev = pNew;
		pNew->prev->next = pNew;
		pFirst = pCurr = pNew;		
	}	
	pFirst->date = x;
	nCurr = 1;
	++size;
}

template <typename TElList> void List<TElList>::add_in_end(TElList x){
	Element<TElList> *pNew = new Element<TElList>;
	if (!pFirst) {
		 pFirst = pCurr = pNew;
		 pFirst->next = pFirst->prev = pFirst;
	} else {
		pNew->prev=pFirst->prev;	
		pNew->next=pFirst;
		pNew->next->prev = pNew;
		pNew->prev->next = pNew;
		pCurr = pNew;		
	}	
	pCurr->date = x;
	nCurr = ++size;	
}

template <typename TElList> TElList& List<TElList>::GetDate(){
	if (!pCurr) return (TElList) 0;
	return pCurr->date;
}

template <typename TElList> TElList& List<TElList>::erase(){
	Element<TElList> *pTemp;
	if (pCurr){
		if (pCurr == pFirst)
			pFirst = pFirst->next;
		pTemp = pCurr;
		pCurr->prev->next = pCurr->next;
		pCurr->next->prev = pCurr->prev;
		pCurr = pCurr->next;
		delete pTemp;
		--size;
	}
	if (!size){
		pCurr = pFirst = 0;
		size = nCurr = 0;
	}
	return pCurr->date;
}
template <typename TElList> void List<TElList>::clear(){
	while(size--){		
		pCurr = pFirst->next;
		delete pFirst;
		pFirst = pCurr;
	}
	pCurr = pFirst = 0;
	size = nCurr = 0;
}
template <typename TElList> TElList& List<TElList>::operator[](int n){
	++n;
	if (nCurr == n) return pCurr->date;
	if (nCurr < n)
		while (n - nCurr){
			pCurr = pCurr->next;
			++nCurr;
		}
	if (nCurr > n)
		while (n - nCurr){
			pCurr = pCurr->prev;
			--nCurr;
		}
	return pCurr->date;
}

template <typename TElList> List<TElList>::~List(){
	while(size--){		
		pCurr = pFirst->next;	
		delete pFirst;
		pFirst = pCurr;
	}
}


//=============================//

template <typename ElType> struct M_Element{
	M_Element* next;
	M_Element* prev;
	ElType date;
	char *c_key; 
	unsigned i_key; 
	M_Element(char *key, ElType y = (ElType) 0, unsigned Ikey = 0){
		int length = (int) strlen(key);
		c_key = new char[length+1];
		for(int i = 0; i <= length; ++i)
			c_key[i] = key[i];
		i_key = Ikey;
		date = y;
	}
};

template <typename TElmap> class map{
	M_Element<TElmap> *pCurr;
	M_Element<TElmap> *pFirst;
	M_Element<TElmap> *pNull;
	int size;
	int nCurr;
public:
	map();
	map(const map<TElmap> &);
	map<TElmap> operator=(map<TElmap>);
	unsigned keyToint(char *key);
	int is_key(char *key);
	void add(char *key, TElmap date = (TElmap) 0);
	TElmap &operator[](char *key);
	void set(char *key, TElmap date = (TElmap) 0);
	TElmap get(char *key);
	TElmap erase(char *key);
	int Size(){return size;};
	void clear();
	~map();
};

template <typename TElmap> map<TElmap>::map(){
	pCurr = pFirst = 0;
	size = nCurr = 0;
	pNull = new M_Element<TElmap>("null",0,0);
}
template <typename TElmap> map<TElmap>::map(const map<TElmap> &obj){
	pCurr = pFirst = 0;
	size = 0;
	M_Element<TElmap> *pNew;
	M_Element<TElmap> *p_obj_first = obj.pFirst;
	M_Element<TElmap> *p_obj_curr = obj.pFirst;
	if (obj.size){
		if (p_obj_first){
			pNew = new M_Element<TElmap>;
			pFirst = pCurr = pNew;
			pFirst->next = pFirst->prev = pFirst;
			pCurr->date = p_obj_curr->date;
			nCurr = ++size;
			p_obj_curr = p_obj_curr->next;
		}
		while(p_obj_curr != p_obj_first){
			pNew = new M_Element<TElmap>;
			pNew->prev=pCurr;	
			pNew->next=pCurr->next;
			pNew->next->prev = pNew;
			pCurr->next=pNew;
			pCurr = pNew;	
			pCurr->date = p_obj_curr->date;
			nCurr = ++size;
			p_obj_curr = p_obj_curr->next;
		}
	}
}

template <typename TElmap> map<TElmap> map<TElmap>::operator=(map<TElmap> obj){
	while(size--){		
		pCurr = pFirst->next;
		delete pFirst;
		pFirst = pCurr;
	}
	pCurr = pFirst = 0;
	size = nCurr = 0;
	M_Element<TElmap> *p_obj_first = obj.pFirst;
	M_Element<TElmap> *p_obj_curr = obj.pFirst;
	M_Element<TElmap> *pNew;
	if (obj.size){
		if (p_obj_first){
			pNew = new M_Element<TElmap>;
			pFirst = pCurr = pNew;
			pFirst->next = pFirst->prev = pFirst;
			pCurr->date = p_obj_curr->date;
			nCurr = ++size;
			p_obj_curr = p_obj_curr->next;
		}
		while(p_obj_curr != p_obj_first){
			pNew = new M_Element<TElmap>;
			pNew->prev=pCurr;	
			pNew->next=pCurr->next;
			pNew->next->prev = pNew;
			pCurr->next=pNew;
			pCurr = pNew;	
			pCurr->date = p_obj_curr->date;
			nCurr = ++size;
			p_obj_curr = p_obj_curr->next;
		}
	}
	return (*this);
}

template <typename TElmap> unsigned map<TElmap>::keyToint(char *key){
	int stop = strlen(key) < 5 ? (int) strlen(key) : 5;
	unsigned result = 0;
	for (int i = 0; i < stop; ++i){
		result <<= 6;
		if (key[i] >= 0x41 && key[i] <= 0x5A) result += key[i]-0x41;
		if (key[i] >= 0x61 && key[i] <= 0x7A) result += key[i]-0x61 + 26;
		if (key[i] >= 0x30 && key[i] <= 0x39) result += key[i]-0x30 + 52;
		if (key[i] == 0x7E) result += 63;
	}
	while (stop++ < 5) result <<= 6;
	return result;
}

template <typename TElmap> int map<TElmap>::is_key(char *key){
// 0 - there is such key
// 1 - the current key is less
//-1 - the current key is more
	unsigned Ikey = keyToint(key);
	if (Ikey > pCurr->i_key){
		if (pCurr == pFirst->prev)
			return 1;
		while((pCurr != pFirst->prev) && (Ikey > pCurr->i_key))
			pCurr = pCurr->next;
		while((pCurr != pFirst->prev) && (Ikey == pCurr->i_key) && (strcmp(pCurr->c_key, key) < 0))
			pCurr = pCurr->next;
		if ((Ikey == pCurr->i_key) && (strcmp(pCurr->c_key, key) == 0))
			return 0;
		else
			if (strcmp(pCurr->c_key, key) < 0)
				return 1;
			else
				return -1;
	}		
	if (Ikey < pCurr->i_key){
		if (pCurr == pFirst){
			return -1;
		}
		while((pCurr != pFirst) && (Ikey < pCurr->i_key))
			pCurr = pCurr->prev;
		while((pCurr != pFirst) && (Ikey == pCurr->i_key) && (strcmp(pCurr->c_key, key) > 0))
			pCurr = pCurr->prev;
		if ((Ikey == pCurr->i_key) && (strcmp(pCurr->c_key, key) == 0))
			return 0;
		else
			if ((strcmp(pCurr->c_key, key) > 0))
				return -1;
			else
				return 1;
	}
	if (pCurr->i_key == Ikey){
		if (strcmp(pCurr->c_key, key) == 0){
			return 0;
		}
		if ((strcmp(pCurr->c_key, key) > 0)){
			while((pCurr != pFirst) && (strcmp(pCurr->c_key, key) > 0))
				pCurr = pCurr->prev;
			if ((strcmp(pCurr->c_key, key) == 0))
				return 0;
			else
				return 1;
		}
		if ((strcmp(pCurr->c_key, key) < 0)){
			while((pCurr != pFirst->prev) && (strcmp(pCurr->c_key, key) < 0))
				pCurr = pCurr->next;
			if ((strcmp(pCurr->c_key, key) == 0))
				return 0;
			else
				return -1;
		}
	}
	return 0;
}

template <typename TElmap> void map<TElmap>::add(char *key, TElmap date){
	M_Element<TElmap> *pNew;
	if (!pFirst){			
		pNew = new M_Element<TElmap>(key, date, keyToint(key));
		pFirst = pCurr = pNew;
		pFirst->next = pFirst->prev = pFirst;
		return;
	}
	int IS_key = is_key(key);
	if (!IS_key){
		pCurr->date = date;
		return;
	}
	pNew = new M_Element<TElmap>(key, date, keyToint(key));
	if (IS_key == 1){		
		pNew->prev=pCurr;	
		pNew->next=pCurr->next;	
		pNew->next->prev = pNew;
		pNew->prev->next = pNew;
	}
	if (IS_key == -1){
		pNew->next=pCurr;	
		pNew->prev=pCurr->prev;	
		pNew->next->prev = pNew;
		pNew->prev->next = pNew;
		if (pFirst == pCurr)
			pFirst = pNew;
	}
		pCurr=pNew;
	++size;
}

template <typename TElmap> TElmap& map<TElmap>::operator[](char *key){
	if (is_key(key)){
		return pNull->date;
	}
	return pCurr->date;	
}
template <typename TElmap> void map<TElmap>::set(char *key, TElmap date){
	if (is_key(key))
		add(key, date);
		pCurr->date = date;	
}
template <typename TElmap> TElmap map<TElmap>::get(char *key){
	if (is_key(key))
		return pNull->date;
	return pCurr->date;	
}

template <typename TElmap> TElmap map<TElmap>::erase(char *key){
	if (is_key(key))
		return pNull->date;
	M_Element<TElmap> *pTemp;
	if (pCurr){
		if (pCurr == pFirst)
			pFirst = pFirst->next;
		pTemp = pCurr;
		pCurr->prev->next = pCurr->next;
		pCurr->next->prev = pCurr->prev;
		pCurr = pCurr->next;
		delete pTemp;
		--size;
	}
	return pCurr->date;
}
template <typename TElmap> void map<TElmap>::clear(){
	while(size--){		
		pCurr = pFirst->next;
		delete pFirst;
		pFirst = pCurr;
	}
	pCurr = pFirst = 0;
	size = 0;
}

template <typename TElmap> map<TElmap>::~map(){
	while(size--){		
		pCurr = pFirst->next;	
		delete pFirst;
		pFirst = pCurr;
	}
}


//=============================//

template <typename ElType> struct S_Element{
	S_Element* prev;
	ElType date;
};

template <typename TElset> class set{
	S_Element<TElset> *pTop;
	S_Element<TElset> *pFirst;
	int size;
public:
	set();
	set(const set<TElset> &);
	set<TElset> &operator=(set<TElset>&);
	void push(TElset date);
	TElset pop();
	TElset &top(int n = 0);
	int Size(){return size;};
	bool is_null() {return size == 0;};
	~set();
};

template <typename TElset> set<TElset>::set(){
	size = 0; pTop = 0;
}
template <typename TElset> set<TElset>::set(const set<TElset> &obj){
	size = 0; pTop = 0;
	S_Element<TElset> *pNew, *pTemp;
	S_Element<TElset> *p_obj_top = obj.pTop;
	if (obj.size){
		pTemp = pTop = new S_Element<TElset>;
		pTemp->date = p_obj_top->date;
		pTemp->prev = 0;
		++size;
		while((p_obj_top = p_obj_top->prev)){
			pNew = new S_Element<TElset>;
			pTemp = (pTemp->prev = pNew);
			pTemp->date = p_obj_top->date;
			pTemp->prev = 0;
			++size;
		}
	}
}

template <typename TElset> set<TElset> &set<TElset>::operator=(set<TElset> &obj){
	S_Element<TElset> *p_obj_top = obj.pTop;
	S_Element<TElset> *pNew, *pTemp;
	while(size--){		
		pTemp = pTop;
		pTop = pTop->prev;
		delete pTemp;		
	}
	pTop = size = 0;	
	if (obj.size){
		pTemp = pTop = new S_Element<TElset>;
		pTemp->date = p_obj_top->date;
		pTemp->prev = 0;
		++size;
		while((p_obj_top = p_obj_top->prev)){
			pNew = new S_Element<TElset>;
			pTemp = (pTemp->prev = pNew);
			pTemp->date = p_obj_top->date;
			pTemp->prev = 0;
			++size;
		}
	}
	return (*this);
}

template <typename TElset> void set<TElset>::push(TElset date){
	if (pTop == 0){
		pFirst = pTop = new S_Element<TElset>;
		pTop -> prev = 0;
		pTop -> date = date;		
	} else {
		S_Element<TElset> *pNew = new S_Element<TElset>;
		pNew -> prev = pTop;
		pTop = pNew;
		pTop -> date = date;
	}
	++size;
}

template <typename TElset> TElset set<TElset>::pop(){
	TElset result;
	if (size--){
		result = pTop -> date;
		S_Element<TElset> *pTemp = pTop -> prev;
		delete pTop;
		pTop = pTemp;
	} else {
		std::cerr << "Warning: steck is null! (pop)";
		exit (1);
	}
	return result;
}
template <typename TElset> TElset &set<TElset>::top(int n){
	if (!size){
		std::cerr << "Warning: steck is null! (top)";
		exit (1);
	}
	if (n){
		S_Element<TElset> *pTemp;
		pTemp = pTop;
		while (n--)
			pTemp = pTemp->prev;
		return pTemp->date;
	}
	return pTop->date;
}


template <typename TElset> set<TElset>::~set(){
	while(size--){		
		pFirst = pTop;
		pTop = pTop->prev;
		delete pFirst;		
	}
}


//=============================//

class m_string{
	char *value;
	unsigned size;
public:
	m_string();
	m_string(const char *);
	m_string(char);
	char *c_str();
	int length();
	m_string(const m_string&);
	m_string &operator=(m_string obj);
	m_string &operator+=(m_string obj);
	m_string operator+(m_string obj);
	bool operator==(m_string obj);
	char &operator[](unsigned x);
	m_string copy(unsigned i, unsigned j);
	m_string cut(unsigned i, unsigned j);
	int find(m_string &);
	~m_string();
};

std::ostream &operator<<(std::ostream &out, m_string obj);


//=============================//

m_string::m_string(){
	size = 0;
	value = new char[1];
	value[0] = 0;
}

m_string::m_string(const char *x){
	size = 0;
	for (unsigned i = 0; x[i]; ++i)
		++size;
	value = new char[size + 1];
	for(unsigned i = 0; i <= size; ++i)
		value[i] = x[i];
}

m_string::m_string(char x){
	size = 1;
	value = new char[size + 1];
	value[0] = x;
	value[1] = 0;
}

char *m_string::c_str(){
	return value;
}

int m_string::length(){
	return size;
}

m_string::m_string(const m_string &obj){
	size = obj.size;
	value = new char[size + 1];
	for(unsigned i = 0; i <= size; ++i)
		value[i] = obj.value[i];
}

m_string &m_string::operator=(m_string obj){
	delete [] value;
	size = obj.size;
	value = new char[size + 1];
	for(unsigned i = 0; i <= size; ++i)
		value[i] = obj.value[i];
	return *this;
}

m_string &m_string::operator+=(m_string obj){
	unsigned new_size = size+obj.size;
	char *temp = new char[new_size+1];
	unsigned i = 0;
	for(; i < size; ++i)
		temp[i] = value[i];
	for(unsigned j = 0; j <= obj.size; ++j, ++i)
		temp[i] = obj.value[j];
	size = new_size;
	delete [] value;	
	value = temp;	
	return *this;
}

m_string m_string::operator+(m_string obj){
	unsigned new_size = size+obj.size;
	char *temp = new char[new_size+1];
	unsigned i = 0;
	for(; i < size; ++i)
		temp[i] = value[i];
	for(unsigned j = 0; j <= obj.size; ++j, ++i)
		temp[i] = obj.value[j];
	return m_string(temp);
}

m_string m_string::copy(unsigned i, unsigned j){
	unsigned new_size = j-i+1;
	char *temp = new char[new_size+1];
	for(unsigned n = 0; n < new_size; ++n)
		temp[n] = value[n+i];
	temp[new_size] = 0;
	return m_string(temp);

}
m_string m_string::cut(unsigned i, unsigned j){
	unsigned new_size = size - (j-i+1);
	char *temp = new char[new_size+1];
	int temp_pos = 0;
	for(unsigned n = 0; n < i; ++n)
		temp[temp_pos++] = value[n];
	for(unsigned n = j+1; n < size; ++n)
		temp[temp_pos++] = value[n];
	temp[new_size] = 0;
	return m_string(temp);

}

char &m_string::operator[](unsigned x){
	if (x >= size){
		std::cout << "Error: Index of string!";
		exit(0);
	}
	return value[x];
}
bool m_string::operator==(m_string obj){
	return (strcmp(value, obj.value) == 0);
}

m_string::~m_string(){
	size = 0;
	delete [] value;
}

int m_string::find(m_string &obj){
	int pos = (int)(strstr(value, obj.value) - value);
	if (pos < 0) pos = -1;
	return pos;
}


std::ostream& operator<<(std::ostream& out, m_string obj){
	out << obj.c_str();
	return out;
}


//=============================//

class bigNumber{
	List<char> number;
	int sign;
	int comparison(bigNumber);
public:
	bigNumber();
	bigNumber(char *x);
	bigNumber(int x);
	bigNumber(const bigNumber &);
	bigNumber& operator=(bigNumber);
	bigNumber operator+(bigNumber);
	bigNumber operator-(bigNumber);
	bigNumber operator*(bigNumber);
	bigNumber operator/(bigNumber);
	bigNumber operator%(bigNumber);
	bigNumber operator-();
	bigNumber operator++();
	bigNumber operator--();
	bigNumber operator--(int);
	bigNumber operator++(int);
	void setABS();
	char &operator[](unsigned int);
	bool is_negative(){ return sign==-1;}
	int length() {return number.Size();}
	bool operator<(bigNumber);
	bool operator>(bigNumber);
	bool operator==(bigNumber);
	bool is_even();
	void set_power_of_ten(unsigned x);
	friend std::ostream& operator<<(std::ostream &out, bigNumber);
	~bigNumber();
};


//=============================//

bigNumber::bigNumber(){
	sign = 1;
	number.add(0);
};

void bigNumber::setABS(){
	sign = 1;
}

bigNumber::bigNumber(char *x){
	int i = 0;
	if (x[0] == '-') {
		sign = -1;
		++i;
	} else 
		sign = 1;
	if (x[0] == '+') ++i;
	int len = (int) strlen(x);
	for (; i < len; ++i)
		number.add(x[i]-48);	
}

bigNumber::bigNumber(int x){
	sign = x >=0 ? 1 : -1;
	if (!x)
		number.add_in_begin(0);
	else
		while(x){
			number.add_in_begin(x%10);
			x /= 10;
		}
}

void bigNumber::set_power_of_ten(unsigned int x){
	number.clear();
	this->sign = 1;
	number.add_in_begin(1);
	while(--x+1)
		number.add_in_end(0);	
}

bigNumber::bigNumber(const bigNumber &dst){
	this->sign = dst.sign;
	number = dst.number;
}

bool bigNumber::is_even(){
	return !(this->number[0] & 1);
}

int bigNumber::comparison(bigNumber obj){
	if (this->number.Size() < obj.number.Size())
		return -1;
	if (this->number.Size() > obj.number.Size())
		return 1;
	for (int i = 0; i < this->number.Size(); ++i){
		if (this->number[i] < obj.number[i])
			return -1;
		if (this->number[i] > obj.number[i])
			return 1;
	}
	return 0;
}

bigNumber bigNumber::operator-(){
	sign = -sign;
	return *this;
}

bigNumber& bigNumber::operator=(bigNumber dst){
	this->sign = dst.sign;
	number = dst.number;
	return *this;
}

bigNumber bigNumber::operator+(bigNumber obj){
	if ((this->sign == -1) && (obj.sign == 1)) {
		bigNumber left(*this);
		left.sign = 1;
		return obj-left;
	}
	if ((this->sign == 1) && (obj.sign == -1)){
		obj.sign = 1;
		return *this-obj;
	}
	bigNumber *left, *right;
	if (number.Size() >= obj.length()){
		left = this;
		right = &obj;
	} else {
		left = &obj;
		right = this;
	}
	bigNumber result(*left);
	char carrying=0;
	int index_left = left->number.Size()-1;
	int index_right = right->number.Size()-1;
	while (index_right+1 && index_left+1){
		carrying += left->number[index_left] + right->number[index_right];
		result.number[index_left] = carrying % 10;
		carrying /= 10;
		--index_left;
		--index_right;		
	}
	while(carrying && index_left+1){
		carrying += result.number[index_left];
		result.number[index_left] = carrying % 10;
		carrying /= 10;
		--index_left;
	}
	while(carrying){
		result.number.add_in_begin(carrying%10);
		carrying /= 10;
	}
	return result;
}

bigNumber bigNumber::operator++(){
	int index = this->number.Size()-1;
	int carrying = number[index] + 1;
	number[index--] = carrying % 10;
	carrying /= 10;
	while(carrying && index+1){
		carrying += number[index];
		number[index] = carrying % 10;
		carrying /= 10;
		--index;
	}
	while(carrying){
		number.add_in_begin(carrying%10);
		carrying /= 10;
	}
	return *this;
}

bigNumber bigNumber::operator++(int){
	bigNumber res(*this);
	int index = this->number.Size()-1;
	int carrying = number[index] + 1;
	number[index--] = carrying % 10;
	carrying /= 10;
	while(carrying && index+1){
		carrying += number[index];
		number[index] = carrying % 10;
		carrying /= 10;
		--index;
	}
	while(carrying){
		number.add_in_begin(carrying%10);
		carrying /= 10;
	}
	return res;
}

bigNumber bigNumber::operator--(){
	int borrow = -1;
	int index = number.Size()-1;
	while (index+1 && borrow == -1){
		if (number[index] == 0){
			number[index] = 9;
			borrow = -1;
		} else {
			number[index] -= 1;
			borrow = 0;
		}
		--index;
	}
	while(number[0] == 0 && number.Size() > 1) 
		number.erase();
	return *this;
}

bigNumber bigNumber::operator--(int){
	bigNumber result(*this);
	int borrow = -1;
	int index = number.Size()-1;
	while (index+1 && borrow == -1){
		if (number[index] == 0){
			number[index] = 9;
			borrow = -1;
		} else {
			number[index] -= 1;
			borrow = 0;
		}
		--index;
	}
	while(number[0] == 0 && number.Size() > 1) 
		number.erase();
	return result;
}

bigNumber bigNumber::operator-(bigNumber obj){
	if ((this->sign == 1) && (obj.sign == -1)){
		obj.sign = 1;
		return *this+obj;
	}
	if ((this->sign == -1) && (obj.sign == -1)){
		obj.sign = 1;
		bigNumber temp(*this);
		temp.sign = 1;
		return obj-temp;
	}
	if ((this->sign == -1) && (obj.sign == 1)){
		obj.sign = -1;
		return *this+obj;
	}
	bigNumber *left = this;
	bigNumber *right = &obj;
	int new_sign = 1;
	if (comparison(obj) == -1){
		left = &obj;
		right = this;
		new_sign = -1;
	}
	bigNumber result(*left);	
	result.sign = new_sign;
	int borrow=0, byte=0;
	int index_left = left->number.Size()-1;
	int index_right = right->number.Size()-1;
	while(index_right+1 && index_left+1){
		byte = left->number[index_left] - right->number[index_right]+borrow;
		if (byte < 0){
			byte += 10;
			borrow = -1;
		} else 
			borrow = 0;
		result.number[index_left] = byte;
		--index_left;
		--index_right;	
	}
	if (borrow == -1)
		while (index_left+1 && borrow == -1){
			if (result.number[index_left] == 0){
				result.number[index_left] = 9;
				borrow = -1;
			} else {
				result.number[index_left] -= 1;
				borrow = 0;
			}
			--index_left;
		}
	while(result.number[0] == 0 && result.number.Size() > 1) 
		result.number.erase();
	return result;
}

bigNumber bigNumber::operator*(bigNumber obj){
	if (*this == 1)
		return obj;
	if (obj == 1)
		return *this;
	int w = this->number.Size() + obj.number.Size();
	char *res = new char[w+1];
	for(int i=0; i < w; ++i) res[i] = '0';
	res[w--] = 0;
	bigNumber result(res);
	int carrying = 0;
	int buffer = 0;
	int n = number.Size()-1;
	int m = obj.number.Size()-1;
	for (int i = 0; i < m+1; ++i){
		//if (obj.number[i] == 0) continue;
		for (int j = 0; j < n+1; ++j){
			buffer = number[n-j]*obj.number[m-i]+result.number[w-i-j]+carrying;
			result.number[w-i-j] = buffer % 10;
			carrying = buffer / 10;
		}
		if (carrying){
			result[w-i-n-1] += carrying;
			carrying = 0;
		}
	}
	while(result.number[0] == 0 && result.number.Size() > 1){ 
		result.number.erase();
	}
	result.sign = sign*obj.sign;
	return result;
}

bigNumber bigNumber::operator/(bigNumber obj){
//	std::cout << "\n\ndel = " << obj; 
	if (obj == 1)
		return *this;
	bigNumber result("");
	if (*this < obj){
		result.number.add_in_begin(0);
		return result;
	}
	int q = 0, r = 0;
	bigNumber A(*this);
	A.number.add_in_begin(0);
	int d = 10/(obj.number[0]+1);
	int lenght = 0, carrying = 0, k = 0;
	/* 
 */
	if (d > 1){
		lenght = obj.number.Size();
		for(int i = lenght-1; i+1; --i){
			carrying += obj.number[i]*d;
			obj.number[i] = carrying % 10;
			carrying /= 10;
		}
		lenght = A.number.Size();
		carrying = 0;
		for(int i = lenght-1; i; --i){
			carrying += A.number[i]*d;
			A.number[i] = carrying % 10;
			carrying /= 10;
		}
		A.number[0] = carrying;
	}
	/*-------no error---------*/
	lenght = A.number.Size() - obj.number.Size();
	for (int j = 1; j <= lenght; ++j){
		q = (A.number[j-1]*10+A.number[j])/obj.number[0];
		r = (A.number[j-1]*10+A.number[j])%obj.number[0];
		while(q > 9){
			--q; 
			r += obj.number[0];		
		}
		if (j+1 < obj.number.Size()){
			if (q*obj.number[1] > 10*r+A.number[j+1]){
				--q; 
				r += obj.number[0];
			}
			if ((r < 10) && (q*obj.number[1] > 10*r+A.number[j+1])){
				--q; 
				r += obj.number[0];
			}
		}
		if (j < 4)
		k = carrying = 0;
		for (int n = obj.number.Size()-1; n >= -1; --n){
			if (n+1)
				carrying += obj.number[n] * q;
			A.number[j+n] = (A.number[j+n]-(carrying%10)+k);
			k = 0;
			carrying /= 10;
			if (A.number[j+n] < 0){
				A.number[j+n] += 10;
				--k;
			}
			A.number[j+n] %= 10;
		}
		if (k < 0){
			--q;
			carrying = 0;
			for (int n = obj.number.Size()-1; n >= 0; --n){
					carrying += A.number[j+n]+obj.number[n];
				A.number[j+n] = carrying % 10;
				carrying /= 10;
			}
			A.number[j-1] = (A.number[j-1] + carrying) % 10;
			k = 0;
		}	
		result.number.add(q);
	}
	while(result.number[0] == 0 && result.number.Size() > 1) 
		result.number.erase();
	result.sign = A.sign * obj.sign;
	return result;
}

bigNumber bigNumber::operator%(bigNumber obj){
	if (obj == 1)
		return bigNumber(0);
	int q = 0, r = 0;
	bigNumber A(*this);
	A.number.add_in_begin(0);
	int d = 10/(obj.number[0]+1);
	int lenght = 0, carrying = 0;
	if (d > 1){
		lenght = obj.number.Size();
		for(int i = lenght-1; i+1; --i){
			carrying += obj.number[i]*d;
			obj.number[i] = carrying % 10;
			carrying /= 10;
		}
		lenght = A.number.Size();
		carrying = 0;
		for(int i = lenght-1; i; --i){
			carrying += A.number[i]*d;
			A.number[i] = carrying % 10;
			carrying /= 10;
		}
		A.number[0] = carrying;
	}
	lenght = A.number.Size() - obj.number.Size();
	for (int j = 1; j <= lenght; ++j){
		q = (A.number[j-1]*10+A.number[j])/obj.number[0];
		r = (A.number[j-1]*10+A.number[j])%obj.number[0];
		if (j+1 < obj.number.Size()){
			if (q > 9 || (q*obj.number[1] > 10*r+A.number[j+1])){
				--q; 
				r += A.number[j+1];
			}
			if (q > 9 || (q*obj.number[1] > 10*r+A.number[j+1])){
				--q; 
				r += A.number[j+1];
			}
		} else {
			if (q > 9){
				--q; 
				r += A.number[j+1];
			}
			if (q > 9){
				--q; 
				r += A.number[j+1];
			}		
		}
		int k = carrying = 0;
		for (int n = obj.number.Size()-1; n+2; --n){
			if (n+1)
				carrying += obj.number[n] * q;
			A.number[j+n] = (A.number[j+n]-(carrying % 10)+k) % 10;
			k = 0;
			carrying /= 10;
			if (A.number[j+n] < 0){
				A.number[j+n] += 10;
				--k;
			}
		}
		if (k == -1){
			--q;
			carrying = 0;
			for (int n = obj.number.Size()-1; n+2; --n){
				if (n+1)
					carrying += A.number[j+n]+obj.number[n];
				A.number[j+n] = carrying % 10;
				carrying /= 10;
			}
		}
	}
	while(A.number[0] == 0 && A.number.Size() > 1) 
		A.number.erase();
	A.sign = A.sign * obj.sign;
	return A/(bigNumber)d;
}

char &bigNumber::operator[](unsigned int i){
	if ((int) i >= number.Size())
		i = number.Size()-1;
	return number[i];
}

bool bigNumber::operator<(bigNumber obj){
	if (this->sign == -1 && obj.sign == 1)
		return 1;
	if (this->sign == 1 && obj.sign == -1)
		return 0;
	if (this->sign == -1){
		if (comparison(obj) == -1)
			return 0;
		if (comparison(obj) == 1)
			return 1;
		for (int n = 0; n < this->number.Size(); ++n){
			if (number[n] > obj.number[n])
				return 1;
			if (number[n] < obj.number[n])
				return 0;
		}
			
	} else {
		if (comparison(obj) == -1)
			return 1;
		if (comparison(obj) == 1)
			return 0;
		for (int n = 0; n < this->number.Size(); ++n){
			if (number[n] < obj.number[n])
				return 1;
			if (number[n] > obj.number[n])
				return 0;
		}
	}
	return 0;
}

bool bigNumber::operator>(bigNumber obj){
	if (this->sign == -1 && obj.sign == 1)
		return 0;
	if (this->sign == 1 && obj.sign == -1)
		return 1;
	if (this->sign == -1){
		if (comparison(obj) == -1)
			return 1;
		if (comparison(obj) == 1)
			return 0;
		for (int n = 0; n < this->number.Size(); ++n){
			if (number[n] > obj.number[n])
				return 0;
			if (number[n] < obj.number[n])
				return 1;
		}
			
	} else {
		if (comparison(obj) == -1)
			return 0;
		if (comparison(obj) == 1)
			return 1;
		for (int n = 0; n < this->number.Size(); ++n){
			if (number[n] < obj.number[n])
				return 0;
			if (number[n] > obj.number[n])
				return 1;
		}
	}		
	return 0;
}

bool bigNumber::operator==(bigNumber obj){
	if (this->sign == obj.sign)
		if (this->number.Size() == obj.number.Size()){
			for (int n = 0; n < this->number.Size(); ++n)
				if (number[n] != obj.number[n])
					return 0;
			return 1;
		}
	return 0;
}

bigNumber::~bigNumber(){
	while(number.Size())
		number.erase();
}

std::ostream &operator<<(std::ostream &out, bigNumber obj){
	int count = obj.length();
	if (obj.is_negative()) out << "-";
	for(int i = 0; i < count; ++i)
		out << (char) (obj[i]+48);
	return out;
}


//=============================//

#define PROPER 0
#define IMPROPER 1

class fraction{
	bigNumber a;
	bigNumber b;
	int sign;
	void shorten();
	bigNumber NOD(bigNumber &, bigNumber &);
public:	
	static bool proper;
	static fraction zer;
	static fraction one;
	static fraction two;
	fraction();
	fraction(bool);
	fraction(bigNumber x, bigNumber y = 1);
	fraction(const fraction &);
	fraction(int x, int y = 1);
	fraction numerator();
	fraction denominator();
	fraction integer();
	fraction operator=(int x);
	fraction operator=(bigNumber &obj);
	fraction operator+(fraction &obj);
	fraction operator-(fraction &obj);
	fraction operator*(fraction &obj);
	fraction operator/(fraction &obj);
	fraction operator^(fraction &obj);
	fraction operator-();
	m_string tostr();
	void set_den_ten();
	bool operator==(fraction &obj);
	bool operator!=(fraction &obj);
	bool operator<(fraction &obj);
	bool operator>(fraction &obj);
	bool operator<=(fraction &obj);
	bool operator>=(fraction &obj);
	bool operator||(fraction &obj);
	bool operator&&(fraction &obj);
	fraction negation();
	friend std::ostream& operator<<(std::ostream& out, fraction &);
};


//=============================//

bool fraction::proper = 0;
fraction fraction::zer = 0;
fraction fraction::one = 1;
fraction fraction::two = 2;

fraction::fraction():a(0),b(0),sign(1){a.setABS(); b.setABS();}
fraction::fraction(bool x):a(x == 1),b(1){
	a.setABS();
	b.setABS();
	sign = 1;
}

fraction::fraction(bigNumber x, bigNumber y):a(x),b(y){
	sign = 1;
	if (a.is_negative()) {
		sign = -1;
	}
	if (b.is_negative()) {
		sign *= -1;
		b = -b;
		a = -a;
	}
	a.setABS();
	b.setABS();
}

fraction::fraction(const fraction &obj):a(obj.a), b(obj.b){
	sign = obj.sign;
}

fraction::fraction(int x, int y):a(x),b(y){
	sign = 1;
	if (x < 0)
		sign = -1;
	if (y < 0)
		sign *= -1;
	a.setABS();
	b.setABS();
}

bigNumber fraction::NOD(bigNumber &A, bigNumber &B){
	bigNumber HOD(A%B);
	bigNumber Ost(HOD);
	bigNumber DEL;
	while (Ost > 0){
		A = B;
		B = HOD = Ost;
		DEL = A / B;
		Ost = A % B;
		if (DEL == 0) break;
	}
	if (HOD > 0)
		return HOD;
	else 
		return 0;
}

void fraction::shorten(){
	/* A = B*(A/B) + HOD; */
	bigNumber A(a);
	bigNumber B(b);
	bigNumber HOD(A%B);
	bigNumber Ost(HOD);
	bigNumber DEL;
	while (Ost > 0){
		A = B;
		B = HOD = Ost;
		DEL = A / B;
		Ost = A % B;
		if (DEL == 0) break;
	}
	
	if (HOD > 0 && Ost == 0){	
		a = a / HOD;
		b = b / HOD;
	}
}

m_string fraction::tostr(){
	m_string res;
	if (sign == -1)
		res = (m_string) "-";
	int length = a.length() + b.length() + 1;
	char *temp = new char[length + 1];
	int pos_temp = 0;
	int pos_big = 0;
	while (pos_big < a.length())
		temp[pos_temp++] = (char) (a[pos_big++] + 48);
	temp[pos_temp++] = '_';
	pos_big = 0;
	while (pos_big < b.length())
		temp[pos_temp++] = (char) (b[pos_big++] + 48);
	temp[pos_temp] = 0;
	return res + (m_string) temp;
}
fraction fraction::integer(){
	fraction res(0);
	if (a < b)
		res.a = 0;
	else 
		res.a = a / b;
	return res;
}
fraction fraction::numerator(){
	fraction res(*this);
	res.b = 1;
	return res;
}
fraction fraction::denominator(){
	fraction res(*this);
	res.a = res.b;
	res.b = 1;
	return res;
}

void fraction::set_den_ten(){
	if (this->b == 1)
		this->b.set_power_of_ten(this->a.length());
}

fraction fraction::operator=(bigNumber &obj){
	sign = obj.is_negative() ? -1 : 1;
	a = obj;
	b = 1;
	return *this;
}

fraction fraction::operator=(int x){
	if (x >= 0){
		sign = 1; a = x;
	} else {
		sign = -1; a = -x;
	}
	b = 1;
	return *this;
}

fraction fraction::operator+(fraction &obj){
	fraction result;
	result.a = a*obj.b + obj.a*b;
	result.b = b*obj.b;
	result.sign = result.a.is_negative() ? -1 : 1;
	return result;
}
fraction fraction::operator-(fraction &obj){
	fraction result;
	result.a = a*obj.b - obj.a*b;
	result.b = b*obj.b;
	result.sign = result.a.is_negative() ? -1 : 1;
	return result;
}
fraction fraction::operator*(fraction &obj){
	fraction result;
	result.a = a*obj.a;
	result.b = b*obj.b;
	result.sign = result.a.is_negative() ? -1 : 1;
	return result;
}
fraction fraction::operator/(fraction &obj){
	fraction result;
	result.a = a*obj.b;
	result.b = b*obj.a;
	if (result.b.is_negative()){
		result.b = -result.b;
		result.a = -result.a;
	}
	result.sign = result.a.is_negative() ? -1 : 1;
	return result;
}

fraction fraction::operator^(fraction &obj){
	if (obj < fraction::zer){
		obj = - obj;
		bigNumber x = this->a;
		this->a = this->b;
		this->b = x;	
	}
	if (obj.a == 0)
		return 1;
	if (obj.a == 1)
		return *this;
	fraction summa(1);
	fraction result = 0;	
	fraction stepE = obj;
	fraction stepB = 1;
	while(stepB < stepE){
		result = (*this);
		while (stepB * two <= stepE){
			stepB = stepB * two;
			result = result * result;
		}
		summa = summa * result;
		stepE = stepE - stepB;
		stepB = 1;
		if (stepE == one){
			summa = summa * (*this);
			break;
		}
	}
	return summa;
}

bool fraction::operator==(fraction &obj){
	if (this->sign != obj.sign) return 0;
	if (!(a == obj.a)) return 0;
	if (!(b == obj.b)) return 0;
	return 1;
}

bool fraction::operator!=(fraction &obj){
	if (this->sign != obj.sign) return 1;
	if (!(a == obj.a)) return 1;
	if (!(b == obj.b)) return 1;
	return 0;
}

bool fraction::operator<(fraction &obj){
	if (this->sign != obj.sign && obj.sign == -1) return 0;
	bigNumber A = this->a * obj.b;
	bigNumber B = this->b * obj.a;
	return A < B;
}

bool fraction::operator>(fraction &obj){
	if (this->sign != obj.sign){
		if (this->sign == 1)
			return 1;
		else
			return 0;
	}
	bigNumber A = this->a * obj.b;
	bigNumber B = this->b * obj.a;
	return (A>B);
}

bool fraction::operator<=(fraction &obj){
	if (this->sign != obj.sign && obj.sign == -1) return 0;
	bigNumber A = this->a * obj.b;
	bigNumber B = this->b * obj.a;
	return A < B || A == B;
}

bool fraction::operator>=(fraction &obj){
	if (this->sign != obj.sign && this->sign == -1) return 0;
	bigNumber A = this->a * obj.b;
	bigNumber B = this->b * obj.a;
	return A > B || A == B;
}

bool fraction::operator||(fraction &obj){
	if (this->a == 0 && obj.a == 0)
		return 0;
	return 1;
}

bool fraction::operator&&(fraction &obj){
	if (!(this->a == 0) && !(obj.a == 0))
		return 1;
	return 0;
}

fraction fraction::negation(){
	if (this->a == 0)
		return 1;
	return 0;
}

fraction fraction::operator-(){
	sign *= -1;
	a = -a;
	return *this;
}

std::ostream& operator<<(std::ostream& out, fraction &obj){
	obj.shorten();
	if (obj.sign == -1)
		out << "-";
	bool integer = (!((obj.b == 1) || (obj.b == 0)));
	bool null = 0;
	int count = 0;
	if (!obj.proper){
		if (obj.a > obj.b && integer){
			null = true;
			bigNumber c = obj.a/obj.b;
			count = c.length();
			for(int i = 0; i < count; ++i)
				out << (char) (c[i]+48);
			obj.a = obj.a - c*obj.b;		
		}
	}
	if (!(obj.a == 0)){		
		if (null) out << ".";
		count = obj.a.length();
		for(int i = 0; i < count; ++i)
			out << (char) (obj.a[i]+48);
		if (integer){
			out << "_";
			count = obj.b.length();
			for(int i = 0; i < count; ++i)
				out << (char) (obj.b[i]+48);
		}
	} else
		if (!null)
			out << "0";
	return out;
}


//=============================//

#define CALCULATIONS 1
#define DESCRIPTION_FUNCTION 2
#define EXECUTION_FUNCTION 3

#define CODE_NUL 0
#define CODE_EXP 1
#define CODE_BLO 2
#define CODE_BLC 3
#define CODE_US_IF 4
#define CODE_US_ELSE 8
#define CODE_US_WHILE 16
#define CODE_US_BLOK 32

struct code{
	code(){name=line=cond=0;};
	code(int x, int c, int y) {name = x; cond = c; line = y;};
	int name;
	int cond;
	int line;
};

struct record_run{
	m_string name;
	m_string command;
	int from;
	code code_cond;
	int codes_size;
	int blok_size;
	int pos_name;
};

struct function{
	int count_par;
	m_string *par;
	int begin;
	int end;
	function(int x = 0){
		count_par = begin = end = 0;
		par = NULL;
	}
	function(const function &x){
		count_par = x.count_par;
		begin = x.begin;
		end = x.end;
		par = new m_string[count_par];
		for(int i = 0; i < count_par; ++i)
			par[i] = x.par[i];
	}
	function &operator=(const function x){
		count_par = x.count_par;
		begin = x.begin;
		end = x.end;
		delete [] par;
		par = new m_string[count_par];
		for(int i = 0; i < count_par; ++i)
			par[i] = x.par[i];
		return *this;
	}
	function(char *name, int count, m_string *p, int b, int e){
		count_par = count;
		begin = b; end = e;
		par = new m_string[count_par];
		for(int i = 0; i < count_par; ++i)
			par[i] = (m_string) "0~" + (m_string) name + (m_string) "~" + (m_string) p[i];		
	}
	~function() {delete [] par;};
};

class command{
	int BREAK;
	/* the buffer for input*/
	char buf [80];
	/* the buffer for a command */
	char com [80];
	/* it is long buffers of input */
	int buf_length;
	/* it is long commands */ 
	int com_length;
	/* a position in the buffer */ 
	int buf_pos;
	/* a position in a command */
	int com_pos;
	/* quantity of symbols in a syntactic word */ 
	int word;
	/* an index of a processable command */
	int n_command;
	/* an operating mode */
	int condit;
	/* an operating mode */
	m_string parametrsV [5];
	/* the container of commands */
	List <m_string> list_com;
	/* the container for calls of functions */
	set <record_run> Runs;
	/* the container of operating structures */
	set <code> codes;
	/* check of a symbol for a variable */
	bool is_symbol_vars (char x, bool first = false);
	/* check on a syntactic word */
	bool is_word (char *x); 					 
	/* to take the next command */
	void read ();
	/* to throw off a symbol ' {' */
	void s_blok ();
	/* removal of the information unnecessary already from a stack */
	bool codes_pop (int code, bool from_else, bool from_end);
	/* a name of the caused function */
	m_string name_func;
	/* number of a command with a condition equal False */
	bool endline;
	int miss_of_line;
	fraction lex_fract;
	m_string lex_vars;
	void copy_com(m_string &x);
public:
	/* the container for tracking blocks */
	set <int> set_blok;
	/* the container of variables */
	map <fraction> m_vars;
	/* the list of functions */
	map <function> functions;
	/* a stack of parameters of function */
	set <fraction> param;
	/* to not do calculation */
	bool miss;
	command();
	void Init();
	/* delivery of lexemes in Yacc */
	int nextlex (int Fract, int Vars);
	/* returning of the previous lexeme - fraction */
	fraction get_fract();
	/* Returning of the previous lexeme - variable */
	m_string get_vars();
	/* an operating mode */
	int condition ();
	/* loading of the program from a file */
	void open_file (char *, bool from_begin = 0);
	/* event: the beginning of the description of function */
	void open_func (char *);
	/* event: result of function */
	void return_func (fraction res);
	/* event: a call of function */
	void run_func (char *);
	/* event: expression */
	bool find_expr (int why, int blok = 0);
	void find_break();
	/* event: the description of a condition */
	void find_if (fraction res, int type = 0);
	/* event: the description else */
	void find_else (int type = 0);
	/* event: the description of a cycle while */
	void find_while (fraction res, int type = 0);
	/* event: the description of a cycle for */
	void find_for (fraction res);
	/* event: the description of a cycle for */
	void find_for_small ();
	/* event: the block has opened */
	void blok_open ();
	/* event: the block was closed */
	void blok_close ();
	/* event: a command with a mistake */
	void error_line (char * x = 0);
	/* event: an exit from the program */
	void find_exit ();
	m_string global(m_string x);
};


//=============================//

/* syntactic words */
char *words[] = {"exit", "if", "else", "while", "for", "break", "return", "include", "proper", "improper"};

command::command(){
	BREAK = 0;
	miss = false;
	miss_of_line = -1;
	buf_length = buf_pos = com_length = com_pos = 0;
	n_command = word = 0;	
	condit = CALCULATIONS;
	m_vars.add("ans", 0);
	function new_func(0, 0, 0, 0, 0);
	functions.add("integer", new_func);
	functions.add("numerator", new_func);
	functions.add("denominator", new_func);	
}

void command::Init(){
	buf_length = buf_pos = com_length = com_pos = 0;
	BREAK = word = 0;
	miss = false;		
	miss_of_line = -1;	
}

bool command::is_symbol_vars(char x, bool first){
	bool res =((0x41 <= x && x <= 0x5A) ||
				(0x61 <= x && x <= 0x7A) ||
				(x == 0x7E));
	if (!first && !res)
		res = (0x30 <= x && x <= 0x39);
	return res;
}
bool command::is_word(char *x){
	int count = sizeof(words)/sizeof(char *);
	for (int i = 0; i < count; ++i)
		if (strcmp(words[i], x) == 0)
			return true;
	return false;
}

int command::condition(){	return condit;	}

inline void command::copy_com(m_string &x){
	for (int i = 0, j = 0; i < x.length(); ++i, ++j){
		if (x[i] == '/' && x[i+1] == '*'){
			++i;
			while(!(x[i-1] == '*' && x[i] == '/'))
				++i;
			++i;
		}
		com[j] = x[i];
		if (com[j] == '=' && x[i+1] == '='){
			com[j] = '?';
			++i;
		}
		if (com[j] == '!' && x[i+1] == '='){
			com[j] = '#';
			++i;
		}
		if (com[j] == '+' && x[i+1] == '+'){
			com[j] = '@';
			++i;
		}
		if (com[j] == '-' && x[i+1] == '-'){
			com[j] = '%';
			++i;
		}
	}
}

void command::read(){
	int sizeList = list_com.Size();
	if (0 <= n_command && n_command < sizeList)
		while (list_com[n_command] == m_string("error\n"))
			++n_command;
	/* the index behind last command */
	if (n_command >= sizeList){
		int n_com = sizeList;
		do{
			if (buf_length == buf_pos){
				for (int i = 0; i < 80; ++i) buf[i] = 0;		
				buf_pos = 0;
				if (set_blok.Size())
					std::cout << "> ";
				if (std::cin.eof()) exit(4);
				std::cin.getline(buf, 78, '\n');
				buf_length = 0;
				for(int i = 0; buf[i]; ++i)
					++buf_length;
				buf[buf_length] = '\n';
				buf[++buf_length] = 0;
			}
			while (buf[buf_pos]){
				int pos = 0;
				for (int i = 0; i < 80; ++i) com[i] = 0;
				bool is_simbol = false;
				while (buf[buf_pos]){
					if (buf[buf_pos] == '#')
						while (buf[buf_pos] != '\n')
							++buf_pos;
					com[pos] = buf[buf_pos];
					++buf_pos;
					if (com[pos] == '{'){com[pos+1] = '\n';com[pos+2] = 0;break;}
					if (com[pos] == ';'){com[pos+1] = '\n';com[pos+2] = 0;break;}
					if (com[pos] == '}'){
						if (is_simbol){
							com[pos] = '\n';com[pos+1] = 0;--buf_pos;
						} else {
							com[pos+1] = '\n';com[pos+2] = 0;
						}
						break;
					}
					if (com[pos] != ' ' && com[pos] != '\t') is_simbol = true;
					++pos;	
				}
				if (com[0] != '\n'){list_com.add_in_end(com); ++n_com;}
			}
		} while (n_com == sizeList);
		for (int i = 0; i < 80; ++i) com[i] = 0;
		copy_com(list_com[n_command]);
		return;
	}
	
	if (n_command < 0){
		copy_com(Runs.top().command);
		n_command = Runs.top().from;
		Runs.pop();
		if (!Runs.Size())
			condit = CALCULATIONS;
		return;
	}	
	for (int i = 0; i < 80; ++i) com[i] = 0;
	copy_com(list_com[n_command]);
}
int command::nextlex(int Fract, int Vars){
	endline = false;
	if (com_length == com_pos) {
		read();com_pos = 0;
		if (!codes.is_null() && codes.top().name == CODE_US_IF)
			if (codes.top().cond == CODE_BLC || codes.top().cond == CODE_EXP)
				if (!strstr(com,"else"))
					find_expr(CODE_EXP);
	}
	int symbol;
	if (word){
		symbol = com[com_pos - word--];
		return symbol;
	}
	while ((symbol = com[com_pos++]) == ' ' || symbol == '\t')
		;
	if (symbol == EOF)
		return 0;
	if (isdigit(symbol)){
		m_string number = (char) symbol;
		while((symbol = com[com_pos++]) >='0' && symbol<='9')
			number += (m_string) symbol;
		--com_pos;
		lex_fract = (bigNumber) number.c_str();
		return Fract;
	}
	if (is_symbol_vars(symbol,1)){
		m_string name_var(symbol);
		while(is_symbol_vars(symbol = com[com_pos++]))
			name_var += (m_string)  symbol;
		--com_pos;
		if (is_word(name_var.c_str())){
			word = name_var.length();
			symbol = com[com_pos - word--];
			return symbol;
		} else {
			if (condit == EXECUTION_FUNCTION && name_var[0] != '~')
				name_var = (m_string) "0~" + Runs.top().name + (m_string) "~" + name_var;
			if (condit == DESCRIPTION_FUNCTION && name_var[0] != '~')
				name_var = (m_string) "0~" + name_func + (m_string) "~" + name_var;
		}
		lex_vars = name_var;
		return Vars;			
	}
	if (symbol == '\n'){
		com_pos = com_length;
		++n_command;
		endline = true;
	}
	return symbol;
}

m_string command::global(m_string x){
	if(x[0] == '0'){
		int pos = x.length()-1;
		while (x[pos] != '~') --pos;
		x = x.cut(0,pos);
	}
	return x;
}

fraction command::get_fract(){
	return lex_fract;
}

m_string command::get_vars(){
	return lex_vars;
}

void command::open_func(char * name){
	condit = DESCRIPTION_FUNCTION;
	m_string str;
	int temp_nom_command = n_command+1;
	int temp_pos = 0;
	int nom_param = 0;
	while (list_com[temp_nom_command-1][temp_pos++] != '(');
	while (list_com[temp_nom_command-1][temp_pos] != ')'){
		str = (m_string) "";
		while (list_com[temp_nom_command-1][temp_pos] != ',' &&	list_com[temp_nom_command-1][temp_pos] != ')'){
			if (is_symbol_vars(list_com[temp_nom_command-1][temp_pos]))
				str += (m_string) list_com[temp_nom_command-1][temp_pos];
			++temp_pos;
		}
		if(list_com[temp_nom_command-1][temp_pos] == ',')
			++temp_pos;
		parametrsV[nom_param] = str;
		++nom_param;					
	}
	function new_func(name, nom_param, parametrsV, n_command, 0);
	functions.add(name, new_func);
	name_func = (m_string) name;
	s_blok();
}
void command::run_func(char *name){
	if (endline) --n_command;
	if (!com_pos) com_pos = (int) strlen(com);
	--com_pos;
	record_run temp;
	temp.name = (m_string) name;
	temp.from = n_command;
	temp.command = (m_string) com;
	temp.codes_size = codes.Size();
	temp.blok_size = set_blok.Size();
	if (temp.codes_size)
		temp.code_cond = codes.top();
	int end_pos = com_pos;
	while (com[end_pos] != ')') --end_pos;
	int count_param = 1;
	int count_sk = 0;
	int exit = 1;
	while (count_sk + exit){
		exit = 0;
		if (com[end_pos] == ')') ++count_sk;
		if (com[end_pos] == '(') --count_sk;
		if (com[end_pos] == ',') ++count_param;
		--end_pos;
	}
	temp.pos_name = end_pos;
	Runs.push(temp);
	while(count_param > functions[name].count_par){
		--count_param;
		param.pop();
	}
	if (count_param < functions[name].count_par){
		int i = functions[name].count_par;
		while(i > count_param){		
			m_vars.set(functions[name].par[--i].c_str(),0);
		}
	}
	for(int i = count_param-1; i+1; --i){
		m_vars.set(functions[name].par[i].c_str(),param.pop());
	}
	n_command = functions[name].begin+1;
	condit = EXECUTION_FUNCTION;
	com[com_pos] = ';';	
	com[++com_pos] = '\n';	
	com_pos = 0;
}
void command::return_func(fraction res){
	/* at CALCULATION there is no this event */
	/* at DEF_FUNCTION there is no this event */
	if (condit == EXECUTION_FUNCTION){
		int pos_end = Runs.top().pos_name;
		int pos = pos_end - Runs.top().name.length()+1;		
		int count_skob = 0;
		int exit = 1;
		while (count_skob+exit){
			exit = 0;
			++pos_end;
			if (Runs.top().command[pos_end] == '(') ++count_skob;
			if (Runs.top().command[pos_end] == ')') --count_skob;			
		}
		Runs.top().command = Runs.top().command.copy(0, --pos) + res.tostr() +		 
			Runs.top().command.copy(++pos_end, Runs.top().command.length()-1);
		n_command = -2;
		while(codes.Size() && codes.Size() >= Runs.top().codes_size)
				codes.pop();
		if (Runs.top().codes_size)
			codes.push(Runs.top().code_cond);
		while (Runs.top().blok_size < set_blok.Size())
			set_blok.pop();
	}
}
void command::find_break(){
	int size_st = 0;
	if (Runs.Size()){
		//  
		int size_codes = codes.Size();
		while(size_codes && size_codes >= Runs.top().codes_size){
			if (codes.top(codes.Size() - size_codes).name == CODE_US_WHILE){
				miss = 1;
				miss_of_line = size_codes;
				break;
			} else
				--size_codes;
		}
	} else {
		//   
		int size_codes = codes.Size();
		while(size_codes){
			if (codes.top(codes.Size() - size_codes).name == CODE_US_WHILE){
				miss = 1;
				miss_of_line = size_codes;
				break;
			} else
				--size_codes;
		}
	}
}
void command::find_if(fraction res,int type){
	find_expr(CODE_US_IF,type);
	if (condit == DESCRIPTION_FUNCTION) res = 0;
	if ((bool) (res == fraction::zer) && miss == 0){
		miss = 1;
		miss_of_line = codes.Size();
	}
}
void command::find_else(int type){
	find_expr(CODE_US_ELSE,type);
}
void command::find_while(fraction res,int type){
	find_expr(CODE_US_WHILE,type);
	if (condit == DESCRIPTION_FUNCTION) res = 0;
	if ((bool) (res == fraction::zer)){
		miss = 1;
		miss_of_line = codes.Size();
	}
}
void command::find_for_small(){
	m_string temp = list_com[n_command-1];
	temp[temp.length() - 1] = ' ';
	temp = temp + list_com[n_command];
	temp[temp.length() - 1] = ' ';
	temp = temp + list_com[n_command+1];

	unsigned pos_b = 0, pos_e = 0;
	while(temp[pos_b] != '(') ++pos_b;
	pos_e = pos_b;
	while(temp[pos_e] != ';') ++pos_e;
	m_string a = temp.copy(pos_b+1,pos_e-1);
	pos_b = pos_e++;
	while(temp[pos_e] != ';') ++pos_e;
	m_string b = temp.copy(pos_b+1,pos_e-1);
	pos_b = pos_e;
	int count_skb = 0;
	while (pos_e < (unsigned) temp.length()){
		if (temp[pos_e] == '(') ++count_skb;
		if (temp[pos_e] == ')') --count_skb;
		if (temp[pos_e] == ')' && count_skb == -1)
			break;
		++pos_e;
	}
	m_string c = temp.copy(pos_b+1,pos_e-1);
	m_string d = temp.copy(pos_e+1, (int) temp.length()-1);
	temp = (m_string) "for (5/*" + a + (m_string) "*/;5/*" + c + (m_string) "*/;" + b + (m_string) ")" + d;
	list_com[n_command-1];
	list_com.erase();
	list_com.erase();
	list_com[n_command-1] = temp;
	--n_command;
}
void command::find_for(fraction res){
	find_expr(CODE_US_WHILE,0);	
	if (condit == DESCRIPTION_FUNCTION) res = 0;
	if ((bool) (res == fraction::zer)){
		miss = 1;
		miss_of_line = codes.Size();
	}
	char *buffer = new char[100];
	int i = 0, j = 0;
	for (; i < list_com[n_command].length(); ++i, ++j){
		if (list_com[n_command][i] == '/' && list_com[n_command][i+1] == '*'){
			j-=2;
			i+=1;
		
		} else
		if (list_com[n_command][i] == '*' && list_com[n_command][i+1] == '/'){
			j-=1;	
			i+=1;	
		} else
		buffer[j] = list_com[n_command][i];
	}
	buffer[j] = 0;
	m_string temp = buffer;
	delete [] buffer;
	unsigned pos_b = 0, pos_e = 0;	
	while(temp[pos_b] != '(') ++pos_b;
	pos_e = pos_b;
	while(temp[pos_e] != ';') ++pos_e;
	m_string a = temp.copy(pos_b+1,pos_e-1);
	pos_b = pos_e++;
	while(temp[pos_e] != ';') ++pos_e;
	m_string b = temp.copy(pos_b+1,pos_e-1);
	pos_b = pos_e;
	int count_skb = 0;
	while (pos_e < (unsigned) temp.length()){
		if (temp[pos_e] == '(') ++count_skb;
		if (temp[pos_e] == ')') --count_skb;
		if (temp[pos_e] == ')' && count_skb == -1)
			break;
		++pos_e;
	}
	m_string c = temp.copy(pos_b+1,pos_e-1);
	m_string d = temp.copy(pos_e+1, (int) temp.length()-1);
	if ((bool) (res == fraction::zer)){
		temp = (m_string) "for (" + a + (m_string) ";5/*" +b + (m_string) "*/;5/*" + c + (m_string) "*/)" + d;
	} else {
		temp = (m_string) "for (5/*" + a + (m_string) "*/;"  + b + (m_string) ";" + c + (m_string) ")" + d;
	}
	list_com[n_command] = temp;
}
bool command::codes_pop(int code, bool from_else, bool from_end = 0){
	bool res = false;
	if (!codes.is_null()){
		if (code == CODE_EXP) res = (codes.top().cond == code);
		if (code == CODE_BLC) res = (codes.top().cond == code);
		if (!code) res = ((codes.top().cond == CODE_EXP) || codes.top().cond == CODE_BLC);
	}
	if (!codes.is_null() && res){
		if (codes.top().name == CODE_US_IF && from_end) return false;
		if (codes.top().name == CODE_US_IF){
			if (from_else){
				if(miss == 1){
					if (miss_of_line == codes.Size()){
						miss = 0; miss_of_line = -1;
					} 
				} else {
					miss = 1; miss_of_line = codes.Size();
				}	
			} else {
				if(miss == 1 && miss_of_line == codes.Size()){
					miss = 0; miss_of_line = -1;
				}
			}
			codes.pop();
			return true;
		}
		if (codes.top().name == CODE_US_WHILE){
			if (miss == 0){
					if (codes.top().cond == CODE_EXP)
						n_command = codes.top().line;
					else
						n_command = codes.top().line - 1;
				codes.pop();
				if (!codes.is_null() && codes.top().cond == CODE_EXP)
					codes.top().cond = CODE_NUL;
			} else {
				if (miss_of_line == codes.Size()){
					miss = 0; miss_of_line = -1;
				}					
				codes.pop();
			}
			return true;
		}
		if (codes.top().name == CODE_US_ELSE){
			if(miss == 1 && miss_of_line == codes.Size()){
				miss = 0; miss_of_line = -1;
			}
			codes.pop();
			return true;
		}	
	}
	return false;
}

bool command::find_expr(int why, int blok){
	bool res = false;
	if (why == CODE_US_IF || why == CODE_US_WHILE){
		if (!codes.is_null() && codes.top().cond == CODE_NUL && codes.top().name != CODE_US_BLOK)
			codes.top().cond = CODE_EXP;
		else
			codes_pop(0,0,0);
		codes.push(code(why, CODE_NUL, n_command+blok));
	}
	if (why == CODE_US_ELSE){
		if (codes_pop(0,1,0)){
			codes.push(code(CODE_US_ELSE, CODE_NUL, n_command));
		}
		else
			error_line("The 'if' in not found");
	}
	if (why == CODE_BLO){
		if (!codes.is_null() && codes.top().cond == CODE_NUL && codes.top().name != CODE_US_BLOK){
			codes.top().cond = CODE_BLO;
			return false;
		}
		if (codes_pop(0,0,0)){
			while(codes_pop(0,0,0));
			return false;
		}
		codes.push(code(CODE_US_BLOK, CODE_NUL, n_command));
	}
	if (why == CODE_BLC){
		while(codes_pop(0,0,0));
		if (!codes.is_null() && codes.top().name == CODE_US_BLOK){
			codes.pop();
			return false;
		}
		if (!codes.is_null() && codes.top().cond == CODE_NUL)
			error_line("The opening curly braces is not found");
		if (!codes.is_null() && codes.top().cond == CODE_BLO)
			codes.top().cond = CODE_BLC;
	}
	if (why == CODE_EXP){
		while(codes_pop(0,0,0));			
		if (!codes.is_null() && codes.top().cond == CODE_NUL && codes.top().name != CODE_US_BLOK){
			codes.top().cond = CODE_EXP;
			if (miss == 1 && (codes.top().name == CODE_US_WHILE || codes.top().name == CODE_US_ELSE))
				res = true;
		}
	}
	while(codes_pop(0,0,1));
	return res;
}
void command::blok_open(){
	find_expr(CODE_BLO);
	set_blok.push(n_command);
}
void command::s_blok(){
	int len = list_com[n_command].length();
	list_com[n_command][len-2] = '\n';
	list_com[n_command][len-1] = 0;
	list_com.add("{\n");
}
void command::blok_close(){
	if (set_blok.is_null())
		error_line("The opening curly braces is not found");
	else {
		find_expr(CODE_BLC);
		set_blok.pop();
		if (set_blok.is_null() && condit == DESCRIPTION_FUNCTION)
			condit = CALCULATIONS;
	}
}

void command::open_file(char *x,  bool from_begin){
	int file_buf_pos = 0;
	char * file_com;
	int file_com_pos = 0;
	char * file_buf;
	bool is_simbol;
	if (!from_begin)
		list_com.erase();
	if (list_com.Size() > 0)
		list_com[n_command-1];
	FILE * file;
	if ((file = fopen(x, "r")) == 0){
		std::cout << "Can't find file \"" << x << "\"";
	} else {
		file_buf = new char[10000];
		file_com = new char[100];
		file_buf_pos = 0;
		while (!feof(file))
			file_buf[file_buf_pos++] = fgetc(file);		
		fclose(file);
		file_buf[--file_buf_pos] = '\n';
		file_buf[++file_buf_pos] = 0;
		file_buf_pos = 0;	
		file_com[file_com_pos = 0] = 0;
		while (file_buf[file_buf_pos]){
			file_com_pos = 0;
			is_simbol = false;
			while (file_buf[file_buf_pos]){
				if (file_buf[file_buf_pos] == '#')
					while (file_buf[file_buf_pos] != '\n')
							++file_buf_pos;
				file_com[file_com_pos] = file_buf[file_buf_pos];
				++file_buf_pos;
				if (file_com[file_com_pos] == '\n'){
					file_com[++file_com_pos] = 0;
					break;
				}
				if (file_com[file_com_pos] == '{'){
					file_com[++file_com_pos] = '\n';
					file_com[++file_com_pos] = 0;
					break;
				}
				if (file_com[file_com_pos] == ';'){
					file_com[++file_com_pos] = '\n';
					file_com[++file_com_pos] = 0;
					break;
				}
				if (file_com[file_com_pos] == '}'){
					if (is_simbol){
						file_com[file_com_pos] = '\n';
						file_com[++file_com_pos] = 0;
						--file_buf_pos;
					} else {
						file_com[++file_com_pos] = '\n';
						file_com[++file_com_pos] = 0;
					}
					break;
				}
				if (file_com[file_com_pos] != ' ' && file_com[file_com_pos] != '\t')
					is_simbol = true;
				++file_com_pos;
			}
			if (!file_com[file_com_pos] && file_com[0] != '\n')
				list_com.add(file_com);	
		}
	}
	if (!from_begin)
		list_com.add("exit\n");
	delete [] file_buf;
	delete [] file_com;
	if (n_command >= 0 && !from_begin) --n_command;
}
void command::error_line(char *x){
	std::cout << "*** Error";
	if (x) std::cout << " : " << x; 
	std::cout << "!\n";
	list_com[n_command] = (m_string) "error\n";
	com_length = com_pos;
	++n_command;
}

void command::find_exit(){
	std::cout << std::endl;
	exit(0);
}

