/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: appindex.h,v 0.6 2000/02/26 15:46:57 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __appindex_h
#define __appindex_h

#define LINE_LEN     40960          /* I think this is enough for all lines */

#define INFO_LINES   7

#define CP_HEADER   1
#define CP_NORMAL   2
#define CP_SELECTED 3
#define CP_KEY      4
#define CP_KEYTEXT  5
#define CP_INFOKEY  6
#define CP_INFOVAL  7
#define CP_ERROR    8

#define COLOR_MAX   8

#define T_COLOR(x)	(COLOR_PAIR(x) | (colors[x]&0x88?A_BOLD:0) )

struct category;

struct app {
 char *name;
 char *stable;
 char *devel;
 char *license;
 char *homepage;
 char *download;
 char *changelog;
 char *deb; 
 char *rpm;
 char *link;
 char *oneliner;
 char *description;
 char *author;
 char *coauthor;
 char *dependancy;
 int day;
 int month;
 int year;
 int priority;
 struct category *cat;
 struct app *next;                /* Next application */
 struct app *prev;                /* Previsous application */
};

struct category {
 char *name;
 struct app *apps;
 struct category *next;
 struct category *prev;
 int appno;
};

/* error.c */
extern void trap(int sig);
extern void die(char *s);
extern void error(char *s);
extern void warning(char *s);

extern void loadstat(int n);
extern void loadinfo(char *filename);

/* catsel.c */
extern void category_selection(struct category *cat);

/* appsel.c */
extern void app_selection (struct app *app,int appno);

/* load.c */
extern void load_appindex(char *file);
extern void relink_cat();
extern void add_app2cat(struct category *cat,struct app *app);
extern int relink_app (struct app *apps);
extern void add_app (char *category, struct app *app);
extern void load_file(FILE *);

/* load_txt.c */
extern void load_txt(FILE *);

/* load_db.c */
extern void load_db(FILE *);

/* load_lsm.c */
extern char *compress (char *s);
extern void load_lsm(FILE *);

extern void run_browser(char *url);
extern void parse_config(char *filename);
extern int configure();
extern void null_config();
extern void run_man();
extern char *noquotes(char *);

/* search.c */
extern void search();
extern void do_search(char *);

/* info.c */
extern void info();

/* details.c */
extern void details(struct app * app);
extern void displaytext(int x, int y, int height, int width, char *s);

#define DB_FMDB         1
#define DB_FMTXT        2
#define DB_LSM          3

extern char gendate[LINE_LEN];
extern char *browser;
extern char *download;
extern char *appindexurl;
extern struct category *categories;
extern int catno;
extern int colors[COLOR_MAX+1];
extern int total_apps;
extern int use_lsm;
extern int dbtype;
extern char *dbfile;

#endif
