%{

/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: appindex.l,v 0.6 2000/02/26 15:46:57 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "y.tab.h"
#include <stdlib.h>
#include <unistd.h>

#include "appindex.h"

int lineno = 1;

%}

%%

[ \t]+		;
#.*		;

Browser		{ BEGIN INITIAL; return BROWSER; }
Color		{ BEGIN INITIAL; return COLOR; }
Download	{ BEGIN INITIAL; return DOWNLOAD; }
AppindexURL	{ BEGIN INITIAL; return APPINDEXURL; }

HEADER+          { yylval.ival = CP_HEADER; return INTEGER; }
NORMAL+          { yylval.ival = CP_NORMAL; return INTEGER; }
SELECTED+        { yylval.ival = CP_SELECTED; return INTEGER; }
KEY+             { yylval.ival = CP_KEY; return INTEGER; }
KEYTEXT+         { yylval.ival = CP_KEYTEXT; return INTEGER; }
INFOKEY+         { yylval.ival = CP_INFOKEY; return INTEGER; }
INFOVAL+         { yylval.ival = CP_INFOVAL; return INTEGER; }
ERROR+           { yylval.ival = CP_ERROR; return INTEGER; }

BLACK+          { yylval.ival = 0; return INTEGER; }
RED+            { yylval.ival = 1; return INTEGER; }
GREEN+          { yylval.ival = 2; return INTEGER; }
BROWN+          { yylval.ival = 3; return INTEGER; }
BLUE+           { yylval.ival = 4; return INTEGER; }
MAGENTA+        { yylval.ival = 5; return INTEGER; }
CYAN+           { yylval.ival = 6; return INTEGER; }
LIGHTGRAY+      { yylval.ival = 7; return INTEGER; }

GRAY+           { yylval.ival = 8; return INTEGER; }
LIGHTRED+       { yylval.ival = 9; return INTEGER; }
LIGHTGREEN+     { yylval.ival = 10; return INTEGER; }
YELLOW+         { yylval.ival = 11; return INTEGER; }
LIGHTBLUE+      { yylval.ival = 12; return INTEGER; }
LIGHTMAGENTA+   { yylval.ival = 13; return INTEGER; }
LIGHTCYAN+      { yylval.ival = 14; return INTEGER; }
WHITE+          { yylval.ival = 15; return INTEGER; }

-?[0-9]+        { yylval.ival = atoi(yytext); return INTEGER; }
[^ \t\n]+	{ yylval.sval = yytext; return STRING; }
\"[^\n]*\"+	{ yylval.sval = noquotes(yytext); return STRING; }

\n		{ lineno++; }
%%

int yywrap()
{
    fclose(yyin);
    BEGIN INITIAL;
    return 1;
}

int yyerror(char * msg)
{
    fprintf(stderr, "Error on line %d of config file.\n", lineno);
    return 1;
}

