/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: appsel.c,v 0.6 2000/02/26 15:46:57 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <string.h>
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif

#include "appindex.h"

#define STRING(x) ((x)?(x):"")

char *full_months[12] =
{
  "January", "February", "March", "April", "May", "June",
  "July", "August", "September", "October", "November", "December"
};

static void
draw_appscreen ()
{
  attrset (T_COLOR (CP_HEADER));
  mvprintw (0, 0, "%-*.*s", COLS-22+strlen(gendate),COLS-22-strlen(gendate),
             "appindex browser");
  mvprintw (0, COLS - (strlen (gendate) + 6), "Date: %s", gendate);

  attrset (T_COLOR (CP_KEY));
  mvprintw (LINES - 1, 0, "q,<bs>");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-back ");

  attrset (T_COLOR (CP_KEY));
  printw ("h");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-help ");

  attrset (T_COLOR (CP_KEY));
  printw ("/");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-search ");

  attrset (T_COLOR (CP_KEY));
  printw ("<cr>");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-details ");

  attrset (T_COLOR (CP_KEY));
  printw ("w");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-homepage ");

  attrset (T_COLOR (CP_KEY));
  printw ("d");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-download ");

  attrset (T_COLOR (CP_KEY));
  printw ("f");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-fm ");

  attrset (T_COLOR (CP_KEY));
  printw ("r");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-rpm ");

  attrset (T_COLOR (CP_KEY));
  printw ("e");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-deb ");
  printw ("%*.*s",COLS-80, COLS-80, "");
}

/*
   Draws items on screen[1,LINES-1].
 */
static void
draw_appitems (struct app *current, struct app *selected)
{
  int x;
  char line[0x100];

  for (x = 1; x < LINES - INFO_LINES - 1; x++)
    {
      if (current)
	{
	  if (current == selected)
	    attrset (T_COLOR (CP_SELECTED));
	  else
	    attrset (T_COLOR (CP_NORMAL));
	  strncpy (line, current->name, 0x40);
	  if (strlen (line) > 31)
	    {
	      line[27] = 0;
	      strcat (line, "...");
	    }

	  mvprintw (x, 0, "  %-31.31s", line);

	  if (current->oneliner)
	    strncpy (line, current->oneliner, 0x80);
	  else
	    line[0] = 0;
          line[0x80] = 0;
	  if (strlen (line) > COLS - 35)
	    {
	      line[COLS - 38] = 0;
	      strcat (line, "...");
	    }
	  printw (" %-*.*s ", COLS - 35, COLS - 35, line);

	  current = current->next;
	}
      else
	{
	  attrset (T_COLOR (CP_NORMAL));
	  mvprintw (x, 0, "%*.*s", COLS, COLS, "");	/* Aaaargh! FIXME */
	}
    }

}

static void
draw_appinfo (struct app *app)
{
  char line[0x100];

  attrset (T_COLOR (CP_HEADER));
  strncpy (line, app->cat->name, 0x100);
  strncat (line, ":", 0x100 - strlen (line));
  strncat (line, app->name, 0x100 - strlen (line));
  mvprintw (LINES - INFO_LINES - 1, 0, "%-*.*s", COLS, COLS, line);

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (LINES - INFO_LINES, 0, "License:  ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s", COLS - 56, COLS - 56, STRING (app->license));
  attrset (T_COLOR (CP_INFOKEY));
  printw ("  Stable: ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-8.8s", STRING (app->stable));
  attrset (T_COLOR (CP_INFOKEY));
  printw ("  Devel: ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-8.8s ", STRING (app->devel));

  if (strcmp (STRING (app->deb), ""))
    printw ("[deb]");
  else
    printw ("     ");

  if (strcmp (STRING (app->rpm), ""))
    printw ("[rpm]");
  else
    printw ("     ");

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (LINES - INFO_LINES + 1, 0, "Author:   ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s", COLS - 36, COLS - 36, STRING (app->author));

  attrset (T_COLOR (CP_INFOKEY));
  printw ("Date: ");
  attrset (T_COLOR (CP_INFOVAL));
  if (app->day != 0 && app->month != 0 && app->year != 0)
    {
      sprintf (line, "%02u %s %04u", app->day, full_months[app->month - 1], app->year);
      printw ("%-*.*s", 20, 20, line);
    }
  else
    printw ("                      ");

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (LINES - INFO_LINES + 2, 0, "Homepage: ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s", COLS - 10, COLS - 10, STRING(app->homepage));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (LINES - INFO_LINES + 3, 0, "Download: ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s", COLS - 10, COLS - 10, STRING(app->download));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (LINES - INFO_LINES + 4, 0, "Summary:  ");
  mvprintw (LINES - INFO_LINES + 5, 0, "          ");
  displaytext (10, LINES - INFO_LINES + 4, COLS - 10, 2, STRING(app->oneliner));
}


void
app_selection (struct app *app, int appno)
{
  struct app *cur, *first;
  int curno, totalno;
  int x;

  cur = app;
  first = app;
  curno = 0;
  totalno = 0;

  draw_appscreen ();

  while (1)
    {
      draw_appitems (first, cur);
      draw_appinfo (cur);
      refresh ();
      switch (getch ())
	{
	case 'q':
	case 'Q':
	case KEY_BACKSPACE:
	case KEY_LEFT:
	  return;
	case KEY_DOWN:
	case 'j':
	case 'J':
	  if (cur->next)
	    {
	      if (curno < LINES - INFO_LINES - 3)
		/* Seek to next item _ON_SCREEN */
		curno++;
	      else
		first = first->next;
	      cur = cur->next;
	      totalno++;
	    }
	  break;
	case KEY_UP:
	case 'k':
	case 'K':
	  if (cur->prev)
	    {
	      if (curno > 0)
		curno--;
	      else
		first = first->prev;
	      cur = cur->prev;
	      totalno--;
	    }
	  break;
	case KEY_HOME:
	  cur = first = app;
	  curno = totalno = 0;
	  break;
	case KEY_END:
	  if (appno > LINES - INFO_LINES - 3)
	    {
	      curno = LINES - INFO_LINES - 3;
	      totalno = appno;
	      while (cur->next)
		cur = cur->next;
	      first = cur;
	      for (x = 0; x < LINES - INFO_LINES - 3; x++)
		first = first->prev;
	    }
	  else
	    {
	      first = app;
	      curno = totalno = appno;
	      while (cur->next)
		cur = cur->next;
	    }
	  break;
	case KEY_NPAGE:
	  if (appno > LINES - INFO_LINES - 3)
	    {
	      if (curno != LINES - INFO_LINES - 3)
		{		/* skip to end of screen */
		  while (curno != LINES - INFO_LINES - 3)
		    {
		      cur = cur->next;
		      curno++;
		      totalno++;
		    }
		}
	      else
		/* page down */
		{
		  for (x = 0; x < LINES - INFO_LINES - 3; x++)
		    if (cur->next)
		      {
			cur = cur->next;
			first = first->next;
			totalno++;
		      }
		}
	    }
	  else
	    {
	      first = app;
	      curno = totalno = appno;
	      while (cur->next)
		cur = cur->next;
	    }
	  break;
	case KEY_PPAGE:
	  if (appno > LINES - INFO_LINES - 3)
	    {
	      if (curno != 0)
		{
		  while (curno != 0)
		    {
		      cur = cur->prev;
		      curno--;
		      totalno--;
		    }
		}
	      else
		{
		  for (x = 0; x < LINES - INFO_LINES - 3; x++)
		    if (cur->prev)
		      {
			cur = cur->prev;
			first = first->prev;
			totalno--;
		      }
		}
	    }
	  else
	    {
	      cur = first = app;
	      curno = totalno = 0;
	    }
	  break;
	case 'h':
	case 'H':
	  run_man ();
	  clear ();
	  draw_appscreen ();
	  refresh ();
	  break;
	case 12:
	  clear ();
	  draw_appscreen ();
	  refresh ();
	  break;
	case 'w':
	case 'W':
	  if (cur->homepage[0])
	    run_browser (cur->homepage);
	  else
	    error ("No homepage URL specified!");
	  clear ();
	  draw_appscreen ();
	  refresh ();
	  break;
	case 'd':
	case 'D':
	  if (cur->download[0])
	    run_browser (cur->download);
	  else
	    error ("No download URL specified!");
	  clear ();
	  draw_appscreen ();
	  refresh ();
	  break;
	case '\n':
	case KEY_RIGHT:
	  details (cur);
	  draw_appscreen ();
	  break;
	case 'i':
	case 'I':
	  info ();
	  draw_appscreen ();
	  break;
	case 'f':
	case 'F':
	  if (cur->link[0])
	    run_browser (cur->link);
	  else
	    error ("No freshmeat link URL specified!");
	  clear ();
	  draw_appscreen ();
	  refresh ();
	  break;
	case 'r':
	case 'R':
	  if (cur->rpm[0])
	    run_browser (cur->rpm);
	  else
	    error ("No .rpm package specified!");
	  clear ();
	  draw_appscreen ();
	  refresh ();
	  break;
	case 'e':
	case 'E':
	  if (cur->deb[0])
	    run_browser (cur->deb);
	  else
	    error ("No .deb package specified!");
	  clear ();
	  draw_appscreen ();
	  refresh ();
	  break;
	case 'c':
	case 'C':
	  if (cur->changelog[0])
	    run_browser (cur->changelog);
	  else
	    error ("No changelog URL specified!");
	  clear ();
	  draw_appscreen ();
	  refresh ();
	  break;
	case '/':
	  search ();
	  draw_appscreen ();
	  refresh ();
	  break;
	}			/* switch */
    }				/* while */
}				/* void app_selection */
