/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: catsel.c,v 0.6 2000/02/26 15:46:57 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <string.h>
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif

#include "appindex.h"

static void
draw_catscreen ()
{
  attrset (T_COLOR (CP_HEADER));
  mvprintw (0, 0, "%-*.*s", COLS-22+strlen(gendate),COLS-22-strlen(gendate),
             "appindex browser");
  mvprintw (0, COLS - (strlen (gendate) + 6), "Date: %s", gendate);

  attrset (T_COLOR (CP_KEY));
  mvprintw (LINES - 1, 0, "q");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-quit ");

  attrset (T_COLOR (CP_KEY));
  printw ("h");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-help ");

  attrset (T_COLOR (CP_KEY));
  printw ("<cr>");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-see category ");

  attrset (T_COLOR (CP_KEY));
  printw ("i");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-info ");

  attrset (T_COLOR (CP_KEY));
  printw ("/");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-search ");

  printw ("%*.*s",COLS-48, COLS-48, "");

}

/*
   Draws items on screen[1,LINES-1].
 */
void
draw_items (struct category *current, struct category *selected)
{
  int x;

  for (x = 1; x < LINES - 1; x++)
    {
      if (current == selected)
	attrset (T_COLOR (CP_SELECTED));
      else
	attrset (T_COLOR (CP_NORMAL));
      if (current)
	{
	  mvprintw (x, 0, "  %-*.*s %3u apps  ",
		    COLS - 13, COLS - 13, current->name, current->appno);
	  current = current->next;
	}
      else
	{
	  mvprintw (x, 0, "  %-*.*s", COLS - 2, COLS - 2, "");	/* FIXME */
	}
    }

}


void
category_selection (struct category *cat)
{
  struct category *cur, *first;
  int curno, totalno;
  int x;

  cur = cat;
  first = cat;
  curno = 0;
  totalno = 0;

  while (1)
    {
      draw_catscreen ();
      draw_items (first, cur);
      refresh ();
      switch (getch ())
	{
	case 'q':
	case 'Q':
	  return;
	case KEY_DOWN:
	case 'j':
	case 'J':
	  if (cur->next)
	    {
	      if (curno < LINES - 3)
		/* Seek to next item _ON_SCREEN */
		curno++;
	      else
		first = first->next;
	      cur = cur->next;
	      totalno++;
	    }
	  break;
	case KEY_UP:
	case 'k':
	case 'K':
	  if (cur->prev)
	    {
	      if (curno > 0)
		curno--;
	      else
		first = first->prev;
	      cur = cur->prev;
	      totalno--;
	    }
	  break;
	case KEY_HOME:
	  cur = first = cat;
	  curno = totalno = 0;
	  break;
	case KEY_END:
	  if (catno > LINES - 3)
	    {
	      curno = LINES - 3;
	      totalno = catno;
	      while (cur->next)
		cur = cur->next;
	      first = cur;
	      for (x = 0; x < LINES - 3; x++)
		first = first->prev;
	    }
	  else
	    {
	      first = cat;
	      curno = totalno = catno;
	      while (cur->next)
		cur = cur->next;
	    }
	  break;
	case KEY_NPAGE:
	  if (catno > LINES - 3)
	    {
	      if (curno != LINES - 3)
		{		/* skip to end of screen */
		  while (curno != LINES - 3)
		    {
		      cur = cur->next;
		      curno++;
		      totalno++;
		    }
		}
	      else
		/* page down */
		{
		  for (x = 0; x < LINES - 3; x++)
		    if (cur->next)
		      {
			cur = cur->next;
			first = first->next;
			totalno++;
		      }
		}
	    }
	  else
	    {
	      first = cat;
	      curno = totalno = catno;
	      while (cur->next)
		cur = cur->next;
	    }
	  break;
	case KEY_PPAGE:
	  if (catno > LINES - 3)
	    {
	      if (curno != 0)
		{
		  while (curno != 0)
		    {
		      cur = cur->prev;
		      curno--;
		      totalno--;
		    }
		}
	      else
		{
		  for (x = 0; x < LINES - 3; x++)
		    if (cur->prev)
		      {
			cur = cur->prev;
			first = first->prev;
			totalno--;
		      }
		}
	    }
	  else
	    {
	      cur = first = cat;
	      curno = totalno = 0;
	    }
	  break;
	case KEY_RIGHT:
	case '\n':
	  app_selection (cur->apps, cur->appno);
	  break;
	case 'h':
	case 'H':
	  run_man ();
	  clear ();
	  draw_catscreen ();
	  refresh ();
	  break;
	case 'i':
	case 'I':
	  info ();
	  draw_catscreen ();
	  refresh ();
	  break;
	case 12:
	  clear ();
	  draw_catscreen ();
	  refresh ();
	  break;
	case '/':
	  search ();
	  draw_catscreen ();
	  refresh ();
	  break;
	}
    }
}
