

/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: config.c,v 0.6 2000/02/26 15:46:57 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <string.h>
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif

#include "appindex.h"

char *browser;
char *download;
char *appindexurl;
int colors[COLOR_MAX + 1];

extern FILE *yyin;
extern int yyparse (void);

void
parse_config (char *filename)
{

  yyin = fopen (filename, "r");

  if (!yyin)
    {
      return;
    }

  if (yyparse ())
    {
      exit (1);
    }
}

int
configure ()
{
  if (!browser)
    browser = strdup ("lynx");

  if (!download)
    download = strdup ("lynx");

  if (!browser || !download)
    {
      fprintf (stderr, "No memory!\n");
      return -1;
    }

  if (browser[strlen (browser) - 1] != ' ')
    strcat (browser, " ");

  if (download[strlen (download) - 1] != ' ')
    strcat (download, " ");

  if (colors[CP_HEADER] == 0)
    colors[CP_HEADER] = (COLOR_BLACK << 4) | COLOR_WHITE;
  if (colors[CP_NORMAL] == 0)
    colors[CP_NORMAL] = (COLOR_WHITE << 4) | COLOR_BLACK;
  if (colors[CP_SELECTED] == 0)
    colors[CP_SELECTED] = (COLOR_BLACK << 4) | COLOR_WHITE;
  if (colors[CP_KEY] == 0)
    colors[CP_KEY] = (COLOR_BLACK << 4) | COLOR_WHITE;
  if (colors[CP_KEYTEXT] == 0)
    colors[CP_KEYTEXT] = (COLOR_BLACK << 4) | COLOR_WHITE;
  if (colors[CP_INFOKEY] == 0)
    colors[CP_INFOKEY] = (COLOR_WHITE << 4) | COLOR_BLACK;
  if (colors[CP_INFOVAL] == 0)
    colors[CP_INFOVAL] = (COLOR_WHITE << 4) | COLOR_BLACK;
  if (colors[CP_ERROR] == 0)
    colors[CP_ERROR] = (COLOR_BLACK << 4) | COLOR_WHITE;
  return 0;
}

void
null_config ()
{
  int x;

  browser = 0;
  for (x = 0; x <= COLOR_MAX; x++)
    colors[x] = 0;

}

char *
noquotes (char *s)
{
  char *s2, *d;

  if (!s)
    return 0;

  if (s[0] == '\"')
    s++;

  s2 = d = s;
  while (*s2)
    {
      if (*s2 == '\\')
	s2++;
      *d = *s2;
      if (*s2 == '\"')
	if (s2[1] == 0)
	  *d = 0;
      d++;
      s2++;
    }
  *d = 0;
  return s;
}
