/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: details.c,v 0.6 2000/02/26 15:46:57 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif

#include "appindex.h"

#define STRING(x) ((x)?(x):"")

void
displaytext (int x, int y, int height, int width, char *s)
{
  int idx, z;

  attrset (T_COLOR (CP_INFOVAL));

  if (!s)
    return;

  while (*s && width)
    {
      if (strlen (s) > height)
	{
	  idx = 0;
	  for (z = height; (z > height - 10) && (idx == 0); z--)
	    if (s[z] == ' ' || s[z] == '\t')
	      idx = z;
	  if (idx == 0)
	    idx = height;
	}
      else
	{
	  idx = strlen (s);
	}

      mvprintw (y, x, "%*.*s", idx, idx, s);
      printw ("%*.*s", height - idx, height - idx, "");
      while (s[idx] == ' ')
	idx++;
      s += idx;
      y++;
      width--;
    }
  while (width--)
    mvprintw (y++, x, "%*.*s", height, height, "");
}

static void
draw_detailscreen (struct app *app)
{
  char temp[0x100];
  int i;

  attrset (T_COLOR (CP_HEADER));
  mvprintw (0, 0, "%-*.*s", COLS-22+strlen(gendate),COLS-22-strlen(gendate),
             "appindex browser");
  mvprintw (0, COLS - (strlen (gendate) + 6), "Date: %s", gendate);

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (1, 0, "%-*.*s", COLS,COLS,"");
  mvprintw (1, (COLS - strlen (app->name)) / 2, "%s", app->name);

  displaytext (0, 2, COLS, 3, app->oneliner);

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (5, 0, "Version:     ");
  attrset (T_COLOR (CP_INFOVAL));
  if (app->stable)
    if (app->stable[0]) 
      sprintf (temp, "stable %s%s", STRING (app->stable),
	      app->devel ? app->devel[0] ? ", " : "" : "");
  if (app->devel)
    if (app->devel[0])
      sprintf (temp, "devel %s", STRING (app->devel));
  printw ("%-*.*s",COLS-13,COLS-13,temp);

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (6, 0, "License:     ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s", COLS-13,COLS-13,STRING (app->license));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (7, 0, "Category:    ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s", COLS-13,COLS-13, STRING (app->cat->name));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (8, 0, "Author:      ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s", COLS-13,COLS-13,STRING (app->author));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (9, 0, "Co-author:   ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s", COLS-13,COLS-13,STRING (app->coauthor));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (10, 0, "Homepage:    ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s",COLS-13,COLS-13, STRING (app->homepage));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (11, 0, "Download:    ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s", COLS-13,COLS-13, STRING (app->download));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (12, 0, "DEB package: ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s",COLS-13,COLS-13, STRING (app->deb));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (13, 0, "RPM package: ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s",COLS-13,COLS-13, STRING (app->rpm));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (14, 0, "Freshmeat:   ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s",COLS-13,COLS-13, STRING (app->link));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (15, 0, "Dependancy:  ");
  attrset (T_COLOR (CP_INFOVAL));
  printw ("%-*.*s",COLS-13,COLS-13, STRING (app->dependancy));

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (16, 0, "Description: ");
  attrset (T_COLOR (CP_INFOVAL));

  for (i=0;i<LINES-18;i++)
    mvprintw (i+17, 0, "             ");
  displaytext (13, 16, COLS - 13, LINES - 17, STRING (app->description));

  attrset (T_COLOR (CP_KEY));
  mvprintw (LINES - 1, 0, "q,<bs>");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-back ");

  attrset (T_COLOR (CP_KEY));
  printw ("h");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-help ");

  attrset (T_COLOR (CP_KEY));
  printw ("/");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-search ");

  attrset (T_COLOR (CP_KEY));
  printw ("w");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-homepage ");

  attrset (T_COLOR (CP_KEY));
  printw ("d");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-download ");

  attrset (T_COLOR (CP_KEY));
  printw ("f");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-fm ");

  attrset (T_COLOR (CP_KEY));
  printw ("r");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-rpm ");

  attrset (T_COLOR (CP_KEY));
  printw ("e");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-deb ");

  attrset (T_COLOR (CP_KEY));
  printw ("c");
  attrset (T_COLOR (CP_KEYTEXT));
  printw ("-changelog");

  printw ("%*.*s",COLS-78, COLS-78, "");

}

void
details (struct app *app)
{
  clear ();
  draw_detailscreen (app);
  refresh ();

  while (1)
    {
      switch (getch ())
	{
	case 'q':
	case 'Q':
	case KEY_BACKSPACE:
	case KEY_LEFT:
	  return;
	case 'h':
	case 'H':
	  run_man ();
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 12:
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case '/':
	  search ();
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'w':
	case 'W':
	  if (app->homepage && app->homepage[0])
	    run_browser (app->homepage);
	  else
	    error ("No homepage URL specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'd':
	case 'D':
	  if (app->download && app->download[0])
	    run_browser (app->download);
	  else
	    error ("No download URL specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'f':
	case 'F':
	  if (app->link && app->link[0])
	    run_browser (app->link);
	  else
	    error ("No freshmeat link URL specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'r':
	case 'R':
	  if (app->rpm && app->rpm[0])
	    run_browser (app->rpm);
	  else
	    error ("No .rpm package specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'e':
	case 'E':
	  if (app->deb && app->deb[0])
	    run_browser (app->deb);
	  else
	    error ("No .deb package specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'c':
	case 'C':
	  if (app->changelog && app->changelog[0])
	    run_browser (app->changelog);
	  else
	    error ("No changelog URL specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	}			/* switch */
    }				/* while */
}				/* details */
