/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: error.c,v 0.6 2000/02/26 15:46:57 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif

#include "appindex.h"

void
die (char *s)
{
  attrset (T_COLOR (CP_ERROR));
  mvprintw (LINES - 1, 0, "%-*.*s", COLS, COLS, s);
  refresh ();
  getch ();
  trap (1);
}

void
error (char *s)
{
  attrset (T_COLOR (CP_ERROR));
  mvprintw (LINES - 1, 0, "%-*.*s", COLS, COLS, s);
  refresh ();
  getch ();
}

void
warning (char *s)
{
  printf ("Warning:%s\n", s);
}

void
loadinfo (char *filename)
{
  char line[0x100];

  attrset (T_COLOR (CP_NORMAL));
  snprintf (line, 0x100, "Using %-80.80s", filename);
  mvprintw (LINES - 2, 0, "%-*.*s", COLS, COLS, line);
  clrtoeol ();
  refresh ();
}

void
loadstat (int num)
{
  char line[0x100];

  if ((num % 100) == 0)
    {
      attrset (T_COLOR (CP_HEADER));
      snprintf (line, 0x100, "Loading: %u applications", num);
      mvprintw (LINES - 1, 0, "%-*.*s", COLS, COLS, line);
      clrtoeol ();
      refresh ();
    }
}
