/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: info.c,v 0.6 2000/02/26 15:46:57 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "intl.h"
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif

#include "appindex.h"

#define INFO_ROWS 9

static char *dbtypes[4] = {"","Freshmeat Appindex-DB", "Freshmeat Appindex-TXT",
                           "Linux Software Map"};

char *
endofstring (char *s, int n)
{
  if (strlen (s) > n)
    return s + (strlen (s) - n);
  return s;
}


void
info ()
{
  clear ();

  attrset (T_COLOR (CP_HEADER));
  mvprintw (0, 0, "%-*.*s", COLS, COLS,
	    _("appindex browser (c) 1999,2000 Martin Hinner <mhi@penguin.cz>") );

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (LINES - INFO_ROWS + 1, 0, _("Appindex database") );
  attrset (T_COLOR (CP_INFOVAL));
  mvprintw (LINES - INFO_ROWS + 3, 0, _("Created : %s"), gendate);
  mvprintw (LINES - INFO_ROWS + 4, 0, _("Entries : %u"), total_apps);
  mvprintw (LINES - INFO_ROWS + 5, 0, _("File    : %s"),
	    endofstring (dbfile, COLS / 2 - 11));
  mvprintw (LINES - INFO_ROWS + 6, 0, _("Type    : %s"), dbtypes[dbtype] );

  attrset (T_COLOR (CP_INFOKEY));
  mvprintw (LINES - INFO_ROWS + 1, COLS / 2, "Appindex browser");
  attrset (T_COLOR (CP_INFOVAL));
  mvprintw (LINES - INFO_ROWS + 3, COLS / 2, "Created  : $Date: 2000/02/26 15:46:57 $");
  mvprintw (LINES - INFO_ROWS + 4, COLS / 2, "Revision : $Revision: 0.6 $");
  mvprintw (LINES - INFO_ROWS + 5, COLS / 2, "Compiled : " __DATE__ ", " __TIME__);
  mvprintw (LINES - INFO_ROWS + 6, COLS / 2, "           " BUILDHOST );

  refresh ();
  error ("Press any key.");
}
