/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: load_lsm.c,v 0.6 2000/02/26 15:46:57 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/stat.h>
#include <time.h>

#include "appindex.h"

static char *months[12] =
{
  "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
  "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"
};

int
skip_to_next_lsm (FILE * f)
{
  char *line;

  line = (char *) malloc (LINE_LEN);
  if (!line)
    die ("Not enough memory!");

  while (fgets (line, LINE_LEN, f))
    {
      if ((!strncmp (line, "Begin3", 6)) || (!strncmp(line, "Begin4", 6)) )
	{
	  free (line);
	  return 1;
	}
    }

  free (line);
  return 0;
}


char *
compress (char *s)
{
  char *d = s, *o = s;

  while (isspace (*s) || *s=='\t')
    s++;

  while (*s)
    {
      if (*s == '\t')
	*s = ' ';
      if ((*s != '\n') && (!(isspace (*s) && isspace (*(s + 1)))))
	*d++ = *s;
      s++;
    }
  *d = 0;
  return o;
}

char getfirstchar(char *s)
{
  char *ss;

  if (s == NULL) 
    return 0;
  ss = s;
  while (*ss) {
   if (isalnum(*ss))
     return toupper(*ss);
   ss++;
  }
  return *s;
}

char *parse_download(char *download)
{
 char *s,*url,*part2;
 int i;

 if (download == NULL)
   return NULL;
 if (!strcmp(download,""))
   return NULL;
 if (!strcmp(download,"-"))
   return NULL;

 s = download;
 /* Skip first part */
 while (*s && *s!=' ' && *s!='\t')
  s++;
 while (*s==' ' || *s=='\t')
  s++;

 /* Skip second part */
 part2 = s;
 while (*s && *s!=' ' && *s!='\t')
  s++;
 *s=0;

 if (isdigit(part2[0])) {
   s = download;
   /* Skip first part */
   while (*s && *s!=' ' && *s!='\t')
     s++;
   *s = 0;
 }

 /* Two {proto}:// URLS specified */
 if ( (!strncmp(download,"http://",7) || !strncmp(download,"ftp://",6)) &&
       (!strncmp(part2,"http://",7) || !strncmp(part2,"ftp://",6)) ) {
   s = download;
   /* Skip first part */
   while (*s && *s!=' ' && *s!='\t')
     s++;
   *s = 0;
 }

#if 0
 ok=1;
 s = download;
 /* Scan first part */
 while (*s && *s!=' ' && *s!='\t') {
   if (*s=='/') 
    ok=0;
   s++;
 }

 if (!ok) {
   s = download;
   /* Skip first part */
   while (*s && *s!=' ' && *s!='\t')
     s++;
   *s = 0;
 }
#endif

 if (!strchr(download,' ') && !strchr(download,'\t')) {
  /* Only one part */
  if (!strncmp(download,"ftp://",6))
   return download;
  if (!strncmp(download,"http://",7))
   return download;
  if (!strncmp(download,"www",3)) {
    url = (char *)malloc(strlen(download)+8);
    if (url) {
      strcpy(url,"http://");
      strcat(url,download);
    }
    free(download);
    return url;
  }
  url = (char *)malloc(strlen(download)+7);
  if (url) {
    strcpy(url,"ftp://");
    strcat(url,download);
  }
  free(download);
  return url;
 }/* if */

 /* Truncate first par */
 s = download;
 while (*s && *s!=' ' && *s!='\t')
   s++;
 *s = 0;

 if (!strncmp(download,"http://",7) || !strncmp(download,"ftp://",6)) {
   url = (char *)malloc(strlen(download)+strlen(part2)+2);
   if (url) {
     strcpy(url,download);
     strcat(url,"/");
     strcat(url,part2);
   }
   free(download);
   return url;
 }

 if (!strncmp(download,"www",3)) {
   url = (char *)malloc(strlen(download)+strlen(part2)+10);
   if (url) {
     strcpy(url,"http://");
     strcat(url,download);
     strcat(url,"/");
     strcat(url,part2);
   }
   free(download);
   return url;
 }

 url = (char *)malloc(strlen(download)+strlen(part2)+10);
 if (url) {
   strcpy(url,"ftp://");
   strcat(url,download);
   strcat(url,"/");
   strcat(url,part2);
 }
 free(download);
 return url;
}

void
load_lsm (FILE * f)
{
  char *line, *buf;
  struct app *app;
  char category[0x10];
  int i;
  struct stat statbuf;
  struct tm *tm;

  dbtype = DB_LSM;
  if (fstat(fileno(f), &statbuf) >= 0) {
    tm = localtime(&statbuf.st_mtime);
    strftime(gendate, LINE_LEN, "%b %d %Y, %H:%M", tm);
  }
  

  line = (char *) malloc (LINE_LEN);
  if (!line)
    return;
  buf = (char *) malloc (LINE_LEN);
  if (!buf)
    return;
  buf[0] = 0;

  do
    {
      app = (struct app *) malloc (sizeof (struct app));
      if (!app)
	return;
      memset (app, 0, sizeof (struct app));

      while (fgets (line, LINE_LEN, f))
	{
	  if (line[0] == '\n')
	    continue;

	  if (isalpha (line[0]) && buf[0])
	    {
	      //printf("[%s]\r\n",buf);
#define GET_ITEM(x,y) \
	      if (!strncmp (buf, x, sizeof (x) - 1 )) \
		{ \
		  app->y = strdup (compress (buf + (sizeof(x) - 1) )); \
		}

	      GET_ITEM ("Title:", name);
	      GET_ITEM ("Copying-policy:", license);
	      GET_ITEM ("Author:", author);
	      GET_ITEM ("Description:", description);
	      GET_ITEM ("Version:", stable);
	      GET_ITEM ("Primary-site:", download);

	      if (!strncmp (buf, "Entered-date:", 13))
		{
		  compress (buf + 13);
#define ATON(x) (x-'0')
		  if (buf[17] == '-' && buf[20] == '-') {
	            /* YYYY-MM-DD */
		    app->year = ATON (buf[13]) * 1000 + ATON (buf[14]) *100 + 
                                  ATON (buf[15]) * 10 + ATON (buf[16]);
		    app->month = ATON (buf[18]) * 10 + ATON (buf[19]);
		    app->day = ATON (buf[21]) * 10 + ATON (buf[22]);
		  } else {
	            /* DD-MMM-YY */
		    app->day = ATON (buf[13]) * 10 + ATON (buf[14]);
		    app->year = 1900 + ATON (buf[18]) * 10 + ATON (buf[19]);
		    for (i = 0; i < 12; i++)
		      if (!memcmp (buf + 15, months[i], 3))
		        app->month = i + 1;
                  }
#undef ATON
		}

#undef GET_ITEM
	      strcpy (buf, line);
	    }
	  if (!isalpha (line[0]))
	    if (strlen (line) + strlen (buf) < LINE_LEN)
	      strcat (buf, line);
	  if (!memcmp (line, "End\n", 4))
	    break;
	}
      if (app->name)
	{
	  total_apps++;
	  if (app->name)
	    {
	      if (category[0] = toupper(getfirstchar(app->name)))
		{
		  category[1] = '.';
		  category[2] = '.';
		  category[3] = '.';
		  category[3] = 0;
		}
	      else
		strcpy (category, "(unnamed)");
              if (app->description)
                 if (strlen(app->description)<160)
                   app->oneliner = strdup(app->description);
                     else {
                       app->oneliner = (char *)malloc(160);
                       if (app->oneliner) {
                         memcpy(app->oneliner,app->description,156);
                         app->description[196] = '.';
                         app->description[197] = '.';
                         app->description[198] = '.';
                         app->description[199] = 0;
                       }
                     }
              app->download = parse_download(app->download);
	      add_app (category, app);
	    }
	}
      loadstat (total_apps);
    }
  while (skip_to_next_lsm (f));

  free (line);
}
