/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: load_txt.c,v 0.6 2000/02/26 15:46:57 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "appindex.h"

#define APPINDEX_PREFIX "http://freshmeat.net/appindex/"

char *header[] =
{
  "",
  "syntax:",
  "name",
  "stable",
  "devel",
  "section/category",
  "license",
  "homepage",
  "download",
  "changelog",
  "deb",
  "rpm",
  "link",
  "oneliner",
  0
};

int
skip_to_next_app (FILE * f)
{
  char *line;

  line = (char *) malloc (LINE_LEN);
  if (!line)
    die ("Not enough memory!");

  while (fgets (line, LINE_LEN, f))
    {
      if (!strcmp (line, "%%\n"))
	{
	  free (line);
	  return 1;
	}
    }

  free (line);
  return 0;
}

void
load_txt (FILE * f)
{
  char *line;
  int n;
  struct app *app;
  char *category;

  dbtype = DB_FMTXT;

  line = (char *) malloc (LINE_LEN);
  if (!line)
    return;

  if (!fgets (line, LINE_LEN, f))
    return;

  if (line[strlen (line) - 1] == '\n')
    line[strlen (line) - 1] = 0;
  if (strncmp (line, "Date of generation: ", 20))
    return;
  strcpy (gendate, line + 20);

  n = 0;
  while (header[n])
    {
      if (!fgets (line, LINE_LEN, f))
	return;

      if (line[strlen (line) - 1] == '\n')
	line[strlen (line) - 1] = 0;
      if (strcmp (line, header[n]))
	return;
      n++;
    }

  while (skip_to_next_app (f))
    {
      app = (struct app *) malloc (sizeof (struct app));
      if (!app)
	return;

#define GET_ITEM(x) \
      if (!fgets(line,LINE_LEN,f)) \
        die("Broken data file"); \
      if (line[strlen (line) - 1] == '\n') \
	line[strlen (line) - 1] = 0; \
      x = strdup(line); \
      if (!x) \
        return ;

      GET_ITEM (app->name);
      GET_ITEM (app->stable);
      GET_ITEM (app->devel);
      GET_ITEM (category);
      GET_ITEM (app->license);
      GET_ITEM (app->homepage);
      GET_ITEM (app->download);
      GET_ITEM (app->changelog);
      GET_ITEM (app->deb);
      GET_ITEM (app->rpm);
      GET_ITEM (app->link);
      GET_ITEM (app->oneliner);
      app->description = 0;
      app->dependancy = 0;
      app->author = 0;
      app->coauthor = 0;
      if (!strncmp (app->link, APPINDEX_PREFIX, strlen (APPINDEX_PREFIX)))
	{
#define ATON(x) (x-'0')
	  app->day = ATON (app->link[strlen (APPINDEX_PREFIX) + 8]) * 10 +
	    ATON (app->link[strlen (APPINDEX_PREFIX) + 9]);
	  app->month = ATON (app->link[strlen (APPINDEX_PREFIX) + 5]) * 10 +
	    ATON (app->link[strlen (APPINDEX_PREFIX) + 6]);
	  app->year = ATON (app->link[strlen (APPINDEX_PREFIX)]) * 1000 +
	    ATON (app->link[strlen (APPINDEX_PREFIX) + 1]) * 100 +
	    ATON (app->link[strlen (APPINDEX_PREFIX) + 2]) * 10 +
	    ATON (app->link[strlen (APPINDEX_PREFIX) + 3]);
#undef  ATON
	}
      else
	{
	  app->day = app->month = app->year = 0;
	}
#undef GET_ITEM
      total_apps++;
      add_app (category, app);
      loadstat (total_apps);
      free (category);
    }				/*while() */

  free (line);
}
