/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: main.c,v 0.6 2000/02/26 15:46:57 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/wait.h>
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else
#include "getopt.h"
#endif
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif

#include "appindex.h"

static char *usage =
"Usage: %s [OPTION] [FILE]\n"
"\n"
"   -c [file]        Configuration file instead of default\n"
"   -s [searchstr]   Search appindex\n"
"   -l               Use LSM database instead of appindex.db\n"
"   -h               Show this help\n"
"\n"
"Report bugs to <mhi@penguin.cz>\n";

char gendate[LINE_LEN];
struct category *categories;
int catno, appno;
int use_lsm;

void
trap (int sig)
{

  move (LINES - 1, 0);
  clrtoeol ();
  refresh ();

  endwin ();
  exit (sig);
}

/* <CZECH> Parchanti, zabili Kennyho ... </CZECH> */
int kill_kenny()
{
        int status;
        pid_t pid;

        while ((pid = waitpid(-1, &status, WNOHANG)) > 0)
                        ;
}

int
main (int argc, char **argv)
{
  char *conf_file;
  char c;
  char *search_str;
  char homeconfig[0x100];

#if HAVE_LIBINTL_H
    bindtextdomain("appindex", "/usr/share/locale");
    textdomain("appindex");
#endif

  conf_file = 0;
  search_str = 0;
  use_lsm = 0;

  while ((c = getopt (argc, argv, "s:c:hl")) != -1)
    {
      switch (c)
	{
	case 's':
	  search_str = optarg;
	  break;
	case 'c':
	  conf_file = optarg;
	  break;
	case 'l':
	  use_lsm = 1;
	  break;
	case 'h':
	  fprintf (stderr, usage, argv[0]);
	  exit (0);
	default:
	  fprintf (stderr, usage, argv[0]);
	  exit (1);
	}
    }


  /* Parse configuration file */
  null_config ();
  if (conf_file)
    parse_config (conf_file);
  else
    {
      if (getenv("HOME")) {
        strcpy(homeconfig,getenv("HOME"));
        strcat(homeconfig,"/.appindexrc");
        parse_config (homeconfig);
      }
      parse_config ("/etc/appindex.conf");
    }
  if (configure () < 0)
    {
      return 1;
    }

  argc -= optind;
  argv += optind;

  /* initialize curses library */
  initscr ();
  noecho ();
  keypad (stdscr, TRUE);
  start_color ();
  cbreak ();

  /* initialize colors */
  init_pair (CP_HEADER, colors[CP_HEADER] >> 4 & 0x7, colors[CP_HEADER] & 0x7);
  init_pair (CP_NORMAL, colors[CP_NORMAL] >> 4 & 0x7, colors[CP_NORMAL] & 0x7);
  init_pair (CP_SELECTED, colors[CP_SELECTED] >> 4 & 0x7, colors[CP_SELECTED] & 0x7);
  init_pair (CP_KEY, colors[CP_KEY] >> 4 & 0x7, colors[CP_KEY] & 0x7);
  init_pair (CP_KEYTEXT, colors[CP_KEYTEXT] >> 4 & 0x7, colors[CP_KEYTEXT] & 0x7);
  init_pair (CP_INFOKEY, colors[CP_INFOKEY] >> 4 & 0x7, colors[CP_INFOKEY] & 0x7);
  init_pair (CP_INFOVAL, colors[CP_INFOVAL] >> 4 & 0x7, colors[CP_INFOVAL] & 0x7);
  init_pair (CP_ERROR, colors[CP_ERROR] >> 4 & 0x7, colors[CP_ERROR] & 0x7);

  categories = 0;
  strcpy (gendate, "(unknown)");

  signal (SIGINT, trap);
  signal (SIGCHLD, kill_kenny);

  attrset (T_COLOR (CP_HEADER));
  mvprintw (0, 0, "%-*.*s", COLS, COLS,
	    "appindex browser (c) 1999,2000 Martin Hinner <mhi@penguin.cz>");
  refresh ();

  load_appindex (argc ? argv[0] : NULL);
  if (!categories)
    {
      fprintf (stderr, "FATAL: Unable to load appindex.txt file!\n");
      trap (0);
    }
  relink_cat ();

  if (search_str)
    do_search (search_str);
  else
    category_selection (categories);

  trap (0);
  return 0;
}
