/*
 *  Qt support for MICO
 *
 *  Original version by
 *  Copyright (C) 1997 Lars Doelle
 *
 *  KOMApplication done by Torben Weis, weis@kde.org
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 weis@kde.org
 */
#include <config.h>
#include "komApplication.h"

#include <CORBA.h>
#include <mico/template_impl.h>
#ifdef HAVE_MINI_STL
#include <ministl/algorithm>
#else
#include <algorithm>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>

// DEBUG
#include <iostream>

KOMApplication* KOMApplication::m_pKOMApplication = 0L;

KOMApplication::KOMApplication( int &argc, char **argv, const QString& rAppName) : 
  KApplication( argc, argv, rAppName )
{
  m_pKOMApplication = this;
  
  pOrb = CORBA::ORB_init( argc, argv, "mico-local-orb");
  pBoa = pOrb->BOA_init( argc, argv, "mico-local-boa");
    
  pQtd = new QTDispatcher (this);
  pOrb->dispatcher( pQtd );

  // add the catalogue to make translations
  getLocale()->insertCatalogue("corba");  
}

KOMApplication::~KOMApplication()
{
  // this will delete the QtDispatcher
  pOrb->dispatcher( 0 );
  // orb and boa are automatically released by the _var types
}

void KOMApplication::exec()
{
  // Make shure that the interface is created
  // (void)interface();

  if ( !pBoa->restoring() )
    start();
  else
    restore();
    
  impl_is_ready (CORBA::ImplementationDef::_nil());
  pOrb->run();
    
  end();
}

void KOMApplication::doquit()
{
  /* if ( m_pInterface )
  {
    CORBA::release( m_pInterface );
    } */

  switch ( state )
  {
  case ImplReady:
    deactivate_impl (CORBA::ImplementationDef::_nil());
    shutdown (TRUE); 
    break;
  case ObjReady:
    deactivate_obj (CORBA::Object::_nil());
    shutdown (TRUE); 
    break;
  }
}

void KOMApplication::shutdown( CORBA::Boolean wait )
{
  pOrb->shutdown (wait);
}   

void KOMApplication::impl_is_ready (CORBA::ImplementationDef_ptr impl)
{
    state = ImplReady;
    pBoa->impl_is_ready (impl);
}

void KOMApplication::deactivate_impl (CORBA::ImplementationDef_ptr impl)
{
    state = Initial;
    pBoa->deactivate_impl (impl);
}

void KOMApplication::obj_is_ready (CORBA::Object_ptr obj, CORBA::ImplementationDef_ptr impl)
{
    state = ObjReady;
    pBoa->obj_is_ready (obj, impl);
}

void KOMApplication::deactivate_obj (CORBA::Object_ptr obj)
{
    state = Initial;
    pBoa->deactivate_obj (obj);
}

void KOMApplication::processNextEvent (bool b)
{
    QApplication::processNextEvent (b);
    // XXX hack
    if (QApplication::quit_now) {
	QApplication::quit_now = false;
	doquit();
    }
}
  
// KFileNotifier /////////////////////////////////////////////////////////////////

KFileNotifier::~KFileNotifier()
{
    delete xid;
}

KFileNotifier::KFileNotifier()
{
}

KFileNotifier::KFileNotifier (QTDispatcher *_disp,
		      CORBA::DispatcherCallback *_cb, int fd, 
		      QSocketNotifier::Type _evq,
		      CORBA::Dispatcher::Event _evc)
    : xid (new QSocketNotifier (fd,_evq)), cb (_cb), disp (_disp), ev (_evc)
{
    QObject::connect (xid, SIGNAL (activated(int)),
		      this, SLOT (activated(int)));
}

void KFileNotifier::activated(int /*fd*/) 
{
    cb->callback (disp, ev);
}

// KTimerNotifier //////////////////////////////////////////////////////////

KTimerNotifier::~KTimerNotifier()
{
    delete xid;
}

KTimerNotifier::KTimerNotifier()
{
}

KTimerNotifier::KTimerNotifier (QTDispatcher* _disp,
			CORBA::DispatcherCallback *_cb,
			long tmout)
    : xid (new QTimer()), cb (_cb), disp (_disp)
{
    QObject::connect (xid, SIGNAL (timeout()), this, SLOT (timeout()));
    xid->start (tmout, TRUE);
}

void KTimerNotifier::timeout()
{
    disp->remove (this);
    cb->callback (disp, CORBA::Dispatcher::Timer);
    // XXX delete *this needed
}

// create & destroy ////////////////////////////////////////////////////

QTDispatcher::QTDispatcher (KOMApplication* _gfw)
    : gfw( _gfw )
{
}

QTDispatcher::~QTDispatcher ()
{
    list<KFileNotifier*>::iterator i;
    for (i = fevents.begin(); i != fevents.end(); ++i) {
	(*i)->cb->callback(this, Remove);
	delete *i;
    }

    list<KTimerNotifier*>::iterator j;
    for (j = tevents.begin(); j != tevents.end(); ++j) {
	(*j)->cb->callback(this, Remove);
	delete *j;
    }
}

// adding events ///////////////////////////////////////////////////////

void QTDispatcher::rd_event (CORBA::DispatcherCallback *cb, CORBA::Long fd)
{
    fevents.push_back(new KFileNotifier(this, cb, fd, QSocketNotifier::Read,
				    CORBA::Dispatcher::Read));
}

void QTDispatcher::wr_event (CORBA::DispatcherCallback *cb, CORBA::Long fd)
{
    fevents.push_back(new KFileNotifier(this, cb, fd, QSocketNotifier::Write,
				    CORBA::Dispatcher::Write));
}

void QTDispatcher::ex_event (CORBA::DispatcherCallback *cb, CORBA::Long fd)
{
    fevents.push_back(new KFileNotifier(this, cb, fd, QSocketNotifier::Exception,
				    CORBA::Dispatcher::Except));
}

void QTDispatcher::tm_event (CORBA::DispatcherCallback *cb, CORBA::ULong tmout)
{
    // both Qt and MICO timeouts are millisecs
    tevents.push_back(new KTimerNotifier(this, cb, tmout));
}

void QTDispatcher::remove (CORBA::DispatcherCallback *cb,
			   CORBA::Dispatcher::Event e)
{
    if (e == All || e == Timer) {
	list<KTimerNotifier*>::iterator i, next;
	for (i = tevents.begin(); i != tevents.end(); i = next) {
	    next = i;
	    ++next;
	    if ((*i)->cb == cb) {
		delete *i;
		tevents.erase (i);
	    }
	}
    }
    if (e == All || e == Read || e == Write || e == Except) {
	list<KFileNotifier*>::iterator i, next;
	for (i = fevents.begin(); i != fevents.end(); i = next) {
	    next = i;
	    ++next;
	    if ((*i)->cb == cb && (e == All || e == (*i)->ev)) {
		delete *i;
		fevents.erase(i);
	    }
	}
    }
}

void QTDispatcher::remove (KTimerNotifier *t)
{
    list<KTimerNotifier*>::iterator i = find(tevents.begin(), tevents.end(), t);
    assert (i != tevents.end());
    tevents.erase (i);
}

void QTDispatcher::run (CORBA::Boolean infinite)
{
    do {
	gfw->processNextEvent (TRUE);
    } while (infinite);
}

void QTDispatcher::move (CORBA::Dispatcher *)
{
    assert (0);
}

CORBA::Boolean QTDispatcher::idle () const
{
    return fevents.size() + tevents.size() == 0;
}

/******************************************************
 *
 * KOMApplicationIf
 *
 ******************************************************/

KOMApplicationIf::KOMApplicationIf()
{
  CORBA::String_var str = komapp_orb->object_to_string( this );
  cout << "IOR of Application=" << str.in() << endl;
}

KOMApplicationIf::KOMApplicationIf( const CORBA::BOA::ReferenceData &refdata ) :
  KOM::Application_skel( refdata )
{
}

KOMApplicationIf::KOMApplicationIf( CORBA::Object_ptr _obj ) :
  KOM::Application_skel( _obj )
{
}

KOMApplicationIf::~KOMApplicationIf()
{
}

#include "komApplication.moc"
