/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "komContainer.h"

/*************************************************************
 *
 * Container
 *
 *************************************************************/

KOMContainer::KOMContainer()
{
  SIGNAL_IMPL( "containeeAdded" );
  SIGNAL_IMPL( "containeeRemoved" );
}

KOMContainer::~KOMContainer()
{
}
  
void KOMContainer::addContainee( const KOM::Member& memb )
{
  map<string,KOM::Base_var>::iterator it = m_mapContainees.find( memb.name.in() );
  if ( it != m_mapContainees.end() )
  {
    KOM::DuplicateMember exc;
    exc.name = CORBA::string_dup( memb.name.in() );
    mico_throw( exc );
  }
  
  m_mapContainees[ memb.name.in() ] = memb.obj;
  memb.obj->adopt( this );
  
  containeeAdded( memb );
}

void KOMContainer::removeContainee( const char* name )
{
  map<string,KOM::Base_var>::iterator it = m_mapContainees.find( name );
  if ( it == m_mapContainees.end() )
  {
    KOM::UnknownMember exc;
    exc.name = CORBA::string_dup( name );
    mico_throw( exc );
  }
  
  KOM::Member memb;
  memb.obj = it->second;
  memb.name = CORBA::string_dup( it->first.c_str() );

  memb.obj->leave( this );

  m_mapContainees.erase( it );

  containeeRemoved( memb );
}

void KOMContainer::replaceContainee( const KOM::Member& memb )
{
  map<string,KOM::Base_var>::iterator it = m_mapContainees.find( memb.name.in() );
  if ( it != m_mapContainees.end() )
  {
    KOM::UnknownMember exc;
    exc.name = CORBA::string_dup( memb.name.in() );
    mico_throw( exc );
  }

  m_mapContainees.erase( it );
  KOM::Member m;
  m.obj = it->second;
  m.name = CORBA::string_dup( it->first.c_str() );
  m.obj->leave( this );
  containeeRemoved( m );

  m_mapContainees[ memb.name.in() ] = memb.obj;
  memb.obj->adopt( this );
  containeeAdded( memb );  
}

void KOMContainer::clear()
{
  map<string,KOM::Base_var>::iterator it = m_mapContainees.begin();
  for( ; it != m_mapContainees.end(); ++it )
  {
    KOM::Member memb;
    memb.obj = it->second;
    memb.name = CORBA::string_dup( it->first.c_str() );
    memb.obj->leave( this );
    containeeRemoved( memb );
  }
  
  m_mapContainees.clear();
}

KOM::MemberSeq* KOMContainer::listContainees()
{
  KOM::MemberSeq* seq = new KOM::MemberSeq;
  CORBA::ULong size = m_mapContainees.size();
  seq->length( size );
  
  map<string,KOM::Base_var>::iterator it = m_mapContainees.begin();
  for( CORBA::ULong l = 0; l < size; l++ )
  {
    KOM::Member m;
    m.obj = it->second;
    m.name = CORBA::string_dup( it->first.c_str() );
    (*seq)[l] = m;
    ++it;
  }
  
  return seq;
}

KOM::Base_ptr KOMContainer::lookupContainee( const char* name )
{
  map<string,KOM::Base_var>::iterator it = m_mapContainees.find( name );
  if ( it == m_mapContainees.end() )
  {
    KOM::UnknownMember exc;
    exc.name = CORBA::string_dup( name );
    mico_throw( exc );
  }

  return KOM::Base::_duplicate( it->second );
}

void KOMContainer::containeeAdded( const KOM::Member& memb )
{
  signal_call1<const KOM::Member&>( "containeeAdded", &m_dctSignals, memb );
}

void KOMContainer::containeeRemoved( const KOM::Member& memb )
{
  signal_call1<const KOM::Member&>( "containeeRemoved", &m_dctSignals, memb );
}

void KOMContainer::leaveNotify( KOM::Base_ptr _ptr )
{
  map<string,KOM::Base_var>::iterator it = m_mapContainees.begin();
  for( ; it != m_mapContainees.end(); ++it )
  {
    if ( cmpIOR( it->second, _ptr ) == 0L )
    {
      KOM::Member memb;
      memb.obj = it->second;
      memb.name = CORBA::string_dup( it->first.c_str() );

      m_mapContainees.erase( it );

      containeeRemoved( memb );
    }
  }

  KOMBase::leaveNotify( _ptr );
}
