/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __kom_container_h__
#define __kom_container_h__

#include "kom.h"
#include "komBase.h"

#include <map>
#include <string>

class KOMContainer : virtual public KOMBase,
		     virtual public KOM::Container_skel
{
public:
  KOMContainer();
  virtual ~KOMContainer();
  
  virtual void addContainee( const KOM::Member& memb );
  virtual void removeContainee( const char* name );
  virtual void replaceContainee( const KOM::Member& memb );
  virtual void clear();
  virtual KOM::MemberSeq* listContainees();
  virtual KOM::Base_ptr lookupContainee( const char* name );
  virtual void containeeAdded( const KOM::Member& memb );
  virtual void containeeRemoved( const KOM::Member& memb );

protected:
  virtual void leaveNotify( KOM::Base_ptr _ptr );
  
  map<string,KOM::Base_var> m_mapContainees;
};

#endif
